/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.agent.discovery.ExecDiscovery;
import org.eclipse.aperi.agent.nas.Contactor;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ImportManager {
    public static final String HOST_DELIMITER = ":/";
    private Map importMap;
    private Map aliasMap;
    private Computer computer;
    private NameList vendors;
    private Contactor contactor;
    private SnmpPeer peer;
    private boolean handlingAutomounts;
    private boolean rejectNonRoot;

    public ImportManager(Computer pComputer, String[] vendorArray, NameList snmpCommunities, boolean pRejectNonRoot) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ImportManager.class.getName(), (String)"ImportManager", (String)"pComputer, vendorArray, snmpCommunities, pRejectNonRoot");
        }
        this.computer = pComputer;
        this.rejectNonRoot = pRejectNonRoot;
        this.importMap = new HashMap();
        this.aliasMap = new HashMap();
        if (vendorArray == null) {
            this.peer = new SnmpPeer(null, null);
            this.contactor = new Contactor(this.peer, null, snmpCommunities);
        } else {
            this.vendors = NasUtil.parseVendorArray(vendorArray);
            if (this.vendors != null) {
                this.peer = new SnmpPeer(null, null);
                this.contactor = new Contactor(this.peer, this.vendors, snmpCommunities);
            }
        }
        this.handlingAutomounts = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ImportManager.class.getName(), (String)"ImportManager");
        }
    }

    public void enterAutomountMode() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ImportManager.class.getName(), (String)"enterAutomountMode", (String)"");
        }
        this.handlingAutomounts = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ImportManager.class.getName(), (String)"enterAutomountMode");
        }
    }

    private static native boolean isRoot(String var0, boolean var1) throws LocalizableException;

    public static boolean isNetAppVolume(String path) {
        int pos;
        int length;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ImportManager.class.getName(), (String)"isNetAppVolume", (String)"path");
        }
        boolean result = false;
        if (path.startsWith("/vol/") && (length = path.length()) > 5 && ((pos = path.indexOf(47, 5)) < 0 || pos == length - 1)) {
            result = true;
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ImportManager.class.getName(), (String)"isNetAppVolume", (boolean)traceResult);
        }
        return traceResult;
    }

    private boolean isRoot(String mountPoint, String remotePath, short osType) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ImportManager.class.getName(), (String)"isRoot", (String)"mountPoint, remotePath, osType");
        }
        boolean result = osType == 10 ? ImportManager.isNetAppVolume(remotePath) : (this.rejectNonRoot ? ImportManager.isRoot(mountPoint, this.handlingAutomounts) : false);
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ImportManager.class.getName(), (String)"isRoot", (boolean)traceResult);
        }
        return traceResult;
    }

    public int handleImport(Mounts mounts, String networkName) {
        boolean root;
        NasFiler nf;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ImportManager.class.getName(), (String)"handleImport", (String)"mounts");
        }
        if (networkName == null && this.vendors == null) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleImport", (int)traceResult);
            }
            return traceResult;
        }
        String imprt = mounts.special;
        int pos = imprt.indexOf(HOST_DELIMITER);
        if (pos <= 0) {
            MessageLog.logMessage((String)"NAA0039W", (Object)imprt);
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleImport", (int)traceResult);
            }
            return traceResult;
        }
        String hostName = imprt.substring(0, pos).toLowerCase();
        String remotePath = imprt.substring(pos + 1);
        Object obj = this.aliasMap.get(hostName);
        if (obj instanceof String) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleImport", (int)traceResult);
            }
            return traceResult;
        }
        int rc = 0;
        if (obj instanceof NasFiler) {
            nf = (NasFiler)obj;
        } else {
            InetAddress addr;
            block28: {
                addr = null;
                try {
                    addr = InetAddress.getByName(hostName);
                }
                catch (UnknownHostException ignored) {
                    if (!TraceLogger.enableTrace) break block28;
                    TraceLogger.exception((String)ImportManager.class.getName(), (String)"handleImport", (Throwable)ignored);
                }
            }
            if (addr == null) {
                MessageLog.logMessage((String)"GEN0039E", (Object)hostName);
                int traceResult = 4;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleImport", (int)traceResult);
                }
                return traceResult;
            }
            this.peer.address = addr;
            this.peer.name = hostName;
            if (this.contactor.contact() == null) {
                if (!this.contactor.temporaryError) {
                    this.aliasMap.put(hostName, HOST_DELIMITER);
                }
                int traceResult = this.contactor.rc;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleImport", (int)traceResult);
                }
                return traceResult;
            }
            nf = this.computer.cmpNasFiler;
            while (nf != null && !nf.nfName.equals(this.peer.name)) {
                nf = nf.nfNext;
            }
            if (nf == null) {
                nf = ExecDiscovery.newFiler(this.peer, hostName, this.contactor, null);
                if (!Probe.enumExports(nf.nfComputer, hostName)) {
                    rc = 4;
                }
                nf.nfNext = this.computer.cmpNasFiler;
                this.computer.cmpNasFiler = nf;
            }
            this.aliasMap.put(hostName, nf);
        }
        if (nf.nfOSType == 10 && remotePath.equals("/")) {
            remotePath = "/vol/vol0";
        }
        if (this.importMap.containsKey(imprt = hostName + HOST_DELIMITER + remotePath)) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleImport", (int)traceResult);
            }
            return traceResult;
        }
        this.importMap.put(imprt, imprt);
        try {
            root = this.isRoot(mounts.mountPoint, remotePath, nf.nfOSType);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ImportManager.class.getName(), (String)"handleImport", (Throwable)e);
            }
            e.print();
            int traceResult = 4;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleImport", (int)traceResult);
            }
            return traceResult;
        }
        boolean ok = this.rejectNonRoot ? root : true;
        if (ok) {
            Filesystem fs = new Filesystem();
            fs.fsNasFiler = nf;
            rc = mounts.statFS(fs);
            fs.fsType = root || nf.nfOSType != 10 ? (short)-1 : (short)16;
            Computer cmp = nf.nfComputer;
            cmp.cmpFilesystemFreeSpace += fs.fsFreeSpace;
            fs.fsMountPoint = remotePath;
            LogicalDisk ld = new LogicalDisk();
            ld.ldFilesystem = fs;
            fs.fsLogicalDisk = ld;
            ld.ldCapacity = fs.fsCapacity;
            ld.ldPath = remotePath;
            ld.ldType = (byte)7;
            ld.ldNext = cmp.cmpLogicalDisk;
            cmp.cmpLogicalDisk = ld;
        }
        int traceResult = rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleImport", (int)traceResult);
        }
        return traceResult;
    }

    public int handleSANFSMount(Mounts mounts) {
        NasFiler nf;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ImportManager.class.getName(), (String)"handleSANFSMount", (String)"mounts");
        }
        if (!mounts.type.equals("sanfs")) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleSANFSMount", (int)traceResult);
            }
            return traceResult;
        }
        int rc = 0;
        String imprt = mounts.special;
        Object obj = this.aliasMap.get(imprt);
        if (obj instanceof String) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleSANFSMount", (int)traceResult);
            }
            return traceResult;
        }
        if (obj instanceof NasFiler) {
            nf = (NasFiler)obj;
        } else {
            nf = this.computer.cmpNasFiler;
            while (nf != null && !nf.nfName.equals(imprt)) {
                nf = nf.nfNext;
            }
            if (nf == null) {
                nf = ExecDiscovery.newSANFSFileset(imprt);
                nf.nfNext = this.computer.cmpNasFiler;
                this.computer.cmpNasFiler = nf;
            }
            this.aliasMap.put(imprt, nf);
        }
        if (this.importMap.containsKey(imprt)) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleSANFSMount", (int)traceResult);
            }
            return traceResult;
        }
        this.importMap.put(imprt, imprt);
        MessageLog.logMessage((String)"STA0623I", (Object)nf.nfName, (Object)mounts.mountPoint);
        Filesystem fs = new Filesystem();
        fs.fsNasFiler = nf;
        rc = mounts.statFS(fs);
        fs.fsType = (short)18;
        Computer cmp = nf.nfComputer;
        cmp.cmpFilesystemFreeSpace += fs.fsFreeSpace;
        StringBuffer mntPoint = new StringBuffer("/");
        mntPoint.append(imprt);
        fs.fsMountPoint = mntPoint.toString();
        LogicalDisk ld = new LogicalDisk();
        ld.ldFilesystem = fs;
        fs.fsLogicalDisk = ld;
        ld.ldCapacity = fs.fsCapacity;
        ld.ldPath = imprt;
        ld.ldType = (byte)7;
        ld.ldNext = cmp.cmpLogicalDisk;
        cmp.cmpLogicalDisk = ld;
        int traceResult = rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ImportManager.class.getName(), (String)"handleSANFSMount", (int)traceResult);
        }
        return traceResult;
    }
}

