/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas;

import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.common.Encrypt;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;

public class NasUtil {
    public static NameList parseVendorArray(String[] vendorArray) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasUtil.class.getName(), (String)"parseVendorArray", (String)"vendorArray");
        }
        NameList result = null;
        if (vendorArray != null) {
            MutableInteger pos = new MutableInteger();
            for (int i = 0; i < vendorArray.length; ++i) {
                NameList vendor;
                String line;
                block8: {
                    line = vendorArray[i];
                    if (line == null) continue;
                    pos.value = 0;
                    String s = Util.nextWord((String)line, (MutableInteger)pos);
                    if (s == null) continue;
                    vendor = new NameList();
                    vendor.nlID = -1;
                    try {
                        vendor.nlID = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        if (!TraceLogger.enableTrace) break block8;
                        TraceLogger.exception((String)NasUtil.class.getName(), (String)"parseVendorArray", (Throwable)e);
                    }
                }
                if (vendor.nlID < 0) continue;
                int length = line.length();
                while (pos.value < length && Character.isWhitespace(line.charAt(pos.value))) {
                    ++pos.value;
                }
                if (pos.value < length) {
                    vendor.nlName = line.substring(pos.value);
                }
                vendor.nlNext = result;
                result = vendor;
            }
        }
        NameList traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasUtil.class.getName(), (String)"parseVendorArray", traceResult);
        }
        return traceResult;
    }

    private static native void nativeCIFSShareLogIn(String var0, String var1, String var2, String var3) throws LocalizableException;

    private static native void nativeCIFSLogIn(String var0, String var1, String var2, String var3, MutableBoolean var4) throws LocalizableException;

    private static String parseEnteredDomain(String domain, StringBuffer user) {
        String userString;
        int pos;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasUtil.class.getName(), (String)"parseEnteredDomain", (String)"domain, user");
        }
        if ((pos = (userString = user.toString()).indexOf(92)) >= 0) {
            if (pos > 0) {
                domain = userString.substring(0, pos);
            }
            user.delete(0, pos + 1);
        }
        String traceResult = domain;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasUtil.class.getName(), (String)"parseEnteredDomain", (Object)traceResult);
        }
        return traceResult;
    }

    public static void cifsLogIn(String domain, String server, String username, String password, MutableBoolean alreadyLoggedIn) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasUtil.class.getName(), (String)"cifsLogIn", (String)"domain, server, username, password, alreadyLoggedIn");
        }
        StringBuffer buf = new StringBuffer(username);
        domain = NasUtil.parseEnteredDomain(domain, buf);
        username = buf.toString();
        String decrypted = Encrypt.decrypt((String)password);
        NasUtil.nativeCIFSLogIn(domain, server, username, decrypted, alreadyLoggedIn);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasUtil.class.getName(), (String)"cifsLogIn");
        }
    }

    public static void cifsLogIn(String domain, String server, String username, String password) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasUtil.class.getName(), (String)"cifsLogIn", (String)"domain, server, username, password");
        }
        NasUtil.cifsLogIn(domain, server, username, password, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasUtil.class.getName(), (String)"cifsLogIn");
        }
    }

    public static void cifsShareLogIn(String domain, String share, String user, String pwd) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasUtil.class.getName(), (String)"cifsShareLogIn", (String)"domain, share, user, pwd");
        }
        StringBuffer buf = new StringBuffer(user);
        domain = NasUtil.parseEnteredDomain(domain, buf);
        user = buf.toString();
        String decrypted = Encrypt.decrypt((String)pwd);
        NasUtil.nativeCIFSShareLogIn(domain, share, user, decrypted);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasUtil.class.getName(), (String)"cifsShareLogIn");
        }
    }

    public static native void cifsShareLogOut(String var0);

    public static void cifsLogOut(String server) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasUtil.class.getName(), (String)"cifsLogOut", (String)"server");
        }
        NasUtil.cifsShareLogOut("\\\\" + server + "\\IPC$");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasUtil.class.getName(), (String)"cifsLogOut");
        }
    }

    public static native long nativeLogonUser(String var0, String var1, String var2) throws LocalizableException;

    public static long logonUser(String domain, String user, String pwd) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasUtil.class.getName(), (String)"logonUser", (String)"domain, user, pwd");
        }
        StringBuffer buf = new StringBuffer(user);
        domain = NasUtil.parseEnteredDomain(domain, buf);
        user = buf.toString();
        String decrypted = Encrypt.decrypt((String)pwd);
        long traceResult = NasUtil.nativeLogonUser(domain, user, decrypted);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasUtil.class.getName(), (String)"logonUser", (long)traceResult);
        }
        return traceResult;
    }

    public static boolean isNetWare(LdapTree tree) {
        if (tree == null) {
            return false;
        }
        return tree.ltTreeID > 0;
    }

    public static String filerDomain(NasFiler filer) {
        Domain domain;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasUtil.class.getName(), (String)"filerDomain", (String)"filer");
        }
        String result = (domain = filer.nfDomain) != null ? domain.domName : null;
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasUtil.class.getName(), (String)"filerDomain", (Object)traceResult);
        }
        return traceResult;
    }

    public static String networkName(NasFiler filer) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasUtil.class.getName(), (String)"networkName", (String)"filer");
        }
        String result = filer.nfNetworkName;
        String domain = NasUtil.filerDomain(filer);
        if (domain != null && !domain.equalsIgnoreCase(Agent.domain)) {
            result = filer.nfName;
        }
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasUtil.class.getName(), (String)"networkName", (Object)traceResult);
        }
        return traceResult;
    }
}

