/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas.netapp;

import java.io.Serializable;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.agent.nas.ImportManager;
import org.eclipse.aperi.agent.nas.netapp.TableHandler;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.MessageLog;

public class FilesystemTableHandler
extends TableHandler {
    protected int currentVolume;
    protected int nVols;

    public FilesystemTableHandler(OID pOID, NasFiler pFiler, SnmpSession pListener, int pNVols) {
        super(pOID, pFiler, pListener);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilesystemTableHandler.class.getName(), (String)"FilesystemTableHandler", (String)"pOID, pFiler, pListener, pNVols");
        }
        this.badTypeMsgID = "NAA0088E";
        this.tableOIDLength = 12;
        this.currentVolume = this.nVols = pNVols;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilesystemTableHandler.class.getName(), (String)"FilesystemTableHandler");
        }
    }

    protected String checkNameLength() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilesystemTableHandler.class.getName(), (String)"checkNameLength", (String)"");
        }
        String result = this.array.length == 13 ? null : "NAA0087E";
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilesystemTableHandler.class.getName(), (String)"checkNameLength", (Object)traceResult);
        }
        return traceResult;
    }

    protected boolean typeOK(Serializable content) {
        return content instanceof OctetString;
    }

    protected void finishProcessing(String fsName, int volNo) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilesystemTableHandler.class.getName(), (String)"finishProcessing", (String)"fsName, volNo");
        }
        LogicalDisk ld = this.comp.cmpLogicalDisk;
        while (ld != null && volNo > 0) {
            ld = ld.ldNext;
            --volNo;
        }
        if (ld == null) {
            Object[] args = new Object[]{fsName, new Integer(this.currentVolume)};
            String s = MessageLog.getMessage((String)"NAA0090E", (Object[])args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)FilesystemTableHandler.class.getName(), (String)"finishProcessing");
            }
            throw new GeneralException(s);
        }
        Filesystem fs = new Filesystem();
        fs.fsComputerID = this.filer.nfComputerID;
        fs.fsMaxFiles = -1;
        fs.fsUsedInodes = -1;
        fs.fsFreeInodes = -1;
        fs.fsMountPoint = fsName;
        fs.fsPhysicalSize = ld.ldCapacity;
        fs.fsCapacity = -1L;
        fs.fsUsedSpace = -1L;
        fs.fsFreeSpace = -1L;
        fs.fsType = (short)15;
        fs.fsClusterSize = (int)this.array[this.array.length - 1];
        fs.fsLogicalDisk = ld;
        ld.ldFilesystem = fs;
        ld.ldPath = fsName;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilesystemTableHandler.class.getName(), (String)"finishProcessing");
        }
    }

    protected void process(Serializable content) throws GeneralException {
        int volNo;
        String fsName;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilesystemTableHandler.class.getName(), (String)"process", (String)"content");
        }
        if (!ImportManager.isNetAppVolume(fsName = ((OctetString)content).toDisplayString())) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)FilesystemTableHandler.class.getName(), (String)"process");
            }
            return;
        }
        if (fsName.endsWith("/")) {
            fsName = fsName.substring(0, fsName.length() - 1);
        }
        if ((volNo = this.currentVolume - 1) < 0) {
            Object[] args = new Object[]{fsName, new Integer(this.nVols)};
            String s = MessageLog.getMessage((String)"NAA0089E", (Object[])args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)FilesystemTableHandler.class.getName(), (String)"process");
            }
            throw new GeneralException(s);
        }
        this.currentVolume = volNo;
        this.finishProcessing(fsName, volNo);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilesystemTableHandler.class.getName(), (String)"process");
        }
    }
}

