/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas.netapp;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.agent.nas.Contactor;
import org.eclipse.aperi.agent.nas.netapp.DiskTableHandler;
import org.eclipse.aperi.agent.nas.netapp.FSAvailSpaceHighHandler;
import org.eclipse.aperi.agent.nas.netapp.FSAvailSpaceLowHandler;
import org.eclipse.aperi.agent.nas.netapp.FSCapacityHighHandler;
import org.eclipse.aperi.agent.nas.netapp.FSCapacityLowHandler;
import org.eclipse.aperi.agent.nas.netapp.FSUsedSpaceHighHandler;
import org.eclipse.aperi.agent.nas.netapp.FSUsedSpaceLowHandler;
import org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler;
import org.eclipse.aperi.agent.nas.netapp.InodeCapacityHandler;
import org.eclipse.aperi.agent.nas.netapp.InodesAvailHandler;
import org.eclipse.aperi.agent.nas.netapp.InodesUsedHandler;
import org.eclipse.aperi.agent.nas.netapp.ItemHandler;
import org.eclipse.aperi.agent.nas.netapp.SCSIAdapterHandler;
import org.eclipse.aperi.agent.nas.netapp.SCSIIDHandler;
import org.eclipse.aperi.agent.nas.netapp.SpareDiskTableHandler;
import org.eclipse.aperi.agent.nas.netapp.TableHandler;
import org.eclipse.aperi.agent.nas.netapp.TotalBloxHandler;
import org.eclipse.aperi.agent.nas.netapp.UsedBloxHandler;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.LongInput;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeNetAppFiler {
    private SnmpPDU getPDU;
    public static final long[] NETAPP_RAIDV_TABLE = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 789L, 1L, 6L, 2L, 1L};
    public static final int NETAPP_PREFIX_LENGTH = 8;
    static final int SPARE_PREFIX_LENGTH = NETAPP_RAIDV_TABLE.length;
    public static final int FS_PREFIX_LENGTH = 11;
    private static final int RAIDV_DISK_ID = 4;
    private static final int RAIDV_SCSI_ADAPTER = 5;
    private static final int RAIDV_SCSI_ID = 6;
    private static final int RAIDV_USED_BLOCKS = 8;
    private static final int RAIDV_TOTAL_BLOCKS = 10;
    private static final int SPARE_DISK_ID = 4;
    private static final int SPARE_SCSI_ADAPTER = 5;
    private static final int SPARE_SCSI_ID = 6;
    private static final int SPARE_TOTAL_BLOCKS = 8;
    public static final int FS_NAME = 2;
    private static final int FS_INODES_USED = 7;
    private static final int FS_INODES_AVAIL = 8;
    private static final int FS_INODE_CAPCTY = 11;
    private static final int FS_CAPACITY_KB = 14;
    private static final int FS_USED_KB = 16;
    private static final int FS_AVAIL_KB = 18;
    private static final int GLOBAL_OS_VERSION = 2;
    private static final int GLOBAL_SERIAL_NO = 3;
    private static final int GLOBAL_MODEL = 5;
    private static final int GLOBAL_UPTIME = 1;
    private static final int GLOBAL_NCPUS = 6;
    private static final long[] RAIDV_ITEM_CODES = new long[]{5L, 6L, 10L, 8L};
    private static final long[] SPARE_ITEM_CODES = new long[]{5L, 6L, 8L};
    private static ItemHandler[] diskItemHandlers;
    private static final long[] FS_ITEM_CODES;
    private static ItemHandler[] fsItemHandlers;
    int rc;
    Disk disk;
    Filesystem fs;
    Computer computer;
    Controller controller;
    private NasFiler filer;
    private SnmpSession listener;

    private static InetAddress getInetAddr(String hostName) {
        InetAddress result;
        block4: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"getInetAddr", (String)"hostName");
            }
            result = null;
            try {
                result = InetAddress.getByName(hostName);
            }
            catch (UnknownHostException e) {
                if (!TraceLogger.enableTrace) break block4;
                TraceLogger.exception((String)ProbeNetAppFiler.class.getName(), (String)"getInetAddr", (Throwable)e);
            }
        }
        InetAddress traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"getInetAddr", (Object)traceResult);
        }
        return traceResult;
    }

    public static SnmpSession contact(NasFiler filer, MutableInteger pRC) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"contact", (String)"filer, pRC");
        }
        pRC.value = 0;
        String hostName = filer.nfName;
        InetAddress addr = ProbeNetAppFiler.getInetAddr(hostName);
        if (addr == null) {
            hostName = filer.nfNetworkName;
            addr = ProbeNetAppFiler.getInetAddr(hostName);
        }
        if (addr == null) {
            Object[] args = new Object[]{filer.nfName, filer.nfNetworkName};
            MessageLog.logMessage((String)"NAA0101E", (Object[])args);
            SnmpSession traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"contact", traceResult);
            }
            return traceResult;
        }
        SnmpPeer peer = new SnmpPeer(hostName, addr);
        NameList vendor = new NameList();
        vendor.nlID = 789;
        vendor.nlName = filer.nfManufacturer;
        Contactor contactor = new Contactor(peer, vendor, filer.nfSnmpCommunity, false);
        if (contactor.contact() == null) {
            SnmpSession traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"contact", traceResult);
            }
            return traceResult;
        }
        if (contactor.rc > pRC.value) {
            pRC.value = contactor.rc;
        }
        filer.nfName = peer.name;
        SnmpSession traceResult = contactor.listener;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"contact", (Object)traceResult);
        }
        return traceResult;
    }

    private static void fillRaidVTableOID(long[] output) {
        System.arraycopy(NETAPP_RAIDV_TABLE, 0, output, 0, NETAPP_RAIDV_TABLE.length);
    }

    private static void fillSpareTableOID(long[] output) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"fillSpareTableOID", (String)"output");
        }
        ProbeNetAppFiler.fillRaidVTableOID(output);
        output[ProbeNetAppFiler.NETAPP_RAIDV_TABLE.length - 2] = 3L;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"fillSpareTableOID");
        }
    }

    public static void fillFSTableOID(long[] output) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"fillFSTableOID", (String)"output");
        }
        System.arraycopy(NETAPP_RAIDV_TABLE, 0, output, 0, 8);
        output[8] = 5L;
        output[9] = 4L;
        output[10] = 1L;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"fillFSTableOID");
        }
    }

    private static long[] makeFilerLevelOID() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"makeFilerLevelOID", (String)"");
        }
        long[] array = new long[11];
        System.arraycopy(NETAPP_RAIDV_TABLE, 0, array, 0, 8);
        array[8] = 1L;
        long[] traceResult = array;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"makeFilerLevelOID", (Object)traceResult);
        }
        return traceResult;
    }

    private static long[] makeCPUStatsOID() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"makeCPUStatsOID", (String)"");
        }
        long[] array = new long[12];
        System.arraycopy(NETAPP_RAIDV_TABLE, 0, array, 0, 8);
        array[8] = 2L;
        array[9] = 1L;
        long[] traceResult = array;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"makeCPUStatsOID", (Object)traceResult);
        }
        return traceResult;
    }

    static void encodeTriple(long[] array, Device dev) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"encodeTriple", (String)"array, dev");
        }
        int i = array.length - 3;
        long encoded = array[i];
        encoded <<= 21;
        encoded |= array[++i];
        encoded <<= 21;
        dev.devDiscoveredTime = encoded |= array[++i];
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"encodeTriple");
        }
    }

    private static void decodeTriple(Device dev, long[] array) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"decodeTriple", (String)"dev, array");
        }
        long encoded = dev.devDiscoveredTime;
        int mask = 0x1FFFFF;
        int i = array.length - 1;
        array[i] = (int)encoded & mask;
        array[--i] = (int)(encoded >>= 21) & mask;
        array[--i] = (int)(encoded >>= 21) & mask;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"decodeTriple");
        }
    }

    static long high32KB2Long(int high32KB) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"high32KB2Long", (String)"high32KB");
        }
        long result = high32KB;
        long traceResult = result <<= 33;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"high32KB2Long", (long)traceResult);
        }
        return traceResult;
    }

    static long low32KB2Long(int low32KB, long originalField) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"low32KB2Long", (String)"low32KB, originalField");
        }
        if ((originalField & 1L) != 0L) {
            originalField = 0L;
        }
        long temp = low32KB;
        long traceResult = originalField | (temp <<= 1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"low32KB2Long", (long)traceResult);
        }
        return traceResult;
    }

    static Device newDisk() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"newDisk", (String)"");
        }
        Disk dev = new Disk();
        dev.devModel = dev.devManufacturer = "NETWORK APPLIANCE";
        dev.devFirmwareRev = " ";
        dev.devType = 0;
        dev.devFlags = (short)2;
        dev.devUnsupportedModel = true;
        Disk traceResult = dev;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"newDisk", (Object)traceResult);
        }
        return traceResult;
    }

    public static Number checkNumber(Serializable value, NasFiler pFiler) {
        Number result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"checkNumber", (String)"value, pFiler");
        }
        if (value instanceof LongInput) {
            result = new Long(((LongInput)value).getValue());
        } else if (value instanceof Number) {
            result = (Number)value;
        } else {
            result = null;
            MessageLog.logMessage((String)"NAA0079E", (Object)pFiler.nfName);
            MessageLog.logMessage((String)"NAA0084E", (Object)value.getClass().getName());
        }
        Number traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"checkNumber", (Object)traceResult);
        }
        return traceResult;
    }

    public static String checkString(Serializable value, NasFiler pFiler) {
        String result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"checkString", (String)"value, pFiler");
        }
        if (value instanceof OctetString) {
            result = ((OctetString)value).toDisplayString();
        } else {
            result = null;
            MessageLog.logMessage((String)"NAA0086W", (Object)pFiler.nfName, (Object)value.getClass().getName());
        }
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"checkString", (Object)traceResult);
        }
        return traceResult;
    }

    Number checkNumber(Serializable value) {
        return ProbeNetAppFiler.checkNumber(value, this.filer);
    }

    String checkString(Serializable value) {
        return ProbeNetAppFiler.checkString(value, this.filer);
    }

    public static Serializable sendGetRequest(OID oid, boolean whine, SnmpSession pListener, SnmpPDU pPDU, NasFiler pFiler) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"sendGetRequest", (String)"oid, whine, pListener, pPDU, pFiler");
        }
        SnmpVarBind varbind = null;
        Serializable value = null;
        boolean ok = false;
        pPDU.operation = 0;
        Vector<SnmpVarBind> v = pPDU.varBindList;
        if (v == null) {
            pPDU.varBindList = v = new Vector<SnmpVarBind>();
        }
        v.clear();
        v.addElement(new SnmpVarBind(oid));
        pPDU.communityString = null;
        SnmpPDU respPdu = pListener.send(pPDU);
        if (respPdu != null) {
            if (respPdu.errorStatus != 0) {
                if (whine || respPdu.errorStatus != 2) {
                    MessageLog.logMessage((String)"NAA0078E", (Object)pFiler.nfName);
                }
            } else {
                if (respPdu.varBindListSize() > 0) {
                    varbind = respPdu.varBindAt(0);
                }
                if (varbind != null) {
                    value = varbind.getVar();
                }
                if (value == null) {
                    MessageLog.logMessage((String)"NAA0085W", (Object)pFiler.nfName);
                }
            }
        }
        if (value == null && whine) {
            MessageLog.logMessage((String)"NAA0081I", (Object)oid.toString());
        }
        Serializable traceResult = value;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"sendGetRequest", (Object)traceResult);
        }
        return traceResult;
    }

    private Serializable sendGetRequest(OID oid, boolean whine) {
        return ProbeNetAppFiler.sendGetRequest(oid, whine, this.listener, this.getPDU, this.filer);
    }

    private Serializable sendGetRequest(OID oid) {
        return this.sendGetRequest(oid, true);
    }

    private boolean requestAndHandle(OID oid, ItemHandler handler) {
        Serializable value;
        boolean ok;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"requestAndHandle", (String)"oid, handler");
        }
        boolean bl = ok = (value = this.sendGetRequest(oid)) != null;
        if (ok && !(ok = handler.handle(this, value))) {
            MessageLog.logMessage((String)"NAA0081I", (Object)oid.toString());
        }
        boolean traceResult = ok;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"requestAndHandle", (boolean)traceResult);
        }
        return traceResult;
    }

    private void finishOffLogicalDisk(LogicalDisk ld, LogicalDisk lastLD) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"finishOffLogicalDisk", (String)"ld, lastLD");
        }
        ld.ldCapacity = 0L;
        ChunkCollection cc = ld.ldCollectionList;
        while (cc != null) {
            Chunk chunk = cc.ccChunkList;
            if (chunk.chkNextInCollection == null) {
                cc.ccType = 0;
                ld.ldCapacity += chunk.chkSize;
            } else {
                do {
                    chunk = chunk.chkNextInCollection;
                    ld.ldCapacity += chunk.chkSize;
                } while (chunk.chkNextInCollection != null);
            }
            cc = cc.ccNext;
        }
        if (lastLD != null) {
            lastLD.ldNext = ld;
        } else {
            this.computer.cmpLogicalDisk = ld;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"finishOffLogicalDisk");
        }
    }

    private void makeDiskHistory() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"makeDiskHistory", (String)"");
        }
        this.disk = (Disk)this.computer.cmpDevice;
        while (this.disk != null) {
            DiskHistory dkh;
            this.disk.dskSectorSize = 512;
            this.disk.dskLogicalBlockSize = 512;
            this.disk.dskSectorsPerAvgTrack = -1;
            this.disk.dskSectorsPerOuterTrack = -1;
            this.disk.dskSectorsPerInnerTrack = -1;
            this.disk.dskHeads = -1;
            this.disk.dskCylinders = -1;
            this.disk.dskCapacity = -1L;
            this.disk.dskRPM = -1;
            this.disk.dskMinutesPoweredOn = -1;
            this.disk.dskSpareBlocks = -1;
            this.disk.dskHistory = dkh = new DiskHistory();
            dkh.dkhPrimaryDefects = -1;
            dkh.dkhGrownDefects = -1;
            dkh.dkhRecoveredWriteErrors = -1;
            dkh.dkhUnrecoveredWriteErrors = -1;
            dkh.dkhBytesWritten = -1L;
            dkh.dkhRecoveredReadErrors = -1;
            dkh.dkhUnrecoveredReadErrors = -1;
            dkh.dkhBytesRead = -1L;
            dkh.dkhRecoveredVerifyErrors = -1;
            dkh.dkhUnrecoveredVerifyErrors = -1;
            dkh.dkhNonMediumErrors = -1;
            dkh.dkhTemperature = (short)-274;
            dkh.dkhCapacity = -1L;
            dkh.dkhFreeSpace = -1L;
            this.disk = (Disk)this.disk.devNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"makeDiskHistory");
        }
    }

    public int probe(NasFiler pFiler, Domain domain) {
        int i;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeNetAppFiler.class.getName(), (String)"probe", (String)"pFiler, domain");
        }
        this.filer = pFiler;
        MutableInteger pRC = new MutableInteger();
        this.listener = ProbeNetAppFiler.contact(this.filer, pRC);
        if (this.listener == null) {
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"probe", (int)traceResult);
            }
            return traceResult;
        }
        this.rc = pRC.value;
        pRC = null;
        this.getPDU = this.listener.makePDU();
        this.computer = new Computer();
        this.computer.cmpDomain = domain;
        if (domain != null) {
            this.computer.cmpDomainID = domain.domID;
        }
        this.computer.cmpID = this.filer.nfComputerID;
        this.computer.cmpProcessorType = this.computer.cmpOSVersion = " ";
        this.computer.cmpManufacturer = this.filer.nfManufacturer;
        this.computer.cmpModel = this.computer.cmpOSVersion;
        this.computer.cmpSerialNumber = this.computer.cmpOSVersion;
        this.computer.cmpRAM = -1;
        this.computer.cmpSwapSpace = -1;
        this.computer.cmpLastBootTime = 0L;
        this.computer.cmpOSType = (short)10;
        this.computer.cmpProcessorCount = 1;
        this.computer.cmpProcessorSpeed = (short)-1;
        long[] array = ProbeNetAppFiler.makeFilerLevelOID();
        array[array.length - 2] = 2L;
        String s = null;
        Serializable value = this.sendGetRequest(new OID(array));
        if (value != null) {
            s = this.checkString(value);
        }
        if (s == null) {
            this.rc = 4;
        } else {
            if (s.length() > 32) {
                s = s.substring(0, 32);
            }
            this.computer.cmpOSVersion = s;
        }
        array[array.length - 2] = 3L;
        s = null;
        value = this.sendGetRequest(new OID(array));
        if (value != null) {
            s = this.checkString(value);
        }
        if (s == null) {
            this.rc = 4;
        } else {
            this.computer.cmpSerialNumber = s;
        }
        array[array.length - 2] = 5L;
        s = null;
        value = this.sendGetRequest(new OID(array), false);
        if (value != null) {
            s = this.checkString(value);
        }
        if (s != null) {
            this.computer.cmpModel = s;
        }
        array = ProbeNetAppFiler.makeCPUStatsOID();
        array[array.length - 2] = 1L;
        Number n = null;
        value = this.sendGetRequest(new OID(array));
        if (value != null) {
            n = this.checkNumber(value);
        }
        if (n == null) {
            this.rc = 4;
        } else {
            long x = n.longValue();
            x *= 10L;
            x += 50L;
            if (Variables.whoAmI == 2) {
                this.computer.cmpLastBootTime = System.currentTimeMillis() - x;
            } else {
                try {
                    this.computer.cmpLastBootTime = CurrentTime.getTimestamp().getTime() - x;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    int traceResult = 8;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ProbeNetAppFiler.class.getName(), (String)"probe", (Throwable)e);
                    }
                    return traceResult;
                }
            }
        }
        array[array.length - 2] = 6L;
        n = null;
        value = this.sendGetRequest(new OID(array), false);
        if (value != null) {
            n = this.checkNumber(value);
        }
        if (n != null) {
            this.computer.cmpProcessorCount = n.shortValue();
        }
        this.filer.nfComputer = this.computer;
        array = new long[NETAPP_RAIDV_TABLE.length + 4];
        ProbeNetAppFiler.fillRaidVTableOID(array);
        array[ProbeNetAppFiler.NETAPP_RAIDV_TABLE.length] = 4L;
        TableHandler tableHandler = new DiskTableHandler(new OID(array), this.filer, this.listener);
        if (!tableHandler.go()) {
            this.listener.close();
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"probe", (int)traceResult);
            }
            return traceResult;
        }
        this.makeDiskHistory();
        int nVols = 0;
        for (i = 0; i < RAIDV_ITEM_CODES.length; ++i) {
            array[ProbeNetAppFiler.NETAPP_RAIDV_TABLE.length] = RAIDV_ITEM_CODES[i];
            ItemHandler handler = diskItemHandlers[i];
            this.disk = (Disk)this.computer.cmpDevice;
            while (this.disk != null) {
                ProbeNetAppFiler.decodeTriple((Device)this.disk, array);
                if (nVols == 0) {
                    nVols = (int)array[array.length - 3];
                }
                if (!this.requestAndHandle(new OID(array), handler)) {
                    this.listener.close();
                    int traceResult = 8;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"probe", (int)traceResult);
                    }
                    return traceResult;
                }
                this.disk = (Disk)this.disk.devNext;
            }
        }
        array = new long[3];
        LogicalDisk lastLD = null;
        LogicalDisk ld = null;
        ChunkCollection cc = null;
        int lastVolume = -1;
        int lastRAIDGroup = -1;
        this.disk = (Disk)this.computer.cmpDevice;
        while (this.disk != null) {
            ProbeNetAppFiler.decodeTriple((Device)this.disk, array);
            if (array[0] != (long)lastVolume) {
                if (ld != null) {
                    this.finishOffLogicalDisk(ld, lastLD);
                    lastLD = ld;
                }
                ld = new LogicalDisk();
                ld.ldType = 1;
                ld.ldPath = "/vol/vol" + ((long)nVols - array[0]);
                lastVolume = (int)array[0];
                lastRAIDGroup = -1;
            }
            if (array[1] != (long)lastRAIDGroup) {
                cc = new ChunkCollection();
                cc.ccType = (byte)3;
                cc.ccSeqno = (short)array[1];
                cc.ccStripingSize = -1;
                cc.ccLogicalDisk = ld;
                cc.ccNext = ld.ldCollectionList;
                ld.ldCollectionList = cc;
                lastRAIDGroup = (int)array[1];
            }
            Chunk chunk = new Chunk();
            chunk.chkDisk = this.disk;
            chunk.chkNextOnDisk = this.disk.dskChunk;
            this.disk.dskChunk = chunk;
            chunk.chkOffset = 0L;
            chunk.chkSize = this.disk.dskCapacity - this.disk.dskHistory.dkhFreeSpace;
            chunk.chkSeqno = (short)array[2];
            chunk.chkPartition = (short)-1;
            chunk.chkUnitSize = 512;
            chunk.chkCollection = cc;
            chunk.chkNextInCollection = cc.ccChunkList;
            cc.ccChunkList = chunk;
            this.disk.devDiscoveredTime = 0L;
            this.disk = (Disk)this.disk.devNext;
        }
        if (ld != null) {
            this.finishOffLogicalDisk(ld, lastLD);
        }
        array = new long[13];
        ProbeNetAppFiler.fillFSTableOID(array);
        array[11] = 2L;
        tableHandler = new FilesystemTableHandler(new OID(array), this.filer, this.listener, nVols);
        if (!tableHandler.go()) {
            this.listener.close();
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"probe", (int)traceResult);
            }
            return traceResult;
        }
        for (i = 0; i < FS_ITEM_CODES.length; ++i) {
            array[11] = FS_ITEM_CODES[i];
            ItemHandler handler = fsItemHandlers[i];
            ld = this.computer.cmpLogicalDisk;
            while (ld != null) {
                this.fs = ld.ldFilesystem;
                if (this.fs != null) {
                    array[array.length - 1] = this.fs.fsClusterSize;
                    if (!this.requestAndHandle(new OID(array), handler)) {
                        this.listener.close();
                        int traceResult = 8;
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"probe", (int)traceResult);
                        }
                        return traceResult;
                    }
                }
                ld = ld.ldNext;
            }
        }
        Device deviceList = this.computer.cmpDevice;
        this.computer.cmpDevice = null;
        array = new long[SPARE_PREFIX_LENGTH + 2];
        ProbeNetAppFiler.fillSpareTableOID(array);
        array[ProbeNetAppFiler.SPARE_PREFIX_LENGTH] = 4L;
        tableHandler = new SpareDiskTableHandler(new OID(array), this.filer, this.listener);
        if (!tableHandler.go()) {
            this.listener.close();
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"probe", (int)traceResult);
            }
            return traceResult;
        }
        this.makeDiskHistory();
        for (i = 0; i < SPARE_ITEM_CODES.length; ++i) {
            array[ProbeNetAppFiler.SPARE_PREFIX_LENGTH] = SPARE_ITEM_CODES[i];
            ItemHandler handler = diskItemHandlers[i];
            this.disk = (Disk)this.computer.cmpDevice;
            while (this.disk != null) {
                array[array.length - 1] = (int)this.disk.devDiscoveredTime;
                if (!this.requestAndHandle(new OID(array), handler)) {
                    this.listener.close();
                    int traceResult = 8;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"probe", (int)traceResult);
                    }
                    return traceResult;
                }
                this.disk = (Disk)this.disk.devNext;
            }
        }
        this.listener.close();
        this.listener = null;
        Disk prev = null;
        this.disk = (Disk)this.computer.cmpDevice;
        while (this.disk != null) {
            this.disk.devDiscoveredTime = 0L;
            this.disk.dskHistory.dkhFreeSpace = this.disk.dskCapacity;
            prev = this.disk;
            this.disk = (Disk)this.disk.devNext;
        }
        if (prev != null) {
            prev.devNext = deviceList;
        } else {
            this.computer.cmpDevice = deviceList;
        }
        this.computer.cmpDiskCapacity = 0L;
        this.computer.cmpDiskFreeSpace = 0L;
        this.disk = (Disk)this.computer.cmpDevice;
        while (this.disk != null) {
            DiskHistory dkh = this.disk.dskHistory;
            this.computer.cmpDiskCapacity += dkh.dkhCapacity;
            this.computer.cmpDiskFreeSpace += dkh.dkhFreeSpace;
            Device dev = this.disk.devNext;
            this.disk.devNext = null;
            this.disk = (Disk)dev;
        }
        this.computer.cmpOwnedDiskCap = this.computer.cmpDiskCapacity;
        this.computer.cmpOwnedDiskFreeSp = this.computer.cmpDiskFreeSpace;
        this.computer.cmpFilesystemFreeSpace = 0L;
        ld = this.computer.cmpLogicalDisk;
        while (ld != null) {
            this.fs = ld.ldFilesystem;
            if (this.fs != null) {
                if (this.fs.fsFreeSpace + this.fs.fsUsedSpace > this.fs.fsCapacity) {
                    this.fs.fsFreeSpace = this.fs.fsCapacity - this.fs.fsUsedSpace;
                }
                this.computer.cmpFilesystemFreeSpace += this.fs.fsFreeSpace;
            }
            ld = ld.ldNext;
        }
        this.fs = this.filer.nfFilesystems;
        while (this.fs != null) {
            Filesystem next = this.fs.fsNext;
            this.fs.fsNext = null;
            ld = new LogicalDisk();
            ld.ldPath = this.fs.fsMountPoint;
            ld.ldFilesystem = this.fs;
            this.fs.fsLogicalDisk = ld;
            ld.ldType = (byte)7;
            ld.ldNext = this.computer.cmpLogicalDisk;
            this.computer.cmpLogicalDisk = ld;
            this.fs = next;
        }
        this.filer.nfFilesystems = null;
        Probe.arrangeDevices(this.computer, null);
        Probe.calculateLDOverhead(this.computer);
        int traceResult = this.rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeNetAppFiler.class.getName(), (String)"probe", (int)traceResult);
        }
        return traceResult;
    }

    static {
        FS_ITEM_CODES = new long[]{7L, 8L, 11L, 14L, 15L, 16L, 17L, 18L, 19L};
        diskItemHandlers = new ItemHandler[RAIDV_ITEM_CODES.length];
        ProbeNetAppFiler.diskItemHandlers[0] = new SCSIAdapterHandler();
        ProbeNetAppFiler.diskItemHandlers[1] = new SCSIIDHandler();
        ProbeNetAppFiler.diskItemHandlers[2] = new TotalBloxHandler();
        ProbeNetAppFiler.diskItemHandlers[3] = new UsedBloxHandler();
        fsItemHandlers = new ItemHandler[FS_ITEM_CODES.length];
        ProbeNetAppFiler.fsItemHandlers[0] = new InodesUsedHandler();
        ProbeNetAppFiler.fsItemHandlers[1] = new InodesAvailHandler();
        ProbeNetAppFiler.fsItemHandlers[2] = new InodeCapacityHandler();
        ProbeNetAppFiler.fsItemHandlers[3] = new FSCapacityHighHandler();
        ProbeNetAppFiler.fsItemHandlers[4] = new FSCapacityLowHandler();
        ProbeNetAppFiler.fsItemHandlers[5] = new FSUsedSpaceHighHandler();
        ProbeNetAppFiler.fsItemHandlers[6] = new FSUsedSpaceLowHandler();
        ProbeNetAppFiler.fsItemHandlers[7] = new FSAvailSpaceHighHandler();
        ProbeNetAppFiler.fsItemHandlers[8] = new FSAvailSpaceLowHandler();
    }
}

