/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.agent.exec.CmdExecer;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class CommonProbe {
    public Computer computer;
    public int rc;
    protected DevAccess removables;
    protected ProbeDefResp probeDef;
    protected static final String VRTS_BOOTFILE = "/etc/vx/volboot";
    protected String veritasHostName;
    protected static long blockSize = 512L;
    protected static long blockMultiplier = blockSize / 512L;
    protected int handleRc;
    protected static final int NONE_NULL = 1;
    protected static final int ALL_NULL = 0;
    protected static final int SOME_NULL = -1;

    protected abstract void platformSpecific();

    public static void setCtlrComputerID(Computer pComputer) {
        Controller ctlr = pComputer.cmpController;
        while (ctlr != null) {
            ctlr.ctlrComputerID = pComputer.cmpID;
            ctlr = ctlr.ctlrNext;
        }
    }

    public static void setVgComputerID(Computer pComputer) {
        VolGroup vg = pComputer.cmpVolGroup;
        while (vg != null) {
            vg.vgComputerID = pComputer.cmpID;
            if (pComputer.cmpOSType != 21) {
                pComputer.cmpVolGroupCapacity += vg.vgTotalSpace;
            }
            pComputer.cmpVolGroupFreespace += vg.vgFreeSpace;
            if (vg.vgDevices != null) {
                vg.vgDisks = vg.vgDevices.length;
            }
            vg = vg.vgNext;
        }
    }

    public static void setRankComputerID(Computer pComputer) {
        Rank rank = pComputer.cmpRank;
        while (rank != null) {
            rank.rankComputerID = pComputer.cmpID;
            rank = rank.rankNext;
        }
    }

    public static void sortExports(Computer pComputer) {
        TreeSet<Export> exportSorter = new TreeSet<Export>(new PathCompare());
        Export export2 = pComputer.cmpExport;
        while (export2 != null) {
            exportSorter.add(export2);
            export2 = export2.xpNext;
        }
        pComputer.cmpExport = null;
        for (Export export2 : exportSorter) {
            export2.xpNext = pComputer.cmpExport;
            export2.xpComputerID = pComputer.cmpID;
            pComputer.cmpExport = export2;
        }
    }

    private static long totalAllocdSpace(LogicalDisk ld) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"totalAllocdSpace", (String)"ld");
        }
        long total = 0L;
        ChunkCollection collection = ld.ldCollectionList;
        while (collection != null) {
            Chunk chunk = collection.ccChunkList;
            while (chunk != null) {
                if (chunk.chkDisk != null) {
                    Disk disk = chunk.chkDisk;
                    if (disk.devType != 5) {
                        total += chunk.chkSize;
                    }
                }
                chunk = chunk.chkNextInCollection;
            }
            collection = collection.ccNext;
        }
        long traceResult = total;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"totalAllocdSpace", (long)traceResult);
        }
        return traceResult;
    }

    public static void calculateLDOverhead(Computer comp) {
        LogicalDisk ld = comp.cmpLogicalDisk;
        while (ld != null) {
            if (ld.ldType == 7 || ld.ldType == 4) {
                ld.ldOverhead = 0L;
            } else {
                LogicalDisk component;
                if (!Constants.isDiskArray((short)comp.cmpOSType) && ld.ldVgroup != null) {
                    VolGroup vg = ld.ldVgroup;
                    ++vg.vgVolumes;
                }
                if ((component = ld.ldNextMirror) == null) {
                    ld.ldOverhead = CommonProbe.totalAllocdSpace(ld);
                } else {
                    ld.ldOverhead = 0L;
                    while (component != null) {
                        ld.ldOverhead += CommonProbe.totalAllocdSpace(component);
                        component = component.ldNextMirror;
                    }
                }
                ld.ldOverhead -= ld.ldCapacity;
                if (ld.ldOverhead < 0L) {
                    ld.ldOverhead = 0L;
                }
            }
            ld = ld.ldNext;
        }
    }

    protected void tallyGlobals(Computer computer) {
        if (computer.cmpOSType != 21) {
            computer.cmpDiskFreeSpace = 0L;
            computer.cmpDiskCapacity = 0L;
            computer.cmpOwnedDiskCap = 0L;
            computer.cmpOwnedDiskFreeSp = 0L;
            computer.cmpNDisks = 0;
            computer.cmpVolGroupCapacity = 0L;
            computer.cmpVolGroupFreespace = 0L;
            computer.cmpLogicalDiskAssignedCapacity = 0L;
            Device device = computer.cmpDevice;
            while (device != null) {
                if (device.devType != 5 && device instanceof Disk) {
                    boolean owned = false;
                    DevAccess da = device.devControllers;
                    while (!owned && da != null) {
                        if (da.daInactive) {
                            da = da.daNextController;
                            continue;
                        }
                        owned = true;
                    }
                    Disk disk = (Disk)device;
                    if (disk.dskHistory.dkhFreeSpace < 0L) {
                        disk.dskHistory.dkhFreeSpace = -1L;
                    } else {
                        computer.cmpDiskFreeSpace += disk.dskHistory.dkhFreeSpace;
                        if (owned) {
                            computer.cmpOwnedDiskFreeSp += disk.dskHistory.dkhFreeSpace;
                        }
                    }
                    if (!disk.isSpare()) {
                        computer.cmpDiskCapacity += disk.dskCapacity;
                    }
                    if (owned) {
                        computer.cmpOwnedDiskCap += disk.dskCapacity;
                        ++computer.cmpNDisks;
                    }
                    disk.dskHistory.dkhCapacity = disk.dskCapacity;
                }
                device = device.devNext;
            }
            if (computer.cmpDiskFreeSpace < 0L) {
                computer.cmpDiskFreeSpace = -1L;
            }
            if (Constants.isDiskArray((short)computer.cmpOSType)) {
                computer.cmpZOSLogicalDiskCapacity = -1L;
                computer.cmpNLogicalDisks = 0;
                computer.cmpLogicalDiskCapacity = 0L;
                LogicalDisk ld = computer.cmpLogicalDisk;
                while (ld != null) {
                    if (!ld.notExposed()) {
                        computer.cmpLogicalDiskAssignedCapacity += ld.ldCapacity;
                    }
                    if (computer.cmpOSType == 12) {
                        if (ld.ldPath.startsWith("0")) {
                            computer.cmpZOSLogicalDiskCapacity += ld.ldCapacity;
                        }
                    } else if ((computer.cmpOSType == 25 || computer.cmpOSType == 27) && ld.ldStorageType == 3) {
                        computer.cmpZOSLogicalDiskCapacity += ld.ldCapacity;
                    }
                    ++computer.cmpNLogicalDisks;
                    computer.cmpLogicalDiskCapacity += ld.ldCapacity;
                    ld = ld.ldNext;
                }
            }
        }
        CommonProbe.calculateLDOverhead(computer);
        CommonProbe.setCtlrComputerID(computer);
        CommonProbe.setVgComputerID(computer);
        CommonProbe.setRankComputerID(computer);
        if (computer.cmpOSType == 15) {
            computer.cmpDiskFreeSpace = computer.cmpVolGroupFreespace + computer.cmpDiskGroupFreeCap;
        }
    }

    protected void tallyFS(Computer computer) {
        computer.cmpFilesystemFreeSpace = 0L;
        LogicalDisk logicalDisk = computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            Filesystem filesystem = logicalDisk.ldFilesystem;
            if (filesystem != null && filesystem.fsType != 10) {
                computer.cmpFilesystemFreeSpace += filesystem.fsFreeSpace;
            }
            logicalDisk = logicalDisk.ldNext;
        }
    }

    protected void tallyGlobals() {
        NasFiler filerList;
        this.tallyGlobals(this.computer);
        NasFiler filer = filerList = this.computer.cmpNasFiler;
        while (filer != null) {
            if (Constants.isVirtualServer((int)filer.nfComputer.cmpOSType)) {
                this.tallyGlobals(filer.nfComputer);
                this.tallyFS(filer.nfComputer);
            }
            filer = filer.nfNext;
        }
    }

    public int probe(ProbeDefResp pProbeDef) {
        this.rc = 8;
        return this.rc;
    }

    protected void multiPathDevice(Device kept, Device discarded) {
    }

    public static void arrangeDevices(Computer computer, CommonProbe self) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"arrangeDevices", (String)"computer, self");
        }
        computer.cmpDevice = null;
        TreeSet<Controller> ctlrSorter = new TreeSet<Controller>(new CtlrCompare());
        TreeSet<DevAccess> accessSorter = new TreeSet<DevAccess>(new AccessCompare());
        HashMap<String, Device> deviceMap = new HashMap<String, Device>();
        Controller ctlr2 = computer.cmpController;
        while (ctlr2 != null) {
            ctlrSorter.add(ctlr2);
            DevAccess access2 = ctlr2.ctlrDevices;
            while (access2 != null) {
                accessSorter.add(access2);
                Device device = access2.daDevice;
                Object devObj = deviceMap.get(device.devSerialNumber);
                if (devObj == null) {
                    deviceMap.put(device.devSerialNumber, device);
                    device.devNext = computer.cmpDevice;
                    computer.cmpDevice = device;
                    access2.daNextController = null;
                    device.devControllers = access2;
                } else {
                    Device keptDevice = (Device)devObj;
                    DevAccess otherPath = keptDevice.devControllers;
                    MessageLog.logMessage((String)"STA0167I", (Object)otherPath.daPath, (Object)access2.daPath);
                    access2.daDevice = keptDevice;
                    access2.daNextController = otherPath;
                    keptDevice.devControllers = access2;
                    if (self != null) {
                        self.multiPathDevice(keptDevice, device);
                    }
                }
                access2 = access2.daNextDevice;
            }
            ctlr2.ctlrDevices = null;
            for (DevAccess access2 : accessSorter) {
                access2.daNextDevice = ctlr2.ctlrDevices;
                ctlr2.ctlrDevices = access2;
            }
            accessSorter.clear();
            ctlr2 = ctlr2.ctlrNext;
        }
        computer.cmpController = null;
        deviceMap = null;
        for (Controller ctlr2 : ctlrSorter) {
            ctlr2.ctlrNext = computer.cmpController;
            computer.cmpController = ctlr2;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"arrangeDevices");
        }
    }

    protected void arrangeDevices() {
        CommonProbe.arrangeDevices(this.computer, this);
    }

    private static boolean notEmpty(Object[] array) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"notEmpty", (String)"array");
        }
        int count = array == null ? 0 : array.length;
        boolean empty = true;
        for (int i = 0; empty && i < count; ++i) {
            if (array[i] == null) continue;
            empty = false;
        }
        boolean bl = traceResult = !empty;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"notEmpty", (boolean)traceResult);
        }
        return traceResult;
    }

    private static boolean cleanSimpleLD(LogicalDisk ld) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"cleanSimpleLD", (String)"ld");
        }
        ChunkCollection prev = null;
        ChunkCollection cc = ld.ldCollectionList;
        while (cc != null) {
            if (cc.ccChunkList != null || CommonProbe.notEmpty(cc.ccPackedChunkList)) {
                prev = cc;
            } else if (prev != null) {
                prev.ccNext = cc.ccNext;
            } else {
                ld.ldCollectionList = cc.ccNext;
            }
            cc = cc.ccNext;
        }
        boolean bl = traceResult = ld.ldCollectionList != null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"cleanSimpleLD", (boolean)traceResult);
        }
        return traceResult;
    }

    private static boolean cleanComplexLD(LogicalDisk logicalDisk) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"cleanComplexLD", (String)"logicalDisk");
        }
        LogicalDisk prev = null;
        LogicalDisk ld = logicalDisk.ldNextMirror;
        while (ld != null) {
            if (CommonProbe.cleanSimpleLD(ld)) {
                prev = ld;
            } else {
                logicalDisk.ldMirrorCount = (byte)(logicalDisk.ldMirrorCount - 1);
                if (prev != null) {
                    prev.ldNextMirror = ld.ldNextMirror;
                } else {
                    logicalDisk.ldNextMirror = ld.ldNextMirror;
                }
            }
            ld = ld.ldNextMirror;
        }
        boolean bl = traceResult = logicalDisk.ldNextMirror != null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"cleanComplexLD", (boolean)traceResult);
        }
        return traceResult;
    }

    private void removeChunklessCollections() {
        LogicalDisk ld = this.computer.cmpLogicalDisk;
        while (ld != null) {
            boolean keep = ld.isComplex() ? CommonProbe.cleanComplexLD(ld) : CommonProbe.cleanSimpleLD(ld);
            if (!keep) {
                ld.ldType = (byte)7;
            }
            ld = ld.ldNext;
        }
    }

    protected LogicalDisk promoteChunk(Chunk chunk) {
        LogicalDisk logicalDisk;
        ChunkCollection collection;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"promoteChunk", (String)"chunk");
        }
        if ((collection = chunk.chkCollection) != null) {
            LogicalDisk traceResult = collection.ccLogicalDisk;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"promoteChunk", (Object)traceResult);
            }
            return traceResult;
        }
        collection = new ChunkCollection();
        collection.ccStripingSize = -1;
        collection.ccSeqno = 0;
        collection.ccType = 0;
        collection.ccChunkList = chunk;
        chunk.chkCollection = collection;
        chunk.chkSeqno = 0;
        collection.ccLogicalDisk = logicalDisk = new LogicalDisk();
        logicalDisk.ldCollectionList = collection;
        logicalDisk.ldType = 0;
        logicalDisk.ldCapacity = chunk.chkSize;
        if (chunk.chkDisk != null) {
            logicalDisk.ldIsSwap = chunk.chkDiskID == -2;
        }
        logicalDisk.ldNext = this.computer.cmpLogicalDisk;
        this.computer.cmpLogicalDisk = logicalDisk;
        LogicalDisk traceResult = logicalDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"promoteChunk", (Object)traceResult);
        }
        return traceResult;
    }

    protected void cleanUpPartitionsAndDisks() {
        Controller controller;
        Device previousDevice = null;
        this.removeChunklessCollections();
        Device device = this.computer.cmpDevice;
        while (device != null) {
            if (device instanceof Disk) {
                Disk disk = (Disk)device;
                Chunk chunk = disk.dskChunk;
                while (chunk != null) {
                    if (chunk.chkCollection == null) {
                        this.promoteChunk(chunk);
                    }
                    chunk = chunk.chkNextOnDisk;
                }
                previousDevice = device;
            } else {
                if (previousDevice != null) {
                    previousDevice.devNext = device.devNext;
                } else {
                    this.computer.cmpDevice = device.devNext;
                }
                DevAccess thisAccess = device.devControllers;
                while (thisAccess != null) {
                    controller = thisAccess.daController;
                    DevAccess previousAccess = null;
                    DevAccess access = controller.ctlrDevices;
                    while (access != thisAccess && access != null) {
                        previousAccess = access;
                        access = access.daNextDevice;
                    }
                    if (access == thisAccess) {
                        if (previousAccess != null) {
                            previousAccess.daNextDevice = access.daNextDevice;
                        } else {
                            controller.ctlrDevices = access.daNextDevice;
                        }
                    }
                    thisAccess.daNextDevice = this.removables;
                    this.removables = thisAccess;
                    thisAccess = thisAccess.daNextController;
                }
            }
            device = device.devNext;
        }
        Controller previousCtlr = null;
        controller = this.computer.cmpController;
        while (controller != null) {
            if (controller.ctlrDevices != null || controller.ctlrHBAPortWWN > 0L) {
                previousCtlr = controller;
            } else if (previousCtlr == null) {
                this.computer.cmpController = controller.ctlrNext;
            } else {
                previousCtlr.ctlrNext = controller.ctlrNext;
            }
            controller = controller.ctlrNext;
        }
    }

    protected Controller cloneController(Controller ctlr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"cloneController", (String)"ctlr");
        }
        Controller result = new Controller();
        result.ctlrDriverName = ctlr.ctlrDriverName;
        result.ctlrDriverDescription = ctlr.ctlrDriverDescription;
        result.ctlrTarget = ctlr.ctlrTarget;
        result.ctlrType = ctlr.ctlrType;
        Controller traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"cloneController", (Object)traceResult);
        }
        return traceResult;
    }

    protected static void makeNASComputer(NasFiler filer) {
        Computer nasComp = new Computer();
        nasComp.cmpManufacturer = filer.nfManufacturer;
        nasComp.cmpDomain = filer.nfDomain;
        nasComp.cmpDomainID = filer.nfDomain != null ? filer.nfDomain.domID : -1;
        nasComp.cmpOSType = (short)9;
        nasComp.cmpRAM = -1;
        nasComp.cmpSwapSpace = -1;
        nasComp.cmpDiskCapacity = -1L;
        nasComp.cmpDiskFreeSpace = -1L;
        nasComp.cmpOwnedDiskCap = -1L;
        nasComp.cmpOwnedDiskFreeSp = -1L;
        nasComp.cmpFilesystemFreeSpace = -1L;
        nasComp.cmpOSVersion = " ";
        nasComp.cmpProcessorType = " ";
        nasComp.cmpModel = " ";
        nasComp.cmpSerialNumber = " ";
        nasComp.cmpID = filer.nfComputerID;
        filer.nfComputer = nasComp;
    }

    protected static void addFSToFiler(NasFiler filer, Filesystem fs) {
        LogicalDisk ld = new LogicalDisk();
        ld.ldCapacity = fs.fsCapacity;
        ld.ldPath = fs.fsMountPoint;
        ld.ldFilesystem = fs;
        fs.fsLogicalDisk = ld;
        ld.ldType = (byte)7;
        Computer nasComp = filer.nfComputer;
        ld.ldNext = nasComp.cmpLogicalDisk;
        nasComp.cmpLogicalDisk = ld;
    }

    private static void cleanUpChild(CmdExecer execer) {
        execer.close();
    }

    protected boolean isVeritasRunning() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"isVeritasRunning", (String)"");
        }
        boolean isRunning = false;
        ShellCommand shell = new ShellCommand("vxdctl mode | awk '{ print $2 }'");
        if (!shell.bCool) {
            MessageLog.logMessage((String)"STA0350E");
            shell.cleanUp();
            boolean traceResult = isRunning;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"isVeritasRunning", (boolean)traceResult);
            }
            return traceResult;
        }
        String buffer = null;
        while ((buffer = shell.getString()) != null) {
            if (buffer.compareTo("enabled") == 0) {
                isRunning = true;
                continue;
            }
            MessageLog.logMessage((String)"STA0350E");
        }
        shell.cleanUp();
        boolean traceResult = isRunning;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"isVeritasRunning", (boolean)traceResult);
        }
        return traceResult;
    }

    protected void determineVeritasHostName() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"determineVeritasHostName", (String)"");
        }
        this.veritasHostName = null;
        FileReader reader = null;
        try {
            reader = new FileReader(VRTS_BOOTFILE);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CommonProbe.class.getName(), (String)"determineVeritasHostName", (Throwable)e);
            }
            MessageLog.logException((String)"GEN0029E", (Exception)e);
            this.rc = 4;
        }
        if (reader == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"determineVeritasHostName");
            }
            return;
        }
        boolean exceptionThrown = false;
        BufferedReader in = new BufferedReader(reader);
        try {
            String line;
            MutableInteger pos = new MutableInteger();
            while (this.veritasHostName == null && (line = in.readLine()) != null) {
                pos.value = 0;
                String token = Util.nextWord((String)line, (MutableInteger)pos);
                if (!Util.stringsEqual((String)token, (String)"hostid")) continue;
                this.veritasHostName = Util.nextWord((String)line, (MutableInteger)pos);
            }
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CommonProbe.class.getName(), (String)"determineVeritasHostName", (Throwable)e);
            }
            MessageLog.logException((String)"GEN0133E", (Exception)e, (Object)VRTS_BOOTFILE);
            exceptionThrown = true;
        }
        if (this.veritasHostName == null) {
            if (!exceptionThrown) {
                MessageLog.logMessage((String)"STA0244W");
            }
            this.rc = 4;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"determineVeritasHostName");
        }
    }

    private Vector getVeritasConfiguration() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"getVeritasConfiguration", (String)"");
        }
        Vector<VeritasDiskGroup> diskGroupVector = new Vector<VeritasDiskGroup>(10, 2);
        ShellCommand shell = null;
        String buffer = null;
        VeritasDiskGroup diskGroup = null;
        Object disk = null;
        Object volume = null;
        Object plex = null;
        Object subDisk = null;
        Object tokenizer = null;
        shell = new ShellCommand("vxdg -q list | awk '{ print $1 }'");
        if (shell.bCool) {
            while ((buffer = shell.getString()) != null) {
                diskGroup = new VeritasDiskGroup(buffer);
                diskGroupVector.add(diskGroup);
            }
        }
        shell.cleanUp();
        boolean allFailed = true;
        for (int i = 0; i < diskGroupVector.size(); ++i) {
            diskGroup = (VeritasDiskGroup)diskGroupVector.elementAt(i);
            if (diskGroup.setAttributes()) {
                allFailed = false;
                continue;
            }
            MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("31" + diskGroup.name));
        }
        if (allFailed) {
            diskGroupVector = null;
        }
        Vector<VeritasDiskGroup> traceResult = diskGroupVector;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"getVeritasConfiguration", traceResult);
        }
        return traceResult;
    }

    public int handleVeritas() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"handleVeritas", (String)"");
        }
        Vector diskGroupVector = null;
        HashedDisk hashDisk = null;
        HashedVolume hashVolume = null;
        HashedPlex hashPlex = null;
        HashedSubDisk hashSubDisk = null;
        Hashtable<VeritasRid, HashedDisk> diskTable = null;
        Hashtable<VeritasRid, HashedVolume> volumeTable = null;
        Hashtable<VeritasRid, HashedPlex> plexTable = null;
        int rc = 0;
        long freeSpace = 0L;
        VeritasDiskGroup vrtsDiskGroup = null;
        VeritasDisk vrtsDisk = null;
        VeritasVolume vrtsVolume = null;
        VeritasPlex vrtsPlex = null;
        VeritasSubDisk vrtsSubDisk = null;
        HashedVolume parentVolume = null;
        HashedVolume headVolume = null;
        HashedVolume currVolume = null;
        HashedVolume prevVolume = null;
        Object currPlex = null;
        Object prevPlex = null;
        HashedSubDisk currSubDisk = null;
        HashedSubDisk prevSubDisk = null;
        diskGroupVector = this.getVeritasConfiguration();
        if (diskGroupVector == null) {
            MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)"32");
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"handleVeritas", (int)traceResult);
            }
            return traceResult;
        }
        for (int i = 0; i < diskGroupVector.size(); ++i) {
            int j;
            vrtsDiskGroup = (VeritasDiskGroup)diskGroupVector.elementAt(i);
            if (!vrtsDiskGroup.probed) continue;
            LinkedList<Disk> vgDevlist = new LinkedList<Disk>();
            diskTable = new Hashtable<VeritasRid, HashedDisk>();
            for (j = 0; j < vrtsDiskGroup.diskVector.size(); ++j) {
                Disk disk = null;
                Chunk chunk = null;
                vrtsDisk = (VeritasDisk)vrtsDiskGroup.diskVector.elementAt(j);
                disk = this.lookUpDisk(vrtsDisk.deviceTag);
                if (disk == null) {
                    rc = 4;
                    continue;
                }
                vgDevlist.add(disk);
                if (!this.AdjustDMOffset(disk, vrtsDisk.publicCPath, vrtsDisk.publicOffset)) {
                    rc = 4;
                }
                freeSpace = disk.dskCapacity - 1L;
                if (!vrtsDisk.tFlag) {
                    chunk = null;
                } else {
                    if (!this.AdjustDMOffset(disk, vrtsDisk.privateCPath, vrtsDisk.privateOffset)) {
                        rc = 4;
                    }
                    chunk = new Chunk();
                    chunk.chkDiskID = -1;
                    chunk.chkPartition = (short)-1;
                    chunk.chkUnitSize = 512;
                    chunk.chkSize = vrtsDisk.privateLength;
                    chunk.chkOffset = vrtsDisk.privateOffset;
                    chunk.chkDisk = disk;
                    freeSpace -= chunk.chkSize;
                }
                disk.dskChunk = chunk;
                disk.dskHistory.dkhFreeSpace = freeSpace;
                hashDisk = new HashedDisk(vrtsDisk, disk);
                diskTable.put(vrtsDisk.rid, hashDisk);
            }
            headVolume = null;
            volumeTable = new Hashtable<VeritasRid, HashedVolume>();
            for (j = 0; j < vrtsDiskGroup.volumeVector.size(); ++j) {
                vrtsVolume = (VeritasVolume)vrtsDiskGroup.volumeVector.elementAt(j);
                hashVolume = new HashedVolume(vrtsVolume);
                if (vrtsVolume.sdNum == 0) {
                    if (headVolume == null) {
                        headVolume = hashVolume;
                    } else {
                        prevVolume.next = hashVolume;
                    }
                    prevVolume = hashVolume;
                }
                volumeTable.put(vrtsVolume.rid, hashVolume);
            }
            plexTable = new Hashtable<VeritasRid, HashedPlex>();
            for (j = 0; j < vrtsDiskGroup.plexVector.size(); ++j) {
                vrtsPlex = (VeritasPlex)vrtsDiskGroup.plexVector.elementAt(j);
                hashPlex = new HashedPlex(vrtsPlex);
                plexTable.put(vrtsPlex.rid, hashPlex);
                hashVolume = (HashedVolume)volumeTable.get(vrtsPlex.volumeRid);
                if (hashVolume != null) {
                    hashPlex.hashVolume = hashVolume;
                    this.AddPlexToVolume(hashVolume, hashPlex);
                    continue;
                }
                MessageLog.logMessage((String)"STA0229W", (Object)vrtsPlex.name, (Object)vrtsPlex.volumeName, (Object)vrtsPlex.volumeRid.toString());
                rc = 4;
            }
            for (j = 0; j < vrtsDiskGroup.subDiskVector.size(); ++j) {
                vrtsSubDisk = (VeritasSubDisk)vrtsDiskGroup.subDiskVector.elementAt(j);
                if (!vrtsSubDisk.pFlag) continue;
                hashVolume = (HashedVolume)volumeTable.get(vrtsSubDisk.diskRid);
                if (hashVolume == null) {
                    MessageLog.logMessage((String)"STA0230W", (Object)vrtsSubDisk.name, (Object)vrtsSubDisk.diskRid.toString());
                    rc = 4;
                    continue;
                }
                hashPlex = this.LookUpPlex(plexTable, vrtsSubDisk);
                if (hashPlex == null) {
                    rc = 4;
                    continue;
                }
                if (hashVolume.vrtsVolume.sdNum == 0) {
                    MessageLog.logMessage((String)"STA0233W", (Object)hashVolume.vrtsVolume.name, (Object)hashVolume.vrtsVolume.rid.toString());
                    rc = 4;
                    continue;
                }
                parentVolume = hashPlex.hashVolume;
                if (hashVolume.assocVolume != null) {
                    MessageLog.logMessage((String)"STA0232W", (Object)hashVolume.vrtsVolume.name, (Object)hashVolume.assocVolume.vrtsVolume.name, (Object)parentVolume.vrtsVolume.name);
                    rc = 4;
                    continue;
                }
                if (parentVolume.vrtsVolume.sdNum != 0) {
                    MessageLog.logMessage((String)"STA0234W", (Object)parentVolume.vrtsVolume.name);
                    continue;
                }
                hashVolume.assocVolume = parentVolume;
                hashVolume.column = vrtsSubDisk.column;
                if (parentVolume.assocVolume == null) {
                    hashVolume.next = null;
                    parentVolume.assocVolume = hashVolume;
                    continue;
                }
                if (hashVolume.column <= parentVolume.assocVolume.column) {
                    hashVolume.next = parentVolume.assocVolume;
                    parentVolume.assocVolume = hashVolume;
                    continue;
                }
                prevVolume = parentVolume.assocVolume;
                currVolume = prevVolume.next;
                while (currVolume != null && hashVolume.column > currVolume.column) {
                    prevVolume = currVolume;
                    currVolume = currVolume.next;
                }
                hashVolume.next = currVolume;
                prevVolume.next = hashVolume;
            }
            for (j = 0; j < vrtsDiskGroup.subDiskVector.size(); ++j) {
                vrtsSubDisk = (VeritasSubDisk)vrtsDiskGroup.subDiskVector.elementAt(j);
                if (vrtsSubDisk.pFlag) continue;
                hashDisk = (HashedDisk)diskTable.get(vrtsSubDisk.diskRid);
                if (hashDisk == null) {
                    MessageLog.logMessage((String)"STA0235W", (Object)vrtsSubDisk.name, (Object)vrtsSubDisk.diskName, (Object)vrtsSubDisk.diskRid);
                    rc = 4;
                    continue;
                }
                hashDisk.disk.dskHistory.dkhFreeSpace -= vrtsSubDisk.length;
                hashPlex = this.LookUpPlex(plexTable, vrtsSubDisk);
                if (hashPlex == null) {
                    rc = 4;
                    continue;
                }
                hashVolume = hashPlex.hashVolume;
                if (hashVolume.vrtsVolume.sdNum != 0 && hashVolume.assocVolume == null) {
                    if (!hashVolume.bMsgIssued) {
                        MessageLog.logMessage((String)"STA0236W", (Object)hashVolume.vrtsVolume.name, (Object)hashVolume.vrtsVolume.rid.toString());
                        hashVolume.bMsgIssued = true;
                    }
                    rc = 4;
                    continue;
                }
                hashSubDisk = new HashedSubDisk(vrtsSubDisk, hashDisk);
                if (hashPlex.hashSubDisk == null) {
                    hashSubDisk.next = null;
                    hashPlex.hashSubDisk = hashSubDisk;
                    continue;
                }
                if (!this.SubDiskGreaterThan(hashSubDisk, hashPlex.hashSubDisk)) {
                    hashSubDisk.next = hashPlex.hashSubDisk;
                    hashPlex.hashSubDisk = hashSubDisk;
                    continue;
                }
                prevSubDisk = hashPlex.hashSubDisk;
                currSubDisk = prevSubDisk.next;
                while (currSubDisk != null && this.SubDiskGreaterThan(hashSubDisk, currSubDisk)) {
                    prevSubDisk = currSubDisk;
                    currSubDisk = currSubDisk.next;
                }
                hashSubDisk.next = currSubDisk;
                prevSubDisk.next = hashSubDisk;
            }
            VolGroup nextVolgroup = null;
            VolGroup vrtsVolgroup = new VolGroup();
            vrtsVolgroup.vgName = vrtsDiskGroup.name;
            vrtsVolgroup.vgType = 0;
            vrtsVolgroup.vgFreeSpace = vrtsDiskGroup.freeSpace;
            vrtsVolgroup.vgTotalSpace = vrtsDiskGroup.totalSpace;
            vrtsVolgroup.vgDevices = new Device[vgDevlist.size()];
            vgDevlist.toArray(vrtsVolgroup.vgDevices);
            vrtsVolgroup.vgNext = nextVolgroup = this.computer.cmpVolGroup;
            this.computer.cmpVolGroup = vrtsVolgroup;
            hashVolume = headVolume;
            while (hashVolume != null) {
                LogicalDisk logicalDisk = null;
                LogicalDisk nextLogicalDisk = null;
                this.handleRc = rc;
                logicalDisk = hashVolume.assocVolume != null ? this.HandleLayeredVolume(hashVolume) : this.HandleSimpleVolume(hashVolume, false);
                rc = this.handleRc;
                if (logicalDisk != null) {
                    String s = "/dev/vx/dsk/" + vrtsDiskGroup.name + "/" + hashVolume.vrtsVolume.name;
                    logicalDisk.ldVgroup = vrtsVolgroup;
                    logicalDisk.ldPath = s;
                    logicalDisk.ldTruePath = s;
                    logicalDisk.ldCapacity = hashVolume.vrtsVolume.length;
                    logicalDisk.ldNext = nextLogicalDisk = this.computer.cmpLogicalDisk;
                    this.computer.cmpLogicalDisk = logicalDisk;
                }
                hashVolume = hashVolume.next;
            }
        }
        int traceResult = rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"handleVeritas", (int)traceResult);
        }
        return traceResult;
    }

    private boolean AdjustDMOffset(Disk disk, String publicCPath, long offset) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"AdjustDMOffset", (String)"disk, publicCPath, offset");
        }
        int slice = 0;
        Chunk chunk = null;
        boolean bLooking = false;
        short partition = 0;
        boolean bResult = true;
        int index = -1;
        index = publicCPath.indexOf(115);
        if (index < 0) {
            boolean traceResult = bResult;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"AdjustDMOffset", (boolean)traceResult);
            }
            return traceResult;
        }
        try {
            slice = Integer.parseInt(publicCPath.substring(index + 1));
        }
        catch (NumberFormatException nfex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CommonProbe.class.getName(), (String)"AdjustDMOffset", (Throwable)nfex);
            }
            boolean traceResult = bResult;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"AdjustDMOffset", (boolean)traceResult);
            }
            return traceResult;
        }
        if (slice == 2) {
            boolean traceResult = bResult;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"AdjustDMOffset", (boolean)traceResult);
            }
            return traceResult;
        }
        bLooking = true;
        chunk = disk.dskChunk;
        while (chunk != null && bLooking) {
            partition = chunk.chkPartition;
            if (partition == slice) {
                bLooking = false;
                continue;
            }
            chunk = chunk.chkNextOnDisk;
        }
        if (!bLooking) {
            offset += chunk.chkOffset;
        } else {
            MessageLog.logMessage((String)"STA0228W", (Object)publicCPath);
            bResult = false;
        }
        boolean traceResult = bResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"AdjustDMOffset", (boolean)traceResult);
        }
        return traceResult;
    }

    private void AddPlexToVolume(HashedVolume hashVolume, HashedPlex hashPlex) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"AddPlexToVolume", (String)"hashVolume, hashPlex");
        }
        HashedPlex curr = null;
        HashedPlex prev = null;
        curr = hashVolume.hashPlex;
        if (curr == null) {
            hashVolume.hashPlex = hashPlex;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"AddPlexToVolume");
            }
            return;
        }
        if (hashPlex.vrtsPlex.rid.compareTo(curr.vrtsPlex.rid) > 0) {
            hashPlex.next = curr;
            hashVolume.hashPlex = hashPlex;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"AddPlexToVolume");
            }
            return;
        }
        prev = curr;
        curr = curr.next;
        while (curr != null && hashPlex.vrtsPlex.rid.compareTo(curr.vrtsPlex.rid) > 0) {
            prev = curr;
            curr = curr.next;
        }
        hashPlex.next = curr;
        prev.next = hashPlex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"AddPlexToVolume");
        }
    }

    private HashedPlex LookUpPlex(Hashtable plexTable, VeritasSubDisk veritasSubDisk) {
        HashedPlex hashPlex;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"LookUpPlex", (String)"plexTable, veritasSubDisk");
        }
        if ((hashPlex = (HashedPlex)plexTable.get(veritasSubDisk.plexRid)) == null) {
            MessageLog.logMessage((String)"STA0231W", (Object)veritasSubDisk.name, (Object)veritasSubDisk.plexName, (Object)veritasSubDisk.plexRid.toString());
        } else if (hashPlex.hashVolume == null) {
            hashPlex = null;
        }
        HashedPlex traceResult = hashPlex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"LookUpPlex", (Object)traceResult);
        }
        return traceResult;
    }

    private boolean SubDiskGreaterThan(HashedSubDisk left, HashedSubDisk right) {
        boolean traceResult;
        long rightOffset;
        long leftOffset;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"SubDiskGreaterThan", (String)"left, right");
        }
        if ((leftOffset = left.vrtsSubDisk.plexOffset) != (rightOffset = right.vrtsSubDisk.plexOffset)) {
            boolean traceResult2;
            boolean bl = traceResult2 = leftOffset > rightOffset;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"SubDiskGreaterThan", (boolean)traceResult2);
            }
            return traceResult2;
        }
        boolean bl = traceResult = left.vrtsSubDisk.column > right.vrtsSubDisk.column;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"SubDiskGreaterThan", (boolean)traceResult);
        }
        return traceResult;
    }

    private Chunk makeChunk(HashedDisk hashDisk, ChunkCollection collection, int seqNo, Chunk lastChunk, long size, long offset) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"makeChunk", (String)"hashDisk, collection, seqNo, lastChunk, size, offset");
        }
        Chunk chunk = new Chunk();
        Disk disk = hashDisk.disk;
        chunk.chkPartition = (short)-1;
        chunk.chkUnitSize = 512;
        chunk.chkSize = size;
        chunk.chkOffset = offset + hashDisk.vrtsDisk.publicOffset;
        chunk.chkDiskID = -1;
        chunk.chkDisk = disk;
        chunk.chkNextOnDisk = disk.dskChunk;
        disk.dskChunk = chunk;
        chunk.chkCollection = collection;
        chunk.chkSeqno = (short)seqNo;
        if (lastChunk != null) {
            lastChunk.chkNextInCollection = chunk;
        } else {
            collection.ccChunkList = chunk;
        }
        Chunk traceResult = chunk;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"makeChunk", (Object)traceResult);
        }
        return traceResult;
    }

    private Chunk makeChunkWrapped(HashedSubDisk hashSubDisk, ChunkCollection collection, int seqNo, Chunk lastChunk) {
        return this.makeChunk(hashSubDisk.hashDisk, collection, seqNo, lastChunk, hashSubDisk.vrtsSubDisk.length, hashSubDisk.vrtsSubDisk.diskOffset);
    }

    private ChunkCollection ConcatCollection(HashedPlex hashPlex, LogicalDisk logicalDisk) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"ConcatCollection", (String)"hashPlex, logicalDisk");
        }
        ChunkCollection collection = new ChunkCollection();
        int seqNo = 0;
        Chunk lastChunk = null;
        HashedSubDisk hashSubDisk = hashPlex.hashSubDisk;
        HashedSubDisk nextSubDisk = null;
        if (hashSubDisk == null) {
            ChunkCollection traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"ConcatCollection", traceResult);
            }
            return traceResult;
        }
        collection.ccType = 0;
        collection.ccLogicalDisk = logicalDisk;
        while (hashSubDisk != null) {
            nextSubDisk = hashSubDisk.next;
            lastChunk = this.makeChunkWrapped(hashSubDisk, collection, seqNo, lastChunk);
            seqNo = (short)(seqNo + 1);
            hashSubDisk = nextSubDisk;
        }
        ChunkCollection traceResult = collection;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"ConcatCollection", (Object)traceResult);
        }
        return traceResult;
    }

    private static void binByColumn(HashedSubDisk[] array, HashedSubDisk member, int column) {
        HashedSubDisk element = array[column];
        if (element == null) {
            array[column] = member;
        } else {
            while (element.next != null) {
                element = element.next;
            }
            element.next = member;
        }
    }

    private static int checkArray(Object[] array) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"checkArray", (String)"array");
        }
        boolean allNull = true;
        boolean noneNull = true;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                noneNull = false;
                continue;
            }
            allNull = false;
        }
        int result = allNull ? 0 : (noneNull ? 1 : -1);
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"checkArray", (int)traceResult);
        }
        return traceResult;
    }

    private LogicalDisk MakePrimitiveLogicalDisk(HashedPlex hashPlex) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"MakePrimitiveLogicalDisk", (String)"hashPlex");
        }
        LogicalDisk logicalDisk = null;
        ChunkCollection collection = null;
        ChunkCollection lastCollection = null;
        Chunk lastChunk = null;
        int collType = 0;
        int chunkSeqNo = 0;
        int nColumns = 0;
        short collSeqNo = 0;
        Object hashSubDisk = null;
        HashedSubDisk nextSubDisk = null;
        logicalDisk = new LogicalDisk();
        logicalDisk.ldType = 1;
        if (hashPlex.vrtsPlex.layout.equals("CONCAT")) {
            logicalDisk.ldCollectionList = collection = this.ConcatCollection(hashPlex, logicalDisk);
        } else {
            int usedStatus;
            collType = hashPlex.vrtsPlex.layout.equals("RAID") ? 2 : 1;
            hashSubDisk = hashPlex.hashSubDisk;
            while (hashSubDisk != null) {
                VeritasSubDisk subDisk = ((HashedSubDisk)hashSubDisk).vrtsSubDisk;
                if (subDisk.column >= nColumns) {
                    nColumns = subDisk.column + 1;
                }
                hashSubDisk = ((HashedSubDisk)hashSubDisk).next;
            }
            Object[] array = new HashedSubDisk[nColumns];
            hashSubDisk = hashPlex.hashSubDisk;
            while (hashSubDisk != null) {
                nextSubDisk = ((HashedSubDisk)hashSubDisk).next;
                ((HashedSubDisk)hashSubDisk).next = null;
                CommonProbe.binByColumn((HashedSubDisk[])array, (HashedSubDisk)hashSubDisk, ((HashedSubDisk)hashSubDisk).vrtsSubDisk.column);
                hashSubDisk = nextSubDisk;
            }
            collSeqNo = 0;
            collection = null;
            while ((usedStatus = CommonProbe.checkArray(array)) == 1) {
                long smallest = Long.MAX_VALUE;
                for (int i = 0; i < nColumns; ++i) {
                    VeritasSubDisk subDisk = ((HashedSubDisk)array[i]).vrtsSubDisk;
                    if (subDisk.length >= smallest) continue;
                    smallest = subDisk.length;
                }
                collection = new ChunkCollection();
                collection.ccType = (byte)collType;
                collection.ccSeqno = collSeqNo;
                collSeqNo = (short)(collSeqNo + 1);
                collection.ccLogicalDisk = logicalDisk;
                collection.ccStripingSize = (int)hashPlex.vrtsPlex.stripeWidth * 512;
                if (lastCollection == null) {
                    logicalDisk.ldCollectionList = collection;
                } else {
                    lastCollection.ccNext = collection;
                }
                lastCollection = collection;
                lastChunk = null;
                for (chunkSeqNo = 0; chunkSeqNo < nColumns; ++chunkSeqNo) {
                    hashSubDisk = array[chunkSeqNo];
                    VeritasSubDisk subDisk = ((HashedSubDisk)hashSubDisk).vrtsSubDisk;
                    lastChunk = this.makeChunk(((HashedSubDisk)hashSubDisk).hashDisk, collection, chunkSeqNo, lastChunk, smallest, subDisk.diskOffset);
                    if (subDisk.length == smallest) {
                        array[chunkSeqNo] = ((HashedSubDisk)hashSubDisk).next;
                        continue;
                    }
                    subDisk.diskOffset += smallest;
                    subDisk.length -= smallest;
                }
            }
            if (usedStatus != 0) {
                MessageLog.logMessage((String)"STA0605W", (Object)hashPlex.vrtsPlex.rid.toString());
                this.handleRc = 4;
            }
        }
        if (collection == null) {
            logicalDisk = null;
        }
        LogicalDisk traceResult = logicalDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"MakePrimitiveLogicalDisk", (Object)traceResult);
        }
        return traceResult;
    }

    private LogicalDisk MakeCollectionMirror(HashedPlex plexHead) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"MakeCollectionMirror", (String)"plexHead");
        }
        int seqNo = 0;
        LogicalDisk logicalDisk = null;
        ChunkCollection lastCollection = null;
        ChunkCollection collection = null;
        HashedPlex currPlex = plexHead;
        logicalDisk = new LogicalDisk();
        logicalDisk.ldType = (byte)2;
        while (currPlex != null) {
            if (!currPlex.vrtsPlex.isLogPlex() && (collection = this.ConcatCollection(currPlex, logicalDisk)) != null) {
                int n = seqNo;
                seqNo = (short)(seqNo + 1);
                collection.ccSeqno = (short)n;
                if (lastCollection != null) {
                    lastCollection.ccNext = collection;
                } else {
                    logicalDisk.ldCollectionList = collection;
                }
                lastCollection = collection;
            }
            currPlex = currPlex.next;
        }
        if (lastCollection == null) {
            logicalDisk = null;
        }
        LogicalDisk traceResult = logicalDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"MakeCollectionMirror", (Object)traceResult);
        }
        return traceResult;
    }

    private LogicalDisk MakeLogicalDiskMirror(HashedVolume hashVolume, int copyNumber) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"MakeLogicalDiskMirror", (String)"hashVolume, copyNumber");
        }
        LogicalDisk logicalDisk = new LogicalDisk();
        LogicalDisk ld = null;
        LogicalDisk lastLogicalDisk = null;
        HashedPlex hashPlex = hashVolume.hashPlex;
        String twoDigitNumber = null;
        String pathBase = hashVolume.vrtsVolume.name + "_";
        int count = 0;
        logicalDisk.ldType = (byte)3;
        logicalDisk.ldMirrorCount = (byte)copyNumber;
        lastLogicalDisk = logicalDisk;
        while (hashPlex != null) {
            if (!hashPlex.vrtsPlex.isLogPlex() && (ld = this.MakePrimitiveLogicalDisk(hashPlex)) != null) {
                twoDigitNumber = count < 10 ? "0" + count : "" + count;
                ld.ldPath = pathBase + twoDigitNumber;
                lastLogicalDisk.ldNextMirror = ld;
                lastLogicalDisk = ld;
                ++count;
            }
            hashPlex = hashPlex.next;
        }
        if (lastLogicalDisk == logicalDisk) {
            logicalDisk = null;
        }
        LogicalDisk traceResult = logicalDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"MakeLogicalDiskMirror", (Object)traceResult);
        }
        return traceResult;
    }

    private LogicalDisk HandleSimpleVolume(HashedVolume hashVolume, boolean isSubVolume) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"HandleSimpleVolume", (String)"hashVolume, isSubVolume");
        }
        int copyNumber = 0;
        HashedPlex hashPlex = null;
        HashedPlex savedPlex = null;
        boolean allConcat = true;
        LogicalDisk logicalDisk = null;
        Object collection = null;
        hashPlex = hashVolume.hashPlex;
        while (hashPlex != null) {
            if (!hashPlex.vrtsPlex.isLogPlex()) {
                savedPlex = hashPlex;
                ++copyNumber;
                if (!hashPlex.vrtsPlex.layout.equals("CONCAT")) {
                    allConcat = false;
                }
            }
            hashPlex = hashPlex.next;
        }
        if (copyNumber == 0) {
            MessageLog.logMessage((String)"STA0237W", (Object)hashVolume.vrtsVolume.name);
            this.handleRc = 4;
            LogicalDisk traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"HandleSimpleVolume", traceResult);
            }
            return traceResult;
        }
        if (isSubVolume && copyNumber > 1 && !allConcat) {
            MessageLog.logMessage((String)"STA0238W", (Object)hashVolume.vrtsVolume.name);
            allConcat = true;
            this.handleRc = 4;
        }
        logicalDisk = copyNumber == 1 ? this.MakePrimitiveLogicalDisk(savedPlex) : (allConcat ? this.MakeCollectionMirror(hashVolume.hashPlex) : this.MakeLogicalDiskMirror(hashVolume, copyNumber));
        LogicalDisk traceResult = logicalDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"HandleSimpleVolume", (Object)traceResult);
        }
        return traceResult;
    }

    private LogicalDisk HandleLayeredVolume(HashedVolume hashVolume) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CommonProbe.class.getName(), (String)"HandleLayeredVolume", (String)"hashVolume");
        }
        int n = 0;
        HashedPlex hashPlex = null;
        HashedPlex savedPlex = null;
        LogicalDisk retLogicalDisk = null;
        int nSubVolumes = 0;
        LogicalDisk lastLogicalDisk = null;
        LogicalDisk logicalDisk = null;
        String basePath = null;
        String msgID = null;
        int ldType = 0;
        hashPlex = hashVolume.hashPlex;
        while (hashPlex != null) {
            if (!hashPlex.vrtsPlex.isLogPlex()) {
                ++n;
                savedPlex = hashPlex;
            }
            hashPlex = hashPlex.next;
        }
        if (n != 1) {
            msgID = n == 0 ? "STA0237W" : "STA0239W";
            MessageLog.logMessage((String)msgID, (Object)hashVolume.vrtsVolume.name);
            this.handleRc = 4;
            LogicalDisk traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"HandleLayeredVolume", traceResult);
            }
            return traceResult;
        }
        if (hashVolume.assocVolume.next == null) {
            LogicalDisk traceResult = this.HandleSimpleVolume(hashVolume.assocVolume, false);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommonProbe.class.getName(), (String)"HandleLayeredVolume", (Object)traceResult);
            }
            return traceResult;
        }
        if (savedPlex.vrtsPlex.layout.equals("CONCAT")) {
            ldType = 6;
        } else if (savedPlex.vrtsPlex.layout.equals("STRIPE")) {
            ldType = 5;
        } else {
            MessageLog.logMessage((String)"STA0240W", (Object)hashVolume.vrtsVolume.name);
            ldType = 5;
        }
        retLogicalDisk = new LogicalDisk();
        retLogicalDisk.ldType = (byte)ldType;
        basePath = hashVolume.vrtsVolume.name + "_";
        nSubVolumes = 0;
        lastLogicalDisk = retLogicalDisk;
        hashVolume = hashVolume.assocVolume;
        while (hashVolume != null) {
            logicalDisk = this.HandleSimpleVolume(hashVolume, true);
            if (logicalDisk != null) {
                logicalDisk.ldPath = basePath + nSubVolumes;
                lastLogicalDisk.ldNextMirror = logicalDisk;
                lastLogicalDisk = logicalDisk;
            }
            ++nSubVolumes;
            hashVolume = hashVolume.next;
        }
        if (lastLogicalDisk != retLogicalDisk) {
            retLogicalDisk.ldMirrorCount = (byte)nSubVolumes;
        } else {
            retLogicalDisk = null;
        }
        LogicalDisk traceResult = retLogicalDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CommonProbe.class.getName(), (String)"HandleLayeredVolume", (Object)traceResult);
        }
        return traceResult;
    }

    protected Disk lookUpDisk(String canonicalName) {
        return null;
    }

    private static class HashedVolume
    implements Comparable {
        public VeritasVolume vrtsVolume;
        public HashedPlex hashPlex;
        int column;
        boolean bMsgIssued;
        HashedVolume assocVolume;
        HashedVolume next;

        HashedVolume(VeritasVolume aVrtsVolume) {
            this.vrtsVolume = aVrtsVolume;
            this.hashPlex = null;
            this.column = 0;
            this.bMsgIssued = false;
            this.assocVolume = null;
            this.next = null;
        }

        HashedVolume() {
            this.vrtsVolume = null;
            this.hashPlex = null;
            this.column = 0;
            this.bMsgIssued = false;
            this.assocVolume = null;
            this.next = null;
        }

        public boolean equals(HashedVolume otherVolume) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)HashedVolume.class.getName(), (String)"equals", (String)"otherVolume");
            }
            boolean traceResult = this.vrtsVolume.equals(otherVolume.vrtsVolume);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)HashedVolume.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)HashedVolume.class.getName(), (String)"compareTo", (String)"object");
            }
            HashedVolume otherVolume = (HashedVolume)object;
            int traceResult = this.vrtsVolume.compareTo(otherVolume.vrtsVolume);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)HashedVolume.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }
    }

    private static class HashedPlex
    implements Comparable {
        public VeritasPlex vrtsPlex;
        public HashedSubDisk hashSubDisk;
        public HashedVolume hashVolume;
        public HashedPlex next;

        HashedPlex(VeritasPlex aVrtsPlex) {
            this.vrtsPlex = aVrtsPlex;
            this.hashSubDisk = null;
            this.hashVolume = null;
            this.next = null;
        }

        HashedPlex() {
            this.vrtsPlex = null;
            this.hashSubDisk = null;
            this.hashVolume = null;
            this.next = null;
        }

        public boolean equals(HashedPlex otherPlex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)HashedPlex.class.getName(), (String)"equals", (String)"otherPlex");
            }
            boolean traceResult = this.vrtsPlex.equals(otherPlex.vrtsPlex);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)HashedPlex.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)HashedPlex.class.getName(), (String)"compareTo", (String)"object");
            }
            HashedPlex otherPlex = (HashedPlex)object;
            int traceResult = this.vrtsPlex.compareTo(otherPlex.vrtsPlex);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)HashedPlex.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }
    }

    private static class HashedSubDisk
    implements Comparable {
        public VeritasSubDisk vrtsSubDisk;
        public HashedDisk hashDisk;
        public HashedSubDisk next;

        HashedSubDisk(VeritasSubDisk aVrtsSubDisk, HashedDisk aHashDisk) {
            this.vrtsSubDisk = aVrtsSubDisk;
            this.hashDisk = aHashDisk;
            this.next = null;
        }

        HashedSubDisk() {
            this.vrtsSubDisk = null;
            this.hashDisk = null;
            this.next = null;
        }

        public boolean equals(HashedSubDisk otherSubDisk) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)HashedSubDisk.class.getName(), (String)"equals", (String)"otherSubDisk");
            }
            boolean traceResult = this.vrtsSubDisk.equals(otherSubDisk.vrtsSubDisk);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)HashedSubDisk.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)HashedSubDisk.class.getName(), (String)"compareTo", (String)"object");
            }
            HashedSubDisk otherSubDisk = (HashedSubDisk)object;
            int traceResult = this.vrtsSubDisk.compareTo(otherSubDisk.vrtsSubDisk);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)HashedSubDisk.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }
    }

    private static class HashedDisk
    implements Comparable {
        public VeritasDisk vrtsDisk;
        public Disk disk;

        HashedDisk(VeritasDisk aVrtsDisk, Disk aDisk) {
            this.vrtsDisk = aVrtsDisk;
            this.disk = aDisk;
        }

        HashedDisk() {
            this.vrtsDisk = null;
            this.disk = null;
        }

        public boolean equals(HashedDisk otherDisk) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)HashedDisk.class.getName(), (String)"equals", (String)"otherDisk");
            }
            boolean traceResult = this.vrtsDisk.equals(otherDisk.vrtsDisk);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)HashedDisk.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)HashedDisk.class.getName(), (String)"compareTo", (String)"object");
            }
            HashedDisk otherDisk = (HashedDisk)object;
            int traceResult = this.vrtsDisk.compareTo(otherDisk.vrtsDisk);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)HashedDisk.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }
    }

    private static class VeritasSubDisk
    implements Comparable {
        public VeritasDiskGroup diskGroup;
        public String name;
        public String diskName;
        public String plexName;
        public boolean pFlag;
        public VeritasRid plexRid;
        public VeritasRid diskRid;
        public int column;
        public long length;
        public long diskOffset;
        public long plexOffset;

        VeritasSubDisk(VeritasDiskGroup aDiskGroup, String aName, String aPlexName, long aLength) {
            this.diskGroup = aDiskGroup;
            this.name = aName;
            this.plexName = aPlexName;
            this.pFlag = false;
            this.plexRid = new VeritasRid();
            this.diskRid = new VeritasRid();
            this.column = 0;
            this.length = aLength;
            this.diskOffset = 0L;
            this.plexOffset = 0L;
        }

        VeritasSubDisk() {
            this.diskGroup = null;
            this.name = "";
            this.plexName = "";
            this.pFlag = false;
            this.plexRid = null;
            this.diskRid = null;
            this.column = 0;
            this.length = 0L;
            this.diskOffset = 0L;
            this.plexOffset = 0L;
        }

        boolean setAttributes() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasSubDisk.class.getName(), (String)"setAttributes", (String)"");
            }
            ShellCommand shell = null;
            String buffer = null;
            StringTokenizer tokenizer = null;
            String token = null;
            String subToken = null;
            Integer integer = null;
            shell = new ShellCommand("/usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name);
            if (!shell.bCool || (buffer = shell.getString()) == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("26 " + buffer));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            shell.cleanUp();
            tokenizer = new StringTokenizer(buffer);
            if (tokenizer.countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("27 " + buffer));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            tokenizer.nextToken();
            tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.startsWith("dm_rid=")) {
                    this.diskRid = new VeritasRid();
                    if (this.diskRid.set(token.substring(7))) continue;
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("28 " + token));
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                    }
                    return traceResult;
                }
                if (token.startsWith("plex_rid=")) {
                    this.plexRid = new VeritasRid();
                    if (this.plexRid.set(token.substring(9))) continue;
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("29 " + token));
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                    }
                    return traceResult;
                }
                if (token.startsWith("dm_name=")) {
                    this.diskName = token.substring(8);
                    continue;
                }
                if (token.startsWith("pl_offset=")) {
                    integer = Integer.valueOf(token.substring(10));
                    this.plexOffset = integer.longValue() * blockMultiplier;
                    continue;
                }
                if (token.startsWith("dm_offset=")) {
                    integer = Integer.valueOf(token.substring(10));
                    this.diskOffset = integer.longValue() * blockMultiplier;
                    continue;
                }
                if (token.startsWith("column=")) {
                    this.column = Integer.parseInt(token.substring(7));
                    continue;
                }
                if (!token.startsWith("subvolume=")) continue;
                subToken = token.substring(10);
                if (subToken.equals("on")) {
                    this.pFlag = true;
                    continue;
                }
                if (subToken.equals("off")) {
                    this.pFlag = false;
                    continue;
                }
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("30 " + token));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
            }
            return traceResult;
        }

        public boolean equals(VeritasSubDisk otherSubDisk) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasSubDisk.class.getName(), (String)"equals", (String)"otherSubDisk");
            }
            if (!this.diskRid.equals(otherSubDisk.diskRid)) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"equals", (boolean)traceResult);
                }
                return traceResult;
            }
            if (this.diskOffset != otherSubDisk.diskOffset) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"equals", (boolean)traceResult);
                }
                return traceResult;
            }
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasSubDisk.class.getName(), (String)"compareTo", (String)"object");
            }
            VeritasSubDisk otherSubDisk = (VeritasSubDisk)object;
            int rc = this.diskRid.compareTo(otherSubDisk.diskRid);
            if (rc != 0) {
                int traceResult = rc;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"compareTo", (int)traceResult);
                }
                return traceResult;
            }
            if (this.diskOffset > otherSubDisk.diskOffset) {
                int traceResult = 1;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"compareTo", (int)traceResult);
                }
                return traceResult;
            }
            if (this.diskOffset == otherSubDisk.diskOffset) {
                int traceResult = 0;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"compareTo", (int)traceResult);
                }
                return traceResult;
            }
            int traceResult = -1;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasSubDisk.class.getName(), (String)"toString", (String)"");
            }
            String traceResult = string = "subDiskName = " + this.name + " diskName = " + this.diskName + " plexName = " + this.plexName + " pFlag = " + this.pFlag + " plexRid = " + this.plexRid + " diskRid = " + this.diskRid + " column = " + this.column + " length = " + this.length + " diskOffset = " + this.diskOffset + " plexOffset = " + this.plexOffset;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasSubDisk.class.getName(), (String)"toString", (Object)traceResult);
            }
            return traceResult;
        }
    }

    private static class VeritasPlex
    implements Comparable {
        public String name;
        public String volumeName;
        public String state;
        public VeritasRid rid;
        public VeritasRid volumeRid;
        public VeritasRid logSubDiskRid;
        public VeritasDiskGroup diskGroup;
        public String layout;
        public int nColumn;
        public long stripeWidth;

        VeritasPlex(VeritasDiskGroup aDiskGroup, String aName, String aVolumeName) {
            this.diskGroup = aDiskGroup;
            this.name = aName;
            this.rid = new VeritasRid();
            this.state = "";
            this.volumeName = aVolumeName;
            this.volumeRid = new VeritasRid();
            this.logSubDiskRid = new VeritasRid();
        }

        VeritasPlex() {
            this.diskGroup = null;
            this.name = "";
            this.volumeName = "";
            this.state = "";
            this.rid = new VeritasRid();
            this.volumeRid = new VeritasRid();
            this.logSubDiskRid = new VeritasRid();
        }

        public boolean isLogPlex() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasPlex.class.getName(), (String)"isLogPlex", (String)"");
            }
            if (!this.logSubDiskRid.isNull() || this.state.equals("LOG")) {
                boolean traceResult = true;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"isLogPlex", (boolean)traceResult);
                }
                return traceResult;
            }
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"isLogPlex", (boolean)traceResult);
            }
            return traceResult;
        }

        public boolean setAttributes() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasPlex.class.getName(), (String)"setAttributes", (String)"");
            }
            ShellCommand shell = null;
            String buffer = null;
            StringTokenizer tokenizer = null;
            String token = null;
            Object subToken = null;
            Integer integer = null;
            shell = new ShellCommand("/usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name);
            if (!shell.bCool || (buffer = shell.getString()) == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("21 " + buffer));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            shell.cleanUp();
            tokenizer = new StringTokenizer(buffer);
            if (tokenizer.countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("22 " + buffer));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            tokenizer.nextToken();
            tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.startsWith("rid=")) {
                    this.rid = new VeritasRid();
                    if (this.rid.set(token.substring(4))) continue;
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("23 " + token));
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"setAttributes", (boolean)traceResult);
                    }
                    return traceResult;
                }
                if (token.startsWith("ncolumn=")) {
                    this.nColumn = Integer.parseInt(token.substring(8));
                    continue;
                }
                if (token.startsWith("state=")) {
                    this.state = token.substring(7);
                    continue;
                }
                if (token.startsWith("vol_rid=")) {
                    this.volumeRid = new VeritasRid();
                    if (this.volumeRid.set(token.substring(8))) continue;
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("24 " + token));
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"setAttributes", (boolean)traceResult);
                    }
                    return traceResult;
                }
                if (token.startsWith("st_width=")) {
                    integer = Integer.valueOf(token.substring(9));
                    this.stripeWidth = integer.longValue();
                    continue;
                }
                if (token.startsWith("layout=")) {
                    this.layout = token.substring(7);
                    continue;
                }
                if (!token.startsWith("log_sd_rid=")) continue;
                this.logSubDiskRid = new VeritasRid();
                if (this.logSubDiskRid.set(token.substring(11))) continue;
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("25 " + token));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"setAttributes", (boolean)traceResult);
            }
            return traceResult;
        }

        public boolean equals(VeritasPlex otherPlex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasPlex.class.getName(), (String)"equals", (String)"otherPlex");
            }
            boolean traceResult = this.rid.equals(otherPlex.rid);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasPlex.class.getName(), (String)"compareTo", (String)"object");
            }
            VeritasPlex otherPlex = (VeritasPlex)object;
            int traceResult = this.rid.compareTo(otherPlex.rid);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasPlex.class.getName(), (String)"toString", (String)"");
            }
            String traceResult = string = "plex name = " + this.name + " volumeName = " + this.volumeName + " state = " + this.state + " rid = " + this.rid + " volumeRid = " + this.volumeRid + " logSubDiskRid = " + this.logSubDiskRid + " layout = " + this.layout + " nColumn = " + this.nColumn + " stripeWidth = " + this.stripeWidth;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasPlex.class.getName(), (String)"toString", (Object)traceResult);
            }
            return traceResult;
        }
    }

    private static class VeritasVolume
    implements Comparable {
        public String name;
        public long length;
        public VeritasRid rid;
        public int sdNum;
        public VeritasDiskGroup diskGroup;

        VeritasVolume(VeritasDiskGroup aDiskGroup, String aName, long aLength) {
            this.diskGroup = aDiskGroup;
            this.name = aName;
            this.length = aLength;
            this.rid = new VeritasRid();
            this.sdNum = 0;
        }

        VeritasVolume() {
            this.diskGroup = null;
            this.name = "";
            this.length = 0L;
            this.rid = new VeritasRid();
            this.sdNum = 0;
        }

        boolean setAttributes() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasVolume.class.getName(), (String)"setAttributes", (String)"");
            }
            ShellCommand shell = null;
            String buffer = null;
            StringTokenizer tokenizer = null;
            String token = null;
            Object subToken = null;
            Object integer = null;
            shell = new ShellCommand("/usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name);
            if (!shell.bCool || (buffer = shell.getString()) == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("18 " + buffer));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasVolume.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            shell.cleanUp();
            tokenizer = new StringTokenizer(buffer);
            if (tokenizer.countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("19 " + buffer));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasVolume.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            tokenizer.nextToken();
            tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.startsWith("sd_num=")) {
                    this.sdNum = Integer.parseInt(token.substring(7));
                    continue;
                }
                if (!token.startsWith("rid=")) continue;
                this.rid = new VeritasRid();
                if (this.rid.set(token.substring(4))) continue;
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("20 " + token));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasVolume.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasVolume.class.getName(), (String)"setAttributes", (boolean)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasVolume.class.getName(), (String)"compareTo", (String)"object");
            }
            VeritasVolume otherVolume = (VeritasVolume)object;
            int traceResult = this.rid.compareTo(otherVolume.rid);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasVolume.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }

        public boolean equals(VeritasVolume otherVolume) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasVolume.class.getName(), (String)"equals", (String)"otherVolume");
            }
            boolean traceResult = this.rid.equals(otherVolume.rid);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasVolume.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasVolume.class.getName(), (String)"toString", (String)"");
            }
            String traceResult = string = "volume name = " + this.name + " length = " + this.length + " rid = " + this.rid + " sdNum = " + this.sdNum + " iosize = " + blockSize;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasVolume.class.getName(), (String)"toString", (Object)traceResult);
            }
            return traceResult;
        }
    }

    private static class VeritasDisk
    implements Comparable {
        public String deviceTag = "";
        public String publicCPath = "";
        public long publicOffset = 0L;
        public long publicLength;
        public String privateCPath = "";
        public long privateOffset = 0L;
        public long privateLength;
        public boolean tFlag = false;
        public VeritasRid rid = new VeritasRid();
        public String name;
        public long freeSpace;
        public VeritasDiskGroup diskGroup;

        VeritasDisk(VeritasDiskGroup aDiskGroup, String aName) {
            this.name = aName;
            this.diskGroup = aDiskGroup;
            this.freeSpace = 0L;
        }

        boolean setAttributes() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasDisk.class.getName(), (String)"setAttributes", (String)"");
            }
            ShellCommand shell = null;
            String buffer = null;
            StringTokenizer tokenizer = null;
            String token = null;
            String subToken = null;
            Integer integer = null;
            shell = new ShellCommand("/usr/sbin/vxprint -g " + this.diskGroup.name + " -a " + this.name);
            if (!shell.bCool || (buffer = shell.getString()) == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("14 " + buffer));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            shell.cleanUp();
            tokenizer = new StringTokenizer(buffer);
            if (tokenizer.countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("15 " + buffer));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            tokenizer.nextToken();
            tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.startsWith("priv_cpath=")) {
                    this.privateCPath = token.substring(12);
                } else if (token.startsWith("pub_cpath=")) {
                    this.publicCPath = token.substring(11);
                }
                if (token.startsWith("priv_offset=")) {
                    integer = Integer.valueOf(token.substring(12));
                    this.privateOffset = integer.longValue() * blockMultiplier;
                } else if (token.startsWith("pub_offset=")) {
                    integer = Integer.valueOf(token.substring(11));
                    this.publicOffset = integer.longValue() * blockMultiplier;
                }
                if (token.startsWith("priv_len=")) {
                    integer = Integer.valueOf(token.substring(9));
                    this.privateLength = integer.longValue() * blockMultiplier;
                    continue;
                }
                if (token.startsWith("pub_len=")) {
                    integer = Integer.valueOf(token.substring(8));
                    this.publicLength = integer.longValue() * blockMultiplier;
                    continue;
                }
                if (token.startsWith("private=")) {
                    subToken = token.substring(8);
                    if (subToken.equals("on")) {
                        this.tFlag = true;
                        continue;
                    }
                    if (subToken.equals("off")) {
                        this.tFlag = false;
                        continue;
                    }
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("16 " + token));
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                    }
                    return traceResult;
                }
                if (!token.startsWith("rid=")) continue;
                this.rid = new VeritasRid();
                if (this.rid.set(token.substring(4))) continue;
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("17 " + token));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
            }
            return traceResult;
        }

        public boolean equals(VeritasDisk otherDisk) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasDisk.class.getName(), (String)"equals", (String)"otherDisk");
            }
            boolean traceResult = this.rid.equals(otherDisk.rid);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasDisk.class.getName(), (String)"compareTo", (String)"object");
            }
            VeritasDisk otherDisk = (VeritasDisk)object;
            int traceResult = this.rid.compareTo(otherDisk.rid);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasDisk.class.getName(), (String)"toString", (String)"");
            }
            String traceResult = string = "disk name = " + this.name + " disk group name = " + this.diskGroup.name + " publicCPath = " + this.publicCPath + " publicOffset = " + this.publicOffset + " publicLength = " + this.publicLength + " privateCPath = " + this.privateCPath + " privateOffset = " + this.privateOffset + " privateLength = " + this.privateLength + " tFlag = " + this.tFlag + " rid = " + this.rid;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"toString", (Object)traceResult);
            }
            return traceResult;
        }
    }

    private static class VeritasDiskGroup
    implements Comparable {
        public String name;
        public int diskCount;
        public int volumeCount;
        public int plexCount;
        public int subDiskCount;
        public long freeSpace;
        public long totalSpace;
        public boolean probed;
        public Vector diskVector = new Vector(10, 2);
        public Vector volumeVector = new Vector(10, 2);
        public Vector plexVector = new Vector(10, 2);
        public Vector subDiskVector = new Vector(10, 2);

        VeritasDiskGroup(String aName) {
            this.name = aName;
            this.diskCount = 0;
            this.volumeCount = 0;
            this.plexCount = 0;
            this.subDiskCount = 0;
            this.freeSpace = 0L;
            this.totalSpace = 0L;
            this.probed = false;
        }

        boolean setAttributes() {
            int i;
            String token;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (String)"");
            }
            ShellCommand shell = null;
            String buffer = null;
            String headBuffer = null;
            String dataBuffer = null;
            StringTokenizer tokenizer = null;
            StringTokenizer headTokenizer = null;
            StringTokenizer dataTokenizer = null;
            String headToken = null;
            String dataToken = null;
            VeritasDisk disk = null;
            VeritasVolume volume = null;
            VeritasPlex plex = null;
            VeritasSubDisk subDisk = null;
            shell = new ShellCommand("/usr/sbin/vxprint -S -g " + this.name + " list");
            if (!shell.bCool) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("3 /usr/sbin/vxprint -S -g " + this.name + " list"));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            headBuffer = shell.getString();
            if (headBuffer == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("3.1 /usr/sbin/vxprint -S -g " + this.name + " list"));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            dataBuffer = shell.getString();
            if (dataBuffer == null) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("3.2 /usr/sbin/vxprint -S -g " + this.name + " list"));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            shell.cleanUp();
            headTokenizer = new StringTokenizer(headBuffer);
            if (headTokenizer.countTokens() < 6) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("4 " + headBuffer));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            dataTokenizer = new StringTokenizer(dataBuffer);
            for (int i2 = 1; i2 <= headTokenizer.countTokens(); ++i2) {
                headToken = headTokenizer.nextToken();
                dataToken = dataTokenizer.nextToken();
                try {
                    if (headToken.equals("VOLUMES")) {
                        this.volumeCount = Integer.parseInt(dataToken);
                        continue;
                    }
                    if (headToken.equals("PLEXES")) {
                        this.plexCount = Integer.parseInt(dataToken);
                        continue;
                    }
                    if (headToken.equals("SUBDISKS")) {
                        this.subDiskCount = Integer.parseInt(dataToken);
                        continue;
                    }
                    if (!headToken.equals("DISKS")) continue;
                    this.diskCount = Integer.parseInt(dataToken);
                    continue;
                }
                catch (NumberFormatException nfex) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (Throwable)nfex);
                }
            }
            shell = new ShellCommand("vxdisk -g " + this.name + " -q list");
            if (!shell.bCool) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("6 vxdisk -g " + this.name + " -q list"));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            while ((buffer = shell.getString()) != null) {
                tokenizer = new StringTokenizer(buffer);
                if (tokenizer.countTokens() < 5) continue;
                String deviceTag = tokenizer.nextToken();
                tokenizer.nextToken();
                String name = tokenizer.nextToken();
                disk = new VeritasDisk(this, name);
                if (deviceTag.length() > 2) {
                    String suffix = deviceTag.substring(deviceTag.length() - 2);
                    String prefix = deviceTag.substring(0, deviceTag.length() - 2);
                    disk.deviceTag = suffix.equals("s2") ? prefix : deviceTag;
                } else {
                    disk.deviceTag = deviceTag;
                }
                this.diskVector.add(disk);
            }
            shell.cleanUp();
            if (this.diskVector.size() > this.diskCount) {
                this.diskCount = this.diskVector.size();
            }
            buffer = null;
            if (this.diskCount > 0) {
                shell = new ShellCommand("/usr/sbin/vxprint -g " + this.name + " -a -d ");
                if (!shell.bCool || (buffer = shell.getString()) == null) {
                    MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("14 " + buffer));
                    shell.cleanUp();
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                    }
                    return traceResult;
                }
                shell.cleanUp();
            }
            if ((tokenizer = new StringTokenizer(buffer)).countTokens() <= 2) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("15 " + buffer));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDisk.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            tokenizer.nextToken();
            tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                String token2 = tokenizer.nextToken();
                if (!token2.startsWith("atomic_iosize=")) continue;
                Integer integer = Integer.valueOf(token2.substring(14));
                blockSize = integer.longValue();
                blockMultiplier = blockSize / 512L;
            }
            for (int i3 = 0; i3 < this.diskVector.size(); ++i3) {
                disk = (VeritasDisk)this.diskVector.elementAt(i3);
                if (disk.setAttributes()) continue;
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("8 " + this.name));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            shell = new ShellCommand("/usr/sbin/vxprint -g " + this.name);
            if (!shell.bCool) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("9 /usr/sbin/vxprint -g " + this.name));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            while ((buffer = shell.getString()) != null) {
                tokenizer = new StringTokenizer(buffer);
                if (tokenizer.countTokens() < 7) continue;
                String token3 = tokenizer.nextToken();
                if (token3.equals("v")) {
                    String volumeName = tokenizer.nextToken();
                    tokenizer.nextToken();
                    tokenizer.nextToken();
                    Integer integer = Integer.valueOf(tokenizer.nextToken());
                    long volumeLength = integer.longValue() * blockMultiplier;
                    volume = new VeritasVolume(this, volumeName, volumeLength);
                    this.volumeVector.add(volume);
                    continue;
                }
                if (token3.equals("pl")) {
                    String plexName = tokenizer.nextToken();
                    String volumeName = tokenizer.nextToken();
                    plex = new VeritasPlex(this, plexName, volumeName);
                    this.plexVector.add(plex);
                    continue;
                }
                if (!token3.equals("sd") && !token3.equals("sv")) continue;
                String subDiskName = tokenizer.nextToken();
                String plexName = tokenizer.nextToken();
                tokenizer.nextToken();
                String lengthString = tokenizer.nextToken();
                Integer integer = Integer.valueOf(lengthString);
                long subdiskLength = integer.longValue() * blockMultiplier;
                subDisk = new VeritasSubDisk(this, subDiskName, plexName, subdiskLength);
                this.subDiskVector.add(subDisk);
            }
            shell.cleanUp();
            shell = new ShellCommand("/usr/sbin/vxprint -qdg " + this.name);
            if (!shell.bCool) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("10 /usr/sbin/vxprint -qdg " + this.name));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            long size = 0L;
            while ((buffer = shell.getString()) != null) {
                tokenizer = new StringTokenizer(buffer);
                if (tokenizer.countTokens() < 5) continue;
                token = null;
                for (int i4 = 0; i4 < 5; ++i4) {
                    token = tokenizer.nextToken();
                }
                long intToken = 0L;
                try {
                    intToken = (long)Integer.parseInt(token) * blockMultiplier;
                }
                catch (NumberFormatException nfex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (Throwable)nfex);
                    }
                    intToken = 0L;
                }
                size += intToken;
            }
            shell.cleanUp();
            this.totalSpace = size;
            shell = new ShellCommand("/usr/sbin/vxdg -qg " + this.name + " free ");
            if (!shell.bCool) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("11 /usr/sbin/vxdg -qg " + this.name + " free "));
                shell.cleanUp();
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            size = 0L;
            long intToken = 0L;
            while ((buffer = shell.getString()) != null) {
                tokenizer = new StringTokenizer(buffer);
                if (tokenizer.countTokens() < 5) continue;
                token = null;
                for (int i5 = 0; i5 < 5; ++i5) {
                    token = tokenizer.nextToken();
                }
                intToken = 0L;
                try {
                    intToken = (long)Integer.parseInt(token) * blockMultiplier;
                }
                catch (NumberFormatException nfex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (Throwable)nfex);
                    }
                    intToken = 0L;
                }
                size += intToken;
            }
            shell.cleanUp();
            this.freeSpace = size;
            if (this.volumeVector.size() > this.volumeCount) {
                this.volumeCount = this.volumeVector.size();
            }
            if (this.plexVector.size() > this.plexCount) {
                this.plexCount = this.plexVector.size();
            }
            if (this.subDiskVector.size() > this.subDiskCount) {
                this.subDiskCount = this.subDiskVector.size();
            }
            for (i = 0; i < this.volumeVector.size(); ++i) {
                volume = (VeritasVolume)this.volumeVector.elementAt(i);
                if (volume.setAttributes()) continue;
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("11 " + volume.name));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            for (i = 0; i < this.plexVector.size(); ++i) {
                plex = (VeritasPlex)this.plexVector.elementAt(i);
                if (plex.setAttributes()) continue;
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("12 " + plex.name));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            for (i = 0; i < this.subDiskVector.size(); ++i) {
                subDisk = (VeritasSubDisk)this.subDiskVector.elementAt(i);
                if (subDisk.setAttributes()) continue;
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("13 " + subDisk.name));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
                }
                return traceResult;
            }
            this.probed = true;
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"setAttributes", (boolean)traceResult);
            }
            return traceResult;
        }

        public boolean equals(VeritasDiskGroup otherDiskGroup) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasDiskGroup.class.getName(), (String)"equals", (String)"otherDiskGroup");
            }
            boolean traceResult = this.name.equals(otherDiskGroup.name);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasDiskGroup.class.getName(), (String)"compareTo", (String)"object");
            }
            VeritasDiskGroup otherDiskGroup = (VeritasDiskGroup)object;
            int traceResult = this.name.compareTo(otherDiskGroup.name);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }

        public String toString() {
            String string;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasDiskGroup.class.getName(), (String)"toString", (String)"");
            }
            String traceResult = string = "diskGroup name = " + this.name + " diskCount = " + this.diskCount + " volumeCount = " + this.volumeCount + " plexCount = " + this.plexCount + " subDiskCount = " + this.subDiskCount;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasDiskGroup.class.getName(), (String)"toString", (Object)traceResult);
            }
            return traceResult;
        }
    }

    private static class VeritasRid
    implements Comparable {
        public long ridHi;
        public long ridLo;

        VeritasRid(long aHi, long aLo) {
            this.ridHi = aHi;
            this.ridLo = aLo;
        }

        VeritasRid() {
            this.ridLo = 0L;
            this.ridHi = 0L;
        }

        boolean set(String token) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasRid.class.getName(), (String)"set", (String)"token");
            }
            Integer hiInt = null;
            Integer loInt = null;
            int dotIndex = token.indexOf(46);
            if (dotIndex <= 0 || dotIndex >= token.length() - 1) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("1" + token));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasRid.class.getName(), (String)"set", (boolean)traceResult);
                }
                return traceResult;
            }
            try {
                hiInt = Integer.valueOf(token.substring(0, dotIndex));
                loInt = Integer.valueOf(token.substring(dotIndex + 1));
            }
            catch (NumberFormatException ex) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)VeritasRid.class.getName(), (String)"set", (Throwable)ex);
                }
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("2 " + token));
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasRid.class.getName(), (String)"set", (boolean)traceResult);
                }
                return traceResult;
            }
            this.ridHi = hiInt.longValue();
            this.ridLo = loInt.longValue();
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasRid.class.getName(), (String)"set", (boolean)traceResult);
            }
            return traceResult;
        }

        public boolean equals(Object pRid) {
            boolean traceResult;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasRid.class.getName(), (String)"equals", (String)"pRid");
            }
            VeritasRid aRid = (VeritasRid)pRid;
            boolean bl = traceResult = this.ridLo == aRid.ridLo && this.ridHi == aRid.ridHi;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasRid.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }

        public int hashCode() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasRid.class.getName(), (String)"hashCode", (String)"");
            }
            int traceResult = (int)this.ridLo;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasRid.class.getName(), (String)"hashCode", (int)traceResult);
            }
            return traceResult;
        }

        public int compareTo(Object object) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasRid.class.getName(), (String)"compareTo", (String)"object");
            }
            VeritasRid aRid = (VeritasRid)object;
            if (this.ridHi > aRid.ridHi) {
                int traceResult = 1;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasRid.class.getName(), (String)"compareTo", (int)traceResult);
                }
                return traceResult;
            }
            if (this.ridHi < aRid.ridHi) {
                int traceResult = -1;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasRid.class.getName(), (String)"compareTo", (int)traceResult);
                }
                return traceResult;
            }
            if (this.ridLo > aRid.ridLo) {
                int traceResult = 1;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasRid.class.getName(), (String)"compareTo", (int)traceResult);
                }
                return traceResult;
            }
            if (this.ridLo < aRid.ridLo) {
                int traceResult = -1;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)VeritasRid.class.getName(), (String)"compareTo", (int)traceResult);
                }
                return traceResult;
            }
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasRid.class.getName(), (String)"compareTo", (int)traceResult);
            }
            return traceResult;
        }

        public String toString() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasRid.class.getName(), (String)"toString", (String)"");
            }
            String traceResult = "" + this.ridHi + "." + this.ridLo;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasRid.class.getName(), (String)"toString", (Object)traceResult);
            }
            return traceResult;
        }

        public boolean isNull() {
            boolean traceResult;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)VeritasRid.class.getName(), (String)"isNull", (String)"");
            }
            boolean bl = traceResult = this.ridLo == 0L && this.ridHi == 0L;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)VeritasRid.class.getName(), (String)"isNull", (boolean)traceResult);
            }
            return traceResult;
        }
    }

    public static class ShellCommand {
        public BufferedReader bufferReader;
        public boolean bCool;
        public CmdExecer execer;

        public ShellCommand(String commandLine) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ShellCommand.class.getName(), (String)"ShellCommand", (String)"commandLine");
            }
            String[] commandArray = new String[]{"/bin/sh", "-c", commandLine};
            this.execer = new CmdExecer(commandArray);
            this.bCool = this.execer.exec();
            if (!this.bCool) {
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)("1.1 " + commandLine));
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ShellCommand.class.getName(), (String)"ShellCommand");
                }
                return;
            }
            this.bufferReader = this.execer.stdout;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ShellCommand.class.getName(), (String)"ShellCommand");
            }
        }

        public String getString() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ShellCommand.class.getName(), (String)"getString", (String)"");
            }
            try {
                String traceResult = this.bufferReader.readLine();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ShellCommand.class.getName(), (String)"getString", (Object)traceResult);
                }
                return traceResult;
            }
            catch (IOException ex) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ShellCommand.class.getName(), (String)"getString", (Throwable)ex);
                }
                MessageLog.logMessage((String)"STA0223E", (Object)"0", (Object)"1.2 ");
                String traceResult = "";
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ShellCommand.class.getName(), (String)"getString", (Object)traceResult);
                }
                return traceResult;
            }
        }

        public void cleanUp() {
            CommonProbe.cleanUpChild(this.execer);
        }
    }

    private static class CtlrCompare
    implements Comparator {
        private CtlrCompare() {
        }

        public int compare(Object pLeft, Object pRight) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CtlrCompare.class.getName(), (String)"compare", (String)"pLeft, pRight");
            }
            Controller left = (Controller)pLeft;
            Controller right = (Controller)pRight;
            int x = right.ctlrDriverName.compareTo(left.ctlrDriverName);
            if (x == 0 && (x = right.ctlrInstance - left.ctlrInstance) == 0) {
                x = right.ctlrBusNumber - left.ctlrBusNumber;
            }
            int traceResult = x;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CtlrCompare.class.getName(), (String)"compare", (int)traceResult);
            }
            return traceResult;
        }
    }

    private static class AccessCompare
    implements Comparator {
        private AccessCompare() {
        }

        public int compare(Object pLeft, Object pRight) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)AccessCompare.class.getName(), (String)"compare", (String)"pLeft, pRight");
            }
            DevAccess left = (DevAccess)pLeft;
            DevAccess right = (DevAccess)pRight;
            int x = right.daTarget - left.daTarget;
            if (x != 0) {
                int traceResult = x;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)AccessCompare.class.getName(), (String)"compare", (int)traceResult);
                }
                return traceResult;
            }
            int traceResult = right.daLUN - left.daLUN;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AccessCompare.class.getName(), (String)"compare", (int)traceResult);
            }
            return traceResult;
        }
    }

    private static class PathCompare
    implements Comparator {
        private PathCompare() {
        }

        public int compare(Object pLeft, Object pRight) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)PathCompare.class.getName(), (String)"compare", (String)"pLeft, pRight");
            }
            Export left = (Export)pLeft;
            Export right = (Export)pRight;
            int traceResult = right.xpExportName.compareTo(left.xpExportName);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)PathCompare.class.getName(), (String)"compare", (int)traceResult);
            }
            return traceResult;
        }
    }
}

