/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.TStorm.server.agentreq.ScanDefReq;
import org.eclipse.aperi.agent.discovery.ExecDiscovery;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.nas.netware.NetWareUtil;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.probe.UpTime;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.NetWareLoader;
import org.eclipse.aperi.backend.ProbeLock;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.CheckedRequest;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExecProbe
implements IExecutable {
    private static Class probeClass = ExecProbe.init();
    private int scheduleID;
    private boolean isInitial;
    private ProbeDefResp def;
    private NasFiler diskArrays;

    private native void defineProbe(ProbeDefResp var1);

    private native void cleanUp();

    public ExecProbe(boolean isInitial) {
        this.initialize(isInitial, null);
    }

    public ExecProbe(ProbeDefResp pDef) {
        this.initialize(false, pDef);
    }

    public ExecProbe() {
        this.initialize(false, null);
    }

    public int exec(StartedJob startedJob, String[] args) {
        this.scheduleID = startedJob.getJobRun().getSchedID();
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec() {
        String[] discoveryArgs;
        ExecDiscovery executable;
        LinkedInteger locked;
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbe.class.getName(), (String)"main", (String)"");
        }
        int rc = 8;
        Probe probe = null;
        try {
            probe = (Probe)probeClass.newInstance();
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ExecProbe.class.getName(), (String)"main", (Throwable)e);
            }
            MessageLog.logException((String)"STA0114E", (Exception)e);
        }
        if (probe == null) {
            int traceResult = rc;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecProbe.class.getName(), (String)"main", (int)traceResult);
            }
            return traceResult;
        }
        boolean thenRunDiscovery = false;
        boolean runNetworkDiscovery = false;
        CheckedRequest request = Agent.makeCheckedRequest();
        request.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        request.subType = "org.eclipse.aperi.server.handler.agent.ProbeDefHndlr";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.machineName = Agent.localName;
        request.userName = null;
        request.flags = 0;
        if (this.def == null) {
            ScanDefReq requestData = new ScanDefReq();
            requestData.computerID = ComputerID.cachedCID;
            requestData.scheduleID = this.scheduleID;
            request.requestData = requestData;
            MessageLog.logMessage((String)"AGT0145I");
            response = Agent.reporter.sendRequest((Request)request, (byte)1);
            if (response == null || response.status > 4 || !(response.responseData instanceof ProbeDefResp)) {
                MessageLog.logMessage((String)"STA0111E");
                int traceResult = rc;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ExecProbe.class.getName(), (String)"main", (int)traceResult);
                }
                return traceResult;
            }
            this.def = (ProbeDefResp)response.responseData;
            MessageLog.logMessage((String)"AGT0152I");
        }
        this.def.unpack();
        NasFiler fLock = null;
        if (this.def.pdProbeLocal) {
            fLock = new NasFiler();
            fLock.nfComputerID = ComputerID.cachedCID.computerID;
            fLock.nfName = Agent.realLocalName;
            fLock.nfNext = this.def.pdNasFiler;
        }
        if ((locked = ProbeLock.lock((ProbeDefResp)this.def, (NasFiler)fLock)) == null) {
            int traceResult = rc;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecProbe.class.getName(), (String)"main", (int)traceResult);
            }
            return traceResult;
        }
        Computer computer = null;
        try {
            int tRC;
            UpTime upTime;
            MessageLog.logMessage((String)"STA0113I");
            this.separateOutDiskArrays(this.def);
            if (!this.def.pdProbeLocal) {
                upTime = null;
                computer = new Computer();
                computer.cmpOSType = Agent.hardwareID.osType;
                rc = 0;
                MessageLog.logMessage((String)"STA0256I");
            } else {
                upTime = (UpTime)Agent.upTimePoller;
                this.defineProbe(this.def);
                rc = probe.probe(this.def);
                if (rc > 4) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ExecProbe.class.getName(), (String)"main");
                    }
                    throw new GeneralException();
                }
                computer = probe.computer;
                if (NetWareLoader.loadNetWare(false)) {
                    try {
                        LdapTree tree;
                        computer.cmpLdapTree = tree = NetWareUtil.enumTrees();
                        while (tree != null) {
                            tree.ltComputerID = ComputerID.cachedCID.computerID;
                            tree = tree.ltNext;
                        }
                    }
                    catch (LocalizableException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ExecProbe.class.getName(), (String)"main", (Throwable)e);
                        }
                        e.print();
                        rc = 4;
                    }
                }
            }
            if (this.def.pdNasFiler != null && (tRC = probe.probeNAS(this.def, computer)) > rc) {
                rc = tRC;
            }
            if (rc <= 4 && this.diskArrays != null && (tRC = this.probeDiskArrays(computer)) > rc) {
                rc = tRC;
            }
            if (!this.def.pdProbeLocal && computer.cmpNasFiler == null) {
                MessageLog.logMessage((String)"STA0274E");
                rc = 8;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ExecProbe.class.getName(), (String)"main");
                }
                throw new GeneralException();
            }
            if (upTime != null) {
                CompHist history;
                computer.cmpHistory = history = new CompHist();
                history.chMonitorStart = upTime.beganMonitoring;
                history.chMonitorEnd = System.currentTimeMillis();
                history.chDownTime = (int)(upTime.downTime / 1000L);
                history.chPowerCycles = (int)upTime.powerCycles;
            }
            computer.pack();
            request.subType = "org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr";
            request.flags = (byte)2;
            request.requestData = computer;
            MessageLog.logMessage((String)"STA0249I");
            response = Agent.reporter.sendRequest((Request)request, (byte)2);
            if (response == null || response.status > 4) {
                MessageLog.logMessage((String)"STA0112E");
                rc = 8;
            } else {
                if (upTime != null) {
                    upTime.reset(computer.cmpHistory.chMonitorEnd);
                }
                if (response.status > rc) {
                    rc = response.status;
                }
                if (rc <= 4) {
                    if (this.isInitial) {
                        thenRunDiscovery = true;
                        if (Agent.isWindows && response.responseData != null) {
                            runNetworkDiscovery = true;
                        }
                    }
                    MessageLog.logMessage((String)"STA0250I");
                }
            }
            computer.unpack();
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ExecProbe.class.getName(), (String)"main", (Throwable)e);
            }
        }
        finally {
            if (this.def != null) {
                this.cleanUp();
            }
            ProbeLock.unlock((LinkedInteger)locked);
        }
        if (rc == 0) {
            MessageLog.logMessage((String)"STA0109I");
        } else if (rc > 4) {
            MessageLog.logMessage((String)"STA0108I");
        } else {
            MessageLog.logMessage((String)"STA0110I");
        }
        if (thenRunDiscovery && (executable = new ExecDiscovery()).exec(null, discoveryArgs = new String[]{"NETWORK_DISCOVERY"}) != 0) {
            rc = 4;
        }
        int traceResult = rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecProbe.class.getName(), (String)"main", (int)traceResult);
        }
        return traceResult;
    }

    private void initialize(boolean pInitial, ProbeDefResp pProbeDef) {
        this.scheduleID = 103;
        this.isInitial = pInitial;
        this.def = pProbeDef;
    }

    private void separateOutDiskArrays(ProbeDefResp def) {
        this.diskArrays = null;
        NasFiler prev = null;
        NasFiler filer = def.pdNasFiler;
        while (filer != null) {
            NasFiler next = filer.nfNext;
            if (Constants.isDiskArray((short)filer.nfOSType)) {
                if (prev != null) {
                    prev.nfNext = next;
                } else {
                    def.pdNasFiler = next;
                }
                filer.nfNext = this.diskArrays;
                this.diskArrays = filer;
                MessageLog.logMessage((String)"SAA0028W", (Object)filer.nfName, (Object)filer.nfAlias);
            } else {
                prev = filer;
                if (Constants.supportsFullProbe((short)filer.nfOSType)) {
                    MessageLog.logMessage((String)"NAA0072I", (Object)filer.nfName);
                } else if (Constants.isSANFSClient((int)filer.nfOSType)) {
                    MessageLog.logMessage((String)"NAA0120I", (Object)filer.nfName);
                } else {
                    MessageLog.logMessage((String)"NAA0073I", (Object)filer.nfName);
                    Filesystem fs = filer.nfFilesystems;
                    while (fs != null) {
                        MessageLog.logMessage((String)"NAA0074I", (Object)fs.fsMountPoint);
                        fs = fs.fsNext;
                    }
                }
            }
            filer = next;
        }
        this.diskArrays = null;
    }

    private int probeDiskArrays(Computer computer) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbe.class.getName(), (String)"probeDiskArrays", (String)"computer");
        }
        int rc = 0;
        while (rc < 8 && this.diskArrays != null) {
            boolean probed;
            NasFiler next = this.diskArrays.nfNext;
            this.diskArrays.nfNext = null;
            switch (this.diskArrays.nfOSType) {
                default: 
            }
            int tRC = 8;
            MessageLog.logMessage((String)"SAA0023W", (Object)new Integer(this.diskArrays.nfOSType));
            boolean bl = probed = tRC < 8;
            if (!probed) {
                tRC -= 4;
            } else {
                this.diskArrays.nfNext = computer.cmpNasFiler;
                computer.cmpNasFiler = this.diskArrays;
            }
            if (tRC > rc) {
                rc = tRC;
            }
            this.diskArrays = next;
        }
        int traceResult = rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecProbe.class.getName(), (String)"probeDiskArrays", (int)traceResult);
        }
        return traceResult;
    }

    private static native Class init();
}

