/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.agent.cluster.mscs.MSCSEventListener;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.nas.RemoteMountInfo;
import org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler;
import org.eclipse.aperi.agent.nas.netware.NetWareDiscovery;
import org.eclipse.aperi.agent.nas.netware.NetWareUtil;
import org.eclipse.aperi.agent.probe.ClusterResource;
import org.eclipse.aperi.agent.probe.DriveLetter;
import org.eclipse.aperi.agent.probe.FileShare;
import org.eclipse.aperi.agent.probe.NetworkName;
import org.eclipse.aperi.agent.probe.PhysicalDisk;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.probe.VirtualServer;
import org.eclipse.aperi.agent.probe.Win2kMounts;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.agent.util.NetWareLoader;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeWin32
extends Probe {
    private static final byte CONCATENATION = 0;
    private static final byte STRIPE_SET = 1;
    private static final byte RAID5 = 2;
    private static final byte MIRROR = 3;
    public boolean isMSCSNode;
    public VirtualServer clusterVS;
    public VirtualServer vServer;
    public ClusterResource cResource;
    public NetworkName vsNetwork;
    public String clusterName;
    public DriveLetter dLetter;
    public String agentIP;
    private String volume;
    private long ftControlHandle;
    private long dirHandle;
    private int nPhysicalDisks;
    private Device[] physicalDisks;

    private native boolean mscsInitIDs();

    private native void cleanupReferences();

    private native boolean isMSCSClusterNode();

    private native int getAllVirtualServers();

    private native int getClusterResources(String var1);

    private native String getClusterName();

    private native int getAllNetworkNames();

    private native int findDisks();

    private native int fillComp();

    private native boolean nextWin2kVolume() throws LocalizableException;

    private native String volumeLink();

    private native int grokFTDisks();

    private native boolean fillLogicalDiskCapacity(LogicalDisk var1);

    private native LogicalDisk expandWin2k(boolean var1, boolean var2, MutableBoolean var3) throws LocalizableException;

    private native void cleanUp();

    private boolean handle4Dot0Mount(Mounts mounts) {
        int partitionNumber;
        int diskNumber;
        String s;
        block24: {
            int x;
            block23: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"handle4Dot0Mount", (String)"mounts");
                }
                s = null;
                diskNumber = -1;
                partitionNumber = -1;
                x = mounts.special.indexOf(92, 16);
                if (x > 16) {
                    s = mounts.special.substring(16, x);
                    try {
                        diskNumber = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception((String)ProbeWin32.class.getName(), (String)"handle4Dot0Mount", (Throwable)e);
                    }
                }
            }
            if (diskNumber >= 0) {
                if (diskNumber >= this.nPhysicalDisks) {
                    MessageLog.logMessage((String)"STA0147W", (Object)s, (Object)mounts.mountPoint);
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"handle4Dot0Mount", (boolean)traceResult);
                    }
                    return traceResult;
                }
                if (!(this.physicalDisks[diskNumber] instanceof Disk)) {
                    boolean traceResult = true;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"handle4Dot0Mount", (boolean)traceResult);
                    }
                    return traceResult;
                }
                if (mounts.special.regionMatches(true, ++x, "Partition", 0, 9)) {
                    s = mounts.special.substring(x += 9);
                    try {
                        partitionNumber = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception((String)ProbeWin32.class.getName(), (String)"handle4Dot0Mount", (Throwable)e);
                    }
                }
            }
        }
        if (partitionNumber < 0) {
            MessageLog.logMessage((String)"STA0151W", (Object)mounts.special);
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"handle4Dot0Mount", (boolean)traceResult);
            }
            return traceResult;
        }
        Disk disk = (Disk)this.physicalDisks[diskNumber];
        Chunk chunk = disk.dskChunk;
        while (chunk != null && chunk.chkPartition != partitionNumber) {
            chunk = chunk.chkNextOnDisk;
        }
        if (chunk == null) {
            Integer obj = new Integer(diskNumber);
            Object[] args = new Object[]{s, obj, mounts.mountPoint};
            MessageLog.logMessage((String)"STA0152W", (Object[])args);
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"handle4Dot0Mount", (boolean)traceResult);
            }
            return traceResult;
        }
        LogicalDisk logicalDisk = chunk.chkCollection.ccLogicalDisk;
        if (logicalDisk.ldPath != null) {
            MessageLog.logMessage((String)"STA0153W", (Object)mounts.special, (Object)mounts.mountPoint);
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"handle4Dot0Mount", (boolean)traceResult);
            }
            return traceResult;
        }
        logicalDisk.ldPath = mounts.mountPoint.substring(0, 2);
        boolean result = true;
        this.volume = "\\\\.\\" + logicalDisk.ldPath;
        if (!(this.computer.cmpOSType == 4 && logicalDisk.ldType != 1 || this.fillLogicalDiskCapacity(logicalDisk))) {
            result = false;
        }
        if (mounts.type != null) {
            Filesystem filesystem;
            logicalDisk.ldFilesystem = filesystem = new Filesystem();
            filesystem.fsLogicalDisk = logicalDisk;
            filesystem.fsMountPoint = mounts.mountPoint;
            mounts.special = this.volume;
            if (mounts.statFS(filesystem) != 0) {
                result = false;
            }
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"handle4Dot0Mount", (boolean)traceResult);
        }
        return traceResult;
    }

    private void do4_0() {
        int x;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"do4_0", (String)"");
        }
        if ((x = this.grokFTDisks()) > this.rc) {
            this.rc = x;
            if (x > 4) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"do4_0");
                }
                return;
            }
        }
        this.cleanUpPartitionsAndDisks();
        Mounts mounts = new Mounts();
        mounts.openMnttab();
        while (mounts.nextMount()) {
            if (this.handle4Dot0Mount(mounts)) continue;
            this.rc = 4;
        }
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            Chunk chunk = logicalDisk.ldCollectionList.ccChunkList;
            Disk disk = chunk.chkDisk;
            int diskNumber = 0;
            while (this.physicalDisks[diskNumber] != disk) {
                ++diskNumber;
            }
            logicalDisk.ldPath = "\\Device\\Harddisk" + diskNumber + "\\Partition" + chunk.chkPartition;
            logicalDisk = logicalDisk.ldNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"do4_0");
        }
    }

    private void doHigherThan4_0() {
        LogicalDisk logicalDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"doHigherThan4_0", (String)"");
        }
        boolean dynamicDisk = false;
        boolean isMirrored = false;
        int volType = 0;
        HashMap<String, LogicalDisk> map = new HashMap<String, LogicalDisk>();
        try {
            MutableBoolean keep = new MutableBoolean();
            while (this.nextWin2kVolume()) {
                boolean usable = false;
                logicalDisk = null;
                String linkTarget = this.volumeLink();
                if (linkTarget != null && linkTarget.regionMatches(true, 0, "\\Device\\Harddisk", 0, 16)) {
                    if (linkTarget.regionMatches(true, 16, "DmVolumes\\", 0, 10)) {
                        dynamicDisk = true;
                        usable = true;
                    } else if (linkTarget.regionMatches(true, 16, "Volume", 0, 6)) {
                        dynamicDisk = false;
                        usable = true;
                    }
                }
                if (usable) {
                    if (dynamicDisk) {
                        int i = linkTarget.lastIndexOf(92) + 1;
                        volType = linkTarget.regionMatches(true, i, "Stripe", 0, 6) ? 1 : (linkTarget.regionMatches(true, i, "Raid", 0, 4) ? 2 : 3);
                    }
                    if ((logicalDisk = this.expandWin2k(dynamicDisk, volType == 3, keep)) == null) {
                        this.rc = 4;
                    } else if (keep.value) {
                        if (dynamicDisk && volType != 3) {
                            ChunkCollection coll = logicalDisk.ldCollectionList;
                            coll.ccType = volType == 2 ? (byte)2 : (byte)1;
                        }
                        logicalDisk.ldNext = this.computer.cmpLogicalDisk;
                        this.computer.cmpLogicalDisk = logicalDisk;
                    }
                }
                map.put(this.volume, logicalDisk);
            }
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeWin32.class.getName(), (String)"doHigherThan4_0", (Throwable)e);
            }
            e.print();
            this.rc = 8;
        }
        if (this.rc > 4) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"doHigherThan4_0");
            }
            return;
        }
        LinkedList<Mounts> oldStyleMounts = new LinkedList<Mounts>();
        Mounts mounts2 = new Mounts();
        Win2kMounts nonRoot = new Win2kMounts();
        Filesystem ntfsList = null;
        Filesystem filesystem = new Filesystem();
        filesystem.fsNext = null;
        filesystem.fsMountPoint = "";
        while (filesystem != null) {
            mounts2.openMnttab();
            while (mounts2.nextMount()) {
                if (mounts2.special.startsWith("\\Device\\Harddisk")) {
                    Mounts cloan = new Mounts();
                    cloan.flags = mounts2.flags;
                    cloan.special = mounts2.special;
                    cloan.mountPoint = mounts2.mountPoint;
                    cloan.type = mounts2.type;
                    oldStyleMounts.add(cloan);
                    continue;
                }
                if (!map.containsKey(mounts2.special)) {
                    MessageLog.logMessage((String)"STA0103W", (Object)mounts2.mountPoint);
                    this.rc = 4;
                    continue;
                }
                logicalDisk = (LogicalDisk)map.get(mounts2.special);
                if (logicalDisk == null) continue;
                if (logicalDisk.ldNewLogicalDisk) {
                    MessageLog.logMessage((String)"STA0100W", (Object)mounts2.special, (Object)mounts2.mountPoint, (Object)logicalDisk.ldPath);
                    continue;
                }
                logicalDisk.ldNewLogicalDisk = true;
                logicalDisk.ldPath = mounts2.mountPoint.substring(0, mounts2.mountPoint.length() - 1);
                if (mounts2.type == null) continue;
                Filesystem newFS = new Filesystem();
                newFS.fsMountPoint = mounts2.mountPoint;
                newFS.fsLogicalDisk = logicalDisk;
                newFS.fsMaxFiles = -1;
                newFS.fsUsedInodes = -1;
                newFS.fsFreeInodes = -1;
                newFS.fsPhysicalSize = -1L;
                newFS.fsCapacity = -1L;
                newFS.fsUsedSpace = -1L;
                newFS.fsFreeSpace = -1L;
                newFS.fsType = (short)-1;
                logicalDisk.ldFilesystem = newFS;
                if (mounts2.statFS(newFS) != 0) {
                    this.rc = 4;
                }
                if (!mounts2.type.startsWith("NTFS")) continue;
                newFS.fsNext = ntfsList;
                ntfsList = newFS;
            }
            filesystem = filesystem.fsNext;
            if (filesystem == null) {
                filesystem = ntfsList;
                ntfsList = null;
            }
            if (filesystem == null) continue;
            nonRoot.root = filesystem.fsMountPoint;
            nonRoot.volume = filesystem.fsLogicalDisk.ldPath;
            mounts2 = nonRoot;
        }
        this.cleanUpPartitionsAndDisks();
        if (oldStyleMounts.size() > 0) {
            for (Mounts mounts2 : oldStyleMounts) {
                if (this.handle4Dot0Mount(mounts2)) continue;
                this.rc = 4;
            }
        }
        logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            String mountPoint;
            int length;
            filesystem = logicalDisk.ldFilesystem;
            if (filesystem != null && (length = (mountPoint = filesystem.fsMountPoint).length()) > 3 && mountPoint.charAt(length - 1) == '\\') {
                filesystem.fsMountPoint = mountPoint.substring(0, length - 1);
            }
            logicalDisk = logicalDisk.ldNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"doHigherThan4_0");
        }
    }

    private void fillPhysicalDisks() {
        Controller ctlr = this.computer.cmpController;
        while (ctlr != null) {
            DevAccess da = ctlr.ctlrDevices;
            while (da != null) {
                String numberString = da.daPath.substring(17);
                int devNo = Integer.parseInt(numberString);
                this.physicalDisks[devNo] = da.daDevice;
                da.daPath = "Disk " + numberString;
                da = da.daNextDevice;
            }
            ctlr = ctlr.ctlrNext;
        }
    }

    private boolean grokNetWareFiler(long handle, LdapTree tree, Map domainMap, NasFiler filer) {
        Computer nwComp;
        String networkName;
        int pos;
        String domainWithinTree;
        Domain domain;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"grokNetWareFiler", (String)"handle, tree, domainMap, filer");
        }
        if ((domain = (Domain)domainMap.get(domainWithinTree = (pos = (networkName = filer.nfNetworkName).indexOf(46)) <= 0 ? "" : networkName.substring(pos + 1))) == null) {
            domain = new Domain();
            StringBuffer temp = new StringBuffer(100);
            temp.append(domainWithinTree);
            temp.append(':');
            temp.append(tree.getLtName());
            domain.domName = temp.toString();
            domain.domTree = tree;
            domain.domTreeID = tree.ltTreeID;
            domainMap.put(domainWithinTree, domain);
        }
        filer.nfComputer = nwComp = new Computer();
        nwComp.cmpDomain = domain;
        nwComp.cmpOSType = (short)8;
        nwComp.cmpManufacturer = filer.nfManufacturer;
        nwComp.cmpID = filer.nfComputerID;
        NetWareDiscovery prober = new NetWareDiscovery(null);
        boolean result = prober.grokFiler(handle, filer);
        if (prober.rc > this.rc) {
            this.rc = prober.rc;
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"grokNetWareFiler", (boolean)traceResult);
        }
        return traceResult;
    }

    public static boolean findExportName(Filesystem fs, NasFiler filer) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"findExportName", (String)"fs, filer");
        }
        String withBackslashes = fs.fsMountPoint.replace('/', '\\');
        Export xp = filer.nfComputer.cmpExport;
        boolean found = false;
        while (!found && xp != null) {
            if (xp.xpPath.equalsIgnoreCase(withBackslashes)) {
                found = true;
                continue;
            }
            xp = xp.xpNext;
        }
        if (found) {
            fs.fsExportName = xp.xpExportName;
        } else {
            MessageLog.logMessage((String)"NAA0092W", (Object)filer.nfName, (Object)fs.fsMountPoint);
            fs.fsExportName = " ";
        }
        boolean traceResult = found;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"findExportName", (boolean)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String logInAndEnumExports(NasFiler filer, LdapTree tree, boolean logOut) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"logInAndEnumExports", (String)"filer, tree, logOut");
        }
        String networkName = NasUtil.networkName(filer);
        try {
            NasUtil.cifsLogIn(NasUtil.filerDomain(filer), networkName, tree.ltLdapUser, tree.ltPassword);
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeWin32.class.getName(), (String)"logInAndEnumExports", (Throwable)e);
            }
            e.print();
            String traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"logInAndEnumExports", traceResult);
            }
            return traceResult;
        }
        try {
            if (!ProbeWin32.enumExports(filer.nfComputer, networkName)) {
                String traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"logInAndEnumExports", traceResult);
                }
                String string = traceResult;
                return string;
            }
        }
        finally {
            if (logOut) {
                NasUtil.cifsLogOut(networkName);
            }
        }
        ProbeWin32.sortExports(filer.nfComputer);
        String traceResult = networkName;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"logInAndEnumExports", (Object)traceResult);
        }
        return traceResult;
    }

    public static boolean logInAndEnumExports(NasFiler filer, LdapTree tree) {
        String networkName;
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"logInAndEnumExports", (String)"filer, tree");
        }
        boolean bl = traceResult = (networkName = ProbeWin32.logInAndEnumExports(filer, tree, true)) != null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"logInAndEnumExports", (boolean)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean grokGenericNAS(LdapTree tree, NasFiler filer, MutableInteger rc) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"grokGenericNAS", (String)"tree, filer, rc");
        }
        int ourComputerID = ComputerID.cachedCID.computerID;
        rc.value = 0;
        ProbeWin32.makeNASComputer(filer);
        RemoteMountInfo stats = new RemoteMountInfo();
        String networkName = ProbeWin32.logInAndEnumExports(filer, tree, false);
        if (networkName == null) {
            boolean traceResult2 = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"grokGenericNAS", (boolean)traceResult2);
            }
            return traceResult2;
        }
        try {
            Filesystem fs = filer.nfFilesystems;
            filer.nfFilesystems = null;
            while (fs != null) {
                Filesystem next = fs.fsNext;
                fs.fsNext = null;
                boolean ok = false;
                if (ProbeWin32.findExportName(fs, filer)) {
                    try {
                        stats.getInfo(networkName, fs.fsExportName);
                        ok = true;
                    }
                    catch (LocalizableException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ProbeWin32.class.getName(), (String)"grokGenericNAS", (Throwable)e);
                        }
                        e.print();
                    }
                }
                if (!ok) {
                    rc.value = 4;
                } else {
                    fs.fsScanningCompID = ourComputerID;
                    fs.fsCapacity = stats.rmCapacity;
                    fs.fsFreeSpace = stats.rmFreeSpace;
                    filer.nfComputer.cmpFilesystemFreeSpace += fs.fsFreeSpace;
                    fs.fsUsedSpace = fs.fsCapacity - fs.fsFreeSpace;
                    fs.fsType = stats.rmFSType;
                    ProbeWin32.addFSToFiler(filer, fs);
                }
                fs = next;
            }
        }
        finally {
            NasUtil.cifsLogOut(networkName);
        }
        boolean bl = traceResult = filer.nfComputer.cmpLogicalDisk != null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"grokGenericNAS", (boolean)traceResult);
        }
        return traceResult;
    }

    public static boolean findNetAppExportName(Filesystem fs, NasFiler filer) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"findNetAppExportName", (String)"fs, filer");
        }
        boolean looking = true;
        Export xp = filer.nfComputer.cmpExport;
        while (looking && xp != null) {
            String translatedName = ProbeWin32.translateNetApp(xp.xpPath);
            if (Util.stringsEqual((String)translatedName, (String)fs.fsMountPoint)) {
                looking = false;
                continue;
            }
            xp = xp.xpNext;
        }
        if (xp != null) {
            fs.fsExportName = xp.xpExportName;
        } else {
            MessageLog.logMessage((String)"NAA0092W", (Object)filer.nfName, (Object)fs.fsMountPoint);
            fs.fsExportName = " ";
        }
        boolean bl = traceResult = !looking;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"findNetAppExportName", (boolean)traceResult);
        }
        return traceResult;
    }

    private static String translateNetApp(String path) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"translateNetApp", (String)"path");
        }
        String result = null;
        int length = path.length();
        if (length >= 3) {
            if (length == 3) {
                result = "/vol/vol0";
            } else {
                result = path.substring(2).replace('\\', '/');
                if (result.endsWith("/")) {
                    result = result.substring(0, length - 3);
                }
            }
        }
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"translateNetApp", (Object)traceResult);
        }
        return traceResult;
    }

    private static boolean grokSpecificNAS(LdapTree tree, NasFiler filer, MutableInteger pRC) {
        ProbeNetAppFiler prober;
        int rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"grokSpecificNAS", (String)"tree, filer, pRC");
        }
        if ((rc = (prober = new ProbeNetAppFiler()).probe(filer, filer.nfDomain)) > 4) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"grokSpecificNAS", (boolean)traceResult);
            }
            return traceResult;
        }
        pRC.value = rc;
        if (!ProbeWin32.logInAndEnumExports(filer, tree)) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"grokSpecificNAS", (boolean)traceResult);
            }
            return traceResult;
        }
        LogicalDisk ld = filer.nfComputer.cmpLogicalDisk;
        while (ld != null) {
            Filesystem fs = ld.ldFilesystem;
            if (fs != null && !ProbeWin32.findNetAppExportName(fs, filer)) {
                pRC.value = 4;
            }
            ld = ld.ldNext;
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"grokSpecificNAS", (boolean)traceResult);
        }
        return traceResult;
    }

    private static boolean probeSanFSFiler(NasFiler filer, MutableInteger rc) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"probeSanFSFiler", (String)"filer, rc");
        }
        int ourComputerID = ComputerID.cachedCID.computerID;
        rc.value = 0;
        Mounts mounts = new Mounts();
        mounts.openMnttab();
        while (mounts.findSanFSMount()) {
            if (!mounts.type.equalsIgnoreCase("SANFS")) continue;
            StringBuffer imprt = new StringBuffer("/");
            imprt.append(mounts.mountPoint);
            boolean tempRC = false;
            if (imprt.toString().compareToIgnoreCase(filer.nfFilesystems.fsMountPoint) != 0) continue;
            Filesystem fs = filer.nfFilesystems;
            if (fs == null) {
                rc.value = 4;
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"probeSanFSFiler", (boolean)traceResult);
                }
                return traceResult;
            }
            if (mounts.statFS(fs) != 0) {
                MessageLog.logMessage((String)"NAA0119I", (Object)imprt.toString());
                rc.value = 4;
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"probeSanFSFiler", (boolean)traceResult);
                }
                return traceResult;
            }
            fs.fsScanningCompID = ourComputerID;
            fs.fsType = (short)18;
            fs.fsUsedSpace = fs.fsCapacity - fs.fsFreeSpace;
            fs.fsPhysicalSize = fs.fsCapacity;
            fs.fsFreeInodes = -1;
            fs.fsMaxFiles = -1;
            fs.fsUsedInodes = -1;
            ProbeWin32.makeNASComputer(filer);
            filer.nfComputer.cmpOSType = (short)23;
            filer.nfComputer.cmpFilesystemFreeSpace += fs.fsFreeSpace;
            ProbeWin32.addFSToFiler(filer, fs);
        }
        boolean traceResult = false;
        if (filer.nfComputer == null) {
            rc.value = 4;
        } else {
            boolean bl = traceResult = filer.nfComputer.cmpLogicalDisk != null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"probeSanFSFiler", (boolean)traceResult);
        }
        return traceResult;
    }

    public int probeNAS(ProbeDefResp probeDef, Computer comp) {
        boolean ok;
        LdapTree tree;
        NasFiler next;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"probeNAS", (String)"probeDef, comp");
        }
        Domain domain = comp.cmpDomain;
        HashMap<LdapTree, NasFiler> map = new HashMap<LdapTree, NasFiler>();
        NasFiler sanfsFilerList = null;
        NasFiler filer = probeDef.pdNasFiler;
        while (filer != null) {
            next = filer.nfNext;
            filer.nfNext = null;
            if (domain == null && filer.nfDomain != null && filer.nfDomain.domName.equalsIgnoreCase(Agent.domain)) {
                comp.cmpDomain = domain = filer.nfDomain;
            }
            if (filer.nfOSType == 23) {
                if (sanfsFilerList == null) {
                    sanfsFilerList = filer;
                } else {
                    sanfsFilerList.nfNext = filer;
                }
            } else {
                tree = filer.nfLdapTree;
                if (tree != null) {
                    NasFiler nf = (NasFiler)map.get(tree);
                    if (nf == null) {
                        map.put(tree, filer);
                    } else {
                        while (nf.nfNext != null) {
                            nf = nf.nfNext;
                        }
                        nf.nfNext = filer;
                    }
                }
            }
            filer = next;
        }
        if (domain == null) {
            domain = new Domain();
            domain.domName = Agent.domain;
            comp.cmpDomain = domain;
        }
        int rc = 0;
        MutableInteger pRC = new MutableInteger();
        int netWareState = 0;
        HashMap domainMap = null;
        Iterator iterator = map.entrySet().iterator();
        while (!Agent.stopNow && iterator.hasNext()) {
            long handle = -1L;
            Map.Entry entry = iterator.next();
            tree = (LdapTree)entry.getKey();
            boolean isNetWare = NasUtil.isNetWare(tree);
            if (isNetWare) {
                if (netWareState == 0) {
                    if (NetWareLoader.loadNetWare(true)) {
                        netWareState = 1;
                        domainMap = new HashMap();
                    } else {
                        MessageLog.logMessage((String)"NAA0052E");
                        netWareState = -1;
                        rc = 4;
                    }
                }
                if (netWareState > 0) {
                    try {
                        handle = NetWareUtil.decryptAndLogIn(tree);
                    }
                    catch (LocalizableException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ProbeWin32.class.getName(), (String)"probeNAS", (Throwable)e);
                        }
                        e.print();
                        rc = 4;
                    }
                }
                if (handle == -1L) continue;
            }
            filer = (NasFiler)entry.getValue();
            while (!Agent.stopNow && filer != null) {
                if (isNetWare) {
                    ok = this.grokNetWareFiler(handle, tree, domainMap, filer);
                } else {
                    ok = Constants.supportsFullProbe((short)filer.nfOSType) ? ProbeWin32.grokSpecificNAS(tree, filer, pRC) : ProbeWin32.grokGenericNAS(tree, filer, pRC);
                    if (pRC.value > rc) {
                        rc = pRC.value;
                    }
                }
                next = filer.nfNext;
                if (!ok) {
                    rc = 4;
                } else {
                    filer.nfNext = comp.cmpNasFiler;
                    comp.cmpNasFiler = filer;
                }
                filer = next;
            }
            if (handle == -1L) continue;
            NetWareUtil.logOut(tree, handle);
        }
        filer = comp.cmpNasFiler;
        while (filer != null) {
            if (!NasUtil.isNetWare(filer.nfLdapTree)) {
                filer.nfLdapTree = null;
            }
            filer = filer.nfNext;
        }
        NasFiler sanfs = sanfsFilerList;
        while (sanfs != null && !Agent.stopNow) {
            ok = ProbeWin32.probeSanFSFiler(sanfs, pRC);
            if (pRC.value > rc) {
                rc = pRC.value;
            } else {
                sanfs.nfNext = comp.cmpNasFiler;
                comp.cmpNasFiler = sanfs;
            }
            sanfs = sanfs.nfNext;
        }
        int traceResult = rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"probeNAS", (int)traceResult);
        }
        return traceResult;
    }

    protected void platformSpecific() {
        int i;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"platformSpecific", (String)"");
        }
        this.rc = this.fillComp();
        if (this.rc > 4) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"platformSpecific");
            }
            return;
        }
        Domain domain = new Domain();
        domain.domID = -1;
        domain.domName = Agent.domain;
        this.computer.cmpDomain = domain;
        HardwareID hardwareID = Agent.hardwareID;
        this.computer.cmpManufacturer = hardwareID.manufacturer;
        if (HardwareID.model != null) {
            this.computer.cmpModel = HardwareID.model;
        }
        if (HardwareID.serialNumber != null) {
            this.computer.cmpSerialNumber = HardwareID.serialNumber;
        }
        if ((i = this.findDisks()) > this.rc) {
            this.rc = i;
            if (i > 4) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"platformSpecific");
                }
                return;
            }
        }
        this.physicalDisks = new Device[this.nPhysicalDisks];
        this.fillPhysicalDisks();
        this.arrangeDevices();
        if (this.computer.cmpOSType == 4) {
            this.do4_0();
        } else {
            this.doHigherThan4_0();
        }
        this.cleanUp();
        if (this.rc > 4) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"platformSpecific");
            }
            return;
        }
        LogicalDisk logicalDisk = this.computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            Filesystem filesystem = logicalDisk.ldFilesystem;
            if (filesystem != null) {
                filesystem.fsMountPoint = filesystem.fsMountPoint.replace('\\', '/');
            }
            logicalDisk = logicalDisk.ldNext;
        }
        this.getHBAPortWWNs();
        this.correlateHBAs();
        this.isMSCSNode = this.isMSCSClusterNode();
        if (this.isMSCSNode) {
            if (Agent.clsEventListener == null) {
                Agent.clsEventListener = new MSCSEventListener(Agent.localName);
                TSThread clsEventThread = new TSThread(Agent.threadGroup, (Runnable)Agent.clsEventListener);
                clsEventThread.start();
            }
            try {
                InetAddress host = InetAddress.getLocalHost();
                String localHost = host.getHostName();
                this.agentIP = this.probeDef.agentIP;
                if (!this.mscsInitIDs()) {
                    this.rc = 8;
                    this.cleanupReferences();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"platformSpecific");
                    }
                    return;
                }
                this.clusterName = this.getClusterName();
                if (this.clusterName == null) {
                    this.rc = 8;
                    this.cleanupReferences();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"platformSpecific");
                    }
                    return;
                }
                this.computer.cmpCluster = new Cluster();
                this.computer.cmpCluster.clusterName = this.clusterName;
                this.computer.cmpCluster.cluster_type = (short)22;
                this.computer.cmpCluster.domain_name = this.computer.cmpDomain.domName;
                this.computer.cmpCluster.windows_domain = this.computer.cmpDomain.domName;
                this.computer.cmpCluster.clusNext = null;
                i = this.getAllVirtualServers();
                if (i > this.rc) {
                    this.rc = i;
                    if (i > 4) {
                        this.cleanupReferences();
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"platformSpecific");
                        }
                        return;
                    }
                }
                this.fillClusterVSs(localHost);
                i = this.getClusterResources(localHost);
                if (i > this.rc) {
                    this.rc = i;
                    if (i > 4) {
                        this.cleanupReferences();
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"platformSpecific");
                        }
                        return;
                    }
                }
                if ((i = this.getAllNetworkNames()) > this.rc) {
                    this.rc = i;
                    if (i > 4) {
                        this.cleanupReferences();
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"platformSpecific");
                        }
                        return;
                    }
                }
                this.cleanupReferences();
                this.fillNetworkNameList();
                this.chooseVirtualServerNameIP();
                this.fillClusterIP();
                this.createNasFilersForVirtualServers();
                this.correlateDisks();
                this.correlateControllers();
                this.correlateLogicalDisks();
                this.qualifyVirtualServerNames();
                NasFiler nFiler = this.computer.cmpNasFiler;
                while (nFiler != null) {
                    if (nFiler.nfComputer.cmpOSType == 20) {
                        ProbeWin32.arrangeDevices(nFiler.nfComputer, this);
                    }
                    nFiler = nFiler.nfNext;
                }
            }
            catch (UnknownHostException ex) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ProbeWin32.class.getName(), (String)"platformSpecific", (Throwable)ex);
                }
                MessageLog.logMessage((String)"AGT0154E");
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"platformSpecific");
        }
    }

    protected void multiPathDevice(Device kept, Device discarded) {
        for (int i = 0; i < this.nPhysicalDisks; ++i) {
            if (this.physicalDisks[i] != discarded) continue;
            this.physicalDisks[i] = kept;
        }
    }

    private static native void initIDs();

    public String isClusteredDisk(int diskNo) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"isClusteredDisk", (String)"diskNo");
        }
        ClusterResource res = this.cResource;
        while (res != null) {
            if (res instanceof PhysicalDisk) {
                PhysicalDisk pDisk = (PhysicalDisk)res;
                if (pDisk.pDiskNo == diskNo) {
                    String traceResult = res.crName;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"isClusteredDisk", (Object)traceResult);
                    }
                    return traceResult;
                }
            }
            res = res.crNext;
        }
        String traceResult = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"isClusteredDisk", traceResult);
        }
        return traceResult;
    }

    public String isClusteredLDisk(String ldPath) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"isClusteredLDisk", (String)"ldPath");
        }
        DriveLetter dl = this.dLetter;
        while (dl != null) {
            if (dl.dlName.equalsIgnoreCase(ldPath)) {
                String traceResult = dl.dlDiskRes;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"isClusteredLDisk", (Object)traceResult);
                }
                return traceResult;
            }
            dl = dl.dlNext;
        }
        String traceResult = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"isClusteredLDisk", traceResult);
        }
        return traceResult;
    }

    public String isClusteredShare(String sName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"isClusteredShare", (String)"sName");
        }
        ClusterResource res = this.cResource;
        while (res != null) {
            if (res instanceof FileShare) {
                FileShare fShare = (FileShare)res;
                if (fShare.shareName.equalsIgnoreCase(sName)) {
                    String traceResult = res.crName;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"isClusteredShare", (Object)traceResult);
                    }
                    return traceResult;
                }
            }
            res = res.crNext;
        }
        String traceResult = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"isClusteredShare", traceResult);
        }
        return traceResult;
    }

    public void createNasFilersForVirtualServers() {
        NasFiler nasFiler = null;
        while (this.vServer != null) {
            NasFiler tempFiler;
            nasFiler = new NasFiler();
            nasFiler.nfNetworkName = this.vServer.vsNetworkName;
            nasFiler.nfIPAddress = this.vServer.vsIPAddress;
            nasFiler.nfName = this.vServer.vsName;
            nasFiler.nfManufacturer = MessageLog.getMessageNoID((String)Constants.OSTYPES[20]);
            nasFiler.nfDomain = this.computer.cmpDomain;
            nasFiler.nfComputer = new Computer();
            nasFiler.nfComputer.cmpOSType = (short)20;
            nasFiler.nfComputer.cmpDomain = this.computer.cmpDomain;
            nasFiler.nfOSType = (short)20;
            nasFiler.nfComputer.cmpCluster = new Cluster();
            nasFiler.nfComputer.cmpCluster.IPAddress = this.computer.cmpCluster.IPAddress;
            nasFiler.nfComputer.cmpCluster.clusterName = this.clusterName;
            nasFiler.nfComputer.cmpCluster.domain_name = this.computer.cmpDomain.domName;
            nasFiler.nfComputer.cmpCluster.windows_domain = this.computer.cmpDomain.domName;
            nasFiler.nfComputer.cmpCluster.clusNext = null;
            nasFiler.nfComputer.cmpManufacturer = MessageLog.getMessageNoID((String)Constants.OSTYPES[20]);
            nasFiler.nfNext = this.computer.cmpNasFiler != null ? (tempFiler = this.computer.cmpNasFiler) : null;
            this.computer.cmpNasFiler = nasFiler;
            this.vServer = this.vServer.vsNext;
        }
    }

    public void fillClusterVSs(String localHost) {
        VirtualServer tempVS = null;
        this.computer.cmpCluster.virtualServers = new Vector();
        while (this.clusterVS != null) {
            if (this.clusterVS.vsName != " ") {
                StringBuffer buf = new StringBuffer();
                buf.append(this.clusterVS.vsName);
                buf.append(".");
                buf.append(this.clusterName);
                buf.append(".");
                buf.append(this.computer.cmpDomain.domName);
                this.computer.cmpCluster.virtualServers.add(buf.toString());
                if (this.clusterVS.vsNode.equalsIgnoreCase(localHost)) {
                    tempVS = new VirtualServer();
                    tempVS.vsName = this.clusterVS.vsName;
                    tempVS.vsNode = this.clusterVS.vsNode;
                    if (this.vServer == null) {
                        this.vServer = tempVS;
                    } else {
                        tempVS.vsNext = this.vServer;
                        this.vServer = tempVS;
                    }
                }
            }
            this.clusterVS = this.clusterVS.vsNext;
        }
    }

    public void correlateDisks() {
        Device device = this.computer.cmpDevice;
        Device prevDev = this.computer.cmpDevice;
        device = this.computer.cmpDevice;
        while (device != null) {
            block12: {
                Device tempDev = device;
                DevAccess devCon = device.devControllers;
                String numberString = devCon.daPath.substring(5);
                int devNo = Integer.parseInt(numberString);
                String disk = this.isClusteredDisk(devNo);
                if (disk != null) {
                    boolean isFirst = false;
                    if (prevDev == device) {
                        isFirst = true;
                        this.computer.cmpDevice = this.computer.cmpDevice.devNext;
                    } else {
                        prevDev.devNext = device.devNext;
                    }
                    String virtualServer = null;
                    ClusterResource res = this.cResource;
                    while (res != null) {
                        if (disk.equalsIgnoreCase(res.crName)) {
                            virtualServer = res.crVirtualServer;
                            NasFiler nFiler = this.computer.cmpNasFiler;
                            while (nFiler != null) {
                                if (virtualServer.equalsIgnoreCase(nFiler.nfName)) {
                                    tempDev.devNext = nFiler.nfComputer.cmpDevice;
                                    nFiler.nfComputer.cmpDevice = tempDev;
                                    if (isFirst) {
                                        prevDev = this.computer.cmpDevice;
                                        device = this.computer.cmpDevice;
                                    } else {
                                        device = prevDev.devNext;
                                    }
                                    break block12;
                                }
                                nFiler = nFiler.nfNext;
                            }
                            break;
                        }
                        res = res.crNext;
                    }
                } else {
                    if (prevDev != device) {
                        prevDev = prevDev.devNext;
                    }
                    device = device.devNext;
                }
            }
            if (device != null) continue;
            break;
        }
    }

    public void correlateControllers() {
        Controller prevCtlr = this.computer.cmpController;
        Controller ctlr = this.computer.cmpController;
        while (ctlr != null) {
            DevAccess prevDevAccess = ctlr.ctlrDevices;
            DevAccess devCon = ctlr.ctlrDevices;
            while (devCon != null) {
                DevAccess tempDevAccess = devCon;
                String numberString = devCon.daPath.substring(5);
                int devNo = Integer.parseInt(numberString);
                String disk = this.isClusteredDisk(devNo);
                if (disk != null) {
                    boolean isFirst = false;
                    if (prevDevAccess == devCon) {
                        isFirst = true;
                        ctlr.ctlrDevices = ctlr.ctlrDevices.daNextDevice;
                    } else {
                        prevDevAccess.daNextDevice = devCon.daNextDevice;
                    }
                    String virtualServer = null;
                    ClusterResource res = this.cResource;
                    block2: while (res != null) {
                        if (disk.equalsIgnoreCase(res.crName)) {
                            virtualServer = res.crVirtualServer;
                            NasFiler nFiler = this.computer.cmpNasFiler;
                            while (nFiler != null) {
                                Controller tempCtlr = null;
                                if (virtualServer.equalsIgnoreCase(nFiler.nfName)) {
                                    if (nFiler.nfComputer.cmpController == null) {
                                        tempCtlr = new Controller();
                                        tempCtlr.ctlrBusNumber = devCon.daController.ctlrBusNumber;
                                        tempCtlr.ctlrComputerID = devCon.daController.ctlrComputerID;
                                        tempCtlr.ctlrDriverDescription = devCon.daController.ctlrDriverDescription;
                                        tempCtlr.ctlrDriverName = devCon.daController.ctlrDriverName;
                                        tempCtlr.ctlrInstance = devCon.daController.ctlrInstance;
                                        tempCtlr.ctlrTarget = devCon.daController.ctlrTarget;
                                        tempCtlr.ctlrType = devCon.daController.ctlrType;
                                        tempCtlr.ctlrNext = nFiler.nfComputer.cmpController;
                                        nFiler.nfComputer.cmpController = tempCtlr;
                                        tempDevAccess.daNextDevice = tempCtlr.ctlrDevices;
                                        tempCtlr.ctlrDevices = tempDevAccess;
                                    } else {
                                        tempDevAccess.daNextDevice = nFiler.nfComputer.cmpController.ctlrDevices;
                                        nFiler.nfComputer.cmpController.ctlrDevices = tempDevAccess;
                                    }
                                    if (isFirst) {
                                        prevDevAccess = ctlr.ctlrDevices;
                                        devCon = ctlr.ctlrDevices;
                                        break block2;
                                    }
                                    devCon = prevDevAccess.daNextDevice;
                                    break block2;
                                }
                                nFiler = nFiler.nfNext;
                            }
                            break;
                        }
                        res = res.crNext;
                    }
                    if (devCon != null) continue;
                    break;
                }
                if (prevDevAccess != devCon) {
                    prevDevAccess = prevDevAccess.daNextDevice;
                }
                devCon = devCon.daNextDevice;
            }
            if (ctlr == null) break;
            prevCtlr = ctlr;
            ctlr = ctlr.ctlrNext;
        }
    }

    public void correlateLogicalDisks() {
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        LogicalDisk prevlDisk = this.computer.cmpLogicalDisk;
        lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            block12: {
                LogicalDisk tempLDisk = lDisk;
                String logDisk = this.isClusteredLDisk(lDisk.ldPath);
                if (logDisk != null) {
                    boolean isFirst = false;
                    if (prevlDisk == lDisk) {
                        isFirst = true;
                        this.computer.cmpLogicalDisk = this.computer.cmpLogicalDisk.ldNext;
                    } else {
                        prevlDisk.ldNext = lDisk.ldNext;
                    }
                    String virtualServer = null;
                    ClusterResource res = this.cResource;
                    while (res != null) {
                        if (logDisk.equalsIgnoreCase(res.crName)) {
                            virtualServer = res.crVirtualServer;
                            NasFiler nFiler = this.computer.cmpNasFiler;
                            while (nFiler != null) {
                                if (virtualServer.equalsIgnoreCase(nFiler.nfName)) {
                                    tempLDisk.ldNext = nFiler.nfComputer.cmpLogicalDisk;
                                    nFiler.nfComputer.cmpLogicalDisk = tempLDisk;
                                    if (isFirst) {
                                        prevlDisk = this.computer.cmpLogicalDisk;
                                        lDisk = this.computer.cmpLogicalDisk;
                                    } else {
                                        lDisk = prevlDisk.ldNext;
                                    }
                                    break block12;
                                }
                                nFiler = nFiler.nfNext;
                            }
                            break;
                        }
                        res = res.crNext;
                    }
                } else {
                    if (prevlDisk != lDisk) {
                        prevlDisk = prevlDisk.ldNext;
                    }
                    lDisk = lDisk.ldNext;
                }
            }
            if (lDisk != null) continue;
            break;
        }
    }

    public void correlateExports() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"correlateExports", (String)"");
        }
        if (!this.isMSCSNode) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"correlateExports");
            }
            return;
        }
        Export prevExport = this.computer.cmpExport;
        Export export = this.computer.cmpExport;
        while (export != null) {
            block16: {
                Export tempExport = export;
                String exp = this.isClusteredShare(export.xpExportName);
                if (exp != null) {
                    boolean isFirst = false;
                    if (prevExport == export) {
                        isFirst = true;
                        this.computer.cmpExport = this.computer.cmpExport.xpNext;
                    } else {
                        prevExport.xpNext = export.xpNext;
                    }
                    String virtualServer = null;
                    ClusterResource res = this.cResource;
                    while (res != null) {
                        if (exp.equalsIgnoreCase(res.crName)) {
                            String qualifier = this.clusterName + "." + this.computer.cmpDomain.domName;
                            virtualServer = res.crVirtualServer;
                            NasFiler nFiler = this.computer.cmpNasFiler;
                            while (nFiler != null) {
                                int index = nFiler.nfName.lastIndexOf(qualifier);
                                if (virtualServer.equalsIgnoreCase(nFiler.nfName.substring(0, index - 1))) {
                                    tempExport.xpNext = nFiler.nfComputer.cmpExport;
                                    nFiler.nfComputer.cmpExport = tempExport;
                                    if (isFirst) {
                                        prevExport = this.computer.cmpExport;
                                        export = this.computer.cmpExport;
                                    } else {
                                        export = prevExport.xpNext;
                                    }
                                    break block16;
                                }
                                nFiler = nFiler.nfNext;
                            }
                            break;
                        }
                        res = res.crNext;
                    }
                } else {
                    if (prevExport != export) {
                        prevExport = prevExport.xpNext;
                    }
                    export = export.xpNext;
                }
            }
            if (export != null) continue;
            break;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"correlateExports");
        }
    }

    public void qualifyVirtualServerNames() {
        NasFiler nFiler = this.computer.cmpNasFiler;
        while (nFiler != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(nFiler.nfName);
            buffer.append(".");
            buffer.append(this.clusterName);
            buffer.append(".");
            buffer.append(this.computer.cmpDomain.domName);
            nFiler.nfName = buffer.toString();
            nFiler = nFiler.nfNext;
        }
    }

    public void chooseVirtualServerNameIP() {
        VirtualServer vs = null;
        NetworkName nwName = null;
        VirtualServer tempVS = this.vServer;
        Object vsIP = null;
        vs = this.vServer;
        while (vs != null) {
            nwName = vs.vsNetworkNameList;
            while (nwName != null) {
                if (nwName.nwName.equalsIgnoreCase(this.clusterName)) {
                    vs.vsNetworkName = nwName.nwName;
                    vs.vsIPAddress = nwName.depIP;
                    break;
                }
                if (this.sameSubnet(this.agentIP, nwName.depIP, nwName.depIPMask)) {
                    vs.vsIPAddress = nwName.depIP;
                    vs.vsNetworkName = nwName.nwName;
                    break;
                }
                nwName = nwName.nwNameNext;
            }
            if (vs.vsIPAddress.equals(" ") && vs.vsNetworkNameList != null) {
                vs.vsIPAddress = vs.vsNetworkNameList.depIP;
            }
            if (vs.vsNetworkName.equals(" ") && vs.vsNetworkNameList != null) {
                vs.vsNetworkName = vs.vsNetworkNameList.nwName;
            }
            vs = vs.vsNext;
        }
    }

    public boolean sameSubnet(String agentIP, String vsIP, String subnetMask) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeWin32.class.getName(), (String)"sameSubnet", (String)"agentIP, vsIP, subnetMask");
        }
        int[] agent_arr = new int[]{0, 0, 0, 0};
        int[] ip_arr = new int[]{0, 0, 0, 0};
        int[] mask_arr = new int[]{0, 0, 0, 0};
        int[] subnet1_arr = new int[]{0, 0, 0, 0};
        int[] subnet2_arr = new int[]{0, 0, 0, 0};
        int ind = 0;
        try {
            InetAddress agent = InetAddress.getByName(agentIP);
            for (ind = 0; ind < 4; ++ind) {
                agent_arr[ind] = agent.getAddress()[ind] & 0xFF;
            }
            InetAddress ip = InetAddress.getByName(vsIP);
            for (ind = 0; ind < 4; ++ind) {
                ip_arr[ind] = ip.getAddress()[ind] & 0xFF;
            }
            InetAddress subnet = InetAddress.getByName(subnetMask);
            for (ind = 0; ind < 4; ++ind) {
                mask_arr[ind] = subnet.getAddress()[ind] & 0xFF;
            }
        }
        catch (UnknownHostException ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeWin32.class.getName(), (String)"sameSubnet", (Throwable)ex);
            }
            MessageLog.logMessage((String)"AGT0154E");
        }
        for (ind = 0; ind < 4; ++ind) {
            subnet1_arr[ind] = agent_arr[ind] & mask_arr[ind];
            subnet2_arr[ind] = ip_arr[ind] & mask_arr[ind];
        }
        for (ind = 0; ind < 4; ++ind) {
            if (subnet1_arr[ind] == subnet2_arr[ind]) continue;
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"sameSubnet", (boolean)traceResult);
            }
            return traceResult;
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeWin32.class.getName(), (String)"sameSubnet", (boolean)traceResult);
        }
        return traceResult;
    }

    public void fillNetworkNameList() {
        VirtualServer vs = null;
        NetworkName nw = null;
        NetworkName tempNw = null;
        NetworkName prevNw = null;
        boolean isFirst = false;
        vs = this.vServer;
        while (vs != null) {
            prevNw = this.vsNetwork;
            nw = this.vsNetwork;
            while (nw != null) {
                tempNw = nw;
                if (nw.nwVS.equalsIgnoreCase(vs.vsName)) {
                    if (prevNw == nw) {
                        isFirst = true;
                        this.vsNetwork = this.vsNetwork.nwNameNext;
                    } else {
                        prevNw.nwNameNext = nw.nwNameNext;
                    }
                    tempNw.nwNameNext = vs.vsNetworkNameList;
                    vs.vsNetworkNameList = tempNw;
                    if (isFirst) {
                        prevNw = this.vsNetwork;
                        nw = this.vsNetwork;
                    } else {
                        nw = prevNw.nwNameNext;
                    }
                } else {
                    if (prevNw != nw) {
                        prevNw = prevNw.nwNameNext;
                    }
                    nw = nw.nwNameNext;
                }
                if (nw != null) continue;
            }
            vs = vs.vsNext;
        }
    }

    public void fillClusterIP() {
        NetworkName nw = null;
        VirtualServer vs = null;
        nw = this.vsNetwork;
        while (nw != null) {
            if (nw.nwName.equalsIgnoreCase(this.clusterName)) {
                this.computer.cmpCluster.IPAddress = nw.depIP;
                break;
            }
            nw = nw.nwNameNext;
        }
        if (this.computer.cmpCluster.IPAddress == null) {
            vs = this.vServer;
            while (vs != null) {
                if (vs.vsNetworkName != null && vs.vsNetworkName.equalsIgnoreCase(this.clusterName)) {
                    this.computer.cmpCluster.IPAddress = vs.vsIPAddress;
                    break;
                }
                vs = vs.vsNext;
            }
        }
    }

    static {
        ProbeWin32.initIDs();
    }
}

