/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.report;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.TStorm.common.MakeBatchGraph;
import org.eclipse.aperi.TStorm.common.PrintHistoryChart;
import org.eclipse.aperi.TStorm.common.PrintHtmlTable;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.WriteReports;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.agent.handler.HandlerExtensionMgr;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.handler.script.AbstractScriptHandler;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationManager;
import org.eclipse.aperi.identity.SuperUser;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExecReport
implements IExecutable {
    private GuiReportReq grr;
    private JobRun jobRun;
    private MutableLong keyObj;
    private ReportDataAdjuster adjuster;
    private StartedJob startedJob;
    private String outputFileName;
    private boolean chartReport;
    private String[] values = new String[7];
    private Object[] parms = new Object[5];
    private String[] keywords;
    private byte reportType = 0;

    public int exec(StartedJob startedJob, String[] args) {
        return this.exec(startedJob);
    }

    private int exec(StartedJob startedJob) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecReport.class.getName(), (String)"main", (String)"");
        }
        this.init(startedJob);
        ReportDataAdjuster adjuster = null;
        int returnCode = 8;
        int[] rowMap = null;
        this.parms[0] = this.jobRun.getSchedCreator();
        this.parms[1] = this.jobRun.getSchedName();
        MessageLog.logMessage((String)"STA2000I", (Object[])this.parms);
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        request.subType = "org.eclipse.aperi.server.handler.agent.BatchReportHndlr";
        request.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.server.svp.AgentSvp");
        request.requestData = this.keyObj;
        BatchReport batchReport = null;
        Response response = Agent.reporter.sendRequest(request);
        if (response == null || response.status > 4) {
            MessageLog.logMessage((String)"AGT0151E");
        } else {
            batchReport = (BatchReport)response.responseData;
            this.grr = batchReport.grr;
            this.keywords = BatchReport.keywords;
            String fileMask = this.getFileName(batchReport, this.grr);
            this.reportType = batchReport.reportType;
            this.chartReport = false;
            if (this.reportType == 8 || this.reportType == 9) {
                this.chartReport = true;
                GuiChartSettingsReq gcsr = new GuiChartSettingsReq();
                gcsr.creator = this.jobRun.getSchedCreator();
                gcsr.reqType = 5;
                Request r = new Request();
                r.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                r.serviceName = RequestTypeManager.getInternalName((String)r.typeCode);
                r.subType = "org.eclipse.aperi.server.handler.gui.ChartSettingsHndlr";
                r.flags = (byte)4;
                r.userName = this.jobRun.getSchedCreator();
                r.requestData = gcsr;
                Response res = Agent.reporter.sendRequest(r);
                if (res.status <= 4) {
                    AperiChartCustomizationManager.initManager((String)this.jobRun.getSchedCreator(), (ArrayList)((ArrayList)res.responseData));
                }
            }
            String suffix = null;
            switch (this.reportType) {
                case 8: {
                    suffix = MessageLog.getMessageNoID((String)"STG5269L");
                    break;
                }
                case 6: 
                case 9: {
                    suffix = MessageLog.getMessageNoID((String)"STG5270L");
                    break;
                }
                case 1: 
                case 7: {
                    suffix = ".csv";
                    break;
                }
                case 2: {
                    suffix = ".txt";
                }
            }
            if (fileMask.length() > suffix.length() && !fileMask.substring(fileMask.length() - 1 - (suffix.length() - 1)).equalsIgnoreCase(suffix)) {
                fileMask = fileMask + suffix;
            }
            int totalRows = 0;
            this.parms[0] = fileMask;
            MessageLog.logMessage((String)"STA2001I", (Object[])this.parms);
            Object out = this.getPrintWriter(fileMask);
            if (out != null) {
                PrintWriter writer = null;
                FileOutputStream stream = null;
                if (this.chartReport) {
                    stream = (FileOutputStream)out;
                } else {
                    writer = (PrintWriter)out;
                }
                Object[] dataArray = batchReport.data instanceof PartitionedReport ? this.getArray((PartitionedReport)batchReport.data) : (Object[])batchReport.data;
                if (dataArray == null || dataArray.length == 0) {
                    if (this.reportType == 2) {
                        writer.println(MessageLog.getMessageNoID((String)"STG5171M"));
                    } else if (this.reportType == 6) {
                        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.xmsg.GuiResources");
                        String description = MessageLog.getMessageNoID((String)GuiReportReq.guiClasses[this.grr.reportType][2]) + rb.getString("COLON") + MessageLog.getMessageNoID((String)GuiReportReq.subtypeTreeLabels[this.grr.reportSubtype][0]);
                        new PrintHtmlTable().printPrelude(writer, this.jobRun.getSchedCreator(), description, 777, false);
                        writer.println(" ");
                        writer.println(MessageLog.getMessageNoID((String)"STG5171M"));
                        writer.println(" ");
                        writer.println("</body>");
                        writer.println("</html>");
                    }
                    returnCode = 4;
                } else {
                    adjuster = null;
                    try {
                        adjuster = ReportDataAdjuster.makeAdjuster((GuiReportReq)this.grr);
                    }
                    catch (GeneralException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ExecReport.class.getName(), (String)"main", (Throwable)e);
                        }
                        e.print();
                    }
                    if (adjuster != null) {
                        Variables.spaceUnits = batchReport.spaceUnits;
                        adjuster.adjust(dataArray, true);
                        if (this.chartReport) {
                            MakeBatchGraph makeBatchGraph = new MakeBatchGraph();
                            returnCode = makeBatchGraph.makeGraph(this.grr, adjuster, dataArray, stream, this.outputFileName, this.reportType, this.jobRun.getSchedCreator(), batchReport);
                        } else if (this.reportType == 7) {
                            this.grr.selectedStatIDs = adjuster.initHistoryLegend();
                            if (this.grr.selectedResources == null) {
                                this.grr.selectedResources = adjuster.getSelectedIDs();
                            }
                            this.grr.selectedUsers = adjuster.getSelectedUsers();
                            MessageLog.logMessage((String)"AGT0149I");
                            request = new Request();
                            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                            request.subType = "org.eclipse.aperi.server.handler.gui.GuiReportHndlr";
                            request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
                            request.requestData = this.grr;
                            int subtype = this.grr.reportSubtype;
                            this.grr.reportSubtype = 28;
                            response = Agent.reporter.sendRequest(request);
                            this.grr.reportSubtype = subtype;
                            if (response == null || response.status > 4) {
                                returnCode = 8;
                            } else {
                                MessageLog.logMessage((String)"AGT0148I");
                                dataArray = response.responseData instanceof PartitionedReport ? (Object[])((PartitionedReport)response.responseData).prData : (Object[])response.responseData;
                                if (dataArray == null || dataArray.length == 0) {
                                    returnCode = 4;
                                } else {
                                    this.grr.reportSubtype = subtype;
                                    String columnHeader = null;
                                    if (batchReport.includeHeaders) {
                                        columnHeader = batchReport.historyHeader;
                                    }
                                    totalRows = new PrintHistoryChart().printBatch(this.grr, (Object)dataArray, writer, columnHeader);
                                    returnCode = 0;
                                }
                            }
                        } else {
                            MessageLog.logMessage((String)"AGT0148I");
                            int[] columnArray = adjuster.fixColumnArray(null);
                            if (this.reportType == 6) {
                                ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.xmsg.GuiResources");
                                String description = MessageLog.getMessageNoID((String)GuiReportReq.guiClasses[this.grr.reportType][2]) + rb.getString("COLON") + MessageLog.getMessageNoID((String)GuiReportReq.subtypeTreeLabels[this.grr.reportSubtype][0]);
                                new PrintHtmlTable().printHtml(adjuster, writer, columnArray, this.jobRun.getSchedCreator(), description, rowMap);
                            } else {
                                WriteReports snapper = new WriteReports();
                                if (this.reportType == 1) {
                                    snapper.writeCSV(adjuster, writer, columnArray, batchReport.includeHeaders, batchReport.includeTotals, rowMap);
                                } else {
                                    snapper.writeFormatted(adjuster, writer, columnArray, rowMap);
                                }
                            }
                            totalRows = adjuster.getNumberRows();
                            returnCode = 0;
                        }
                    }
                }
                if (writer != null) {
                    writer.close();
                }
            }
            if (this.chartReport) {
                if (returnCode == 4) {
                    MessageLog.logMessage((String)"STA2012I");
                }
            } else if (totalRows == 1) {
                MessageLog.logMessage((String)"STA2006I");
            } else {
                this.parms[0] = Integer.toString(totalRows);
                MessageLog.logMessage((String)"STA2002I", (Object[])this.parms);
            }
        }
        if (returnCode > 4) {
            MessageLog.logMessage((String)"STA2008I");
        } else {
            if (returnCode == 0) {
                MessageLog.logMessage((String)"STA2003I");
            } else {
                MessageLog.logMessage((String)"STA2007I");
            }
            if (!Util.isEmpty((String)batchReport.scriptName)) {
                this.kickOffScript(batchReport);
            }
        }
        int traceResult = returnCode;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecReport.class.getName(), (String)"main", (int)traceResult);
        }
        return traceResult;
    }

    private void init(StartedJob startedJob) {
        this.startedJob = startedJob;
        this.jobRun = startedJob.getJobRun();
        long key = this.jobRun.getSchedID();
        key = Agent.isWindows ? (key |= 0x100000000L) : (key &= 0xFFFFFFFFL);
        this.keyObj = new MutableLong(key);
    }

    private String getFileName(BatchReport bp, GuiReportReq grr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecReport.class.getName(), (String)"getFileName", (String)"bp, grr");
        }
        this.values[0] = this.jobRun.getSchedCreator();
        this.values[1] = this.jobRun.getSchedName();
        this.values[2] = WriteReports.adjustFileName((String)(MessageLog.getMessageNoID((String)GuiReportReq.guiClasses[grr.reportType][2]) + MessageLog.getMessageNoID((String)GuiReportReq.subtypeTreeLabels[grr.reportSubtype][0])));
        int schedRunNumber = this.jobRun.getSchedRunNumber();
        String number = "000" + Integer.toString(this.jobRun.getSchedRunNumber());
        this.values[3] = schedRunNumber < 10000 ? number.substring(number.length() - 4) : (schedRunNumber < 100000 ? number.substring(number.length() - 5) : (schedRunNumber < 1000000 ? number.substring(number.length() - 6) : (schedRunNumber < 10000000 ? number.substring(number.length() - 7) : (schedRunNumber < 100000000 ? number.substring(number.length() - 8) : number.substring(number.length() - 9)))));
        Date date = new Date();
        this.values[4] = new SimpleDateFormat("yyyy_MM_dd").format(date);
        this.values[5] = new SimpleDateFormat("kk_mm").format(date);
        number = "0000000" + Integer.toString(this.jobRun.getRunNumber());
        this.values[6] = this.jobRun.getRunNumber() < 100000000 ? number.substring(number.length() - 8) : number.substring(number.length() - 9);
        String traceResult = bp.maskToText(null, this.values);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecReport.class.getName(), (String)"getFileName", (Object)traceResult);
        }
        return traceResult;
    }

    private Object[] getArray(PartitionedReport partition) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecReport.class.getName(), (String)"getArray", (String)"partition");
        }
        Object[] array = null;
        long[] idArray = new long[]{partition.prID};
        if (partition.prLastPart) {
            array = (Object[])partition.prData;
        } else {
            PartitionedReport last = partition;
            short part = partition.prPartition;
            while (!last.prLastPart) {
                part = (short)(part + 1);
                PartitionedReport clone = (PartitionedReport)partition.clone();
                clone.prPartition = part;
                clone.prData = null;
                Request request = new Request();
                request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
                request.subType = "org.eclipse.aperi.server.handler.gui.PartitionHndlr";
                request.requestData = clone;
                Object[] parms = new Object[]{new Integer(part)};
                MessageLog.logMessage((String)"AGT0147I", (Object[])parms);
                Response response = Agent.reporter.sendRequest(request);
                if (response == null || response.status > 4 || response.responseData == null) {
                    partition = null;
                    break;
                }
                last = last.next = (PartitionedReport)response.responseData;
            }
            if (partition != null) {
                int total = 0;
                last = partition;
                while (last != null) {
                    total += ((Object[])last.prData).length;
                    last = last.next;
                }
                Object[] workArray = (Object[])partition.prData;
                Class<?> classy = workArray[0].getClass();
                array = (Object[])Array.newInstance(classy, total);
                int toIndex = 0;
                while (partition != null) {
                    workArray = (Object[])partition.prData;
                    System.arraycopy(workArray, 0, array, toIndex, workArray.length);
                    toIndex += workArray.length;
                    partition = partition.next;
                }
            }
        }
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.PartitionHndlr";
        request.requestData = idArray;
        request.userName = this.jobRun.getSchedCreator();
        MessageLog.logMessage((String)"AGT0150I");
        if (!Agent.reporter.sendNoWaitRequest(request)) {
            MessageLog.logMessage((String)"STA2005W");
        }
        Object[] traceResult = array;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecReport.class.getName(), (String)"getArray", (Object)traceResult);
        }
        return traceResult;
    }

    private Object getPrintWriter(String fileMask) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecReport.class.getName(), (String)"getPrintWriter", (String)"fileMask");
        }
        Closeable out = null;
        String path = Agent.logFileDirectory + File.separator + "reports";
        File directory = new File(path);
        try {
            if (!directory.isDirectory()) {
                if (!directory.mkdir()) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ExecReport.class.getName(), (String)"getPrintWriter");
                    }
                    throw new SecurityException();
                }
                SuperUser.secureDirectory((String)path);
            }
        }
        catch (SecurityException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ExecReport.class.getName(), (String)"getPrintWriter", (Throwable)e);
            }
            MessageLog.logException((String)"AGT0124E", (Exception)e, (Object)path);
            directory = null;
        }
        catch (LocalizableException ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ExecReport.class.getName(), (String)"getPrintWriter", (Throwable)ex);
            }
            ex.print();
            directory = null;
        }
        if (directory != null) {
            this.outputFileName = path + File.separator + fileMask;
            try {
                FileOutputStream fos = new FileOutputStream(this.outputFileName);
                if (this.chartReport) {
                    out = fos;
                } else {
                    OutputStreamWriter stream = null;
                    stream = this.reportType == 6 ? new OutputStreamWriter((OutputStream)fos, "UTF-8") : new OutputStreamWriter(fos);
                    if (stream != null) {
                        out = new PrintWriter((Writer)stream, true);
                    }
                }
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ExecReport.class.getName(), (String)"getPrintWriter", (Throwable)e);
                }
                this.parms[0] = e.getMessage();
                MessageLog.logMessage((String)"STA2010E", (Object[])this.parms);
            }
        }
        FileOutputStream traceResult = out;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecReport.class.getName(), (String)"getPrintWriter", traceResult);
        }
        return traceResult;
    }

    private void kickOffScript(BatchReport batchReport) {
        block9: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ExecReport.class.getName(), (String)"kickOffScript", (String)"batchReport");
            }
            RunScriptReq requestData = new RunScriptReq();
            requestData.scrArgv = new String[2];
            requestData.scrArgv[0] = batchReport.scriptName;
            requestData.scrArgv[1] = this.outputFileName;
            requestData.scrExtension = batchReport.scriptExtension;
            requestData.scrData = new byte[1][];
            requestData.scrData[0] = batchReport.scriptBody;
            FileWriter mid = null;
            try {
                mid = new FileWriter(this.startedJob.getLogFileName(), true);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ExecReport.class.getName(), (String)"kickOffScript", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0029E", (Exception)e);
            }
            if (mid == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ExecReport.class.getName(), (String)"kickOffScript");
                }
                return;
            }
            PrintWriter newLog = new PrintWriter((Writer)mid, true);
            try {
                HandlerExtensionMgr handlerExMgr = HandlerExtensionMgr.getExtensionMgr();
                AbstractScriptHandler h = (AbstractScriptHandler)handlerExMgr.getExtensionImpl("org.eclipse.aperi.agent.handler.script.ScriptHandlerFactory");
                IAssignable task = h.makeRunner(requestData, this.startedJob.getLogFileName(), newLog, false);
                Agent.breadLine.assign(task);
            }
            catch (ExtensionException e) {
                if (!TraceLogger.enableTrace) break block9;
                TraceLogger.exception((String)ExecReport.class.getName(), (String)"kickOffScript", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecReport.class.getName(), (String)"kickOffScript");
        }
    }
}

