/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.worker;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.agent.worker.Worker;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.logging.TraceLogger;

public class BreadLine {
    private List<Worker> workerList = new LinkedList<Worker>();
    private int maxIdleThreads;

    public BreadLine(int pMaxInLine) {
        this.maxIdleThreads = pMaxInLine;
    }

    synchronized boolean join(Worker worker) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BreadLine.class.getName(), (String)"join", (String)"worker");
        }
        if (this.workerList.size() >= this.maxIdleThreads) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)BreadLine.class.getName(), (String)"join", (boolean)false);
            }
            return false;
        }
        this.workerList.add(worker);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BreadLine.class.getName(), (String)"join", (boolean)true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(IAssignable task) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)BreadLine.class.getName(), (String)"assign", (String)"task");
        }
        Worker worker = null;
        BreadLine breadLine = this;
        synchronized (breadLine) {
            if (this.workerList.size() > 0) {
                worker = this.workerList.remove(0);
            }
        }
        if (worker != null) {
            worker.dispatch(task);
        } else {
            worker = new Worker(task);
            TSThread thread = new TSThread(Agent.threadGroup, (Runnable)worker);
            thread.start();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)BreadLine.class.getName(), (String)"assign");
        }
    }

    public int getMaxIdleThreads() {
        return this.maxIdleThreads;
    }

    public void setMaxIdleThreads(int maxIdleThreads) {
        this.maxIdleThreads = maxIdleThreads;
    }
}

