/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.worker;

import java.net.Socket;
import org.eclipse.aperi.agent.handler.HandlerExtensionMgr;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.xmsg.MessageLog;

public class Router
implements IAssignable {
    private Transceiver transceiver;
    private Socket connection;

    public Router(Socket pConnection) {
        this.connection = pConnection;
        this.transceiver = new SocketTransceiver(pConnection);
    }

    public void execute() {
        Response response;
        Request request;
        block14: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Router.class.getName(), (String)"execute", (String)"");
            }
            request = null;
            response = null;
            try {
                IAgentRequestHandler handler;
                block13: {
                    request = this.transceiver.receiveRequest();
                    if (request == null) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)Router.class.getName(), (String)"execute");
                        }
                        throw new GeneralException();
                    }
                    response = new Response(12, null);
                    if (!request.typeCode.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
                        response.errorMessage = MessageLog.getMessage((String)"GEN0031E", null);
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)Router.class.getName(), (String)"execute");
                        }
                        throw new GeneralException();
                    }
                    handler = null;
                    try {
                        handler = (IAgentRequestHandler)HandlerExtensionMgr.getExtensionMgr().getExtensionImpl(request.subType);
                    }
                    catch (ExtensionException e) {
                        if (!TraceLogger.enableTrace) break block13;
                        TraceLogger.exception((String)Router.class.getName(), (String)"execute", (Throwable)e);
                    }
                }
                if (handler == null) {
                    response.errorMessage = MessageLog.getMessage((String)"GEN0032E", null);
                } else {
                    handler.handle(request, response, this.connection);
                }
            }
            catch (GeneralException e) {
                if (!TraceLogger.enableTrace) break block14;
                TraceLogger.exception((String)Router.class.getName(), (String)"execute", (Throwable)e);
            }
        }
        if (response != null) {
            this.transceiver.transmitResponse(request, response);
        }
        this.transceiver.close();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Router.class.getName(), (String)"execute");
        }
    }
}

