/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.Constants;
import org.eclipse.aperi.connector.internal.client.SocketBuilder;

public class HttpPost
implements Constants {
    static final int DEFAULT_OUTPUT_BUFFER_SIZE = 512;

    public static TransportMessage post(URL url, TransportMessage request) throws IllegalArgumentException, IOException, SOAPException {
        TransportMessage response;
        int offset;
        Socket s;
        int port;
        OutputStream outStream = null;
        InputStream inStream = null;
        try {
            port = HttpPost.getPort(url);
            boolean sslEnabled = false;
            if (url.toString().startsWith("https://")) {
                sslEnabled = true;
            }
            s = SocketBuilder.buildSocket(url.getHost(), port, sslEnabled);
            outStream = s.getOutputStream();
            inStream = s.getInputStream();
        }
        catch (Exception e) {
            Throwable t = e;
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            throw new IllegalArgumentException("Error opening socket: " + t);
        }
        String URI2 = url.toString();
        if (URI2.length() == 0) {
            URI2 = "/";
        }
        StringBuffer headerbuf = new StringBuffer();
        headerbuf.append("POST").append(' ').append(URI2).append(" HTTP/").append("1.0").append("\r\n").append("Host").append(": ").append(url.getHost()).append(':').append(port).append("\r\n").append("Content-Type").append(": ").append(request.getContentType()).append("\r\n").append("Content-Length").append(": ").append(request.getContentLength()).append("\r\n");
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            headerbuf.append(key).append(": ").append(request.getHeader((String)key)).append("\r\n");
        }
        headerbuf.append("\r\n");
        BufferedOutputStream bOutStream = new BufferedOutputStream(outStream, 512);
        bOutStream.write(headerbuf.toString().getBytes("iso-8859-1"));
        request.writeTo((OutputStream)bOutStream);
        bOutStream.flush();
        outStream.flush();
        BufferedInputStream bInStream = new BufferedInputStream(inStream);
        StringBuffer linebuf = new StringBuffer();
        int b = 0;
        while (b != 10 && b != -1) {
            b = bInStream.read();
            if (b == 10 || b == 13 || b == -1) continue;
            linebuf.append((char)b);
        }
        String line = linebuf.toString();
        try {
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken());
                if (!st.hasMoreTokens()) continue;
                sb.append(" ");
            }
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Error parsing HTTP status line \"" + line + "\": " + e2);
        }
        ByteArrayDataSource ds = new ByteArrayDataSource((InputStream)bInStream, "iso-8859-1");
        byte[] bytes = ds.toByteArray();
        Hashtable<String, String> respHeaders = new Hashtable<String, String>();
        int respContentLength = -1;
        String respContentType = null;
        StringBuffer namebuf = new StringBuffer();
        StringBuffer valuebuf = new StringBuffer();
        boolean parsingName = true;
        for (offset = 0; offset < bytes.length; ++offset) {
            if (bytes[offset] == 10) {
                if (namebuf.length() == 0) break;
                String name = namebuf.toString();
                int valueLen = valuebuf.length();
                if (valueLen > 0 && valuebuf.charAt(valueLen - 1) == ';') {
                    valuebuf.deleteCharAt(valueLen - 1);
                }
                String value = valuebuf.toString();
                if (name.equalsIgnoreCase("Content-Length")) {
                    respContentLength = Integer.parseInt(value);
                } else if (name.equalsIgnoreCase("Content-Type")) {
                    respContentType = value;
                } else {
                    respHeaders.put(name, value);
                }
                namebuf = new StringBuffer();
                valuebuf = new StringBuffer();
                parsingName = true;
                continue;
            }
            if (bytes[offset] == 13) continue;
            if (parsingName) {
                if (bytes[offset] == 58) {
                    parsingName = false;
                    if (offset == bytes.length - 1 || bytes[offset + 1] != 32) continue;
                    ++offset;
                    continue;
                }
                namebuf.append((char)bytes[offset]);
                continue;
            }
            valuebuf.append((char)bytes[offset]);
        }
        InputStream is = ds.getInputStream();
        is.skip(offset + 1);
        if (respContentLength < 0) {
            respContentLength = ds.getSize() - offset - 1;
        }
        try {
            SOAPContext ctx = new SOAPContext();
            response = new TransportMessage(is, respContentLength, respContentType, ctx, respHeaders);
            response.read();
        }
        catch (MessagingException me) {
            throw new IllegalArgumentException("Error parsing response: " + (Object)((Object)me));
        }
        bOutStream.close();
        outStream.close();
        bInStream.close();
        inStream.close();
        s.close();
        return response;
    }

    private static int getPort(URL url) throws IOException {
        int port = url.getPort();
        if (port < 0) {
            String sport = Config.getProperty("connector.target.port");
            try {
                port = Integer.parseInt(sport);
            }
            catch (NumberFormatException nfe) {
                port = 80;
            }
        }
        return port;
    }
}

