/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.eclipse.aperi.connector.internal.client.HttpPost;

public class SOAPConnection
implements SOAPTransport {
    private BufferedReader responseReader;
    private Hashtable responseHeaders;
    private SOAPContext responseSOAPContext;

    public void send(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws SOAPException {
        try {
            TransportMessage response;
            String payload = null;
            if (env != null) {
                StringWriter payloadSW = new StringWriter();
                env.marshall((Writer)payloadSW, (XMLJavaMappingRegistry)smr, ctx);
                payload = payloadSW.toString();
            }
            if (headers == null) {
                headers = new Hashtable<String, String>();
            }
            headers.put("SOAPAction", action != null ? '\"' + action + '\"' : "");
            try {
                TransportMessage msg = new TransportMessage(payload, ctx, headers);
                msg.save();
                response = HttpPost.post(sendTo, msg);
            }
            catch (Exception me) {
                throw new IOException("Failed to encode mime multipart: " + me);
            }
            Reader envReader = response.getEnvelopeReader();
            this.responseReader = envReader != null ? new BufferedReader(envReader) : null;
            this.responseSOAPContext = response.getSOAPContext();
            this.responseHeaders = response.getHeaders();
        }
        catch (Exception e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable getHeaders() {
        return this.responseHeaders;
    }

    public SOAPContext getResponseSOAPContext() {
        return this.responseSOAPContext;
    }

    public BufferedReader receive() {
        return this.responseReader;
    }
}

