/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.eclipse.aperi.connector.internal.InternalConstants;
import org.eclipse.aperi.connector.internal.server.BiModalSocketListener;
import org.eclipse.aperi.connector.internal.ssl.SSLManager;
import org.eclipse.aperi.connector.log.LogHelper;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.jetty.servlet.ServletSSL;
import org.mortbay.util.InetAddrPort;

public class BiModalSSLSocketListener
extends BiModalSocketListener
implements InternalConstants {
    static final long serialVersionUID = 298789788L;
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    private String[] cipherSuites = null;

    public BiModalSSLSocketListener() {
        this.setDefaultScheme("https://");
    }

    public boolean isIntegral(HttpConnection connection) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == this.getPort();
    }

    public boolean isConfidential(HttpConnection connection) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == this.getPort();
    }

    protected void customizeRequest(Socket socket, HttpRequest request) {
        super.customizeRequest(socket, request);
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        try {
            java.security.cert.X509Certificate[] certs;
            Integer keySize;
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession sslSession = sslSocket.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
            } else {
                keySize = new Integer(ServletSSL.deduceKeyLength((String)cipherSuite));
                certs = BiModalSSLSocketListener.getCertChain(sslSession);
                cachedInfo = new CachedInfo(keySize, certs);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs == null) {
                throw new HttpException(403);
            }
            request.setAttribute("javax.servlet.request.X509Certificate", (Object)certs);
            request.setAttribute("javax.servlet.request.cipher_suite", (Object)cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", (Object)keySize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        return SSLManager.getSSLServerSocketFactory();
    }

    protected ServerSocket newServerSocket(InetAddrPort p_address, int p_acceptQueueSize) throws IOException {
        String METHOD = "newServerSocket";
        SSLServerSocketFactory factory = null;
        SSLServerSocket socket = null;
        try {
            factory = this.createFactory();
            socket = p_address == null ? (SSLServerSocket)factory.createServerSocket(0, p_acceptQueueSize) : (SSLServerSocket)factory.createServerSocket(p_address.getPort(), p_acceptQueueSize, p_address.getInetAddress());
            socket.setNeedClientAuth(true);
            if (this.cipherSuites != null && this.cipherSuites.length > 0) {
                socket.setEnabledCipherSuites(this.cipherSuites);
                for (int i = 0; i < this.cipherSuites.length; ++i) {
                    LogHelper.trace("SslListener enabled ciphersuite: " + this.cipherSuites[i], this.getClass(), "newServerSocket");
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LogHelper.trace("Could not create JSSE Listener", this.getClass(), "newServerSocket");
            throw new IOException(e.toString());
        }
        return socket;
    }

    protected Socket accept(ServerSocket p_serverSocket) throws IOException {
        SSLSocket s = (SSLSocket)p_serverSocket.accept();
        if (this.getMaxIdleTimeMs() > 0) {
            s.setSoTimeout(this.getMaxIdleTimeMs());
        }
        s.startHandshake();
        return s;
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        String METHOD = "getCertChain";
        java.security.cert.X509Certificate[] javaCerts = null;
        try {
            X509Certificate[] javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (Exception e) {
            LogHelper.logException(e, BiModalSSLSocketListener.class, "getCertChain");
            return javaCerts;
        }
    }

    private class CachedInfo {
        private Integer keySize;
        private java.security.cert.X509Certificate[] certs;

        Integer getKeySize() {
            return this.keySize;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this.certs;
        }

        CachedInfo(Integer keySize, java.security.cert.X509Certificate[] certs) {
            this.keySize = keySize;
            this.certs = certs;
        }
    }
}

