/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.server;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.RPCRouterServlet;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.eclipse.aperi.connector.Constants;
import org.eclipse.aperi.connector.internal.Activator;
import org.eclipse.aperi.connector.internal.SecurityContext;
import org.eclipse.aperi.connector.internal.SessionContext;
import org.eclipse.aperi.connector.internal.SystemSecurityContext;
import org.eclipse.aperi.connector.internal.server.DeploymentDescriptorFactory;
import org.eclipse.aperi.connector.log.LogHelper;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

public class Connector
extends RPCRouterServlet
implements ServiceListener,
IDisposable,
Constants {
    public static final long serialVersionUID = 4813483L;
    private boolean registered = false;

    public void start() {
        String METHOD = "start";
        LogHelper.traceEntry(this.getClass(), METHOD);
        ServiceReference sr = Activator.getContext().getServiceReference(HttpService.class.getName());
        this.registerWithHttpService(sr);
        LogHelper.log("CNT004I", this.getClass(), METHOD);
        Activator.registerDisposable(this);
        LogHelper.log("CNT017I", this.getClass(), METHOD);
        Activator.getContext().addServiceListener((ServiceListener)this);
        LogHelper.log("CNT018I", this.getClass(), METHOD);
        LogHelper.traceExit(this.getClass(), METHOD);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        super.init();
        SecurityContext.setDefaultContext(new SystemSecurityContext());
        this.registerExistingServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SessionContext.addSession(req);
        try {
            super.doPost(req, resp);
        }
        finally {
            SessionContext.removeSession(req);
        }
    }

    public void destroy() {
    }

    protected synchronized void deploy(String name, Object impl) {
        String METHOD = "deploy";
        try {
            DeploymentDescriptor dd = DeploymentDescriptorFactory.createDD(name, impl.getClass());
            ServiceManager ssm = ServerHTTPUtils.getServiceManagerFromContext((ServletContext)this.getServletContext());
            ssm.deploy(dd);
            LogHelper.log("CNT003I", this.getClass(), "deploy", name);
        }
        catch (Exception e) {
            LogHelper.logException(e, this.getClass(), "deploy");
        }
    }

    public void undeploy(String name) {
        String METHOD = "undeploy";
        try {
            ServiceManager ssm = ServerHTTPUtils.getServiceManagerFromContext((ServletContext)this.getServletContext());
            ssm.undeploy(name);
            LogHelper.log("CNT021I", this.getClass(), "undeploy");
        }
        catch (Exception e) {
            LogHelper.traceException(e, this.getClass(), "undeploy");
        }
    }

    public void serviceChanged(ServiceEvent event) {
        String name;
        ServiceReference sr = null;
        sr = event.getServiceReference();
        if (event.getType() == 1) {
            boolean isWebService = this.deployServiceReference(sr);
            if (!this.isRegistered() & !isWebService) {
                this.registerWithHttpService(sr);
            }
        } else if (event.getType() == 4 && (name = (String)sr.getProperty("org.eclipse.aperi.webservice.name")) != null) {
            this.undeploy(name);
        }
    }

    public void registerExistingServices() {
        String METHOD = "registerExistingServices";
        try {
            ServiceReference[] srs = Activator.getContext().getAllServiceReferences(null, null);
            for (int i = 0; i < srs.length; ++i) {
                this.deployServiceReference(srs[i]);
            }
        }
        catch (InvalidSyntaxException e) {
            LogHelper.log("CNT019W", this.getClass(), "registerExistingServices");
            LogHelper.logException((Exception)((Object)e), this.getClass(), "registerExistingServices");
        }
    }

    protected boolean deployServiceReference(ServiceReference sr) {
        boolean isWebService = false;
        String name = (String)sr.getProperty("org.eclipse.aperi.webservice.name");
        if (name != null) {
            isWebService = true;
            Object service = Activator.getContext().getService(sr);
            super.getServletContext().setAttribute(name, service);
            this.deploy(name, service);
        }
        return isWebService;
    }

    protected void registerWithHttpService(ServiceReference sr) {
        Object service;
        String METHOD = "registerWithHttpService";
        if (sr != null && (service = Activator.getContext().getService(sr)) != null && service instanceof HttpService) {
            HttpService http = (HttpService)service;
            try {
                http.registerServlet("/ServiceManager", (Servlet)this, null, null);
                this.setRegistered(true);
                LogHelper.log("CNT004I", this.getClass(), "registerWithHttpService");
            }
            catch (Exception e) {
                LogHelper.logException(e, this.getClass(), "registerWithHttpService");
            }
        }
    }

    public void dispose() {
        Object service;
        String METHOD = "dispose";
        ServiceReference sr = Activator.getContext().getServiceReference(HttpService.class.getName());
        if (sr != null && (service = Activator.getContext().getService(sr)) != null) {
            HttpService http = (HttpService)service;
            try {
                http.unregister("/ServiceManager");
                this.setRegistered(false);
                LogHelper.log("CNT020I", this.getClass(), "dispose");
            }
            catch (Exception e) {
                LogHelper.traceException(e, this.getClass(), "dispose");
            }
        }
    }

    protected boolean isRegistered() {
        return this.registered;
    }

    protected void setRegistered(boolean registered) {
        this.registered = registered;
    }
}

