/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.log;

import com.ibm.log.Level;
import com.ibm.log.PDLogger;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.LogManager;
import com.ibm.log.mgr.PropertyDataStore;
import com.ibm.log.util.MessageCatalog;
import java.io.File;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.aperi.connector.Constants;
import org.eclipse.aperi.connector.log.ConnectorResources;

public class LogHelper {
    private static PDLogger logger = null;
    private static PDLogger tracer = null;
    private static LogManager lm = null;
    private static MessageCatalog msgCat = new MessageCatalog((ResourceBundle)new ConnectorResources());
    public static final Level INFO = Level.INFO;
    public static final Level WARN = Level.WARN;
    public static final Level ERROR = Level.ERROR;
    public static final Level MAX = Level.DEBUG_MAX;
    public static final Level MIN = Level.DEBUG_MIN;
    public static final Level MID = Level.DEBUG_MID;

    public static void log(String id, Class cls, String meth) {
        String s = msgCat.getMessage(id);
        LogHelper.getLogger().text(INFO, (Object)cls, meth, s);
    }

    public static void log(String id, Class cls, String meth, String var) {
        String s = msgCat.getMessage(id, (Object)var);
        LogHelper.getLogger().text(INFO, (Object)cls, meth, s);
    }

    public static void log(String id, Class cls, String meth, String[] vars) {
        String s = msgCat.getMessage(id, (Object[])vars);
        LogHelper.getLogger().text(INFO, (Object)cls, meth, s);
    }

    public static void logException(Exception e, Class cls, String meth) {
        LogHelper.getLogger().exception(ERROR, (Object)cls, meth, (Throwable)e);
    }

    public static void logException(Exception e, Class cls, String meth, String var) {
        LogHelper.getLogger().exception(ERROR, (Object)cls, meth, (Throwable)e, var);
    }

    public static void trace(String text, Class cls, String meth) {
        LogHelper.getTracer().text(MID, (Object)cls, meth, text);
    }

    public static void traceException(Exception e, Class cls, String meth) {
        LogHelper.getTracer().exception(ERROR, (Object)cls, meth, (Throwable)e);
    }

    public static void traceEntry(Class cls, String meth) {
        LogHelper.getTracer().entry(MAX, (Object)cls, meth);
    }

    public static void traceExit(Class cls, String meth) {
        LogHelper.getTracer().exit(MAX, (Object)cls, meth);
    }

    private static PDLogger getLogger() {
        if (logger == null) {
            logger = (PDLogger)LogHelper.getLogManager().getLogger("common.log");
        }
        return logger;
    }

    private static PDLogger getTracer() {
        if (tracer == null) {
            tracer = (PDLogger)LogHelper.getLogManager().getLogger("common.trace");
        }
        return tracer;
    }

    private static LogManager getLogManager() {
        if (lm == null) {
            try {
                InputStream stream = LogHelper.class.getResourceAsStream("/org/eclipse/aperi/connector/log/logging.properties");
                PropertyDataStore store = new PropertyDataStore(stream);
                DataStoreConfig dsc = store.getConfig("file");
                File dir = new File(Constants.LOG_DIR);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                dsc.setProperty("fileDir", Constants.LOG_DIR);
                lm = LogManager.getManagerWithMergedDataStore((DataStore)store, (boolean)false);
            }
            catch (Exception e) {
                e.printStackTrace();
                lm = LogManager.getManager();
            }
        }
        return lm;
    }
}

