/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotService;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SnapshotTakenEvent;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DeviceSnapshotHandler {
    private static ILogger msgLogger = LogConstants.msgLogger;
    private static ILogger traceLogger = LogConstants.traceLogger;
    static final String className = DeviceSnapshotHandler.class.getName();
    private EventCorrelatorFactory monitorService = null;

    public DeviceSnapshotHandler(EventCorrelatorFactory eventMonitor) {
        this.monitorService = eventMonitor;
    }

    public boolean needSnapshot(String deviceType, String deviceId) {
        boolean bool = false;
        String methodName = "needSnapshot";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + deviceId));
        }
        try {
            if (deviceType.equals("switch") || deviceType.equals("subsystem") || deviceType.equals("host")) {
                short devCat = this.determineDevCat(deviceType);
                int devKey = Integer.parseInt(deviceId);
                bool = true;
            }
        }
        catch (Exception ep) {
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "VoteForSnapshot not found device=" + deviceType + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)(bool ? "Yes" : "No"));
        }
        return bool;
    }

    private short determineDevCat(String deviceType) {
        int devCat = -1;
        if (deviceType.equals("switch")) {
            devCat = 2;
        } else if (deviceType.equals("subsystem")) {
            devCat = 1;
        } else if (deviceType.equals("host")) {
            devCat = 3;
        }
        return (short)devCat;
    }

    public void doSnapshot(Vector highLevelDevices) throws Exception {
        Iterator entities;
        String methodName = "doSnapshot";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if ((entities = highLevelDevices.iterator()) == null) {
            throw new Exception("Device collection is empty");
        }
        while (entities.hasNext()) {
            String entityKey;
            int index;
            String entity = (String)entities.next();
            String entityClass = entity.substring(0, index = entity.indexOf(58));
            if (!this.needSnapshot(entityClass, entityKey = entity.substring(index + 1))) continue;
            int rc = -1;
            try {
                int snapshotDevId = Integer.parseInt(entityKey);
                int snapshotDevType = this.determineSnapshotDevType(entityClass);
                rc = SnapshotService.createSnapshot((int)snapshotDevId, (int)snapshotDevType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (rc == 0) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "Snapshot success for " + entity);
                this.monitorService.publish((SRMEvent)new SnapshotTakenEvent(entityClass, entityKey));
                continue;
            }
            traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "Snapshot failed for " + entity);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private int determineSnapshotDevType(String deviceType) {
        int devType = -1;
        if (deviceType.equals("fabric")) {
            devType = 5;
        }
        if (deviceType.equals("subsystem")) {
            devType = 1;
        }
        if (deviceType.equals("switch")) {
            devType = 2;
        }
        if (deviceType.equals("host")) {
            devType = 4;
        }
        if (deviceType.equals("cimom")) {
            devType = 3;
        }
        return devType;
    }
}

