/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.monitor.dataservernotification.Notifier;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceOperationalStatusChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DeviceStateChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.EntityEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.InbandEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.data.NewDeviceEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.NewRelationshipEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.PropertyChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.RelationshipStateChangeEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SNMPTrapEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class EventHandler {
    private static ILogger msgLogger = LogConstants.msgLogger;
    private static ILogger traceLogger = LogConstants.traceLogger;
    static final String className = EventHandler.class.getName();
    private static Notifier notifier = null;
    private static Hashtable errors = new Hashtable();
    private EventCorrelatorFactory monitorService = null;

    public EventHandler(EventCorrelatorFactory eventMonitor) {
        this.monitorService = eventMonitor;
    }

    public static void handleEventAlert(SRMEvent tmpEvent) {
        String methodName = "handleEventAlert";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)tmpEvent.toString());
        }
        int computerId = EventDBAccessor.getComputerId(1);
        try {
            if (tmpEvent instanceof SNMPTrapEvent) {
                String source = ((SNMPTrapEvent)tmpEvent).getSource();
                String eventType = ((SNMPTrapEvent)tmpEvent).getType();
                int alertCondition = 178;
                int resourceId = -1;
                short resourceType = 128;
                int alertId = EventDBAccessor.getAlertIDByCondition(alertCondition);
                if (alertId > 0) {
                    AlertDefinition alertDef = new AlertDefinition();
                    alertDef.aldAlertID = alertId;
                    int[] enterprise = null;
                    int trapType = -1;
                    Hashtable snmpTable = null;
                    String tecClass = null;
                    Hashtable tecTable = null;
                    String msgId = "ALR4100I";
                    Object[] msgValues = new Object[]{source};
                    FabricAlert alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
                    EventHandler.getDataSenderProxy().sendAlert((Alert)alert);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + tmpEvent.getEventName() + " with source= " + eventType + "|" + source + "|" + alertCondition);
                } else {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "AlertId not found for " + tmpEvent.getEventName() + " with device= " + eventType + "|" + source + "|" + alertCondition);
                }
            } else if (tmpEvent instanceof InbandEvent) {
                String source = ((InbandEvent)tmpEvent).getSource();
                String eventType = ((InbandEvent)tmpEvent).getType();
                int alertCondition = 178;
                int resourceId = -1;
                short resourceType = 128;
                int alertId = EventDBAccessor.getAlertIDByCondition(alertCondition);
                if (alertId > 0) {
                    AlertDefinition alertDef = new AlertDefinition();
                    alertDef.aldAlertID = alertId;
                    int[] enterprise = null;
                    int trapType = -1;
                    Hashtable snmpTable = null;
                    String tecClass = null;
                    Hashtable tecTable = null;
                    String msgId = "ALR4101I";
                    Object[] msgValues = new Object[]{source};
                    FabricAlert alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
                    EventHandler.getDataSenderProxy().sendAlert((Alert)alert);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + tmpEvent.getEventName() + " with source= " + eventType + "|" + source + "|" + alertCondition);
                } else {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "AlertId not found for " + tmpEvent.getEventName() + " with device= " + eventType + "|" + source + "|" + alertCondition);
                }
            } else if (tmpEvent instanceof CIMIndicationEvent) {
                String source = ((CIMIndicationEvent)tmpEvent).getSource();
                String eventType = ((CIMIndicationEvent)tmpEvent).getType();
                int alertCondition = 178;
                int resourceId = -1;
                short resourceType = 128;
                int alertId = EventDBAccessor.getAlertIDByCondition(alertCondition);
                if (alertId > 0) {
                    AlertDefinition alertDef = new AlertDefinition();
                    alertDef.aldAlertID = alertId;
                    int[] enterprise = null;
                    int trapType = -1;
                    Hashtable snmpTable = null;
                    String tecClass = null;
                    Hashtable tecTable = null;
                    String msgId = "ALR4102I";
                    Object[] msgValues = new Object[]{source};
                    FabricAlert alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
                    EventHandler.getDataSenderProxy().sendAlert((Alert)alert);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + tmpEvent.getEventName() + " with source= " + eventType + "|" + source + "|" + alertCondition);
                } else {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "AlertId not found for " + tmpEvent.getEventName() + " with device= " + eventType + "|" + source + "|" + alertCondition);
                }
            } else {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "Alert for " + tmpEvent.getEventName() + " not supported");
            }
        }
        catch (Exception ep) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ep);
            }
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "Failed to send alert for " + tmpEvent.getEventName());
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)tmpEvent.toString());
        }
    }

    public void publishEvents(String processId, Vector events) {
        Alert alert;
        String methodName = "publishEvents";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, new Object[]{processId, "allEvents"});
        }
        Iterator eventIt = events.iterator();
        HashMap<String, HashMap> entityAttributeMap = new HashMap<String, HashMap>();
        Vector<EntityEvent> holdEvents = new Vector<EntityEvent>();
        while (eventIt.hasNext()) {
            EntityEvent event = (EntityEvent)eventIt.next();
            String deviceType = event.getType();
            String deviceId = event.getUniqueId();
            try {
                HashMap attributeMap;
                int newState;
                this.monitorService.publish((SRMEvent)event);
                IPopulator alertP = (IPopulator)EventCorrelatorFactory.devAlertPopulators.get(deviceType);
                if (alertP == null) {
                    if (errors.get(deviceType) != null) continue;
                    errors.put(deviceType, new Object());
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "No alert populator found for " + deviceType + deviceId);
                    continue;
                }
                if (event instanceof NewDeviceEvent || event instanceof NewRelationshipEvent) {
                    Alert alert2 = alertP.populateNew(deviceId);
                    if (alert2 == null) continue;
                    EventHandler.getDataSenderProxy().sendAlert(alert2);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + event.getEventName() + " with device= " + deviceType + deviceId);
                    continue;
                }
                if (event instanceof DeviceStateChangeEvent) {
                    int oldState = ((DeviceStateChangeEvent)event).getPreviousState();
                    newState = ((DeviceStateChangeEvent)event).getCurrentState();
                    attributeMap = ((DeviceStateChangeEvent)event).getAttributeMap();
                    if (attributeMap == null || attributeMap.isEmpty()) {
                        alert = alertP.populateStateChange(deviceId, newState, oldState);
                        if (alert == null) continue;
                        EventHandler.getDataSenderProxy().sendAlert(alert);
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + event.getEventName() + " with device= " + deviceType + deviceId);
                        continue;
                    }
                    if (deviceType.equals("datapath")) {
                        alert = alertP.populateStateChange(deviceId, newState, oldState, attributeMap);
                        if (alert == null) continue;
                        EventHandler.getDataSenderProxy().sendAlert(alert);
                        String msg = "Alert sent for " + event.getEventName() + " with device= " + deviceType + deviceId;
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, msg);
                        continue;
                    }
                    entityAttributeMap.put(deviceType + deviceId, attributeMap);
                    holdEvents.add(event);
                    continue;
                }
                if (event instanceof PropertyChangeEvent) {
                    Hashtable newValues = ((PropertyChangeEvent)event).getNewValues();
                    Hashtable oldValues = ((PropertyChangeEvent)event).getOldValues();
                    Enumeration e = newValues.keys();
                    while (e.hasMoreElements()) {
                        String parameterName = (String)e.nextElement();
                        Object newValue = newValues.get(parameterName);
                        Object oldValue = oldValues.get(parameterName);
                        if (newValue == null || oldValue == null) {
                            System.out.println("Error in change detection - " + parameterName + " has null value (new value=" + newValue + ", old value = " + oldValue);
                            continue;
                        }
                        Hashtable singleNewValues = new Hashtable();
                        Hashtable singleOldValues = new Hashtable();
                        singleNewValues.put(parameterName, newValue);
                        singleOldValues.put(parameterName, oldValue);
                        Alert alert3 = null;
                        if (parameterName.equalsIgnoreCase("OPERATIONAL_STATUS")) {
                            if (!(newValue instanceof Integer) || !(oldValue instanceof Integer)) {
                                System.out.println("Error in change detection - status values are NOT integers");
                                continue;
                            }
                            Vector newOpVect = DBConstants.convertOperationalstatusBitValueToArray((int)((Integer)newValue));
                            String newConStatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)newOpVect);
                            Vector oldOpVect = DBConstants.convertOperationalstatusBitValueToArray((int)((Integer)oldValue));
                            String oldConStatus = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)oldOpVect);
                            String newOpStatus = ((Integer)newValue).toString();
                            String oldOpStatus = ((Integer)oldValue).toString();
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Operational Status changed from " + oldOpStatus + " to " + newOpStatus + " for device= " + deviceType + deviceId);
                            if (newConStatus.equals(oldConStatus)) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Consolidate Status " + newConStatus + " not changed for device= " + deviceType + deviceId);
                            } else {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Consolidate Status changed from " + oldConStatus + " to " + newConStatus + " for device= " + deviceType + deviceId);
                                alert3 = alertP.populateOperationalStatusChange(deviceId, Integer.parseInt(oldConStatus), Integer.parseInt(newConStatus));
                            }
                        } else if (parameterName.equalsIgnoreCase("DETECTABLE")) {
                            int newState2 = (Integer)newValue;
                            int oldState = (Integer)oldValue;
                            this.monitorService.publish((SRMEvent)new DeviceStateChangeEvent(deviceType, deviceId, oldState, newState2));
                            alert3 = alertP.populateStateChange(deviceId, newState2, oldState);
                        } else {
                            alert3 = alertP.populatePropertyChange(deviceId, singleOldValues, singleNewValues);
                        }
                        if (alert3 == null) continue;
                        EventHandler.getDataSenderProxy().sendAlert(alert3);
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + event.getEventName() + " with device= " + deviceType + deviceId);
                    }
                    continue;
                }
                if (event instanceof DeviceOperationalStatusChangeEvent) {
                    int newStatus;
                    int oldStatus = ((DeviceOperationalStatusChangeEvent)event).getPreviousStatus();
                    Alert alert4 = alertP.populateOperationalStatusChange(deviceId, oldStatus, newStatus = ((DeviceOperationalStatusChangeEvent)event).getCurrentStatus());
                    if (alert4 == null) continue;
                    EventHandler.getDataSenderProxy().sendAlert(alert4);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + event.getEventName() + " with device= " + deviceType + deviceId);
                    continue;
                }
                if (!(event instanceof RelationshipStateChangeEvent)) continue;
                int oldState = ((RelationshipStateChangeEvent)event).getPreviousState();
                newState = ((RelationshipStateChangeEvent)event).getCurrentState();
                attributeMap = ((RelationshipStateChangeEvent)event).getAttributeMap();
                if (attributeMap == null || attributeMap.isEmpty()) {
                    alert = alertP.populateStateChange(deviceId, newState, oldState);
                    if (alert == null) continue;
                    EventHandler.getDataSenderProxy().sendAlert(alert);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + event.getEventName() + " with device= " + deviceType + deviceId);
                    continue;
                }
                entityAttributeMap.put(deviceType + deviceId, attributeMap);
                holdEvents.add(event);
            }
            catch (AlertCreationException ae) {
                if (!traceLogger.isLogging()) continue;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ae);
            }
            catch (Exception ep) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ep);
                }
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "Failed to send alert for " + event.getEventName() + " with device= " + deviceType + deviceId);
            }
        }
        if (!holdEvents.isEmpty()) {
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "Process hold Events: " + holdEvents);
        }
        Enumeration e = holdEvents.elements();
        while (e.hasMoreElements()) {
            EntityEvent event = (EntityEvent)e.nextElement();
            String deviceType = event.getType();
            String deviceId = event.getUniqueId();
            IPopulator alertP = (IPopulator)EventCorrelatorFactory.devAlertPopulators.get(deviceType);
            if (alertP == null) {
                if (errors.get(deviceType) != null) continue;
                errors.put(deviceType, new Object());
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "No alert populator found for " + deviceType + deviceId);
                continue;
            }
            try {
                int newState;
                if (event instanceof DeviceStateChangeEvent) {
                    int oldState = ((DeviceStateChangeEvent)event).getPreviousState();
                    newState = ((DeviceStateChangeEvent)event).getCurrentState();
                    alert = alertP.populateStateChange(deviceId, newState, oldState, entityAttributeMap);
                    if (alert == null) continue;
                    EventHandler.getDataSenderProxy().sendAlert(alert);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + event.getEventName() + " with device= " + deviceType + deviceId);
                    continue;
                }
                if (!(event instanceof RelationshipStateChangeEvent)) continue;
                int oldState = ((RelationshipStateChangeEvent)event).getPreviousState();
                newState = ((RelationshipStateChangeEvent)event).getCurrentState();
                alert = alertP.populateStateChange(deviceId, newState, oldState, entityAttributeMap);
                if (alert == null) continue;
                EventHandler.getDataSenderProxy().sendAlert(alert);
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + event.getEventName() + " with device= " + deviceType + deviceId);
            }
            catch (AlertCreationException ae) {
                if (!traceLogger.isLogging()) continue;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ae);
            }
            catch (Exception ep) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ep);
                }
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "Failed to send alert for " + event.getEventName() + " with device= " + deviceType + deviceId);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)processId);
        }
    }

    private static Notifier getDataSenderProxy() {
        if (notifier == null) {
            notifier = new Notifier();
        }
        return notifier;
    }

    private static void handleAlert(Alert alert) {
        String methodName = "handleAlert";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)alert.toString());
        }
        try {
            if (alert != null) {
                EventHandler.getDataSenderProxy().sendAlert(alert);
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert sent for " + alert.toString());
            }
        }
        catch (Exception ep) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ep);
            }
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "Failed to send alert for " + alert.toString());
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }
}

