/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class FabricAlertPopulator
implements IPopulator {
    public static final String deviceType = "fabric";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = FabricAlertPopulator.class.getName();

    public FabricAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getFabricData(deviceId, snmpValues, tecValues)) {
            int resourceId = Integer.parseInt(ID);
            short resourceType = 114;
            int alertCondition = 103;
            int alertId = EventDBAccessor.getAlertIDByCondition(alertCondition);
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldType = (short)30;
                alertDef.aldCondition = (short)alertCondition;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 104;
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4046I";
                Object[] msgValues = null;
                msgValues = new Object[]{snmpValues.get("label")};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: fabric" + ID);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: fabric" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getFabricData(deviceId, snmpValues, tecValues)) {
            int resourceId = Integer.parseInt(ID);
            short resourceType = 114;
            int alertCondition = 91;
            int alertResourceId = resourceId;
            short alertResourceType = resourceType;
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
            if (alertId <= 0) {
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
            }
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = (short)alertCondition;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 112;
                }
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = newState == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4047W";
                if (newState == 1) {
                    msgId = "ALR4048I";
                }
                Object[] msgValues = null;
                msgValues = new Object[]{snmpValues.get("label")};
                alert = new FabricAlert(computerId, alertResourceId, alertResourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: fabric" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: fabric" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) throws AlertCreationException {
        String methodName = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getFabricData(deviceId, snmpValues, tecValues)) {
            int resourceId = Integer.parseInt(deviceId);
            short resourceType = 114;
            int alertResourceId = resourceId;
            short alertResourceType = resourceType;
            int alertCondition = newStatus == 0 ? 114 : 113;
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
            if (alertId <= 0) {
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
            }
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = (short)alertCondition;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 116;
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SEOperationalStatusChangeEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = "MINOR";
                this.addCommonTecAttributes(tecTable, severity);
                this.addOperationalStatusData(snmpTable, tecTable, oldStatus, newStatus);
                String msgId = "ALR4049W";
                if (newStatus == 0) {
                    msgId = "ALR4050I";
                }
                Object[] msgValues = null;
                msgValues = new Object[]{snmpValues.get("label")};
                alert = new FabricAlert(computerId, alertResourceId, alertResourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: fabric" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: fabric" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private void addOperationalStatusData(Hashtable snmpTable, Hashtable tecTable, int oldStatus, int newStatus) {
        snmpTable.put(MIBConstants.BTAOldStatus, "" + oldStatus);
        snmpTable.put(MIBConstants.BTANewStatus, "" + newStatus);
        tecTable.put("oldStatus", "" + oldStatus);
        tecTable.put("oldStatus", "" + newStatus);
    }

    private String getSRValue(int index, Hashtable values) {
        if (srVarNames[index].equals("description")) {
            return srVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return srVarNames[index];
        }
        return (String)values.get(srVarNames[index]);
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

