/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class FifoQueue {
    static ILogger msgLogger = LogConstants.msgLogger;
    static ILogger traceLogger = LogConstants.traceLogger;
    static final String className = FifoQueue.class.getName();
    private Vector queue;
    private static int queueSize = 10;
    private static FifoQueue fifoQueue = null;

    private FifoQueue(int queueSize) {
        FifoQueue.queueSize = queueSize;
        this.queue = new Vector(queueSize);
    }

    public static FifoQueue getQueue() {
        return FifoQueue.getQueue(queueSize);
    }

    public static FifoQueue getQueue(int queueSize) {
        String methodName = "getQueue";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + queueSize));
        }
        if (fifoQueue == null) {
            fifoQueue = new FifoQueue(queueSize);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return fifoQueue;
    }

    public void add(Object obj) {
        String methodName = "add";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + obj));
        }
        if (queueSize == this.queue.size()) {
            this.queue.removeElementAt(0);
        }
        this.queue.add(obj);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public boolean contains(Object obj) {
        String methodName = "contains";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + obj));
        }
        boolean out = this.queue.contains(obj);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "In FifoQueue.contains: checking if the object is present in the queue.. Result=\"" + out + "\"");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return out;
    }
}

