/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class HostAlertPopulator
implements IPopulator {
    public static final String deviceType = "host";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = HostAlertPopulator.class.getName();

    public HostAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getHostData(deviceId, snmpValues, tecValues)) {
            int resourceId = Integer.parseInt(ID);
            short resourceType = 1;
            int alertCondition = 31;
            int alertId = EventDBAccessor.getAlertIDByCondition(alertCondition);
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 104;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4041I";
                Object[] msgValues = null;
                String value0 = "" + (String)snmpValues.get("label");
                msgValues = new Object[]{value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined for device: host" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found for device: host" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getHostData(deviceId, snmpValues, tecValues)) {
            int resourceId = Integer.parseInt(deviceId);
            short resourceType = 1;
            short alertCondition = -1;
            int alertId = -1;
            if (newState == 1) {
                alertCondition = 31;
                alertId = EventDBAccessor.getAlertIDByCondition(alertCondition);
            } else {
                alertCondition = 15;
                alertId = this.getAlertId(resourceType, resourceId, alertCondition, deviceId);
            }
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 112;
                }
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = "" + this.getPEValue(i, snmpValues);
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = "" + (String)tecValues.get(peTecSlotNames[i]);
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = newState == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4042W";
                if (newState == 1) {
                    msgId = "ALR4043I";
                }
                Object[] msgValues = null;
                String value0 = "" + (String)snmpValues.get("label");
                msgValues = new Object[]{value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined for device: host" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found for device: host" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) throws AlertCreationException {
        String methodName = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getHostData(deviceId, snmpValues, tecValues)) {
            short alertCondition;
            short resourceType = 1;
            int resourceId = Integer.parseInt(ID);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition = newStatus == 0 ? (short)173 : 172, deviceId);
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 116;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable tecTable = new Hashtable();
                String eventType = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PEOperationalStatusChangeEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    tecTable.put(peTecSlotNames[i], tecValues.get(peTecSlotNames[i]));
                }
                String severity = "MINOR";
                this.addCommonTecAttributes(tecTable, severity);
                this.addOperationalStatusData(snmpTable, tecTable, oldStatus, newStatus);
                String msgId = "ALR4044W";
                if (newStatus == 0) {
                    msgId = "ALR4045I";
                }
                Object[] msgValues = null;
                String value0 = "" + (String)snmpValues.get("label");
                msgValues = new Object[]{value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined for device: host" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found for device: host" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private void addOperationalStatusData(Hashtable snmpTable, Hashtable tecTable, int oldStatus, int newStatus) {
        snmpTable.put(MIBConstants.BTAOldStatus, "" + oldStatus);
        snmpTable.put(MIBConstants.BTANewStatus, "" + newStatus);
        tecTable.put("oldStatus", "" + oldStatus);
        tecTable.put("oldStatus", "" + newStatus);
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private String getPEValue(int index, Hashtable values) {
        if (peVarNames[index].equals("description")) {
            return peVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return peVarNames[index];
        }
        return (String)values.get(peVarNames[index]);
    }

    private int getAlertId(short resourceType, int resourceId, short alertCondition, String deviceId) {
        int alertId = -1;
        alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
        if (alertId <= 0) {
            String fabricId = EventDBAccessor.getFabricIdForHost(deviceId);
            if (fabricId != null && !fabricId.equals("")) {
                alertId = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(fabricId), alertCondition);
            }
            if (alertId <= 0) {
                alertId = EventDBAccessor.getAlertIDByResource(resourceType, -1, alertCondition);
            }
        }
        return alertId;
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

