/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class NodeAlertPopulator
implements IPopulator {
    public static final String deviceType = "node";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = NodeAlertPopulator.class.getName();

    public NodeAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getNodeData(deviceId, snmpValues, tecValues)) {
            String hldType = ((String)snmpValues.get("HLDType")).trim();
            String hldId = ((String)snmpValues.get("HLDUniqueId")).trim();
            String eventType = "TPC_NEW_DEVICE_EVENT";
            short alertCondition = this.determineAlertCondition(hldType, eventType);
            int resourceId = this.determineResourceId(deviceId, hldId);
            short resourceType = this.determineResourceType(hldType);
            int alertId = -1;
            alertId = alertCondition == 106 ? EventDBAccessor.getAlertIDByCondition(alertCondition) : this.getAlertId(resourceType, resourceId, alertCondition, deviceId);
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = alertCondition;
                if (this.isSvcNode(hldType)) {
                    alertDef.aldProductID = (short)3;
                    alertDef.aldType = (short)20;
                }
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 104;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "msgid";
                Object[] msgValues = null;
                if (hldType.equals(deviceType) || hldType.equals("")) {
                    msgId = "ALR4000I";
                    String value0 = (String)snmpValues.get("label");
                    if (value0 == null) {
                        value0 = "";
                    }
                    msgValues = new Object[]{value0};
                } else {
                    String value2;
                    String value1;
                    msgId = "ALR4005I";
                    String value0 = (String)snmpValues.get("HLDType");
                    if (value0 == null) {
                        value0 = "";
                    }
                    if ((value1 = (String)snmpValues.get("HLDLabel")) == null) {
                        value1 = "";
                    }
                    if ((value2 = (String)snmpValues.get("label")) == null) {
                        value2 = "";
                    }
                    msgValues = new Object[]{value0, value1, value2};
                }
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: node" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: node" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getNodeData(deviceId, snmpValues, tecValues)) {
            String hldType = ((String)snmpValues.get("HLDType")).trim();
            String hldId = ((String)snmpValues.get("HLDUniqueId")).trim();
            String eventType = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short alertCondition = this.determineAlertCondition(hldType, eventType);
            int resourceId = this.determineResourceId(deviceId, hldId);
            short resourceType = this.determineResourceType(hldType);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition, deviceId);
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = alertCondition;
                if (this.isSvcNode(hldType)) {
                    alertDef.aldProductID = (short)3;
                    alertDef.aldType = (short)20;
                }
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 112;
                }
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType1 = newState == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                snmpValues.put("eventType", eventType1);
                tecValues.put("eventType", eventType1);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = newState == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "msgid";
                Object[] msgValues = null;
                if (hldType.equals(deviceType) || hldType.equals("")) {
                    String value0;
                    msgId = "ALR4001W";
                    if (newState == 1) {
                        msgId = "ALR4002I";
                    }
                    if ((value0 = (String)snmpValues.get("label")) == null) {
                        value0 = "";
                    }
                    msgValues = new Object[]{value0};
                } else {
                    String value2;
                    String value1;
                    String value0;
                    msgId = "ALR4006W";
                    if (newState == 1) {
                        msgId = "ALR4007I";
                    }
                    if ((value0 = (String)snmpValues.get("HLDType")) == null) {
                        value0 = "";
                    }
                    if ((value1 = (String)snmpValues.get("HLDLabel")) == null) {
                        value1 = "";
                    }
                    if ((value2 = (String)snmpValues.get("label")) == null) {
                        value2 = "";
                    }
                    msgValues = new Object[]{value0, value1, value2};
                }
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: node" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: node" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) throws AlertCreationException {
        String methodName = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getNodeData(deviceId, snmpValues, tecValues)) {
            String hldType = ((String)snmpValues.get("HLDType")).trim();
            String hldId = ((String)snmpValues.get("HLDUniqueId")).trim();
            String eventType = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
            int resourceId = this.determineResourceId(deviceId, hldId);
            short resourceType = this.determineResourceType(hldType);
            short alertCondition = -1;
            alertCondition = resourceType == 78 ? (newStatus == 0 ? (short)138 : 137) : (newStatus == 0 ? (short)134 : 133);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition, deviceId);
            if (alertId > 0) {
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = alertCondition;
                if (this.isSvcNode(hldType)) {
                    alertDef.aldProductID = (short)3;
                    alertDef.aldType = (short)20;
                }
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 116;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PEOperationalStatusChangeEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "MINOR";
                this.addCommonTecAttributes(tecTable, severity);
                this.addOperationalStatusData(snmpTable, tecTable, oldStatus, newStatus);
                String msgId = null;
                Object[] msgValues = null;
                if (hldType.equals(deviceType) || hldType.equals("")) {
                    String value0;
                    msgId = "ALR4003W";
                    if (newStatus == 0) {
                        msgId = "ALR4004I";
                    }
                    if ((value0 = (String)snmpValues.get("label")) == null) {
                        value0 = "";
                    }
                    msgValues = new Object[]{value0};
                } else {
                    String value2;
                    String value1;
                    String value0;
                    msgId = "ALR4008W";
                    if (newStatus == 0) {
                        msgId = "ALR4009I";
                    }
                    if ((value0 = (String)snmpValues.get("HLDType")) == null) {
                        value0 = "";
                    }
                    if ((value1 = (String)snmpValues.get("HLDLabel")) == null) {
                        value1 = "";
                    }
                    if ((value2 = (String)snmpValues.get("label")) == null) {
                        value2 = "";
                    }
                    msgValues = new Object[]{value0, value1, value2};
                }
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: node" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: node" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private void addOperationalStatusData(Hashtable snmpTable, Hashtable tecTable, int oldStatus, int newStatus) {
        snmpTable.put(MIBConstants.BTAOldStatus, "" + oldStatus);
        snmpTable.put(MIBConstants.BTANewStatus, "" + newStatus);
        tecTable.put("oldStatus", "" + oldStatus);
        tecTable.put("oldStatus", "" + newStatus);
    }

    private short determineAlertCondition(String hldType, String eventType) {
        int condition = -1;
        if (hldType.equals(deviceType)) {
            if (eventType.equals("TPC_NEW_DEVICE_EVENT")) {
                condition = 106;
            } else if (eventType.equals("TPC_DEVICE_STATE_CHANGE_EVENT")) {
                condition = 101;
            } else if (eventType.equals("TPC_PROPERTY_CHANGE_EVENT")) {
                condition = 102;
            }
        } else if (hldType.equals("pe")) {
            condition = 102;
        } else if (hldType.equals("host")) {
            condition = 174;
        } else if (hldType.equals("subsystem")) {
            if (eventType.equals("TPC_NEW_DEVICE_EVENT")) {
                condition = 136;
            } else if (eventType.equals("TPC_DEVICE_STATE_CHANGE_EVENT")) {
                condition = 135;
            } else if (eventType.equals("TPC_PROPERTY_CHANGE_EVENT")) {
                condition = 123;
            }
        }
        return (short)condition;
    }

    private short determineResourceType(String hldType) {
        int type = 138;
        if (hldType.equals("subsystem")) {
            type = 78;
        } else if (hldType.equals("host")) {
            type = 1;
        } else if (hldType.equals("pe")) {
            type = 139;
        }
        return (short)type;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private int determineResourceId(String deviceId, String hldId) {
        int resourceId = -1;
        resourceId = hldId == null || hldId.equals("") ? Integer.parseInt(deviceId) : Integer.parseInt(hldId);
        return resourceId;
    }

    private String getPEValue(int index, Hashtable values) {
        if (peVarNames[index].equals("description")) {
            return peVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return peVarNames[index];
        }
        return (String)values.get(peVarNames[index]);
    }

    private int getAlertId(short resourceType, int resourceId, short alertCondition, String deviceId) {
        int alertId = -1;
        alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
        if (alertId <= 0) {
            String fabricId = EventDBAccessor.getFabricIdForNode(deviceId);
            if (fabricId != null && !fabricId.equals("")) {
                alertId = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(fabricId), alertCondition);
            }
            if (alertId <= 0) {
                alertId = resourceType == 138 ? EventDBAccessor.getAlertIDByResource((short)129, -1, alertCondition) : EventDBAccessor.getAlertIDByResource(resourceType, -1, alertCondition);
            }
        }
        return alertId;
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    private boolean isSvcNode(String hldType) {
        String methodName = "isSvcNode";
        boolean bool = false;
        if (hldType.equals("subsystem")) {
            bool = true;
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "Alert for SVC Node processed.");
            }
        }
        return bool;
    }
}

