/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Port2PortAlertPopulator
implements IPopulator {
    public static final String deviceType = "port2port";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = Port2PortAlertPopulator.class.getName();

    public Port2PortAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPort2PortData(deviceId, snmpValues, tecValues)) {
            int resourceId = this.getResourceId(deviceId, snmpValues);
            short resourceType = 114;
            int alertCondition = 93;
            int alertResourceId = resourceId;
            short alertResourceType = resourceType;
            int alertId = EventDBAccessor.getAlertIDByCondition(alertCondition);
            if (alertId <= 0) {
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
            }
            if (alertId > 0) {
                String value5;
                String value4;
                String value3;
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 106;
                int[] enterprise = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] varBindOIDs = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_RELATIONSHIP_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalRelationshipEvent";
                for (int i = 0; i < prTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(prTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(prTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4063I";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("fromObjectHLDType");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("fromObjectHLDLabel")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("fromPortPhysicalNumber")) == null || value2.equals("")) {
                    value2 = (String)snmpValues.get("fromObjectName");
                }
                if ((value3 = (String)snmpValues.get("toObjectHLDType")) == null) {
                    value3 = "";
                }
                if ((value4 = (String)snmpValues.get("toObjectHLDLabel")) == null) {
                    value4 = "";
                }
                if ((value5 = (String)snmpValues.get("toPortPhysicalNumber")) == null || value5.equals("")) {
                    value5 = (String)snmpValues.get("toObjectName");
                }
                msgValues = new Object[]{value0, value1, value2, value3, value4, value5};
                alert = new FabricAlert(computerId, alertResourceId, alertResourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "FabricAlert:No AlertDefinition defined for device: port2port" + deviceId);
            }
        } else {
            throw new AlertCreationException("FabricAlert:No data found for device: port2port" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPort2PortData(deviceId, snmpValues, tecValues)) {
            int resourceId = this.getResourceId(deviceId, snmpValues);
            short resourceType = 114;
            int alertCondition = 94;
            int alertResourceId = resourceId;
            short alertResourceType = resourceType;
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
            if (alertId <= 0) {
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
            }
            if (alertId > 0) {
                String value5;
                String value4;
                String value3;
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 103;
                if (newState == 1) {
                    trapType = 114;
                }
                int[] enterprise = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] varBindOIDs = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 1 ? "TPC_NORMAL_RELATIONSHIP_EVENT" : "TPC_MISSING_RELATIONSHIP_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = "" + this.getPRValue(i, snmpValues);
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalRelationshipEvent";
                for (int i = 0; i < prTecSlotNames.length; ++i) {
                    String value = "" + (String)tecValues.get(prTecSlotNames[i]);
                    tecTable.put(prTecSlotNames[i], value);
                }
                String severity = newState == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4064W";
                if (newState == 1) {
                    msgId = "ALR4065I";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("fromObjectHLDType");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("fromObjectHLDLabel")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("fromPortPhysicalNumber")) == null || value2.equals("")) {
                    value2 = (String)snmpValues.get("fromObjectName");
                }
                if ((value3 = (String)snmpValues.get("toObjectHLDType")) == null) {
                    value3 = "";
                }
                if ((value4 = (String)snmpValues.get("toObjectHLDLabel")) == null) {
                    value4 = "";
                }
                if ((value5 = (String)snmpValues.get("toPortPhysicalNumber")) == null || value5.equals("")) {
                    value5 = (String)snmpValues.get("toObjectName");
                }
                msgValues = new Object[]{value0, value1, value2, value3, value4, value5};
                alert = new FabricAlert(computerId, alertResourceId, alertResourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "FabricAlert:No AlertDefinition defined for device: port2port" + deviceId);
            }
        } else {
            throw new AlertCreationException("FabricAlert:No data found for device: port2port" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) throws AlertCreationException {
        String methodName = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPort2PortData(deviceId, snmpValues, tecValues)) {
            int resourceId = this.getResourceId(deviceId, snmpValues);
            short resourceType = 114;
            int alertResourceId = resourceId;
            short alertResourceType = resourceType;
            int alertCondition = newStatus == 0 ? 115 : 116;
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
            if (alertId <= 0) {
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
            }
            if (alertId > 0) {
                String value5;
                String value4;
                String value3;
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 103;
                if (newStatus == 0) {
                    trapType = 114;
                }
                int[] enterprise = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] varBindOIDs = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newStatus == 0 ? "TPC_NORMAL_RELATIONSHIP_EVENT" : "TPC_MISSING_RELATIONSHIP_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = "" + this.getPRValue(i, snmpValues);
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalRelationshipEvent";
                for (int i = 0; i < prTecSlotNames.length; ++i) {
                    String value = "" + (String)tecValues.get(prTecSlotNames[i]);
                    tecTable.put(prTecSlotNames[i], value);
                }
                String severity = newStatus == 0 ? "CRITICAL" : "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                this.addOperationalStatusData(snmpTable, tecTable, oldStatus, newStatus);
                String msgId = "ALR4087W";
                if (newStatus == 0) {
                    msgId = "ALR4088I";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("fromObjectHLDType");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("fromObjectHLDLabel")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("fromPortPhysicalNumber")) == null || value2.equals("")) {
                    value2 = (String)snmpValues.get("fromObjectName");
                }
                if ((value3 = (String)snmpValues.get("toObjectHLDType")) == null) {
                    value3 = "";
                }
                if ((value4 = (String)snmpValues.get("toObjectHLDLabel")) == null) {
                    value4 = "";
                }
                if ((value5 = (String)snmpValues.get("toPortPhysicalNumber")) == null || value5.equals("")) {
                    value5 = (String)snmpValues.get("toObjectName");
                }
                msgValues = new Object[]{value0, value1, value2, value3, value4, value5};
                alert = new FabricAlert(computerId, alertResourceId, alertResourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "FabricAlert:No AlertDefinition defined for device: port2port" + deviceId);
            }
        } else {
            throw new AlertCreationException("FabricAlert:No data found for device: port2port" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private void addOperationalStatusData(Hashtable snmpTable, Hashtable tecTable, int oldStatus, int newStatus) {
        snmpTable.put(MIBConstants.BTAOldStatus, "" + oldStatus);
        snmpTable.put(MIBConstants.BTANewStatus, "" + newStatus);
        tecTable.put("oldStatus", "" + oldStatus);
        tecTable.put("oldStatus", "" + newStatus);
    }

    private int getResourceId(String deviceId, Hashtable values) {
        int resourceId = -1;
        String tmpId = "" + (String)values.get("fabricId");
        resourceId = tmpId.equals("") ? Integer.parseInt(deviceId) : Integer.parseInt(tmpId);
        return resourceId;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private String getPRValue(int index, Hashtable values) {
        if (prVarNames[index].equals("description")) {
            return prVarNames[index];
        }
        if (prVarNames[index].equals("messageId")) {
            return prVarNames[index];
        }
        return (String)values.get(prVarNames[index]);
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

