/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Switch2PortAlertPopulator
implements IPopulator {
    public static final String deviceType = "switch2port";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = Switch2PortAlertPopulator.class.getName();

    public Switch2PortAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getSwitch2PortData(deviceId, snmpValues, tecValues)) {
            int alertCondition;
            short resourceType = 121;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 127);
            if (alertId <= 0) {
                String switchId = (String)snmpValues.get("switchId");
                String fabricID = EventDBAccessor.getFabricIDFromSwitch(switchId);
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                tmpResourceId = fabricID == null || fabricID.equals("") ? -1 : Integer.parseInt(fabricID);
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                if (alertId <= 0) {
                    tmpResourceId = -1;
                    tmpResourceType = 121;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
            }
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 106;
                int[] enterprise = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] varBindOIDs = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_RELATIONSHIP_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalRelationshipEvent";
                for (int i = 0; i < prTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(prTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(prTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4069I";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("fromObjectHLDLabel");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("portPhysicalNumber")) == null || value1.equals("")) {
                    value1 = (String)snmpValues.get("toObjectName");
                }
                msgValues = new Object[]{value1, value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: switch2port" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: switch2port" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getSwitch2PortData(deviceId, snmpValues, tecValues)) {
            int alertCondition;
            short resourceType = 121;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 127);
            if (alertId <= 0) {
                String switchId = (String)snmpValues.get("switchId");
                String fabricID = EventDBAccessor.getFabricIDFromSwitch(switchId);
                int tmpResourceId = -1;
                short tmpResourceType = 114;
                tmpResourceId = fabricID == null || fabricID.equals("") ? -1 : Integer.parseInt(fabricID);
                alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                if (alertId <= 0) {
                    tmpResourceId = -1;
                    tmpResourceType = 121;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
            }
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 103;
                if (newState == 1) {
                    trapType = 114;
                }
                int[] enterprise = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] varBindOIDs = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 1 ? "TPC_NORMAL_RELATIONSHIP_EVENT" : "TPC_MISSING_RELATIONSHIP_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalRelationshipEvent";
                for (int i = 0; i < prTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(prTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(prTecSlotNames[i], value);
                }
                String severity = newState == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4070W";
                if (newState == 1) {
                    msgId = "ALR4071I";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("fromObjectHLDLabel");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("portPhysicalNumber")) == null || value1.equals("")) {
                    value1 = (String)snmpValues.get("toObjectName");
                }
                msgValues = new Object[]{value1, value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: switch2port" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: switch2port" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) {
        Alert tmpAlert = null;
        return tmpAlert;
    }

    private int getResourceId(String deviceId, Hashtable values) {
        int resourceId = -1;
        String tmpId = "" + (String)values.get("switchId");
        resourceId = tmpId.equals("") ? Integer.parseInt(deviceId) : Integer.parseInt(tmpId);
        return resourceId;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private String getPRValue(int index, Hashtable values) {
        if (prVarNames[index].equals("description")) {
            return prVarNames[index];
        }
        if (prVarNames[index].equals("messageId")) {
            return prVarNames[index];
        }
        return (String)values.get(prVarNames[index]);
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

