/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.interfaces;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventXMLParser;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.DataManager;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.ExtractEventFailedException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.InvalidParameterException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartAction;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartEvent;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.Source;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SnmpSanEventExtractor {
    static ILogger msgLogger = LogConstants.msgLogger;
    static ILogger traceLogger = LogConstants.traceLogger;
    static final String className = SnmpSanEventExtractor.class.getName();

    public SmartEvent[] extractEvent(DataManager dataManager, String xmlEvent) throws ExtractEventFailedException {
        String methodName = "extractEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + dataManager + " and " + xmlEvent));
        }
        SmartEvent smartEvent = null;
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "In SnmpSanEventExtractor.extractEvent Parsing Data from xml");
        }
        XMLReader xmlReader = null;
        String xEventType = null;
        String xTimeStamp = null;
        String xSourceName = null;
        String xSourceAddress = null;
        String xSourceSpecific = null;
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(true);
            SAXParser saxParser = spfactory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
            EventXMLParser ep = new EventXMLParser();
            xmlReader.setContentHandler(ep);
            xmlReader.setErrorHandler(ep);
            xmlReader.parse(new InputSource(new StringReader(xmlEvent)));
            xEventType = ep.getEventIds()[0];
            xTimeStamp = ep.getTimeStamps()[0];
            xSourceName = ep.getSourceNames()[0];
            xSourceAddress = ep.getSourceAddresses()[0];
            xSourceSpecific = ep.getSourceSpecifics()[0];
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "In SnmpSanEventExtractor.extractEvent Parsing Data from xml-done");
            }
        }
        catch (Exception e) {
            try {
                SmartEvent event = new SmartEvent("name", "address", "Specific Info", "ActionTarget", 0, "ActionDescription", 0, 0, "description", Calendar.getInstance());
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return new SmartEvent[]{event};
            }
            catch (Exception ee) {
                throw new ExtractEventFailedException();
            }
        }
        String queryKeyTag = xEventType + "." + "Snmp";
        String eventTypeStr = dataManager.getData(queryKeyTag + ".SmartEvent.EventType");
        int eventType = Integer.parseInt(eventTypeStr);
        String eventPriorityStr = dataManager.getData(queryKeyTag + ".SmartEvent.Priority");
        int eventPriority = Integer.parseInt(eventPriorityStr);
        String eventDescription = dataManager.getData(queryKeyTag + ".SmartEvent.Description");
        String eventActionTarget = dataManager.getData(queryKeyTag + ".SmartEvent.SmartAction.Target");
        String eventActionTypeStr = dataManager.getData(queryKeyTag + ".SmartEvent.SmartAction.ActionType");
        int eventActionType = Integer.parseInt(eventActionTypeStr);
        String eventActionDescription = dataManager.getData(queryKeyTag + ".SmartEvent.SmartAction.ActionDescription");
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "In SnmpSanEventExtractor.extractEvent Dot the descriptions");
        }
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
            date = sdf.parse(xTimeStamp);
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            throw new ExtractEventFailedException();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "In SnmpSanEventExtractor.extractEvent Created the calendar");
        }
        try {
            Source source = new Source(xSourceName, xSourceAddress, xSourceSpecific);
            SmartAction smartAction = new SmartAction(eventActionTarget, eventActionType, eventActionDescription);
            smartEvent = new SmartEvent(source, smartAction, eventType, eventPriority, eventDescription, calendar);
        }
        catch (InvalidParameterException ipe) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ipe);
            }
            throw new ExtractEventFailedException();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return new SmartEvent[]{smartEvent};
    }
}

