/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.Agent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.IAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;

class ActiveAgentListImpl {
    static final String className = ActiveAgentListImpl.class.getName();

    ActiveAgentListImpl() {
    }

    static Agent[] getActiveHostList() throws TdmException {
        String methodName = "getActiveHostList";
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getActiveHostList");
        }
        Agent[] activeHostList = new Agent[]{};
        AgentTableReader tableAccess = null;
        try {
            tableAccess = SANDiskMgrHostService.getHostTableReader();
            activeHostList = ActiveAgentListImpl.getActiveHostList(tableAccess);
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getActiveHostList", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getActiveHostList", (Throwable)e);
            }
            throw new SqlException(e);
        }
        catch (InterruptedException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getActiveHostList", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getActiveHostList", (Throwable)e);
            }
            throw new DatabaseConnectException(e);
        }
        finally {
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getActiveHostList");
        }
        return activeHostList;
    }

    static Agent[] getActiveHostList(AgentTableReader tableAccess) throws SQLException, TdmException {
        String methodName = "getActiveHostList";
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getActiveHostList");
        }
        DeviceAgent.DeviceAgentCursor hostResults = tableAccess.listActiveHosts();
        Vector<AgentBuilder> v = new Vector<AgentBuilder>();
        while (hostResults.next()) {
            v.addElement(new AgentBuilder(hostResults, tableAccess));
        }
        hostResults.close();
        hostResults = null;
        Agent[] activeHostList = new Agent[v.size()];
        for (int i = 0; i < activeHostList.length; ++i) {
            activeHostList[i] = new Agent((IAgentBuilder)v.elementAt(i));
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getActiveHostList");
        }
        return activeHostList;
    }
}

