/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableUpdater;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.HostManager;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogWrapper;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.PeerDataException;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.subagent.common.HostQueryInfo;

class AgentRegistrationListener {
    static final String className = AgentRegistrationListener.class.getName();
    private Map hostMap = null;
    private LogWrapper messages = SANDiskMgrHostService.messages;
    private LogWrapper trace = SANDiskMgrHostService.trace;

    AgentRegistrationListener(Map hostMap) {
        this.hostMap = hostMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void agentRegistrationHeartbeat(HostQueryInfo hostinfo) {
        String methodName = "agentRegistrationHeartbeat";
        AgentTableReader tableAccess = null;
        if (this.trace.isLogging()) {
            this.trace.entry((Object)this, "agentRegistrationHeartbeat");
        }
        String hostName = hostinfo.hostName;
        if (this.trace.isLogging()) {
            String msg = hostName + " " + hostinfo.getUniqueAgentName() + ":  Got agent registration!  ";
            this.trace.text(IRecordType.TYPE_INFORMATION, (Object)className, "agentRegistrationHeartbeat", msg);
        }
        try {
            TdmAgent host = null;
            host = (TdmAgent)this.hostMap.get(hostinfo.getUniqueAgentName());
            if (host != null) {
                boolean hostinfo_change = false;
                boolean status_change = false;
                Integer hostinfo_port = new Integer(hostinfo.hostPort);
                if (!(host.agentName.equals(hostinfo.hostName) && host.osname.equals(hostinfo.osName) && host.ipAddress.equals(hostinfo.hostIP) && this.versionsMatch(host.version, hostinfo.hostVersion))) {
                    hostinfo_change = true;
                    String msg = host.getNameGuidPort() + ":  Host information changed!";
                    this.trace.text(IRecordType.TYPE_INFORMATION, (Object)className, "agentRegistrationHeartbeat", msg);
                }
                if (host.status.equals("IA")) {
                    status_change = true;
                }
                if (hostinfo_change || status_change) {
                    tableAccess = SANDiskMgrHostService.getHostTableUpdater();
                    if (hostinfo_change) {
                        int r;
                        TdmAgent host_new = HostManager.bldTdmHostObject(hostinfo);
                        host_new.index = host.index;
                        String testmsg = "index: " + host_new.index + " " + host_new.getUniqueAgentName() + " " + host_new.toString();
                        this.trace.text(IRecordType.TYPE_INFORMATION, (Object)className, "agentRegistrationHeartbeat", testmsg);
                        if (this.hostMap.remove(host.getUniqueAgentName()) == null) {
                            String msg = host.getNameGuidPort() + ":  Host could not be removed from map!";
                            this.trace.text(IRecordType.TYPE_WARN, (Object)className, "agentRegistrationHeartbeat", msg);
                        }
                        if ((r = ((AgentTableUpdater)tableAccess).updateHost(host_new, true)) <= 0) {
                            host = null;
                        } else {
                            this.hostMap.put(host_new.getUniqueAgentName(), host_new);
                        }
                    }
                    if (status_change && host != null) {
                        host.status_lstchanged = new Date();
                        host.status = "AC";
                        Timestamp ts = new Timestamp(host.status_lstchanged.getTime());
                        int r = ((AgentTableUpdater)tableAccess).updateStatus(host.guid, host.agentPort, ts, host.status);
                        if (r <= 0) {
                            this.hostMap.remove(host.getUniqueAgentName());
                            host = null;
                        }
                    }
                    if (host != null) {
                        HostManager.fireDiskMgrHostEvent(host.guid, host.agentPort, "AC");
                        this.messages.message(IRecordType.TYPE_WARN, (Object)this, "agentRegistrationHeartbeat", "Agent_active", (Object)(hostinfo.hostName + ":" + hostinfo.hostPort));
                    }
                } else {
                    host.status_lstchanged = new Date();
                    host.status = "AC";
                }
            }
            if (host == null) {
                if (this.trace.isLogging()) {
                    this.trace.text(IRecordType.TYPE_INFORMATION, (Object)className, "agentRegistrationHeartbeat", hostinfo.getUniqueAgentName() + hostinfo.hostName + " NEW host");
                }
                tableAccess = SANDiskMgrHostService.getHostTableUpdater();
                TdmAgent h1 = HostManager.bldTdmHostObject(hostinfo);
                h1.status = "AC";
                this.hostMap.put(h1.getUniqueAgentName(), h1);
                String evtstatus = HostManager.addTdmHost((AgentTableUpdater)tableAccess, h1);
                HostManager.fireDiskMgrHostEvent(h1.guid, h1.agentPort, "AC");
                this.messages.message(IRecordType.TYPE_WARN, (Object)this, "agentRegistrationHeartbeat", "Agent_active", (Object)h1.toAgentString());
            }
        }
        catch (PeerDataException e1) {
            this.messages.exception((Object)this, "agentRegistrationHeartbeat", (Throwable)((Object)e1));
            if (this.trace.isLogging()) {
                this.trace.exception((Object)this, "agentRegistrationHeartbeat", (Throwable)((Object)e1));
            }
        }
        catch (Exception e2) {
            this.messages.exception((Object)this, "agentRegistrationHeartbeat", (Throwable)e2);
            if (this.trace.isLogging()) {
                this.trace.exception((Object)this, "agentRegistrationHeartbeat", (Throwable)e2);
            }
        }
        finally {
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (this.trace.isLogging()) {
            this.trace.exit((Object)this, "agentRegistrationHeartbeat");
        }
    }

    private boolean versionsMatch(String version1, String version2) {
        boolean match = false;
        if (version1 == null && version2 == null) {
            match = true;
        }
        if (version1 != null && version2 != null && version1.equals(version2)) {
            match = true;
        }
        return match;
    }
}

