/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExternalEvent;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.indications.CIMEvent;

public class CIMIndicationEvent
extends ExternalEvent {
    private transient CIMEvent cCimEvent = null;
    private transient CIMOM cCimom = null;
    private transient CIMClientWrapper cCimClient = null;

    public CIMIndicationEvent() {
        this.eventName = "TPC_CIM_INDICATION_EVENT";
    }

    public CIMIndicationEvent(String tmpSource, String tmpType, CIMEvent cimEvent) {
        super(tmpSource, tmpType);
        this.eventName = "TPC_CIM_INDICATION_EVENT";
        this.cCimEvent = cimEvent;
    }

    public CIMInstance getCIMInstance() {
        return this.cCimEvent.getIndication();
    }

    public CIMEvent getCIMEvent() {
        return this.cCimEvent;
    }

    public CIMObjectPath getSourceCop() {
        try {
            CIMInstance mInstance = this.getCIMInstance();
            String mSourceCopString = (String)mInstance.getProperty("SourceInstance").getValue().getValue();
            return CIMIndicationEvent.parse(mSourceCopString);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance getSourceInstance() throws CIMException, DiskManagerTimeoutException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getSourceInstance", null);
        CIMInstance mResult = null;
        try {
            CIMObjectPath mSourceCop = this.getSourceCop();
            mSourceCop.setNameSpace(this.getCIMNameSpace());
            mResult = this.getCIMClient().getInstance(mSourceCop, false, true, mLTH);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        mLTH.exit((Object)mResult);
        return mResult;
    }

    public String getCIMNameSpace() {
        String mNameSpace = null;
        CIMObjectPath mSourceCop = this.getSourceCop();
        if (mSourceCop != null) {
            mNameSpace = mSourceCop.getNameSpace();
        }
        if (mNameSpace == null || mNameSpace.trim().length() == 0) {
            mNameSpace = this.getCIMInstance().getObjectPath().getNameSpace();
        }
        if (mNameSpace == null || mNameSpace.trim().length() == 0) {
            mNameSpace = this.getCIMOM().getInteropSchemaNamespace();
        }
        return mNameSpace;
    }

    public CIMOM getCIMOM() {
        if (this.cCimom == null) {
            if (this.cCimEvent.getID() != null && this.cCimEvent.getID().trim().length() > 0) {
                try {
                    this.cCimom = CIMOMManager.getCIMOMManager().getCIMMOMByDBKey(Integer.parseInt(this.cCimEvent.getID()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.cCimom == null) {
                CIMOM[] mCimoms = CIMOMManager.getCIMOMManager().findCIMOMsByNetAddress(this.cCimEvent.getInetAddress());
                if (mCimoms.length == 1) {
                    this.cCimom = mCimoms[0];
                } else if (mCimoms.length > 1) {
                    throw CimomNotIdentifyable.createAmbiguous(mCimoms.length);
                }
            }
            if (this.cCimom == null) {
                throw CimomNotIdentifyable.createNothing();
            }
        }
        return this.cCimom;
    }

    public CIMClientWrapper getCIMClient() {
        if (this.cCimClient == null) {
            CIMOM mCimom = this.getCIMOM();
            String mNameSpace = this.getCIMNameSpace();
            this.cCimClient = CIMClientPool.getClient((String)mCimom.getUserId(), (String)mCimom.getPassword(), (String)mCimom.getServiceUrl(), (String)mNameSpace);
        }
        return this.cCimClient;
    }

    public void close() {
        if (this.cCimClient != null) {
            CIMClientPool.returnClient((CIMClientWrapper)this.cCimClient);
            this.cCimClient = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static CIMObjectPath parse(String instanceName) throws CIMException {
        int i;
        char[] values = instanceName.toCharArray();
        int keystart = 0;
        Vector<CIMProperty> tmpkeys = new Vector<CIMProperty>();
        boolean singleKey = true;
        boolean inquote = false;
        boolean nstype = true;
        boolean nshdl = false;
        int classNamePos = 0;
        String nameSpaceType = null;
        String nameSpaceHdl = null;
        singleKey = false;
        for (i = 0; i < values.length && (values[i] != '.' || nshdl); ++i) {
            if (values[i] != ':') continue;
            if (nstype) {
                nameSpaceType = new String(values, 0, i);
                classNamePos = i + 1;
                nstype = false;
                nshdl = true;
                continue;
            }
            nameSpaceHdl = new String(values, classNamePos, i - classNamePos);
            classNamePos = i + 1;
            nshdl = false;
        }
        if (i == values.length) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + instanceName + "\" did not have a '.' as a class delimeter"));
        }
        if (!nstype && nshdl) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + instanceName + "\" did not have a namespace handle"));
        }
        if (nameSpaceType != null && !nameSpaceType.equalsIgnoreCase("HTTP")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + instanceName + "\" does not represent a HTTP namespace"));
        }
        String className = new String(values, classNamePos, i - classNamePos);
        int equalspos = 0;
        keystart = ++i;
        while (i < values.length) {
            char ch = values[i];
            if (i < values.length - 1 && ch == '\\') {
                if (values[i + 1] != '\"') {
                    ++i;
                }
            } else {
                if (ch == '\"') {
                    boolean bl = inquote = !inquote;
                }
                if (!inquote) {
                    if (ch == '=') {
                        equalspos = i + 1;
                    }
                    if (ch == ',' || i + 1 == values.length) {
                        String keyvalue;
                        if (i + 1 == values.length && equalspos == 0 && singleKey) {
                            CIMProperty cp = new CIMProperty();
                            cp.setName("test it");
                            keyvalue = values[keystart] != '\"' ? new String(values, keystart, i - keystart + 1) : new String(values, keystart + 1, i - keystart + 1 - 2);
                            cp.setValue(new CIMValue((Object)keyvalue, CIMDataType.getPredefinedType((int)8)));
                            cp.setType(CIMDataType.getPredefinedType((int)8));
                            tmpkeys.addElement(cp);
                            break;
                        }
                        if (i + 1 == values.length) {
                            ++i;
                        }
                        if (equalspos == 0) {
                            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)("Bad key in string (" + instanceName + ")"));
                        }
                        String keyprop = new String(values, keystart, equalspos - keystart - 1);
                        keyvalue = values[equalspos] == '\"' ? CIMIndicationEvent.unEscape(new String(values, equalspos + 1, i - equalspos - 2)) : (values[equalspos] == '\\' && values[equalspos + 1] == '\"' ? CIMIndicationEvent.unEscape(new String(values, equalspos + 2, i - equalspos - 3)) : new String(values, equalspos, i - equalspos));
                        equalspos = 0;
                        keystart = ++i;
                        CIMProperty cp = new CIMProperty();
                        cp.setName(keyprop);
                        cp.setValue(new CIMValue((Object)keyvalue, CIMDataType.getPredefinedType((int)8)));
                        cp.setType(CIMDataType.getPredefinedType((int)8));
                        tmpkeys.addElement(cp);
                        singleKey = false;
                    }
                }
            }
            ++i;
        }
        CIMObjectPath mReturnResult = new CIMObjectPath();
        if (nameSpaceHdl != null) {
            String hostName = null;
            String newNameSpace = null;
            if (!nameSpaceHdl.substring(0, 2).equals("//")) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + instanceName + "\" does not specify a host"));
            }
            StringTokenizer stok = new StringTokenizer(nameSpaceHdl, "/", false);
            int tokenNumber = 0;
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                if (tokenNumber == 0) {
                    hostName = token;
                } else {
                    newNameSpace = tokenNumber == 1 ? token : newNameSpace.concat("/" + token);
                }
                ++tokenNumber;
            }
            if (hostName == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + instanceName + "\" does not specify a host"));
            }
            if (newNameSpace == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)("Instance name \"" + instanceName + "\" does not specify a namespace"));
            }
            mReturnResult.setNameSpace(newNameSpace);
            mReturnResult.setHost(hostName);
        }
        mReturnResult.setObjectName(className);
        for (int l = 0; l < tmpkeys.size(); ++l) {
            mReturnResult.addKey((CIMProperty)tmpkeys.elementAt(l));
        }
        return mReturnResult;
    }

    public static String unEscape(String inString) {
        int bufSize = 0;
        int out = 0;
        boolean noconv = true;
        if (inString == null) {
            return null;
        }
        char[] values = inString.toCharArray();
        if (values.length * 5 + 1 <= bufSize) {
            return null;
        }
        bufSize = 5 * values.length + 1;
        char[] newValue = new char[bufSize];
        for (int i = 0; i < values.length; ++i) {
            char ch = values[i];
            if (ch == '\\') {
                if (i + 1 < values.length) {
                    newValue[out++] = values[++i];
                }
                noconv = false;
                continue;
            }
            newValue[out++] = values[i];
        }
        if (noconv) {
            return inString;
        }
        newValue[out++] = '\u0000';
        return new String(newValue, 0, out - 1);
    }

    public static class CimomNotIdentifyable
    extends RuntimeException {
        private static final String NOTHING = "CIMOM look-up unsuccesful. No database record found for this network address.";
        private static final String AMBIGUOUS = "CIMOM look-up ambiguous. {1} database records found for this network address.";

        public CimomNotIdentifyable(String pMsg) {
            super(pMsg);
        }

        public static CimomNotIdentifyable createNothing() {
            return new CimomNotIdentifyable(NOTHING);
        }

        public static CimomNotIdentifyable createAmbiguous(int pCount) {
            return new CimomNotIdentifyable(MessageFormat.format(AMBIGUOUS, new Integer(pCount)));
        }
    }
}

