/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class SANEventUtil {
    private static final long serialVersionUID = 20001130L;
    static final String TRACE_NAME = "aperi.logger.trace.event";
    static final String MESSAGE_NAME = "aperi.logger.message.event";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.event.resources.SANEventService";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public static final String className = SANEventUtil.class.getName();
    private static IConfigService dbParms = null;
    public static final String DEFAULT_DOMAIN = "127.0.0.1";
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final String DOMAINID = "SANDomainID";
    public static final String PUBLISHERID = "publisherID";

    public SANEventUtil() {
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        if (msgLogger != null) {
            msgLogger.setMessageFile(BUNDLENAME);
        }
    }

    private String getDomainFilter() {
        String domainID;
        block4: {
            String methodName = "getDomainFilter";
            domainID = "127.0.0.1";
            try {
                dbParms = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
                domainID = dbParms.getProperty(DOMAINID, "user");
                if (domainID == null) {
                    domainID = "127.0.0.1";
                }
            }
            catch (Exception e) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getDomainFilter", (Throwable)e);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getDomainFilter", (Throwable)e);
            }
        }
        return "(SANDomainID = '" + domainID + "')";
    }

    public static String getDomainName() {
        String domainID;
        block4: {
            String methodName = "getDomainName";
            domainID = "127.0.0.1";
            try {
                dbParms = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
                domainID = dbParms.getProperty(DOMAINID, "user");
                if (domainID == null) {
                    domainID = "127.0.0.1";
                }
            }
            catch (Exception e) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getDomainName", (Throwable)e);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getDomainName", (Throwable)e);
            }
        }
        return domainID;
    }

    public static String getUniqueQualifier() {
        String hostName = "127.0.0.1";
        try {
            InetAddress address = InetAddress.getLocalHost();
            InetAddress addr = InetAddress.getByName(address.getHostAddress());
            hostName = addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            hostName = "127.0.0.1";
        }
        return hostName.trim();
    }

    public static String getUniqueSubscriberId(String baseName) {
        String qualifier = SANEventUtil.getUniqueQualifier();
        if (baseName == null) {
            baseName = "";
        }
        if (baseName.trim().length() == 0) {
            baseName = "NONAME";
        }
        return new String(qualifier.trim() + "." + baseName.trim());
    }
}

