/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.MessagingService;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.jms.Message;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.TopicHandler;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.interfaces.IMessagingService;
import org.eclipse.aperi.sanmgmt.middleware.data.CliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;

public class MessagingService
implements IMessagingService,
IService,
ICliDispatcher {
    private static String className = null;
    static ILogger traceLogger = null;
    static ILogger msgLogger = null;
    private static final String TRACE_NAME = "aperi.logger.trace.MessagingService";
    private static final String MESSAGE_NAME = "aperi.logger.message.MessagingService";
    private static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.MessagingService.resources.MsgSvcMsgs";
    private Status status = new Status(5, 9);
    private Hashtable topics;
    private Vector listOfSubscribers = new Vector();
    private Vector listOfTopicHandlers = new Vector();

    public MessagingService() {
        className = this.getClass().getName();
        String methodName = "MessagingService()";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.topics = new Hashtable();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void subscribe(String topic, String service) {
        String methodName = "subscribe(String topic, String service)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.subscribe(topic, null, service);
        if (msgLogger != null && msgLogger.isLogging()) {
            msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "MessagingService_subscribed", (Object)service, (Object)topic);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String topic, String url, String service) {
        String methodName = "subscribe(String topic, String url, String service)";
        String subscriber = "";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "service " + service + "subscribing to topic: " + topic);
        }
        if (url == null) {
            IConfigService dbp = null;
            dbp = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
            String managerPort = dbp.getProperty("manager.port", "setup");
            int serverPort = Integer.parseInt(managerPort);
            subscriber = "localhost:" + serverPort + ":" + service;
        } else {
            subscriber = url + ":" + service;
        }
        if (!this.listOfSubscribers.contains(subscriber)) {
            this.listOfSubscribers.add(subscriber);
        }
        Vector topicHandlers = new Vector();
        Hashtable hashtable = this.topics;
        synchronized (hashtable) {
            if (!this.topics.containsKey(topic)) {
                TopicHandler th = new TopicHandler(topic);
                this.listOfTopicHandlers.add(th);
                th.addSubscriber(url, service);
                topicHandlers.add(th);
                Enumeration keys = this.topics.keys();
                while (keys.hasMoreElements()) {
                    String pattern = (String)keys.nextElement();
                    if (this.matches(topic, pattern)) {
                        Vector tHandlers1 = (Vector)this.topics.get(pattern);
                        Enumeration Ths = tHandlers1.elements();
                        while (Ths.hasMoreElements()) {
                            TopicHandler tHandler1 = (TopicHandler)Ths.nextElement();
                            if (topicHandlers.contains(tHandler1)) continue;
                            topicHandlers.add(tHandler1);
                        }
                        continue;
                    }
                    if (!this.isSuperClassOf(topic, pattern)) continue;
                    Vector tHandlers2 = (Vector)this.topics.get(pattern);
                    if (!tHandlers2.contains(th)) {
                        tHandlers2.add(th);
                    }
                    this.topics.put(pattern, tHandlers2);
                }
                this.topics.put(topic, topicHandlers);
                new Thread((Runnable)th, "TopicHandler-" + topic).start();
            } else {
                topicHandlers = (Vector)this.topics.get(topic);
                TopicHandler topicHandler = (TopicHandler)topicHandlers.get(0);
                topicHandler.addSubscriber(url, service);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, this.toString());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void unsubscribe(String topic, String service) {
        String methodName = "unsubscribe(String topoic, String service)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.unsubscribe(topic, null, service);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String topic, String url, String service) {
        String methodName = "unsubscribe(String topic, String url, String service)";
        Vector topicHandlers = new Vector();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Hashtable hashtable = this.topics;
        synchronized (hashtable) {
            topicHandlers = (Vector)this.topics.get(topic);
            Enumeration ths = topicHandlers.elements();
            while (ths.hasMoreElements()) {
                TopicHandler topicHandler = (TopicHandler)ths.nextElement();
                topicHandler.removeSubscriber(url, service);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void publish(String topic, Message message) {
        String methodName = "publish(String topic, Message message)";
        Vector topicHandlers = new Vector();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "topic = " + topic);
        }
        if ((topicHandlers = this.getTopicHandlers(topic)) != null) {
            for (int i = 0; i < topicHandlers.size(); ++i) {
                try {
                    TopicHandler th = (TopicHandler)topicHandlers.get(i);
                    if (th == null) continue;
                    if (traceLogger != null && traceLogger.isLogging()) {
                        String topicHandlerName = th.getTopic();
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Adding message to TopicHandler = " + topicHandlerName);
                        Hashtable subs = th.getSubscribers();
                        Enumeration keys = subs.keys();
                        while (keys.hasMoreElements()) {
                            String subscriber = (String)keys.nextElement();
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "TopicHandler subscriber= " + subscriber);
                        }
                    }
                    th.addMessage(message);
                    continue;
                }
                catch (Exception e) {
                    if (traceLogger == null || !traceLogger.isLogging()) continue;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getName() {
        return "MessagingService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("MessagingService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("MessagingService_Description");
    }

    public boolean startup() {
        String methodName = "startup()";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.status.setRunStatus(8);
        if (msgLogger != null && msgLogger.isLogging()) {
            msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "MessagingService_started");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    public boolean shutdown() {
        String methodName = "shutdown()";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        for (int i = 0; i < this.listOfTopicHandlers.size(); ++i) {
            TopicHandler th = (TopicHandler)this.listOfTopicHandlers.get(i);
            th.stopThread();
        }
        this.status.setRunStatus(10);
        if (msgLogger != null && msgLogger.isLogging()) {
            msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "MessagingService_shutdown");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    public String getDescription() {
        return "Messaging Toolkit";
    }

    public Status getStatus() {
        return this.status;
    }

    public String dispatch(String arg0, String[] arg1) {
        return CliDispatcher.dispatch((Object)this, (String)arg0, (String[])arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getTopicHandlers(String topic) {
        Vector v;
        String methodName;
        block9: {
            block8: {
                methodName = "getTopicHandlers(String topic)";
                v = new Vector();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
                }
                Hashtable hashtable = this.topics;
                synchronized (hashtable) {
                    v = (Vector)this.topics.get(topic + "*");
                }
                if (v == null) break block8;
                if (traceLogger == null || !traceLogger.isLogging()) break block9;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Size of v vector = " + v.size());
                break block9;
            }
            String Topic2 = topic;
            while (!Topic2.equals("java.lang.Object")) {
                Vector vec;
                String nextTopicToLookFor;
                int index = Topic2.lastIndexOf("/");
                Topic2 = nextTopicToLookFor = topic.substring(0, index);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "nextTopicToLookFor = " + nextTopicToLookFor);
                }
                if ((vec = (Vector)this.topics.get(Topic2 + "*")) == null) continue;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found nextTopicToLookFor");
                }
                v = vec;
                break;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return v;
    }

    private boolean matches(String str, String pattern) {
        String methodName = "matches(String str, String pattern)";
        boolean result = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "topic = " + str + ", pattern = " + pattern);
        }
        result = pattern.endsWith("*") ? str.startsWith(pattern.substring(0, pattern.length() - 1)) : str.equals(pattern);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    private boolean isSuperClassOf(String str, String pattern) {
        String methodName = "isSuperClassOf(String str, String pattern)";
        boolean result = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "topic = " + str + ", pattern = " + pattern);
        }
        if (str.endsWith("*")) {
            result = pattern.startsWith(str.substring(0, str.length() - 1));
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public String toString() {
        String output = "There are " + this.topics.size() + " topics in the topics Hashtable.\n";
        Enumeration keys = this.topics.keys();
        while (keys.hasMoreElements()) {
            String pattern = (String)keys.nextElement();
            Vector topicHandlers = (Vector)this.topics.get(pattern);
            output = output + "Topic " + pattern + " has " + topicHandlers.size() + " topic handlers.\n";
            Enumeration ths = topicHandlers.elements();
            while (ths.hasMoreElements()) {
                TopicHandler topicHandler = (TopicHandler)ths.nextElement();
                output = output + "\tTopicHandler: " + topicHandler + "\n";
                Hashtable subscribers = topicHandler.getSubscribers();
                Enumeration keys1 = subscribers.keys();
                while (keys1.hasMoreElements()) {
                    String sub = (String)keys1.nextElement();
                    output = output + "\t\tSubscriber: " + sub + "\n";
                }
            }
        }
        return output;
    }

    public boolean isAlive() {
        String methodName = "isAlive()";
        boolean state = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (this.status.getRunStatus() == 8) {
            state = true;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return state;
    }

    public boolean isSubscriber(String url, String service) {
        String methodName = "isSubscriber(String url, String service)";
        String subscriber = "";
        boolean isSubs = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (url == null) {
            IConfigService dbp = null;
            dbp = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
            String managerPort = dbp.getProperty("manager.port", "setup");
            int serverPort = Integer.parseInt(managerPort);
            subscriber = "localhost:" + serverPort + ":" + service;
        } else {
            subscriber = url + ":" + service;
        }
        if (this.listOfSubscribers.contains(subscriber)) {
            isSubs = true;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return isSubs;
    }

    public Hashtable getRoleMap() {
        Hashtable roleMap = new Hashtable();
        return roleMap;
    }

    static {
        try {
            msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
            msgLogger.setMessageFile(BUNDLENAME);
            traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

