/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.messagingimpl;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.event.TESTopicExtensionMgr;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopic;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopicConnectionFactory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.FactoryInvalidException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.InvalidTopicClassException;
import org.eclipse.aperi.sanmgmt.middleware.messagingimpl.TESTopicImpl;

public class MSFactoryImpl
implements Factory {
    private static String className = null;
    static ILogger traceLogger = null;
    static ILogger msgLogger = null;
    private static final String TRACE_NAME = "aperi.logger.trace.tes";
    private static final String MESSAGE_NAME = "aperi.logger.message.tes";
    private static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.messaging.resources.TESMessages";
    MSTopicConnectionFactory topicFactory;
    TopicConnection connection;
    TopicSession session;
    ExceptionListener exceptionListener = null;

    public MSFactoryImpl(String serverURL, String messageLoggerName, String traceLoggerName) throws Exception {
        int serverPort;
        className = this.getClass().getName();
        String methodName = "MSFactoryImpl(String serverURL, String messageLoggerName, String traceLoggerName)";
        if (messageLoggerName == null) {
            messageLoggerName = MESSAGE_NAME;
        }
        if (traceLoggerName == null) {
            traceLoggerName = TRACE_NAME;
        }
        try {
            msgLogger = LogManagerFactory.getMessageLogger((String)messageLoggerName);
            msgLogger.setMessageFile(BUNDLENAME);
            traceLogger = LogManagerFactory.getTraceLogger((String)traceLoggerName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.topicFactory = new MSTopicConnectionFactory();
        String serverName = null;
        if (serverURL != null) {
            serverName = this.getServerName(serverURL);
            serverPort = this.getPortNumber(serverURL);
        } else {
            IConfigService dbp = null;
            dbp = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
            serverName = dbp.getProperty("manager.loc", "setup");
            String managerPort = dbp.getProperty("manager.port", "setup");
            serverPort = Integer.parseInt(managerPort);
        }
        this.topicFactory.setHostName(serverName);
        this.topicFactory.setPort(serverPort);
        this.connection = this.topicFactory.createTopicConnection();
        this.session = this.connection.createTopicSession(false, 0);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public TopicPublisher createPublisher(String tesTopicToPublish, Message template) throws JMSException, FactoryInvalidException {
        String methodName = "createPublisher(String tesTopicToPublish, Message template)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        TopicPublisher topicPub = this.createPublisher(tesTopicToPublish, null, template);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return topicPub;
    }

    public TopicPublisher createPublisher(String tesTopicToPublish, String topicSuffix, Message template) throws JMSException, FactoryInvalidException {
        String methodName = "createPublisher(String tesTopicToPublish, String topicSuffix, Message template)";
        TopicPublisher publisher = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        try {
            MSTopic topic = new MSTopic(this.makeTopic(tesTopicToPublish));
            publisher = this.session.createPublisher((Topic)topic);
        }
        catch (JMSException e) {
            if (msgLogger != null && msgLogger.isLogging()) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "createPublisher_failed", (Object)tesTopicToPublish);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(e);
            }
            throw new JMSException("createPublisher failed due to: " + e.getMessage());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return publisher;
    }

    public TopicSubscriber createSubscriber(String tesTopic, String subscriberID, String selector, MessageListener listener) throws JMSException, FactoryInvalidException {
        String methodName = "createSubscriber(String tesTopic, String subscriberID, String selector, MessageListener listener)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        TopicSubscriber topicSub = this.createSubscriber(tesTopic, "", subscriberID, selector, listener);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return topicSub;
    }

    public TopicSubscriber createSubscriber(String tesTopic, String topicSuffix, String subscriberID, String selector, MessageListener listener) throws JMSException, FactoryInvalidException {
        String methodName = "createSubscriber(String tesTopic, String topicSuffix, String subscriberID, String selector, MessageListener listener)";
        TopicSubscriber subscriber = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        try {
            MSTopic topic = new MSTopic(this.makeTopic(tesTopic) + "*");
            subscriber = this.session.createSubscriber((Topic)topic);
            subscriber.setMessageListener(listener);
            this.connection.start();
        }
        catch (JMSException e) {
            if (msgLogger != null && msgLogger.isLogging()) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "createSubscriber_failed", (Object)tesTopic);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(e);
            }
            throw new JMSException("createSubscriber failed due to: " + e.getMessage());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return subscriber;
    }

    public void unsubscribe(String s) throws JMSException, FactoryInvalidException {
    }

    public String getReconnectionString() {
        return null;
    }

    public ObjectMessage createMessage(Serializable object) throws JMSException {
        String methodName = "createMessage(Serializable object)";
        ObjectMessage objMessage = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        try {
            objMessage = this.session.createObjectMessage();
            objMessage.setObject(object);
        }
        catch (JMSException ex) {
            if (msgLogger != null && msgLogger.isLogging()) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "createMessage_failed");
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ex);
            }
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(ex);
            }
            throw new JMSException("createMessage failed due to: " + ex.getMessage());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return objMessage;
    }

    public Message createPlainMessage() throws JMSException {
        return null;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return null;
    }

    public MapMessage createMapMessage() throws JMSException {
        return null;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return null;
    }

    public TextMessage createTextMessage() throws JMSException {
        return null;
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        return null;
    }

    public void setExceptionListener(ExceptionListener exceptionlistener) throws JMSException {
        String methodName = "setExceptionListener(ExceptionListener exceptionlistener)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.exceptionListener = exceptionlistener;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void setLogging(boolean flag) {
    }

    public void close() throws JMSException {
        String methodName = "close()";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.topicFactory = null;
        this.connection.close();
        this.session.close();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private String makeTopic(String topicName) throws InvalidTopicClassException {
        String methodName = "makeTopic(String topicName)";
        String realTopic = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        try {
            TESTopicExtensionMgr extMgr = TESTopicExtensionMgr.getExtensionMgr();
            TESTopicImpl tesTopic = (TESTopicImpl)extMgr.getExtensionImpl(topicName);
            Class<?> topicClass = tesTopic.getClass();
            realTopic = topicClass.getName();
            Class<?> topic = topicClass;
            while (topic != null) {
                if ((topic = topic.getSuperclass()) == null) continue;
                realTopic = topic.getName() + "/" + realTopic;
            }
        }
        catch (Exception exception) {
            if (msgLogger != null && msgLogger.isLogging()) {
                msgLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "makeTopic_failed", (Object)topicName);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exception);
            }
            throw new InvalidTopicClassException(topicName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return realTopic;
    }

    protected final String getServerName(String url) {
        int loc;
        String methodName = "getServerName(String url)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String server = (loc = url.indexOf(58)) == -1 ? url : url.substring(0, loc);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return server;
    }

    protected final int getPortNumber(String url) throws NumberFormatException {
        int port;
        int loc;
        String methodName = "getPortNumber(String url)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if ((loc = url.indexOf(58)) == -1) {
            IConfigService dbp = null;
            dbp = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
            String managerPort = dbp.getProperty("manager.port", "setup");
            port = Integer.parseInt(managerPort);
        } else {
            port = Integer.parseInt(url.substring(loc + 1));
            if (port <= 0) {
                throw new NumberFormatException("Invalid port number: " + port);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return port;
    }
}

