/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;

public class DiskCliDispatcher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dispatch(Object obj, String methodName, String[] args) {
        String ret = "";
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"DiskCliDispatcher", (String)"dispatch", (Object[])new Object[]{obj, methodName, args});
        try {
            boolean found = false;
            Class[] paramTypes = null;
            Method[] methods = obj.getClass().getMethods();
            Method method = null;
            Object retObj = null;
            Hashtable<Method, Class<?>[]> methodsTable = new Hashtable<Method, Class<?>[]>();
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] pt;
                if (!methods[i].getName().equals(methodName) || ((pt = methods[i].getParameterTypes()).length != 0 || args != null && args.length != 0) && (args == null || pt.length != args.length)) continue;
                methodsTable.put(methods[i], pt);
            }
            if (methodsTable.size() > 0) {
                Object[] params = null;
                Enumeration keys = methodsTable.keys();
                while (keys.hasMoreElements()) {
                    method = (Method)keys.nextElement();
                    paramTypes = (Class[])methodsTable.get(method);
                    if (paramTypes.length == 0) {
                        params = null;
                        found = true;
                        break;
                    }
                    try {
                        params = DiskCliDispatcher.convertToParams(args, paramTypes);
                        found = true;
                        break;
                    }
                    catch (RuntimeException re) {
                        re.printStackTrace();
                    }
                }
                if (found) {
                    retObj = method.invoke(obj, params);
                    if (retObj != null) {
                        ret = retObj.toString();
                    }
                } else {
                    mLTH.exit((Object)ret);
                    RuntimeException e1 = new RuntimeException("Method not found or method signature mismatch");
                    mLTH.traceError("HWN021503E", (Throwable)e1);
                }
            } else {
                RuntimeException e1 = new RuntimeException("Method not found or method signature mismatch");
                mLTH.traceError("HWN021503E", (Throwable)e1);
            }
        }
        catch (Throwable e) {
            ret = e.toString();
            mLTH.traceError("Error during method dispatching for method " + methodName + " with parameters " + DiskMessageHelper.toMsgString((Object)args), e);
        }
        finally {
            mLTH.exit((Object)ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] convertToParams(String[] args, Class[] paramTypes) throws RuntimeException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)"DiskCliDispatcher", (String)"convertToParams", (Object[])new Object[]{args, paramTypes});
        Object[] params = new Object[paramTypes.length];
        try {
            Class[] constructorParam = new Class[]{String.class};
            for (int i = 0; i < paramTypes.length; ++i) {
                Class paramType = paramTypes[i];
                try {
                    if (args[i].equalsIgnoreCase("null")) {
                        params[i] = null;
                        continue;
                    }
                    if (paramType.isArray()) {
                        String[] curParamsString = ParameterHelper.convertToStringArray((String)args[i]);
                        Class<?> componentType = paramType.getComponentType();
                        if (componentType.isPrimitive()) {
                            params[i] = DiskCliDispatcher.createPrimitiveArray(componentType, curParamsString);
                            continue;
                        }
                        Object[] curArray = (Object[])Array.newInstance(componentType, curParamsString.length);
                        for (int j = 0; j < curParamsString.length; ++j) {
                            Constructor<?> c = componentType.getConstructor(constructorParam);
                            Object[] p = new Object[]{curParamsString[j]};
                            curArray[j] = c.newInstance(p);
                        }
                        params[i] = curArray;
                        continue;
                    }
                    if (paramType.isPrimitive()) {
                        paramType = DiskCliDispatcher.convertPrimitiveToObject(paramType);
                    }
                    Constructor c = paramType.getConstructor(constructorParam);
                    Object[] p = new Object[]{args[i]};
                    params[i] = c.newInstance(p);
                    continue;
                }
                catch (Throwable mEx) {
                    mLTH.traceError("HWN021503E", mEx);
                    mLTH.traceInfo("Unable to convert \"" + args[i] + "\" to object of type " + paramType.getName());
                }
            }
            Object[] objectArray = params;
            return objectArray;
        }
        finally {
            mLTH.exit((Object)params);
        }
    }

    private static Class convertPrimitiveToObject(Class pClass) {
        if (pClass == Boolean.TYPE) {
            pClass = Boolean.class;
        } else if (pClass == Character.TYPE) {
            pClass = Character.class;
        } else if (pClass == Byte.TYPE) {
            pClass = Byte.class;
        } else if (pClass == Short.TYPE) {
            pClass = Short.class;
        } else if (pClass == Integer.TYPE) {
            pClass = Integer.class;
        } else if (pClass == Long.TYPE) {
            pClass = Long.class;
        } else if (pClass == Float.TYPE) {
            pClass = Float.class;
        } else if (pClass == Double.TYPE) {
            pClass = Double.class;
        }
        return pClass;
    }

    private static Object createPrimitiveArray(Class pClass, String[] pParams) {
        Object curArray = Array.newInstance(pClass, pParams.length);
        for (int i = 0; i < pParams.length; ++i) {
            DiskCliDispatcher.setElementAt(curArray, pClass, i, pParams[i]);
        }
        return curArray;
    }

    private static void setElementAt(Object pArray, Class pClass, int pIndex, String pValue) {
        if (pClass == Boolean.TYPE) {
            ((boolean[])pArray)[pIndex] = Boolean.valueOf(pValue);
        } else if (pClass == Character.TYPE) {
            ((char[])pArray)[pIndex] = pValue.charAt(0);
        } else if (pClass == Byte.TYPE) {
            ((byte[])pArray)[pIndex] = Byte.valueOf(pValue);
        } else if (pClass == Short.TYPE) {
            ((short[])pArray)[pIndex] = Short.valueOf(pValue);
        } else if (pClass == Integer.TYPE) {
            ((int[])pArray)[pIndex] = Integer.valueOf(pValue);
        } else if (pClass == Long.TYPE) {
            ((long[])pArray)[pIndex] = Long.valueOf(pValue);
        } else if (pClass == Float.TYPE) {
            ((float[])pArray)[pIndex] = Float.valueOf(pValue).floatValue();
        } else if (pClass == Double.TYPE) {
            ((double[])pArray)[pIndex] = Double.valueOf(pValue);
        }
    }
}

