/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.api.SRMVersion;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.DiskActivator;
import org.eclipse.aperi.disk.api.DiskVersion;
import org.eclipse.aperi.disk.api.HostType;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.disk.api.impl.DiskCliDispatcher;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskManagerService
implements IDiskManagerService,
IService,
ICliDispatcher {
    static final String className = DiskManagerService.class.getName();
    ServiceHelper cServiceHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskManagerService(ServiceHelper pServiceHelper) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"DiskManagerService", null);
        this.cServiceHelper = pServiceHelper;
        try {
            mLTH.objectCreation(DiskManagerService.class.getName());
        }
        finally {
            mLTH.exit(null);
        }
    }

    private IJobMgmtService getJobManagement() {
        return (IJobMgmtService)DiskActivator._serviceHelper.bindLocal(IFabricManagerService.class);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult createStorageVolumes(long[] sizes, String[] storagePoolIDs, String[] volumeNames, HashMap goal) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"createStorageVolumes", (Object[])new Object[]{sizes, storagePoolIDs, volumeNames, goal});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{sizes, storagePoolIDs, volumeNames, goal});
            asyncResult = mReturn = DiskManager.getInstance().createStorageVolumes(sizes, storagePoolIDs, volumeNames, goal);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult deleteStorageVolumes(String[] storageVolumeIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"deleteStorageVolumes", (Object[])new Object[]{storageVolumeIDs});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storageVolumeIDs});
            asyncResult = mReturn = DiskManager.getInstance().deleteStorageVolumes(storageVolumeIDs);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult assignStorageVolumesToWWPNs(String[] storageVolumeIDs, String[] subsystemPortIDs, String[] deviceNumbers, String[] hostWWPNs, int hostType, String hostTypeDescription, String[] hostNames, String[] activities, boolean force) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"assignStorageVolumesToWWPNs", (Object[])new Object[]{storageVolumeIDs, subsystemPortIDs, deviceNumbers, hostWWPNs, new Integer(hostType), hostTypeDescription, hostNames, activities, new Boolean(force)});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storageVolumeIDs, subsystemPortIDs, deviceNumbers, hostWWPNs, new Integer(hostType), hostTypeDescription, hostNames, activities, new Boolean(force)});
            asyncResult = mReturn = DiskManager.getInstance().assignStorageVolumesToWWPNs(storageVolumeIDs, subsystemPortIDs, deviceNumbers, hostWWPNs, hostType, hostTypeDescription, hostNames, activities, force);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult unassignStorageVolumesFromWWPNs(String[] storageVolumeIDs, String[] hostWWPNs, int pUnMappingMode, boolean force) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"unassignStorageVolumesFromWWPNs", (Object[])new Object[]{storageVolumeIDs, hostWWPNs, new Integer(pUnMappingMode), new Boolean(force)});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storageVolumeIDs, hostWWPNs, new Integer(pUnMappingMode), new Boolean(force)});
            asyncResult = mReturn = DiskManager.getInstance().unassignStorageVolumesFromWWPNs(storageVolumeIDs, hostWWPNs, pUnMappingMode, force);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult unassignStorageVolumesFromWWPNs(String[] storageVolumeIDs, String[] hostWWPNs, boolean force) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"deleteStorageVolumes", (Object[])new Object[]{storageVolumeIDs});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storageVolumeIDs});
            asyncResult = mReturn = DiskManager.getInstance().unassignStorageVolumesFromWWPNs(storageVolumeIDs, hostWWPNs, force);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult modifyStoragePoolSize(String storagePoolID, String[] storageExtentIDsToAdd, String[] storageExtentIDsToRemove) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"modifyStoragePoolSize", (Object[])new Object[]{storagePoolID, storageExtentIDsToAdd, storageExtentIDsToRemove});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storagePoolID, storageExtentIDsToAdd, storageExtentIDsToRemove});
            asyncResult = mReturn = DiskManager.getInstance().modifyStoragePoolSize(storagePoolID, storageExtentIDsToAdd, storageExtentIDsToRemove);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult modifyStorageVolumeSize(String storageVolumeID, long newSize) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"modifyStorageVolumeSize", (Object[])new Object[]{storageVolumeID, new Long(newSize)});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storageVolumeID, new Long(newSize)});
            asyncResult = mReturn = DiskManager.getInstance().modifyStorageVolumeSize(storageVolumeID, newSize);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result[] deleteStorageSubsystems(String[] subsystemIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        Result[] resultArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"deleteStorageSubsystems", (Object[])new Object[]{subsystemIDs});
        Result[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{subsystemIDs});
            resultArray = mReturn = DiskManager.getInstance().deleteStorageSubsystems(subsystemIDs);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return resultArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result removePhysicalVolumesFromDB(int[] pPhyVolumeAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        Result result;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"removePhysicalVolumesFromDB", (Object[])new Object[]{pPhyVolumeAutoIDs});
        Result mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{pPhyVolumeAutoIDs});
            result = mReturn = DiskManager.getInstance().removePhysicalVolumesFromDB(pPhyVolumeAutoIDs);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result removeStoragePoolsFromDB(int[] pPoolAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        Result result;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"removeStoragePoolsFromDB", (Object[])new Object[]{pPoolAutoIDs});
        Result mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{pPoolAutoIDs});
            result = mReturn = DiskManager.getInstance().removeStoragePoolsFromDB(pPoolAutoIDs);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result removePortsFromDB(int[] pPortAutoIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        Result result;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"removePortsFromDB", (Object[])new Object[]{pPortAutoIDs});
        Result mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{pPortAutoIDs});
            result = mReturn = DiskManager.getInstance().removePortsFromDB(pPortAutoIDs);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result removeStorageVolumesFromDB(int[] pVolumeIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        Result result;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"removeStorageVolumesFromDB", (Object[])new Object[]{pVolumeIDs});
        Result mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{pVolumeIDs});
            result = mReturn = DiskManager.getInstance().removeStorageVolumesFromDB(pVolumeIDs);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult createSVCVDisks(long[] sizes, String[] svcMDiskGroupIDs, String[] svcVDiskNames, boolean formatOnCreate, int virtualizationType, int ioGroup, String[] svcMDiskIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"createSVCVDisks", (Object[])new Object[]{sizes, svcMDiskGroupIDs, svcVDiskNames, new Boolean(formatOnCreate), new Integer(virtualizationType), new Integer(ioGroup), svcMDiskIDs});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{sizes, svcMDiskGroupIDs, svcVDiskNames, new Boolean(formatOnCreate), new Integer(virtualizationType), new Integer(ioGroup), svcMDiskIDs});
            asyncResult = mReturn = DiskManager.getInstance().createSVCVDisks(sizes, svcMDiskGroupIDs, svcVDiskNames, formatOnCreate, virtualizationType, ioGroup, svcMDiskIDs);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getStorageSubsystems(HashMap attributes) throws ServerException, InvalidParameterException {
        String[] stringArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageSubsystems", (Object[])new Object[]{attributes});
        String[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{attributes});
            stringArray = mReturn = DiskManager.getInstance().getStorageSubsystems(attributes);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return stringArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getStorageSubsystemAttributes(String[] subsystemIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageSubsystemAttributes", (Object[])new Object[]{subsystemIDs, attribList});
        HashMap[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{subsystemIDs, attribList});
            hashMapArray = mReturn = DiskManager.getInstance().getStorageSubsystemAttributes(subsystemIDs, attribList);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return hashMapArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getPortsForSubsystem(String subsystemID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getPortsForSubsystem", (Object[])new Object[]{subsystemID, attributes});
        String[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{subsystemID, attributes});
            stringArray = mReturn = DiskManager.getInstance().getPortsForSubsystem(subsystemID, attributes);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return stringArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getPortAttributes(String[] portIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getPortAttributes", (Object[])new Object[]{portIDs, attribList});
        HashMap[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{portIDs, attribList});
            hashMapArray = mReturn = DiskManager.getInstance().getPortAttributes(portIDs, attribList);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return hashMapArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getStoragePoolsForSubsystem(String subsystemID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStoragePoolsForSubsystem", (Object[])new Object[]{subsystemID, attributes});
        String[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{subsystemID, attributes});
            stringArray = mReturn = DiskManager.getInstance().getStoragePoolsForSubsystem(subsystemID, attributes);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return stringArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getStoragePoolAttributes(String[] poolIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStoragePoolAttributes", (Object[])new Object[]{poolIDs, attribList});
        HashMap[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{poolIDs, attribList});
            hashMapArray = mReturn = DiskManager.getInstance().getStoragePoolAttributes(poolIDs, attribList);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return hashMapArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getStorageVolumesForPool(String poolID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageVolumesForPool", (Object[])new Object[]{poolID, attributes});
        String[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{poolID, attributes});
            stringArray = mReturn = DiskManager.getInstance().getStorageVolumesForPool(poolID, attributes);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return stringArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getStorageVolumesForSubsystem(String subsystemID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageVolumesForSubsystem", (Object[])new Object[]{subsystemID, attributes});
        String[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{subsystemID, attributes});
            stringArray = mReturn = DiskManager.getInstance().getStorageVolumesForSubsystem(subsystemID, attributes);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return stringArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getStorageVolumeAttributes(String[] storageVolumeIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageVolumeAttributes", (Object[])new Object[]{storageVolumeIDs, attribList});
        HashMap[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storageVolumeIDs, attribList});
            hashMapArray = mReturn = DiskManager.getInstance().getStorageVolumeAttributes(storageVolumeIDs, attribList);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return hashMapArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getStorageVolumeAssignments(String[] storageVolumeIDs, HashMap filters) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getStorageVolumeAssignments", (Object[])new Object[]{storageVolumeIDs, filters});
        HashMap[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storageVolumeIDs, filters});
            hashMapArray = mReturn = DiskManager.getInstance().getStorageVolumeAssignments(storageVolumeIDs, filters);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return hashMapArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getHostInfo(String subsystemID, HashMap Filters, boolean IncludeVolumes) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap hashMap;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getHostInfo", (Object[])new Object[]{subsystemID, Filters, new Boolean(IncludeVolumes)});
        HashMap mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{subsystemID, Filters, new Boolean(IncludeVolumes)});
            hashMap = mReturn = DiskManager.getInstance().getHostInfo(subsystemID, Filters, IncludeVolumes);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return hashMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HostType[] getHostTypes(String subsystemID) throws ServerException, InvalidParameterException, MissingParameterException {
        HostType[] hostTypeArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getHostTypes", (Object[])new Object[]{subsystemID});
        HostType[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{subsystemID});
            hostTypeArray = mReturn = DiskManager.getInstance().getHostTypes(subsystemID);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return hostTypeArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] getSupportedVolumeSizeRange(String storagePoolID, int dataRedundancy, int packageRedundancy, int deltaReservation) throws ServerException, InvalidParameterException, MissingParameterException {
        long[] lArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getSupportedVolumeSizeRange", (Object[])new Object[]{storagePoolID, new Integer(dataRedundancy), new Integer(packageRedundancy), new Integer(deltaReservation)});
        long[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storagePoolID, new Integer(dataRedundancy), new Integer(packageRedundancy), new Integer(deltaReservation)});
            lArray = mReturn = DiskManager.getInstance().getSupportedVolumeSizeRange(storagePoolID, dataRedundancy, packageRedundancy, deltaReservation);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return lArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] getDefaultSupportedVolumeSizeRange(String storagePoolID) throws ServerException, InvalidParameterException, MissingParameterException {
        long[] lArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getDefaultSupportedVolumeSizeRange", (Object[])new Object[]{storagePoolID});
        long[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{storagePoolID});
            lArray = mReturn = DiskManager.getInstance().getDefaultSupportedVolumeSizeRange(storagePoolID);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return lArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult discoverStorageSubsystems(String[] cimomIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"discoverStorageSubsystems", (Object[])new Object[]{cimomIDs});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{cimomIDs});
            asyncResult = mReturn = DiskManager.getInstance().discoverStorageSubsystems(cimomIDs);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult discoverDevicesFromCIMOM(String[] cimomIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"discoverDevicesFromCIMOM", (Object[])new Object[]{cimomIDs});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{cimomIDs});
            asyncResult = mReturn = DiskManager.getInstance().discoverDevicesFromCIMOM(cimomIDs);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    public AsyncResult probeStorageSubsystems(String[] subsystemIDs, Integer collectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.probeStorageSubsystems(subsystemIDs, (int)collectionType);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult probeStorageSubsystems(String[] subsystemIDs, int collectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"probeStorageSubsystems", (Object[])new Object[]{subsystemIDs, new Integer(collectionType)});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{subsystemIDs, new Integer(collectionType)});
            asyncResult = mReturn = DiskManager.getInstance().probeStorageSubsystems(subsystemIDs, collectionType);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    public Hashtable getRoleMap() {
        return DiskManager.getInstance().getRoleMap();
    }

    public String getDescription() {
        return DiskManager.getInstance().getDescription();
    }

    public String getName() {
        return DiskManager.getInstance().getName();
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("DiskManagerService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("DiskManagerService_Description");
    }

    public String getVersion() {
        return "5.0.0";
    }

    public Status getStatus() {
        return DiskManager.getInstance().getStatus();
    }

    public boolean shutdown() {
        return DiskManager.getInstance().shutdown();
    }

    public boolean startup() {
        return DiskManager.getInstance().startup(this.cServiceHelper);
    }

    public AsyncResult discoverCIMOMs(String[] DAs, Boolean localSubnet) throws ServerException {
        return this.discoverCIMOMs(DAs, (boolean)localSubnet);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult discoverCIMOMs(String[] DAs, boolean localSubnet) throws ServerException {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"discoverCIMOMs", (Object[])new Object[]{DAs, new Boolean(localSubnet)});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{DAs, new Boolean(localSubnet)});
            asyncResult = mReturn = DiskManager.getInstance().discoverCIMOMs(DAs, localSubnet);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMOM[] getCIMOMs() throws ServerException {
        CIMOM[] cIMOMArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getCIMOMs", null);
        CIMOM[] mReturn = null;
        try {
            mLTH.traceDMInvokation(null);
            cIMOMArray = mReturn = DiskManager.getInstance().getCIMOMs();
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit((Object)mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return cIMOMArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getCIMOMIDs() throws ServerException {
        String[] stringArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getCIMOMIDs", null);
        String[] mReturn = null;
        try {
            mLTH.traceDMInvokation(null);
            stringArray = mReturn = DiskManager.getInstance().getCIMOMIDs();
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit((Object)mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return stringArray;
    }

    public void modifyCIMOMs(CIMOM[] cimoms) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"modifyCIMOMs", (Object[])new Object[]{cimoms});
        try {
            mLTH.traceDMInvokation(new Object[]{cimoms});
            DiskManager.getInstance().modifyCIMOMs(cimoms);
            return;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] addCIMOMs(CIMOM[] cimoms) throws ServerException {
        String[] stringArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"addCIMOMs", (Object[])new Object[]{cimoms});
        String[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{cimoms});
            stringArray = mReturn = DiskManager.getInstance().addCIMOMs(cimoms);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return stringArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result testDeviceStatus(String pServiceUrl, String pDeviceID) throws ServerException {
        Result result;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"testDeviceStatus", (Object[])new Object[]{pServiceUrl, pDeviceID});
        Result mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{pServiceUrl, pDeviceID});
            result = mReturn = DiskManager.getInstance().testDeviceStatus(pServiceUrl, pDeviceID);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return result;
    }

    public void deleteCIMOMs(String[] cimomIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"deleteCIMOMs", (Object[])new Object[]{cimomIDs});
        try {
            mLTH.traceDMInvokation(new Object[]{cimomIDs});
            DiskManager.getInstance().deleteCIMOMs(cimomIDs);
            return;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cimoms) throws ServerException {
        CIMOMConnectionStatus[] cIMOMConnectionStatusArray;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"testCIMOMConnection", (Object[])new Object[]{cimoms});
        CIMOMConnectionStatus[] mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{cimoms});
            cIMOMConnectionStatusArray = mReturn = DiskManager.getInstance().testCIMOMConnection(cimoms);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return cIMOMConnectionStatusArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] cimoms, CIMObjectPath device) throws ServerException {
        CimomAndDeviceStatus cimomAndDeviceStatus;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"testCIMOMConnection", (Object[])new Object[]{cimoms, device});
        CimomAndDeviceStatus mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{cimoms, device});
            cimomAndDeviceStatus = mReturn = DiskManager.getInstance().testCIMOMConnection(cimoms, device);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return cimomAndDeviceStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult getJobStatus(String pJobId) {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getJobStatus", (Object[])new Object[]{pJobId});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{pJobId});
            asyncResult = mReturn = DiskManager.getInstance().getJobStatus(pJobId);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult waitForJobToComplete(String pJobId) {
        AsyncResult asyncResult;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"waitForJobToComplete", (Object[])new Object[]{pJobId});
        AsyncResult mReturn = null;
        try {
            mLTH.traceDMInvokation(new Object[]{pJobId});
            asyncResult = mReturn = DiskManager.getInstance().waitForJobToComplete(pJobId);
        }
        catch (SRMRuntimeException pEx) {
            try {
                mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
                throw pEx;
                catch (RuntimeException pEx2) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.traceDMReturn(mReturn);
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        mLTH.traceDMReturn((Object)mReturn);
        mLTH.exit((Object)mReturn);
        return asyncResult;
    }

    public void cancelJob(String pJobId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"cancelJob", (Object[])new Object[]{pJobId});
        try {
            mLTH.traceDMInvokation(new Object[]{pJobId});
            DiskManager.getInstance().cancelJob(pJobId);
            return;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    public ReadLogResponse getLog(String name, byte direction, LogFilePos position, int linesDesired) throws RemoteException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{name, new Byte(direction), position, new Integer(linesDesired)});
        ReadLogResponse logResponse = new ReadLogResponse();
        try {
            mLTH.traceDMInvokation(new Object[]{name, new Byte(direction), position, new Integer(linesDesired)});
            ReadLogResponse readLogResponse = logResponse = this.getJobManagement().getLog(name, direction, position, linesDesired);
            return readLogResponse;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    public ReadLogResponse getLog(String name, byte direction, LogFilePos position, String search, int linesDesired) throws RemoteException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{name, new Byte(direction), position, search, new Integer(linesDesired)});
        ReadLogResponse logResponse = new ReadLogResponse();
        try {
            mLTH.traceDMInvokation(new Object[]{name, new Byte(direction), position, search, new Integer(linesDesired)});
            ReadLogResponse readLogResponse = logResponse = this.getJobManagement().getLog(name, direction, position, search, linesDesired);
            return readLogResponse;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    public ReadLogResponse getLog(int agentID, String name, byte direction, LogFilePos position, int linesDesired) throws RemoteException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{new Integer(agentID), name, new Byte(direction), position, new Integer(linesDesired)});
        ReadLogResponse logResponse = new ReadLogResponse();
        try {
            mLTH.traceDMInvokation(new Object[]{new Integer(agentID), name, new Byte(direction), position, new Integer(linesDesired)});
            ReadLogResponse readLogResponse = logResponse = this.getJobManagement().getLog(agentID, name, direction, position, linesDesired);
            return readLogResponse;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    public ReadLogResponse getLog(int agentID, String name, byte direction, LogFilePos position, String search, int linesDesired) throws RemoteException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{new Integer(agentID), name, new Byte(direction), position, search, new Integer(linesDesired)});
        ReadLogResponse logResponse = new ReadLogResponse();
        try {
            mLTH.traceDMInvokation(new Object[]{new Integer(agentID), name, new Byte(direction), position, search, new Integer(linesDesired)});
            ReadLogResponse readLogResponse = logResponse = this.getJobManagement().getLog(agentID, name, direction, position, linesDesired);
            return readLogResponse;
        }
        catch (SRMRuntimeException pEx) {
            mLTH.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)pEx);
            throw pEx;
        }
        catch (RuntimeException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceDMReturn(null);
            mLTH.exit(null);
        }
    }

    public String dispatch(String method, String[] args) {
        return DiskCliDispatcher.dispatch(this, method, args);
    }

    public SRMVersion getAPIVersion() throws RemoteException {
        return new DiskVersion();
    }
}

