/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Physicalvolume2extent;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extent;
import org.eclipse.aperi.interfaces.ParameterException;

class OverheadUpdatePostProcess
extends DiscoverProcess {
    public OverheadUpdatePostProcess() {
        super("Overhead Update Post Process", false, new String[]{"DEVICEID"}, new String[]{Integer.class.getName()});
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"OverheadUpdatePostProcess", null);
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        mLTH = LogTraceHelper.entry((Object)this, (String)"process", (Object[])new Object[]{pRequest, pParameters});
        mReturn = new Result(1);
        mCon = ServiceUtils.getConnection();
        mSSID = (String)pParameters.get("DEVICEID");
        try {
            try {
                mSQLStatement = "update " + StorageVolume.getTablename() + "  set " + "OVERHEAD" + " =  0  where " + "SUBSYSTEM_ID" + " = " + mSSID + " AND " + "REDUNDANCY" + " = 0";
                mLTH.traceHigh("Invoking query " + mSQLStatement);
                mReturnInt = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)mCon, (String)mSQLStatement, null);
                mCon.commit();
                mLTH.traceInfo("Updated rows : " + mReturnInt);
                mSQLStatement = "update " + StorageVolume.getTablename() + "  set " + "OVERHEAD" + " = " + "CAPACITY" + " where " + "SUBSYSTEM_ID" + " = " + mSSID + " AND " + "REDUNDANCY" + " = 10";
                mLTH.traceHigh("Invoking query " + mSQLStatement);
                mReturnInt = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)mCon, (String)mSQLStatement, null);
                mCon.commit();
                mLTH.traceInfo("Updated rows : " + mReturnInt);
                mStripeStatement = "select DISTINCT SVID,REDUNDANCY,CAPACITY from " + Physicalvolume2extent.getTablename() + " AS PE ," + Volume2extent.getTablename() + " AS VE ," + StorageVolume.getTablename() + " AS SV where " + "PE." + "STORAGE_EXTENT_ID" + " = " + "VE." + "STORAGE_EXTENT_ID" + " AND " + "VE." + "VOLUME_ID" + " = " + "SV." + "SVID" + " AND " + "SV." + "SUBSYSTEM_ID" + " = " + mSSID + " AND " + "(" + "REDUNDANCY" + " = 3" + " OR " + "REDUNDANCY" + " = 4" + " OR " + "REDUNDANCY" + " = 5" + " OR " + "REDUNDANCY" + " = 6" + " OR " + "REDUNDANCY" + " = 51" + " OR " + "REDUNDANCY" + " = 15 )";
                mDbResult = ComplexQuery.sqlQuery((DBConnection)mCon, (String)mStripeStatement, null);
lbl19:
                // 2 sources

                try {
                    while (mDbResult.next()) {
                        mSVID = mDbResult.getInt(1);
                        mRaid = mDbResult.getShort(2);
                        mCapacity = mDbResult.getLong(3);
                        mCountDiskDrivesPerVolume = "select DISTINCT count(PHYSICAL_VOLUME_ID) from " + Physicalvolume2extent.getTablename() + " AS PE ," + Volume2extent.getTablename() + " AS VE where " + "PE." + "STORAGE_EXTENT_ID" + " = " + "VE." + "STORAGE_EXTENT_ID" + " AND " + "VE." + "VOLUME_ID" + " = " + mSVID;
                        mDbResult2 = ComplexQuery.sqlQuery((DBConnection)mCon, (String)mCountDiskDrivesPerVolume, null);
                        try {
                            while (mDbResult2.next()) {
                                mDiskDrives = mDbResult2.getInt(1);
                                mOverhead = 0L;
                                try {
                                    switch (mRaid) {
                                        case 3: 
                                        case 4: 
                                        case 5: {
                                            mOverhead = mCapacity / (long)(mDiskDrives - 1);
                                            break;
                                        }
                                        case 6: {
                                            mOverhead = 2L * mCapacity / (long)(mDiskDrives - 1);
                                            break;
                                        }
                                        case 15: 
                                        case 51: {
                                            mOverhead = 2L * mCapacity * (long)(1 + 1 / mDiskDrives);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                mSQLStatement = "update " + StorageVolume.getTablename() + "  set " + "OVERHEAD" + " = " + mOverhead + " where " + "SVID" + " = " + mSVID;
                                mLTH.traceHigh("Invoking query " + mSQLStatement);
                                mReturnInt = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)mCon, (String)mSQLStatement, null);
                                mLTH.traceInfo("Updated rows : " + mReturnInt);
                            }
                        }
                        finally {
                            if (mDbResult2 == null) ** GOTO lbl19
                            mDbResult2.closeAll();
                        }
                    }
                }
                finally {
                    if (mDbResult != null) {
                        mDbResult.closeAll();
                    }
                }
                mCon.commit();
                mReturn = new Result(0);
            }
            catch (Exception mEx) {
                try {
                    mCon.rollback();
                }
                catch (SQLException pEx) {
                    // empty catch block
                }
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)mLTH);
            }
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            mLTH.exit((Object)mReturn);
        }
        return mReturn;
    }
}

