/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.api.DiskManagerRCs;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.ProbeGenericSubsystemProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProbeGenericInBandVirtualizerProcess
extends ProbeGenericSubsystemProcess
implements DiscoveryConstants,
DiskManagerRCs {
    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("collectDataFromStorageSubsystem", null, "In Band Virtualization", null, null, null)};
    }

    public ProbeGenericInBandVirtualizerProcess(String description, boolean mainProcess) {
        super(description, mainProcess);
        this.cProbeProgressVolumeStart = "HWN021737I";
        this.cProbeProgressVolumeProgress = "HWN021738I";
        this.cProbeProgressVolumeTotal = "HWN021739I";
    }

    public ProbeGenericInBandVirtualizerProcess() {
        super("collectDataFromStorageSubsystem", false);
        this.cProbeProgressVolumeStart = "HWN021737I";
        this.cProbeProgressVolumeProgress = "HWN021738I";
        this.cProbeProgressVolumeTotal = "HWN021739I";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result process(Request pDiscoverRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)pDiscoverRequest, (Object)((Object)this), (String)"process", (Object[])new Object[]{pParameters});
        Result mResult = new Result(10010);
        try {
            String mSubSystemLogName;
            block27: {
                mSubSystemLogName = (String)pParameters.get("SUBSYSTEMID");
                mLTH.logMsg("HWN021708I", new Object[]{mSubSystemLogName});
                pParameters = DiscoverUtils.setProbeTimeout((Map)pParameters, (long)DiskManagerConfigSvc.getLongConfigValue((String)"Probe.Timeout.InBand", (long)0L), (LogTraceHelper)mLTH);
                DiskCIMProcessor mProcessor = new DiskCIMProcessor(pDiscoverRequest.getScannerId());
                mProcessor.initializeForSubsystemProbe(pParameters);
                try {
                    boolean mStatus;
                    String mSubsystemID;
                    block26: {
                        CapabilityData mCapabData = (CapabilityData)pParameters.get("CAPABILITY");
                        IStep collectPoolsFromComputerSystem = this.getStepCollectPoolsFromComputerSystem(mProcessor, mCapabData, mSubSystemLogName, mLTH);
                        IStep collectVolumeSettings = this.getStepCollectVolumeSettings(mProcessor, mLTH);
                        DiscoverStep collectClientSettingDataFromComputerSystem = new DiscoverStep("collectClientSettingDataFromComputerSystem", null, (CIMProcessor)mProcessor, mLTH);
                        mSubsystemID = (String)pParameters.get("SUBSYSTEMID");
                        CIMObjectPath mCIMObjPath = (CIMObjectPath)pParameters.get("TL_CS");
                        CIMInstance mCIMSubsystem = new CIMInstance(mCIMObjPath);
                        pParameters.put("CIM_ComputerSystem", mCIMSubsystem);
                        Hashtable mRefDBKeys = (Hashtable)mProcessor.getDBReferences().get(mCIMSubsystem.getClassName());
                        Hashtable<String, Hashtable> mDBKeys = new Hashtable<String, Hashtable>();
                        mProcessor.start(pDiscoverRequest.getId());
                        mStatus = true;
                        try {
                            ProbeGenericInBandVirtualizerProcess.setCollectionStatus(mSubsystemID, 2, true, false);
                            if (mStatus) {
                                mDBKeys = new Hashtable();
                                mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                                mProcessor.setDBReferences(mDBKeys);
                                mResult.setRc(10013);
                                mStatus = collectPoolsFromComputerSystem.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                            }
                            if (mStatus) {
                                mDBKeys = new Hashtable();
                                mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                                mProcessor.setDBReferences(mDBKeys);
                                mLTH.logMsg("HWN021717I", new Object[]{mSubSystemLogName});
                                mResult.setRc(10014);
                                mStatus = collectVolumeSettings.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                            }
                            if (mStatus) {
                                mDBKeys = new Hashtable();
                                mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
                                mProcessor.setDBReferences(mDBKeys);
                                mLTH.logMsg("HWN021718I", new Object[]{mSubSystemLogName});
                                mResult.setRc(10015);
                                mStatus = collectClientSettingDataFromComputerSystem.process(new Integer(pDiscoverRequest.getId()).toString(), pParameters);
                            }
                        }
                        catch (Throwable bEx) {
                            this.checkException(bEx, mLTH, pParameters);
                            mStatus = false;
                        }
                        finally {
                            mProcessor.end(pDiscoverRequest.getId());
                        }
                        if (!mStatus) break block26;
                        mLTH.logMsg("HWN021719I", new Object[]{mSubSystemLogName});
                        mResult.setRc(10016);
                        ProbePerfTracker.ProbeAction bProbePostProcessing = TrackProbePerformance.startProbeAction((String)this.getScannerId(pParameters), (int)ProbePerfTracker.POST_PROCESSING);
                        this.getDiscoverRouterService().perform("CapabilityUpdatePostProcess", pParameters, new Integer(pDiscoverRequest.getId()).toString());
                        TrackProbePerformance.finishedProbeAction((ProbePerfTracker.ProbeAction)bProbePostProcessing);
                        mResult.setRc(0);
                    }
                    try {
                        ProbeGenericInBandVirtualizerProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 8, true, false);
                    }
                    catch (Exception bEx) {
                        mResult.setRc(10017);
                        mLTH.traceError("HWN021503E", (Throwable)bEx);
                        mLTH.logMsg("HWN021503E", null);
                        mStatus = false;
                    }
                    break block27;
                    catch (Throwable bEx) {
                        try {
                            this.checkException(bEx, mLTH, pParameters);
                            mStatus = false;
                        }
                        catch (Throwable throwable) {
                            try {
                                ProbeGenericInBandVirtualizerProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 8, true, false);
                            }
                            catch (Exception bEx2) {
                                mResult.setRc(10017);
                                mLTH.traceError("HWN021503E", (Throwable)bEx2);
                                mLTH.logMsg("HWN021503E", null);
                                mStatus = false;
                            }
                            throw throwable;
                        }
                        try {
                            ProbeGenericInBandVirtualizerProcess.setCollectionStatus(mSubsystemID, mStatus ? 0 : 8, true, false);
                        }
                        catch (Exception bEx3) {
                            mResult.setRc(10017);
                            mLTH.traceError("HWN021503E", (Throwable)bEx3);
                            mLTH.logMsg("HWN021503E", null);
                            mStatus = false;
                        }
                    }
                }
                finally {
                    if (mProcessor != null) {
                        mProcessor.shutdown(pDiscoverRequest.getId());
                        mProcessor = null;
                    }
                }
            }
            mLTH.logMsg("HWN021709I", new Object[]{mSubSystemLogName});
        }
        finally {
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }
}

