/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMObjectPath;

public class SVCBackendControllerUpdatePostProcess
extends DiscoverProcess {
    public SVCBackendControllerUpdatePostProcess() {
        this("SVC BackendController Update Post Processing");
    }

    protected SVCBackendControllerUpdatePostProcess(String pName) {
        super(pName, false, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"SVCBackendControllerUpdatePostProcess", null);
        mLTH.exit(null);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("SVCBackendControllerPostProcess", null, "In Band Virtualization", "IBM", null, null)};
    }

    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
        Result mReturn = new Result(1);
        DBConnection mCon = null;
        try {
            int mDeviceID = Integer.parseInt((String)pParameters.get("DEVICEID"));
            String mSSID = (String)pParameters.get("SUBSYSTEMID");
            mCon = ServiceUtils.getConnection();
            StorageSubsystem mStorageSubsystem = ExternalKeyManager.getStorageSubsystem((String)mSSID, (DBConnection)mCon);
            List mBCEntrys = this.getBackendController(mStorageSubsystem.getSubsystemId(), mCon);
            System.out.println("Size : " + mBCEntrys.size());
            for (BackendController mBCEntry : mBCEntrys) {
                List mPortEntries = this.getPortEntries(mBCEntry.getPortWwns(), mCon);
                for (Port mPort : mPortEntries) {
                    int mRefSSID = mPort.getSubsystemId();
                    mLTH.traceInfo("SVCBackendControllerUpdatePostProcess Found WWN :" + mBCEntry.getPortWwns() + " for " + mSSID + " which reference to :" + mRefSSID);
                    mBCEntry.setReferencedSubsystemId(mRefSSID);
                    mBCEntry.update(mCon);
                    mCon.commit();
                }
            }
            mCon.commit();
            mReturn = new Result(0);
        }
        catch (Exception pEx) {
            if (mCon != null) {
                try {
                    mCon.rollback();
                }
                catch (SQLException pInnerEx) {
                    // empty catch block
                }
            }
            mReturn = new Result(1);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pInnerEx) {}
            }
            mLTH.exit((Object)mReturn);
        }
        return mReturn;
    }

    private List getPortEntries(String pWWPN, DBConnection pCon) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getPortEntries", (Object[])new Object[]{pWWPN, pCon});
        LinkedList<Port> mReturn = new LinkedList<Port>();
        try {
            Hashtable mWhereClause = new Hashtable();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(Port.class, (String)"NAME", (LogTraceHelper)mLTH);
            Vector mWWPN = SVCBackendControllerUpdatePostProcess.processArrayvalues(pWWPN);
            mWhereClause.put(mInfo, mWWPN.firstElement());
            Port.PortCursor mCursor = Port.getCursor((DBConnection)pCon, mWhereClause, null);
            while (mCursor.next()) {
                mReturn.add(mCursor.getObject());
            }
            mCursor.close();
            pCon.commit();
        }
        catch (SQLException e) {
            mLTH.traceError("Internal error: SQLException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mReturn);
        }
        return mReturn;
    }

    protected List getBackendController(int pSSID, DBConnection pCon) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getBackendController", (Object[])new Object[]{new Integer(pSSID), pCon});
        LinkedList<BackendController> mReturn = new LinkedList<BackendController>();
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(BackendController.class, (String)"OWNING_SUBSYSTEM_ID", (LogTraceHelper)mLTH);
            mWhereClause.put(mInfo, Integer.toString(pSSID));
            BackendController.BackendControllerCursor mCursor = BackendController.getCursor((DBConnection)pCon, mWhereClause, null);
            while (mCursor.next()) {
                mReturn.add(mCursor.getObject());
            }
            mCursor.close();
            pCon.commit();
        }
        catch (SQLException e) {
            mLTH.traceError("Internal error: SQLException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mReturn);
        }
        return mReturn;
    }

    protected List getPortEntries(int pSubsystemID, DBConnection pCon) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getPortEntries", (Object[])new Object[]{new Integer(pSubsystemID), pCon});
        LinkedList<Port> mReturn = new LinkedList<Port>();
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(Port.class, (String)"SUBSYSTEM_ID", (LogTraceHelper)mLTH);
            mWhereClause.put(mInfo, Integer.toString(pSubsystemID));
            Port.PortCursor mCursor = Port.getCursor((DBConnection)pCon, mWhereClause, null);
            while (mCursor.next()) {
                Port mPort = mCursor.getObject();
                mLTH.traceInfo("Found :" + mPort.getName());
                mReturn.add(mPort);
            }
            mCursor.close();
            pCon.commit();
        }
        catch (SQLException e) {
            mLTH.traceError("Internal error: SQLException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mReturn);
        }
        return mReturn;
    }

    protected static Vector processArrayvalues(String pValue) {
        Vector<String> mResult = new Vector<String>();
        try {
            int lastBracket = pValue.indexOf("]");
            if (lastBracket == -1) {
                lastBracket = pValue.length();
            }
            pValue = pValue.substring(pValue.indexOf("[") + 1, lastBracket);
            StringTokenizer tokens = new StringTokenizer(pValue, ",");
            while (tokens.hasMoreTokens()) {
                mResult.add(tokens.nextToken().trim());
            }
            return mResult;
        }
        catch (Exception e) {
            return null;
        }
    }
}

