/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.SVCBackendControllerUpdatePostProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.interfaces.ParameterException;

public class SVCExtentUpdatePostProcess
extends SVCBackendControllerUpdatePostProcess {
    public SVCExtentUpdatePostProcess() {
        this("MDISK Update Post Processing");
    }

    protected SVCExtentUpdatePostProcess(String pName) {
        super(pName);
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"SVCExtentUpdatePostProcess", null);
        mLTH.exit(null);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("ExtentUpdatePostProcess", null, "In Band Virtualization", "IBM", null, null)};
    }

    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
        Result mReturn = new Result(1);
        DBConnection mCon = null;
        try {
            int mDeviceID = Integer.parseInt((String)pParameters.get("DEVICEID"));
            String mSSID = (String)pParameters.get("SUBSYSTEMID");
            mCon = ServiceUtils.getConnection();
            StorageSubsystem mSVCStorageSubsystem = ExternalKeyManager.getStorageSubsystem((String)mSSID, (DBConnection)mCon);
            mCon.commit();
            this.processMdisk(mCon, mSSID, mSVCStorageSubsystem);
            mCon.commit();
            mReturn = new Result(0);
        }
        catch (Exception pEx) {
            if (mCon != null) {
                try {
                    mCon.rollback();
                }
                catch (SQLException pInnerEx) {
                    // empty catch block
                }
            }
            mReturn = new Result(1);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pInnerEx) {}
            }
            mLTH.exit((Object)mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMdisk(DBConnection pCon, String pSSID, StorageSubsystem pSVCStorageSubsystem) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"processMdisk", (Object[])new Object[]{pCon, pSSID, pSVCStorageSubsystem});
        Result mReturn = new Result(1);
        try {
            List mBCEntrys = this.getBackendController(pSVCStorageSubsystem.getSubsystemId(), pCon);
            List mIP = this.getAllInitiatorPorts(pSVCStorageSubsystem.getSubsystemId(), pCon, mLTH);
            for (BackendController mBC : mBCEntrys) {
                mLTH.traceInfo("BackendControllerID :" + mBC.getBackendControllerId());
                StorageSubsystem mStorageSubsystem = this.getStorageSubsystem(mBC.getReferencedSubsystemId(), pCon, mLTH);
                if (mStorageSubsystem == null) continue;
                mLTH.traceInfo("BackendController SubsystemID:" + mStorageSubsystem.getSubsystemId());
                Vector mTP = SVCExtentUpdatePostProcess.processArrayvalues(mBC.getPortWwns(), pCon, mLTH);
                List mExtentList = this.getExtentEntries(mBC, pCon);
                for (StorageExtent mExtent : mExtentList) {
                    mLTH.traceInfo("StorageExtent : " + mExtent.getStorageExtentId());
                    String mExtentName = mExtent.getName();
                    if (mExtentName == null) continue;
                    String mLUNID = Integer.toString(Integer.parseInt(mExtent.getName().substring(mExtentName.length() - 4, mExtentName.length()), 16));
                    try {
                        this.UpdateMdisk_VolumeID(pCon, mIP, mTP, mLUNID, Integer.toString(mExtent.getStorageExtentId()));
                    }
                    catch (SQLException pEx) {
                        mLTH.traceAlways("Problem with MDISK update :" + mStorageSubsystem.getSubsystemId() + "Initiator Port :" + mIP.toString() + " Target Port :" + ((Object)mTP).toString() + " LUNID :" + mLUNID);
                    }
                }
            }
            mReturn.setRc(0);
        }
        finally {
            mLTH.exit((Object)mReturn);
        }
    }

    private void setMdisk(Integer pVolumeID, Integer pExtentID, DBConnection pCon) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"setMdisk", (Object[])new Object[]{pCon, pVolumeID, pExtentID});
        try {
            ColumnInfo mInfo = null;
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            mInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, (String)"SVID", (LogTraceHelper)mLTH);
            mWhereClause.put(mInfo, pVolumeID.toString());
            StorageVolume.StorageVolumeCursor mCursor = StorageVolume.getCursor((DBConnection)pCon, mWhereClause, null);
            while (mCursor.next()) {
                StorageVolume mVolume = mCursor.getObject();
                mVolume.setMdiskId(pExtentID.intValue());
                mVolume.update(pCon);
            }
            mCursor.close();
        }
        catch (SQLException pEx) {
            mLTH.traceError(pEx.getMessage(), (Throwable)pEx);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(null);
        }
    }

    protected StorageSubsystem getStorageSubsystem(int pKey, DBConnection pCon, LogTraceHelper pLTH) {
        StorageSubsystem mSS = null;
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, (String)"SUBSYSTEM_ID", (LogTraceHelper)pLTH);
            mWhereClause.put(mInfo, Integer.toString(pKey));
            StorageSubsystem.StorageSubsystemCursor mCursor = StorageSubsystem.getCursor((DBConnection)pCon, mWhereClause, null);
            if (mCursor.next()) {
                StorageSubsystem mStorageSubsystem = mCursor.getObject();
                pLTH.traceInfo("Found :" + mStorageSubsystem.getSubsystemId());
                mSS = mStorageSubsystem;
            }
            mCursor.close();
        }
        catch (SQLException e) {
            pLTH.traceError("Internal error: SQLException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)pLTH);
        }
        finally {
            pLTH.traceInfo("StorageSubsystem  :" + mSS + " found.");
            return mSS;
        }
    }

    private List getAllInitiatorPorts(int pSSID, DBConnection pCon, LogTraceHelper pLTH) {
        Vector<String> mReturn = new Vector<String>();
        List mPortList = this.getPortEntries(pSSID, pCon);
        for (Port mPort : mPortList) {
            mReturn.add(Integer.toString(mPort.getPortId()));
        }
        pLTH.traceInfo("getAllInitiatorPorts return :" + mReturn.toArray());
        return mReturn;
    }

    private List getExtentEntries(BackendController pBC, DBConnection pCon) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getExtentEntries", (Object[])new Object[]{pBC, pCon});
        LinkedList<StorageExtent> mReturn = new LinkedList<StorageExtent>();
        try {
            ColumnInfo mInfo = null;
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            mInfo = DiskReportingHelper.getColumnInfo(StorageExtent.class, (String)"BACKEND_CONTROLLER_ID", (LogTraceHelper)mLTH);
            mWhereClause.put(mInfo, Integer.toString(pBC.getBackendControllerId()));
            StorageExtent.StorageExtentCursor mCursor = StorageExtent.getCursor((DBConnection)pCon, mWhereClause, null);
            while (mCursor.next()) {
                StorageExtent mExtent = mCursor.getObject();
                mLTH.traceInfo("Found :" + mExtent.getName());
                mReturn.add(mExtent);
            }
            mCursor.close();
            pCon.commit();
        }
        catch (SQLException e) {
            mLTH.traceError("Internal error: SQLException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mReturn);
        }
        return mReturn;
    }

    private List getBackendController(DBConnection pCon) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getBackendController", (Object[])new Object[]{pCon});
        LinkedList<BackendController> mReturn = new LinkedList<BackendController>();
        try {
            Hashtable mWhereClause = new Hashtable();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(BackendController.class, (String)"OWNING_SUBSYSTEM_ID", (LogTraceHelper)mLTH);
            BackendController.BackendControllerCursor mCursor = BackendController.getCursor((DBConnection)pCon, mWhereClause, null);
            if (mCursor.next()) {
                mReturn.add(mCursor.getObject());
            }
            mCursor.close();
        }
        catch (SQLException e) {
            mLTH.traceError("Internal error: SQLException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void UpdateMdisk_VolumeID(DBConnection pCon, List pIP, List pTP, String pLUNID, String pExtent) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getVolumeIDs", (Object[])new Object[]{pCon, pIP, pTP, pLUNID});
        String mIP = pIP.toString().substring(1, pIP.toString().length() - 1);
        String mTP = pTP.toString().substring(1, pTP.toString().length() - 1);
        try {
            String mSQLStatement = "update " + StorageVolume.getTablename() + " set " + StorageVolume.getTablename() + "." + "MDISK_ID" + "=" + pExtent + " WHERE " + StorageVolume.getTablename() + "." + "SVID" + " = ( SELECT DISTINCT " + "VOLUME_ID" + " from " + DataPath.getTablename() + " where (" + "DEVICE_LUN_ID" + " = " + pLUNID + " and " + "DEVICE_LUN_ID" + " > " + "0" + " and " + "INITIATOR_PORT_ID" + " IN ( " + mIP + " ) and " + "TARGET_PORT_ID" + " IN ( " + mTP + " )))";
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            int mReturn = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)pCon, (String)mSQLStatement, null);
            pCon.commit();
            mLTH.traceHigh("MDSIK Query update result: " + mReturn + " for " + pExtent);
        }
        finally {
            mLTH.exit(null);
        }
    }

    protected static Vector processArrayvalues(String pValue, DBConnection pCon, LogTraceHelper pLTH) {
        Vector<String> mResult = new Vector<String>();
        try {
            int lastBracket = pValue.indexOf("]");
            if (lastBracket == -1) {
                lastBracket = pValue.length();
            }
            pValue = pValue.substring(pValue.indexOf("[") + 1, lastBracket);
            StringTokenizer tokens = new StringTokenizer(pValue, ",");
            while (tokens.hasMoreTokens()) {
                String mIPName = tokens.nextToken().trim();
                String mIP = SVCExtentUpdatePostProcess.getPortID(mIPName, pCon, pLTH);
                mResult.add(mIP);
            }
            return mResult;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getPortID(String pIPName, DBConnection pCon, LogTraceHelper pLTH) {
        String mReturn = "";
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(Port.class, (String)"NAME", (LogTraceHelper)pLTH);
            mWhereClause.put(mInfo, pIPName);
            Port.PortCursor mCursor = Port.getCursor((DBConnection)pCon, mWhereClause, null);
            if (mCursor.next()) {
                Port mPort = mCursor.getObject();
                pLTH.traceInfo("Found :" + mPort.getName());
                mReturn = Integer.toString(mPort.getPortId());
            }
            mCursor.close();
        }
        catch (SQLException e) {
            pLTH.traceError("Internal error: SQLException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)pLTH);
        }
        finally {
            pLTH.traceInfo("Initiator Port :" + pIPName + " with " + mReturn + " found.");
        }
        return mReturn;
    }
}

