/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMObjectPath;

public class StoragePoolUpdatePostProcess
extends DiscoverProcess {
    public StoragePoolUpdatePostProcess() {
        this("StoragePool Update Post Processing");
    }

    protected StoragePoolUpdatePostProcess(String pName) {
        super(pName, false, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, new String[]{String.class.getName(), String.class.getName(), String[].class.getName(), CIMObjectPath.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()});
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"StoragePoolUpdatePostProcess", null);
        mLTH.exit(null);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("StoragePoolUpdatePostProcess", null, null, null, null, null)};
    }

    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
        Result mReturn = new Result(1);
        DBConnection mCon = null;
        int mDeviceID = -1;
        try {
            mDeviceID = Integer.parseInt((String)pParameters.get("DEVICEID"));
            String mSSID = (String)pParameters.get("SUBSYSTEMID");
            mCon = ServiceUtils.getConnection();
            StorageSubsystem mStorageSubsystem = ExternalKeyManager.getStorageSubsystem((String)mSSID, (DBConnection)mCon);
            this.setSURFACED_LUN_CAPACITY(Integer.toString(mStorageSubsystem.getSubsystemId()), mCon);
            this.setUNSURFACED_LUN_CAPACITY(Integer.toString(mStorageSubsystem.getSubsystemId()), mCon);
            mReturn = new Result(0);
            mCon.commit();
        }
        catch (Exception pEx) {
            if (mCon != null) {
                try {
                    mCon.rollback();
                }
                catch (SQLException pInnerEx) {
                    // empty catch block
                }
            }
            mReturn = new Result(1);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pInnerEx) {}
            }
            mLTH.exit((Object)mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSURFACED_LUN_CAPACITY(String pSSID, DBConnection pCon) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"SURFACED_LUN_CAPACITY", (Object[])new Object[]{pCon, pSSID});
        try {
            String mSQLStatement = "update " + StoragePool.getTablename() + "  set " + "SURFACED_LUN_CAP" + " =  (  select sum( " + "CAPACITY" + " )  from " + StorageVolume.getTablename() + " where " + "POOL_ID" + "=" + StoragePool.getTablename() + "." + "POOL_ID" + " and " + "IS_ASSIGNED" + " = 1 " + " and " + "DETECTABLE" + " = 1 " + ")  where " + "SUBSYSTEM_ID" + " = " + pSSID;
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            int mReturn = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)pCon, (String)mSQLStatement, null);
            pCon.commit();
            mLTH.traceInfo("Updated rows : " + mReturn);
            mSQLStatement = "update " + StoragePool.getTablename() + "   set " + "SURFACED_LUN_CAP" + "= 0  where " + "SURFACED_LUN_CAP" + " is null";
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            mReturn = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)pCon, (String)mSQLStatement, null);
            mLTH.traceInfo("Updated rows : " + mReturn);
            pCon.commit();
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUNSURFACED_LUN_CAPACITY(String pSSID, DBConnection pCon) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"UNSURFACED_LUN_CAPACITY", (Object[])new Object[]{pCon, pSSID});
        try {
            String mSQLStatement = "update " + StoragePool.getTablename() + "  set " + "UNSURFACED_LUN_CAP" + " =  (  select sum( " + "CAPACITY" + " )  from " + StorageVolume.getTablename() + " where " + "POOL_ID" + "=" + StoragePool.getTablename() + "." + "POOL_ID" + " and " + "IS_ASSIGNED" + " = 0" + " and " + "DETECTABLE" + " = 1 " + "  )  where " + "SUBSYSTEM_ID" + " = " + pSSID;
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            int mReturn = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)pCon, (String)mSQLStatement, null);
            mLTH.traceInfo("Updated rows : " + mReturn);
            mSQLStatement = "update " + StoragePool.getTablename() + "   set " + "UNSURFACED_LUN_CAP" + "= 0  where " + "UNSURFACED_LUN_CAP" + " is null";
            mLTH.traceHigh("Invoking query " + mSQLStatement);
            mReturn = DiskCIMProcessor.updateComplexQueryDeadlockRetry((DBConnection)pCon, (String)mSQLStatement, null);
            mLTH.traceInfo("Updated rows : " + mReturn);
            pCon.commit();
        }
        finally {
            mLTH.exit(null);
        }
    }
}

