/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.Physicalvolume2extent;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;

public class SubsystemPostCollectionProcess
extends DiscoverProcess {
    public SubsystemPostCollectionProcess() {
        super("Subsystem Post Collection Process", false, new String[]{"DEVICEID"}, new String[]{Integer.class.getName()});
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"SubsystemPostCollectionProcess", null);
        mLTH.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
        Result mReturn = new Result(1);
        DBConnection mCon = ServiceUtils.getConnection();
        try {
            int mDeviceID = Integer.parseInt((String)pParameters.get("DEVICEID"));
            String mSSID = (String)pParameters.get("SUBSYSTEMID");
            try {
                StorageSubsystem mStorageSubsystem = ExternalKeyManager.getStorageSubsystem((String)mSSID, (DBConnection)mCon);
                mCon.commit();
                String mSchema = mCon.getSchema();
                String mSQL = "select SUM(TOTAL_MANAGED_SPACE) from " + mSchema + "." + StoragePool.getTablename() + " where (" + "SUBSYSTEM_ID" + " = " + mDeviceID + " AND " + "PRIMORDIAL" + " = 0" + " AND " + "DETECTABLE" + " = 1)";
                mLTH.traceInfo("Sending DB2 complex query for TotalCapacity: " + mSQL);
                DBResultSet mDBR = ComplexQuery.sqlQuery((DBConnection)mCon, (String)mSQL, null);
                double mTotalCapacity = 0.0;
                while (mDBR.next()) {
                    mTotalCapacity = mDBR.getDouble(1);
                    mLTH.traceInfo("Result: " + Double.toString(mTotalCapacity));
                }
                mDBR.close();
                mCon.commit();
                mSQL = "select SUM(REMAINING_MANAGED_SPACE) from " + mSchema + "." + StoragePool.getTablename() + " where (" + "SUBSYSTEM_ID" + " = " + mDeviceID + " AND " + "PRIMORDIAL" + " = 0" + " AND " + "DETECTABLE" + " = 1)";
                mLTH.traceInfo("Sending DB2 complex query for RemainingCapacity: " + mSQL);
                mDBR = ComplexQuery.sqlQuery((DBConnection)mCon, (String)mSQL, null);
                double mRemainingCapacity = 0.0;
                while (mDBR.next()) {
                    mRemainingCapacity = mDBR.getDouble(1);
                    mLTH.traceInfo("Result: " + Double.toString(mRemainingCapacity));
                }
                mDBR.close();
                mCon.commit();
                mSQL = "select SUM(CAPACITY) from " + mSchema + "." + StoragePool.getTablename() + " where (" + "SUBSYSTEM_ID" + " = " + mDeviceID + " AND " + "PRIMORDIAL" + " = 0" + " AND " + "DETECTABLE" + " = 1)";
                mLTH.traceInfo("Sending DB2 complex query for RemainingCapacity: " + mSQL);
                mDBR = ComplexQuery.sqlQuery((DBConnection)mCon, (String)mSQL, null);
                double mCapacity = 0.0;
                while (mDBR.next()) {
                    mCapacity = mDBR.getDouble(1);
                    mLTH.traceInfo("Result: " + Double.toString(mCapacity));
                }
                mDBR.close();
                mCon.commit();
                mSQL = "select SUM(TOTAL_AVAILABLE_SPACE) from " + mSchema + "." + StoragePool.getTablename() + " where (" + "SUBSYSTEM_ID" + " = " + mDeviceID + " AND " + "PRIMORDIAL" + " = 0" + " AND " + "DETECTABLE" + " = 1)";
                mLTH.traceInfo("Sending DB2 complex query for RemainingCapacity: " + mSQL);
                mDBR = ComplexQuery.sqlQuery((DBConnection)mCon, (String)mSQL, null);
                double mAvailableSpace = 0.0;
                while (mDBR.next()) {
                    mAvailableSpace = mDBR.getDouble(1);
                    mLTH.traceInfo("Result: " + Double.toString(mAvailableSpace));
                }
                mDBR.close();
                mCon.commit();
                mSQL = "select DISTINCT SUM(CAPACITY) FROM " + mSchema + "." + PhysicalVolume.getTablename() + " WHERE (" + "SUBSYSTEM_ID" + " = " + mDeviceID + " AND " + "DETECTABLE" + " = 1 " + " AND (" + "PHYSICAL_VOLUME_ID" + " NOT IN ( SELECT " + "PHYSICAL_VOLUME_ID" + " FROM " + Physicalvolume2extent.getTablename() + " ) OR " + "PHYSICAL_VOLUME_ID" + " IN ( SELECT " + "PHYSICAL_VOLUME_ID" + " FROM " + Physicalvolume2extent.getTablename() + " WHERE " + "STORAGE_EXTENT_ID" + " IN ( SELECT " + "STORAGE_EXTENT_ID" + " FROM " + StorageExtent.getTablename() + " WHERE " + "SUBSYSTEM_ID" + " = " + mDeviceID + " AND " + "POOL_ID" + " IN ( SELECT " + "POOL_ID" + " FROM " + StoragePool.getTablename() + " WHERE " + "SUBSYSTEM_ID" + " = " + mDeviceID + " AND " + "PRIMORDIAL" + " = 1" + " AND " + "DETECTABLE" + " = 1 )))))";
                mLTH.traceInfo("Sending DB2 complex query for RemainingCapacity: " + mSQL);
                mDBR = ComplexQuery.sqlQuery((DBConnection)mCon, (String)mSQL, null);
                double mDGCap = 0.0;
                while (mDBR.next()) {
                    mDGCap = mDBR.getDouble(1);
                    mLTH.traceInfo("Result: " + Double.toString(mDGCap));
                }
                mDBR.close();
                mCon.commit();
                StorageSubsystem mOnlyUpdatedColumns = new StorageSubsystem();
                mOnlyUpdatedColumns.setName(mStorageSubsystem.getName());
                mOnlyUpdatedColumns.setNameFormat(mStorageSubsystem.getNameFormat());
                mOnlyUpdatedColumns.setAllocatedCapacity((long)mTotalCapacity - (long)mRemainingCapacity);
                mOnlyUpdatedColumns.setAvailableCapacity((long)mRemainingCapacity);
                mOnlyUpdatedColumns.setVgCapacity((long)mCapacity);
                mOnlyUpdatedColumns.setVgFreespace((long)mAvailableSpace);
                mOnlyUpdatedColumns.setDgFreespace((long)mDGCap);
                mOnlyUpdatedColumns.update(mCon);
                mCon.commit();
                mReturn = new Result(0);
            }
            catch (Exception mEx) {
                try {
                    mCon.rollback();
                }
                catch (SQLException pEx) {
                    // empty catch block
                }
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)mEx, (LogTraceHelper)mLTH);
            }
        }
        finally {
            if (mCon != null) {
                try {
                    mCon.close();
                }
                catch (SQLException pEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            mLTH.exit((Object)mReturn);
        }
        return mReturn;
    }
}

