/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;

public class FilterPrimordialStep
extends SimpleStep
implements IStep {
    protected String cInstanceName = null;
    private ArrayList cPrimordialSteps = new ArrayList();
    private ArrayList cNonPrimordialSteps = new ArrayList();

    public FilterPrimordialStep(String pInstanceName) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"FilterPrimordialStep", (Object[])new Object[]{pInstanceName});
        this.cInstanceName = pInstanceName;
        mLTH.exit(null);
    }

    public boolean process(String pDiscoverRequest, Map pParameters) throws Exception {
        boolean mReturn = true;
        CIMInstance mCIMInstance = (CIMInstance)pParameters.get(this.cInstanceName);
        if (mCIMInstance != null) {
            boolean bIsPrimordial = this.checkPrimoridal(mCIMInstance);
            mReturn = bIsPrimordial ? this.processNextPrimordial(pDiscoverRequest, pParameters) : this.processNextNonPrimordial(pDiscoverRequest, pParameters);
        }
        if (mReturn) {
            mReturn = this.processNext(pDiscoverRequest, pParameters);
        }
        return mReturn;
    }

    protected boolean checkPrimoridal(CIMInstance mCIMPool) {
        Hashtable mPoolProperties = DiskCIMProcessor.convertPropertiesToHashtable((Vector)mCIMPool.getAllProperties(), new Hashtable());
        String bPrimordial = (String)mPoolProperties.get("Primordial".toLowerCase());
        boolean bIsPrimordial = bPrimordial != null && bPrimordial.equalsIgnoreCase("true");
        return bIsPrimordial;
    }

    public void addNextPrimordialStep(IStep pStep) {
        this.cPrimordialSteps.add(pStep);
    }

    public void addNextNonPrimordialStep(IStep pStep) {
        this.cNonPrimordialSteps.add(pStep);
    }

    protected boolean processNextPrimordial(String pDiscoverRequest, Map pParameters) throws Exception {
        boolean mResult = true;
        if (this.cPrimordialSteps.size() != 0) {
            Iterator stepIter = this.cPrimordialSteps.iterator();
            while (stepIter.hasNext() && mResult) {
                mResult = ((IStep)stepIter.next()).process(pDiscoverRequest, pParameters);
            }
        }
        return mResult;
    }

    protected boolean processNextNonPrimordial(String pDiscoverRequest, Map pParameters) throws Exception {
        boolean mResult = true;
        if (this.cNonPrimordialSteps.size() != 0) {
            Iterator stepIter = this.cNonPrimordialSteps.iterator();
            while (stepIter.hasNext() && mResult) {
                mResult = ((IStep)stepIter.next()).process(pDiscoverRequest, pParameters);
            }
        }
        return mResult;
    }
}

