/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.CIMNames;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.IStorageConfigurationManagementPlugin;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.CIMEnumeration;

public class CIMManagement
implements CIMNames {
    protected CIMClientWrapper cCimClient;
    protected String cStorageSystemID;
    protected CIMObjectPath cStorageSystem;
    protected IStorageConfigurationManagementPlugin cPlugin;
    protected LogTraceHelper cLogTraceHelper;
    protected Token cToken;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMManagement(IStorageConfigurationManagementPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, String pStorageSystemID, Token pJobId) {
        this.cLogTraceHelper = LogTraceHelper.entry((Token)pJobId, (Object)this, (String)"CIMManagement", (Object[])new Object[]{pPlugin, pCIMClient, pStorageSystem, pStorageSystemID, pJobId});
        try {
            this.cToken = pJobId;
            this.cCimClient = pCIMClient;
            this.cStorageSystem = pStorageSystem;
            this.cStorageSystemID = pStorageSystemID;
            this.cPlugin = pPlugin;
            int mInvokeMethodTimeout = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.InvokeMethodTimeout", (int)0);
            if (mInvokeMethodTimeout != 0) {
                this.cCimClient.setTimeout("invokeMethod", (long)mInvokeMethodTimeout);
            }
        }
        finally {
            this.cLogTraceHelper.exit((Object)this);
        }
    }

    public CIMInstance retrieveCIMInstance(CIMObjectPath pCOP) throws DiskManagerTimeoutException, CIMException {
        CIMInstance mCIMInst = this.cCimClient.getInstance(pCOP, false, true, true, this.cLogTraceHelper);
        return mCIMInst;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath retrieveAssociatedService(String pServiceName, String pAssocClass, String pRole, String pResultRole) throws ServerException {
        CIMObjectPath bEx2;
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveAssociatedService", (Object[])new Object[]{pServiceName, pAssocClass, pRole, pResultRole, this.cToken});
        CIMObjectPath mService = null;
        CIMEnumeration mServices = null;
        try {
            mServices = (CIMEnumeration)this.cCimClient.associatorNames(this.cStorageSystem, pAssocClass, pServiceName, pRole, pResultRole, this.cLogTraceHelper);
            if (!mServices.hasMoreElements()) {
                ServerException bEx2 = DiskMessageHelper.getServerException((String)"HWN021531E", (Object)this.cCimClient.toString(), (Object)this.cStorageSystemID, (LogTraceHelper)mLTH);
                mLTH.traceError("No Service returned from CIMOM, Device is not reachable", (Throwable)bEx2);
                throw bEx2;
            }
            bEx2 = mService = (CIMObjectPath)mServices.nextElement();
        }
        catch (CIMException e) {
            try {
                mLTH.traceError("Internal error: CIMException", (Throwable)e);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
                catch (DiskManagerTimeoutException e2) {
                    mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e2);
                    throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e2, (LogTraceHelper)mLTH);
                }
            }
            catch (Throwable throwable) {
                mLTH.exit(mService);
                try {
                    if (mServices == null) throw throwable;
                    mServices.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    mLTH.traceError("Internal error: IOException", (Throwable)e3);
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e3, (LogTraceHelper)mLTH);
                }
            }
        }
        mLTH.exit((Object)mService);
        try {
            if (mServices == null) return bEx2;
            mServices.close();
            return bEx2;
        }
        catch (IOException e) {
            mLTH.traceError("Internal error: IOException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
    }

    public void invokeCIMMethod(CIMObjectPath pCIMClass, String pMethod, Vector pInParams, Vector pOutParams) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"invokeCIMMethod", (Object[])new Object[]{pCIMClass, pMethod, pInParams, pOutParams});
        try {
            CIMValue bResult = this.cCimClient.invokeMethod(pCIMClass, pMethod, pInParams, pOutParams, this.cLogTraceHelper);
            if (((Number)bResult.getValue()).longValue() != 0L) {
                if (((Number)bResult.getValue()).longValue() == 4097L && pMethod.equals("AttachDevice") && ((String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)pCIMClass, (String)"CreationClassName")).startsWith("IBMTSSVC_")) {
                    return;
                }
                if (((Number)bResult.getValue()).longValue() == 32770L && pMethod.equals("CreateProtocolControllerWithPorts") && ((String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)pCIMClass, (String)"CreationClassName")).startsWith("IBMTSSVC_")) {
                    return;
                }
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021514E", (Object)pMethod, (Object)this.cCimClient.toString(), (Object)bResult.getValue(), (LogTraceHelper)mLTH);
                mLTH.traceError("invokeMethod returned failure returncode", (Throwable)bEx);
                throw bEx;
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)pMethod, (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(null);
        }
    }

    public void invokeAsyncCIMMethod(CIMObjectPath pCIMClass, String pMethod, Vector pInParams, Vector pOutParams, String pExpectedArgumentName, String pExpectedCOP, Object pExpectedType) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"invokeAsyncCIMMethod", (Object[])new Object[]{pCIMClass, pMethod, pInParams, pOutParams, pExpectedArgumentName, pExpectedCOP, pExpectedType});
        try {
            CIMValue bResult = this.cCimClient.invokeMethod(pCIMClass, pMethod, pInParams, pOutParams, mLTH);
            if (((Number)bResult.getValue()).longValue() != 4096L && ((Number)bResult.getValue()).longValue() != 0L) {
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021514E", (Object)pMethod, (Object)this.cCimClient.toString(), (Object)bResult.getValue(), (LogTraceHelper)mLTH);
                mLTH.traceError("invokeMethod returned failure returncode", (Throwable)bEx);
                throw bEx;
            }
            if (((Number)bResult.getValue()).longValue() == 0L || ((String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)pCIMClass, (String)"CreationClassName")).startsWith("IBMTSESS_")) {
                return;
            }
            this.processAsyncMethod(pOutParams, pExpectedArgumentName, pExpectedCOP, pExpectedType);
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)pMethod, (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(null);
        }
    }

    protected void processAsyncMethod(Vector pOutParams, String pExpectedArgumentName, String pExpectedCOP, Object pExpectedType) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"processAsyncMethod", (Object[])new Object[]{pOutParams, pExpectedArgumentName, pExpectedCOP, pExpectedType});
        try {
            CIMObjectPath mJobCOP = (CIMObjectPath)CIMInstanceHelper.getCIMPropertyValue((Vector)pOutParams, (String)"Job");
            this.waitForCIMJobToComplete(mJobCOP);
            Enumeration mEnumeration = this.cCimClient.associatorNames(mJobCOP, "CIM_AffectedJobElement", pExpectedCOP, null, null, mLTH);
            if (pExpectedType instanceof Vector) {
                Vector<CIMObjectPath> bCOPs = new Vector<CIMObjectPath>();
                while (mEnumeration.hasMoreElements()) {
                    CIMObjectPath element = (CIMObjectPath)mEnumeration.nextElement();
                    bCOPs.add(element);
                }
                pOutParams.add(new CIMArgument(pExpectedArgumentName, new CIMValue(bCOPs, CIMDataType.getPredefinedType((int)14))));
                return;
            }
            if (pExpectedType instanceof CIMObjectPath) {
                CIMObjectPath element = null;
                if (mEnumeration.hasMoreElements()) {
                    element = (CIMObjectPath)mEnumeration.nextElement();
                }
                pOutParams.add(new CIMArgument(pExpectedArgumentName, new CIMValue((Object)element, CIMDataType.getPredefinedType((int)14))));
                return;
            }
            try {
                throw new RuntimeException("Incorrect use of invokeAsyncCIMMethod. Specify CIMObjectPath or Vector as ExpectedType.");
            }
            catch (CIMException e) {
                e.printStackTrace();
                mLTH.traceError("Internal error: CIMException", (Throwable)e);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
            }
            catch (DiskManagerTimeoutException e) {
                mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    public void waitForCIMJobToComplete(CIMObjectPath pJob) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"waitForCIMJobToComplete", (Object[])new Object[]{pJob});
        try {
            String bError;
            boolean mDone = pJob == null;
            int mRetries = DiskManagerConfigSvc.getIntConfigValue((String)"CIMJobContext.JobRetrievalRetry", (int)3600);
            int mSleepTime = DiskManagerConfigSvc.getIntConfigValue((String)"CIMJobContext.JobRetrievalSleep", (int)1000);
            int mCount = 0;
            CIMInstance mJobInst = null;
            Number mPercent = new Integer(0);
            String bStatus = "";
            Number bState = null;
            while (!mDone && mCount < mRetries) {
                Thread.sleep(mSleepTime);
                mJobInst = this.cCimClient.getInstance(pJob, false, true, true, mLTH);
                mPercent = (Number)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mJobInst, (String)"PercentComplete");
                if (mPercent == null) {
                    String bRC = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mJobInst, (String)"ErrorCode");
                    bError = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mJobInst, (String)"ErrorDescription");
                    bStatus = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mJobInst, (String)"JobStatus");
                    bState = (Number)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mJobInst, (String)"JobState");
                    if (bRC == null || Integer.parseInt(bRC) == 0) {
                        ++mCount;
                        continue;
                    }
                    ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021651E", (Object)this.cCimClient, (Object)bStatus, (Object)bRC, (Object)bError, (LogTraceHelper)mLTH);
                    throw bEx;
                }
                if (mPercent.intValue() < 100) {
                    ++mCount;
                    continue;
                }
                mDone = true;
            }
            if (!mDone) {
                ServerException bEx;
                if (mPercent != null) {
                    bEx = DiskMessageHelper.getServerException((String)"HWN021673E", (Object)this.cCimClient, (Object)new Integer(mCount * mRetries), (Object)mPercent, (Object)pJob, (LogTraceHelper)mLTH);
                    throw bEx;
                }
                bEx = DiskMessageHelper.getServerException((String)"HWN021674E", (Object)this.cCimClient, (Object)pJob, bState, (Object)bStatus, (LogTraceHelper)mLTH);
                throw bEx;
            }
            int bRC = Integer.parseInt(CIMInstanceHelper.getCIMProperyValue(mJobInst, (String)"ErrorCode").toString());
            if (bRC > 0) {
                bError = (String)CIMInstanceHelper.getCIMProperyValue(mJobInst, (String)"ErrorDescription");
                bStatus = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mJobInst, (String)"JobStatus");
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021651E", (Object)this.cCimClient, (Object)bStatus, (Object)new Integer(bRC), (Object)bError, (LogTraceHelper)mLTH);
                throw bEx;
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"getInstance", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (InterruptedException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(null);
        }
    }
}

