/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.CIMManagement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.HardwareIDCollection;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;

public class HardwareIDMangement
extends CIMManagement {
    private CIMObjectPath cHardwareIDManagementService = null;

    public HardwareIDMangement(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClientWrapper, CIMObjectPath pStorageSystem, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClientWrapper, pStorageSystem, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath retrieveAssociatedHardwareIDManagementService() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveAssociatedHardwareIDManagementService", null);
        try {
            this.cHardwareIDManagementService = this.retrieveAssociatedService("CIM_StorageHardwareIDManagementService", "CIM_HostedService", "Antecedent", "Dependent");
        }
        finally {
            mLTH.exit((Object)this.cHardwareIDManagementService);
        }
        return this.cHardwareIDManagementService;
    }

    public ArrayList retrieveStorageHardwareIDsOfHardwareIDCollection(HardwareIDCollection pHardwareIDCollection) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveStorageHardwareIDsOfHardwareIDCollection", (Object[])new Object[]{pHardwareIDCollection});
        ArrayList<StorageHardwareID> mStorageHardwareIDs = new ArrayList<StorageHardwareID>();
        try {
            Enumeration mStorageHardwareIDEnum = this.cCimClient.associators(pHardwareIDCollection.getHardwareIDCollectionCOP(), "CIM_MemberOfCollection", "CIM_StorageHardwareID", "Collection", "Member", true, true, null, this.cLogTraceHelper);
            while (mStorageHardwareIDEnum.hasMoreElements()) {
                CIMInstance bStorageHardwareIDInstance = (CIMInstance)mStorageHardwareIDEnum.nextElement();
                StorageHardwareID bStorageHardwareID = this.generateStorageHardwareIDsFromCIMInstance(bStorageHardwareIDInstance, null);
                mStorageHardwareIDs.add(bStorageHardwareID);
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mStorageHardwareIDs);
        }
        return mStorageHardwareIDs;
    }

    public ArrayList retrieveStorageHardwareIDs(ArrayList pWWPNs, boolean pFailIfNotFound) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveStorageHardwareIDs", (Object[])new Object[]{pWWPNs, new Boolean(pFailIfNotFound)});
        ArrayList<StorageHardwareID> mStorageHardwareIDs = new ArrayList<StorageHardwareID>();
        try {
            Enumeration mAllHardwareIDs = this.cCimClient.associators(this.retrieveAssociatedHardwareIDManagementService(), "CIM_ConcreteDependency", "CIM_StorageHardwareID", "Antecedent", "Dependent", true, true, null, this.cLogTraceHelper);
            while (mAllHardwareIDs.hasMoreElements() && mStorageHardwareIDs.size() < pWWPNs.size()) {
                CIMInstance bHardwareID = (CIMInstance)mAllHardwareIDs.nextElement();
                StorageHardwareID bStorageHardwareID = this.generateStorageHardwareIDsFromCIMInstance(bHardwareID, pWWPNs);
                if (bStorageHardwareID == null) continue;
                mStorageHardwareIDs.add(bStorageHardwareID);
            }
            if (pFailIfNotFound && mStorageHardwareIDs.size() < pWWPNs.size()) {
                int i;
                String bWWPNNotFound = "";
                ArrayList<String> bWWPNsFound = new ArrayList<String>();
                for (i = 0; i < mStorageHardwareIDs.size(); ++i) {
                    bWWPNsFound.add(((StorageHardwareID)mStorageHardwareIDs.get(i)).getWWPN());
                }
                for (i = 0; i < pWWPNs.size(); ++i) {
                    if (bWWPNsFound.contains(pWWPNs.get(i))) continue;
                    bWWPNNotFound = (String)pWWPNs.get(i);
                }
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021613E", (Object)bWWPNNotFound, (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)mLTH);
                mLTH.traceError("StorageHardwareID not found", (Throwable)bEx);
                throw bEx;
            }
            if (mStorageHardwareIDs.size() > pWWPNs.size()) {
                ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)mLTH);
                mLTH.traceError("CIMOM returned several StorageHardwareIDs for the same WWPN.", (Throwable)bEx);
                throw bEx;
            }
            ArrayList<StorageHardwareID> arrayList = mStorageHardwareIDs;
            return arrayList;
        }
        catch (CIMException e) {
            e.printStackTrace();
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mStorageHardwareIDs);
        }
    }

    public PrivilegeToWWPNs retrieveHardwareIDCollectionsOfPrivileges(PrivilegeToWWPNs pPrivilegeToWWPNs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveHardwareIDCollectionsOfPrivileges", (Object[])new Object[]{pPrivilegeToWWPNs});
        PrivilegeToWWPNs mPrivilegeToWWPNs = pPrivilegeToWWPNs;
        try {
            Enumeration bStorageHardwareIDInstances = this.cCimClient.associators(pPrivilegeToWWPNs.getPrivilege(), "CIM_AuthorizedSubject", "CIM_SystemSpecificCollection", "Privilege", "PrivilegedElement", true, true, null, this.cLogTraceHelper);
            while (bStorageHardwareIDInstances.hasMoreElements()) {
                CIMInstance bHardwareIDCollectionInstance = (CIMInstance)bStorageHardwareIDInstances.nextElement();
                HardwareIDCollection bHardwareIDCollection = new HardwareIDCollection(bHardwareIDCollectionInstance.getObjectPath());
                bHardwareIDCollection.setHardwareIDCollectionInstance(bHardwareIDCollectionInstance);
                bHardwareIDCollection.setStorageHardwareIDs(this.retrieveStorageHardwareIDsOfHardwareIDCollection(bHardwareIDCollection));
                mPrivilegeToWWPNs.addStorageHardwareIDCollection(bHardwareIDCollection);
            }
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)mPrivilegeToWWPNs);
        }
        return mPrivilegeToWWPNs;
    }

    public PrivilegeToWWPNs retrieveStorageHardwareIDsOfPrivileges(PrivilegeToWWPNs pPrivilegeToWWPNs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveStorageHardwareIDsOfPrivileges", (Object[])new Object[]{pPrivilegeToWWPNs});
        PrivilegeToWWPNs mPrivilegeToWWPNs = pPrivilegeToWWPNs;
        try {
            Enumeration bStorageHardwareIDInstances = this.cCimClient.associators(pPrivilegeToWWPNs.getPrivilege(), "CIM_AuthorizedSubject", "CIM_StorageHardwareID", "Privilege", "PrivilegedElement", true, true, null, this.cLogTraceHelper);
            while (bStorageHardwareIDInstances.hasMoreElements()) {
                CIMInstance bStorageHardwareIDInstance = (CIMInstance)bStorageHardwareIDInstances.nextElement();
                mPrivilegeToWWPNs.addStorageHardwareID(this.generateStorageHardwareIDsFromCIMInstance(bStorageHardwareIDInstance, null));
            }
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit((Object)mPrivilegeToWWPNs);
        }
        return mPrivilegeToWWPNs;
    }

    public ArrayList createStorageHardwareIDs(ArrayList pWWPNs, String[] pHardwareIDNames, CIMObjectPath pStorageClientSettingDataCOP) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createStorageHardwareIDs", (Object[])new Object[]{pWWPNs, pHardwareIDNames, pStorageClientSettingDataCOP});
        ArrayList<StorageHardwareID> mStorageHardwareIDs = new ArrayList<StorageHardwareID>();
        try {
            for (int i = 0; i < pWWPNs.size(); ++i) {
                Vector<CIMArgument> bInParams = new Vector<CIMArgument>();
                Vector bOutParams = new Vector();
                bInParams.add(new CIMArgument("StorageID", new CIMValue(pWWPNs.get(i), CIMDataType.getPredefinedType((int)8))));
                bInParams.add(new CIMArgument("IDType", new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2))));
                if (pHardwareIDNames != null && pHardwareIDNames.length != 0) {
                    bInParams.add(new CIMArgument("ElementName", new CIMValue((Object)pHardwareIDNames[i], CIMDataType.getPredefinedType((int)8))));
                }
                if (pStorageClientSettingDataCOP != null) {
                    bInParams.add(new CIMArgument("Setting", new CIMValue((Object)pStorageClientSettingDataCOP, CIMDataType.getPredefinedType((int)14))));
                }
                this.invokeCIMMethod(this.getHardwareIDManagementService(), "CreateStorageHardwareID", bInParams, bOutParams);
                for (int j = 0; j < bOutParams.size(); ++j) {
                    CIMArgument bOut = (CIMArgument)bOutParams.get(j);
                    if (!bOut.getName().equals("HardwareID")) continue;
                    CIMObjectPath bHWIDCOP = (CIMObjectPath)bOut.getValue().getValue();
                    CIMInstance bHWIDInstance = this.retrieveCIMInstance(bHWIDCOP);
                    StorageHardwareID mHardwareID = new StorageHardwareID((String)pWWPNs.get(i), bHWIDInstance, bHWIDCOP);
                    mStorageHardwareIDs.add(mHardwareID);
                }
            }
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"getInstance", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mStorageHardwareIDs);
        }
        return mStorageHardwareIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getStorageHardwareIDs(ArrayList pWWPNs, String[] pStorageHardwareIDNames, CIMObjectPath pStorageClientSettingDataCOP, ArrayList pCreatedStorageHardwareIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getStorageHardwareIDs", (Object[])new Object[]{pWWPNs, pStorageHardwareIDNames, pStorageClientSettingDataCOP, pCreatedStorageHardwareIDs});
        ArrayList mExistingStorageHardwareIDs = null;
        try {
            if (pCreatedStorageHardwareIDs == null) {
                pCreatedStorageHardwareIDs = new ArrayList();
            }
            ArrayList bNewWWPNs = new ArrayList();
            ArrayList<String> bNamesToSet = new ArrayList<String>();
            mExistingStorageHardwareIDs = this.retrieveStorageHardwareIDs(pWWPNs, false);
            if (mExistingStorageHardwareIDs.size() != pWWPNs.size()) {
                int i;
                ArrayList<String> mExistingWWPNs = new ArrayList<String>();
                for (i = 0; i < mExistingStorageHardwareIDs.size(); ++i) {
                    mExistingWWPNs.add(((StorageHardwareID)mExistingStorageHardwareIDs.get(i)).getWWPN());
                }
                for (i = 0; i < pWWPNs.size(); ++i) {
                    if (mExistingWWPNs.contains(pWWPNs.get(i))) continue;
                    bNewWWPNs.add(pWWPNs.get(i));
                    if (pStorageHardwareIDNames == null) continue;
                    bNamesToSet.add(pStorageHardwareIDNames[i]);
                }
                pCreatedStorageHardwareIDs.addAll(this.createStorageHardwareIDs(bNewWWPNs, bNamesToSet.toArray(new String[0]), pStorageClientSettingDataCOP));
                mExistingStorageHardwareIDs.addAll(pCreatedStorageHardwareIDs);
            }
        }
        catch (Throwable throwable) {
            mLTH.exit(mExistingStorageHardwareIDs);
            throw throwable;
        }
        mLTH.exit((Object)mExistingStorageHardwareIDs);
        return mExistingStorageHardwareIDs;
    }

    public ArrayList retrieveCollectionsForStorageHardwareIDs(ArrayList pStorageHardwareIDs, ArrayList pStorageHardwareIDsWithoutCollection) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveCollectionsForStorageHardwareIDs", (Object[])new Object[]{pStorageHardwareIDs, pStorageHardwareIDsWithoutCollection});
        ArrayList<HardwareIDCollection> mHardwareIDCollections = new ArrayList<HardwareIDCollection>();
        try {
            for (int i = 0; i < pStorageHardwareIDs.size(); ++i) {
                HardwareIDCollection bStorageHardwareIDCollection;
                boolean bFound = false;
                for (int j = 0; j < mHardwareIDCollections.size(); ++j) {
                    bStorageHardwareIDCollection = (HardwareIDCollection)mHardwareIDCollections.get(j);
                    bFound = bStorageHardwareIDCollection.containsStorageHardwareID((StorageHardwareID)pStorageHardwareIDs.get(i));
                }
                if (bFound) continue;
                CIMObjectPath mCurrentStorageHardwareIDCOP = ((StorageHardwareID)pStorageHardwareIDs.get(i)).getStorageHardwareIDCOP();
                Enumeration hardwareIDCollections = this.cCimClient.associators(mCurrentStorageHardwareIDCOP, "CIM_MemberOfCollection", "CIM_SystemSpecificCollection", "Member", "Collection", true, true, null, this.cLogTraceHelper);
                if (!hardwareIDCollections.hasMoreElements()) {
                    if (pStorageHardwareIDsWithoutCollection == null) {
                        ServerException bEx = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)mLTH);
                        mLTH.traceError("No HardwareIDCollection for StorageHardwareID found", (Throwable)bEx);
                        throw bEx;
                    }
                    pStorageHardwareIDsWithoutCollection.add(pStorageHardwareIDs.get(i));
                }
                while (hardwareIDCollections.hasMoreElements()) {
                    CIMInstance mCollectionInstance = (CIMInstance)hardwareIDCollections.nextElement();
                    bStorageHardwareIDCollection = new HardwareIDCollection(mCollectionInstance.getObjectPath());
                    bStorageHardwareIDCollection.setHardwareIDCollectionInstance(mCollectionInstance);
                    ArrayList bStorageHardwareIDs = this.retrieveStorageHardwareIDsOfHardwareIDCollection(bStorageHardwareIDCollection);
                    bStorageHardwareIDCollection.addStorageHardwareIDs(bStorageHardwareIDs);
                    mHardwareIDCollections.add(bStorageHardwareIDCollection);
                }
            }
        }
        catch (CIMException e) {
            mLTH.traceError("Internal error: CIMException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)e.toString(), (Throwable)e, (LogTraceHelper)mLTH);
        }
        catch (DiskManagerTimeoutException e) {
            mLTH.traceError("Internal error: DiskManagerTimeoutException", (Throwable)e);
            throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)e, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.exit(mHardwareIDCollections);
        }
        return mHardwareIDCollections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivilegeToWWPNs retrieveInitiatorsOfPrivilege(PrivilegeToWWPNs pPrivilegeToWWPNs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"retrieveInitiatorsOfPrivilege", (Object[])new Object[]{pPrivilegeToWWPNs});
        PrivilegeToWWPNs mPrivilegeToWWPNs = null;
        try {
            mPrivilegeToWWPNs = this.retrieveStorageHardwareIDsOfPrivileges(pPrivilegeToWWPNs);
            if (((AssignmentParameter)this.cPlugin.getParams()).getCapability().getControllerSuppColl() == 1) {
                mPrivilegeToWWPNs = this.retrieveHardwareIDCollectionsOfPrivileges(mPrivilegeToWWPNs);
            }
        }
        finally {
            mLTH.exit((Object)mPrivilegeToWWPNs);
        }
        return mPrivilegeToWWPNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath getHardwareIDManagementService() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"getHardwareIDManagementService", (Object[])new Object[]{null});
        try {
            if (this.cHardwareIDManagementService == null) {
                this.retrieveAssociatedHardwareIDManagementService();
            }
            CIMObjectPath cIMObjectPath = this.cHardwareIDManagementService;
            return cIMObjectPath;
        }
        finally {
            mLTH.exit((Object)this.cHardwareIDManagementService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageHardwareID generateStorageHardwareIDsFromCIMInstance(CIMInstance pHardwareIDInstance, ArrayList pWWPNsToCheck) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"generateStorageHardwareIDsFromCIMInstance", (Object[])new Object[]{pHardwareIDInstance, pWWPNsToCheck});
        StorageHardwareID mHardwareID = null;
        try {
            CIMValue bValue = pHardwareIDInstance.getProperty("IDType").getValue();
            if (((UnsignedInt16)bValue.getValue()).intValue() == 2) {
                bValue = pHardwareIDInstance.getProperty("StorageID").getValue();
                if (pWWPNsToCheck == null || pWWPNsToCheck.contains((String)bValue.getValue())) {
                    mHardwareID = new StorageHardwareID((String)bValue.getValue(), pHardwareIDInstance);
                }
            }
        }
        finally {
            mLTH.exit(mHardwareID);
        }
        return mHardwareID;
    }
}

