/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagementSMIS11;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.sblim.wbem.cim.CIMObjectPath;

public class MappingManagementFUJ11
extends MappingManagementSMIS11 {
    public MappingManagementFUJ11(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, CapabilityData pCapablities, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pCapablities, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList deleteMappings(ArrayList pProtocolControllers, AssignmentParameter pParams, ArrayList pStorageHardwareIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteMappings", (Object[])new Object[]{pProtocolControllers, pParams, pStorageHardwareIDs});
        ArrayList mNewVolumeAssignments = new ArrayList();
        try {
            CIMObjectPath[] bProtocolControllerCOPs = new CIMObjectPath[pProtocolControllers.size()];
            ArrayList mAllPortsInPCs = new ArrayList();
            for (int i = 0; i < pProtocolControllers.size(); ++i) {
                bProtocolControllerCOPs[i] = ((ProtocolControllerToPrivileges)pProtocolControllers.get(i)).getProtocolController();
                mAllPortsInPCs.addAll(((ProtocolControllerToPrivileges)pProtocolControllers.get(i)).getWWPNs());
            }
            if (!pParams.getInitiatorWWPNs().containsAll(mAllPortsInPCs)) {
                if (pParams.isForce()) {
                    SRMMessage tpcMsg = DiskMessageHelper.getSRMMessage((String)"HWN021603W", null, null, (LogTraceHelper)mLTH);
                    AsyncResult mResult = pParams.getAsyncResult();
                    mResult.setSRMMessage(tpcMsg);
                    pParams.setAsyncResult(mResult);
                } else {
                    ArrayList mCollateralPortWWPNs = new ArrayList();
                    mCollateralPortWWPNs = mAllPortsInPCs;
                    mCollateralPortWWPNs.removeAll(pParams.getInitiatorWWPNs());
                    ArrayList<String> mCollateralVolumeNames = new ArrayList<String>();
                    String[] mCollateralVolumeNamesArray = pParams.getVolumeNames();
                    for (int j = 0; j < mCollateralVolumeNamesArray.length; ++j) {
                        mCollateralVolumeNames.add(mCollateralVolumeNamesArray[j]);
                    }
                    throw DiskMessageHelper.getServerException((String)"HWN021604E", mAllPortsInPCs, mCollateralPortWWPNs, (Object)pParams.getVolumeIDs(), mCollateralVolumeNames, (LogTraceHelper)mLTH);
                }
            }
            CIMObjectPath[] mNewPCs = this.hidePaths(bProtocolControllerCOPs, pParams.getCapability(), pParams.getVolumeNames(), null, pParams.getTargetPortWWPNs());
            ArrayList<CIMObjectPath> mPCsWithoutVolumes = new ArrayList<CIMObjectPath>();
            for (int i = 0; i < bProtocolControllerCOPs.length; ++i) {
                ArrayList mVolumes = this.retrieveProtocolControllerForUnit(bProtocolControllerCOPs[i]);
                if (mVolumes != null && !mVolumes.isEmpty()) continue;
                mPCsWithoutVolumes.add(bProtocolControllerCOPs[i]);
            }
            CIMObjectPath[] bProtocolControllerCOPsWithoutVolumes = new CIMObjectPath[mPCsWithoutVolumes.size()];
            for (int i = 0; i < mPCsWithoutVolumes.size(); ++i) {
                bProtocolControllerCOPsWithoutVolumes[i] = (CIMObjectPath)mPCsWithoutVolumes.get(i);
            }
            if (bProtocolControllerCOPsWithoutVolumes.length > 0) {
                int i;
                String[] mInitiatorsWWPNs = pParams.getInitiatorWWPNsArray();
                for (i = 0; i < mInitiatorsWWPNs.length; ++i) {
                    String[] mOneWWPN = new String[]{mInitiatorsWWPNs[i]};
                    try {
                        this.hidePaths(bProtocolControllerCOPsWithoutVolumes, pParams.getCapability(), null, mOneWWPN, pParams.getTargetPortWWPNs());
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    for (i = 0; i < bProtocolControllerCOPsWithoutVolumes.length; ++i) {
                        this.cCimClient.deleteInstance(bProtocolControllerCOPsWithoutVolumes[i], mLTH);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (int i = 0; i < pProtocolControllers.size(); ++i) {
                ProtocolControllerToPrivileges bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllers.get(i);
                mNewVolumeAssignments.addAll(ConfigurationResultHelper.createUnMappingResults(bProtocolController.getPrivilegeToWWPNs(), pParams.getVolumeIDs(), this.cToken));
                pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
            }
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList createMapping(ArrayList pProtocolControllerToPrivileges, AssignStorageVolumesParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMapping", (Object[])new Object[]{pProtocolControllerToPrivileges, pParams});
        ArrayList bNewVolumeAssignments = new ArrayList();
        try {
            ProtocolControllerToPrivileges bProtocolController;
            int i;
            ArrayList mWWPNsWithPC = new ArrayList();
            String[] mTargetPorts = pParams.getTargetPortWWPNs();
            for (i = 0; i < pProtocolControllerToPrivileges.size(); ++i) {
                bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllerToPrivileges.get(i);
                String[] mFCPortsOnPC = this.getFCPortWWPNs(bProtocolController.getProtocolController());
                boolean wrongPC = true;
                block4: for (int j = 0; j < mFCPortsOnPC.length; ++j) {
                    for (int k = 0; k < mTargetPorts.length; ++k) {
                        if (mTargetPorts[k].equalsIgnoreCase(mFCPortsOnPC[j])) {
                            mWWPNsWithPC.addAll(bProtocolController.getWWPNs());
                            wrongPC = false;
                            continue block4;
                        }
                        if (!wrongPC) continue block4;
                    }
                }
                if (!wrongPC) continue;
                pProtocolControllerToPrivileges.remove(i);
                --i;
            }
            for (i = 0; i < pProtocolControllerToPrivileges.size(); ++i) {
                bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllerToPrivileges.get(i);
                if (!pParams.getInitiatorWWPNs().containsAll(bProtocolController.getWWPNs())) {
                    if (pParams.isForce()) {
                        SRMMessage tpcMsg = DiskMessageHelper.getSRMMessage((String)"HWN021605I", null, null, (LogTraceHelper)mLTH);
                        AsyncResult mResult = pParams.getAsyncResult();
                        mResult.setSRMMessage(tpcMsg);
                        pParams.setAsyncResult(mResult);
                    } else {
                        ArrayList mCollateralPortWWPNs = new ArrayList();
                        mCollateralPortWWPNs = bProtocolController.getWWPNs();
                        mCollateralPortWWPNs.removeAll(pParams.getInitiatorWWPNs());
                        ArrayList<String> mCollateralVolumeNames = new ArrayList<String>();
                        String[] mCollateralVolumeNamesArray = pParams.getVolumeNames();
                        for (int j = 0; j < mCollateralVolumeNamesArray.length; ++j) {
                            mCollateralVolumeNames.add(mCollateralVolumeNamesArray[j]);
                        }
                        throw DiskMessageHelper.getServerException((String)"HWN021606E", (Object)mCollateralPortWWPNs, mCollateralVolumeNames, (LogTraceHelper)mLTH);
                    }
                }
                CIMObjectPath[] mModifiedPCs = this.exposePaths(pParams.getCapability(), bProtocolController.getProtocolController(), pParams.getVolumeNames(), null, null, pParams.getDeviceNumbers());
                this.checkModifiedProtocolControllers(bProtocolController, mModifiedPCs);
                String[] mDeviceNumbers = this.getDeviceNumbers(bProtocolController.getProtocolController(), pParams.getVolumeCOPs());
                String[] mFCPortWWPNs = this.getFCPortWWPNs(bProtocolController.getProtocolController());
                bNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResults(bProtocolController.getPrivilegeToWWPNs(), pParams.getVolumeIDs(), mDeviceNumbers, mFCPortWWPNs, bProtocolController.getProtocolController(), this.cToken));
                pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), bNewVolumeAssignments, (String)pParams.getAPIMethodName()));
            }
            this.createMappingExposePathsWithoutProtocolController(pParams, bNewVolumeAssignments, mWWPNsWithPC);
        }
        finally {
            mLTH.exit(bNewVolumeAssignments);
        }
        return bNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMappingExposePathsWithoutProtocolController(AssignStorageVolumesParameter pParams, ArrayList pNewVolumeAssignments, ArrayList pWWPNsWithPC) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMappingExposePathsWithoutProtocolController", (Object[])new Object[]{pParams, pNewVolumeAssignments, pWWPNsWithPC});
        try {
            ArrayList<String> mWWPNsWithoutPC = new ArrayList<String>();
            for (int i = 0; i < pParams.getInitiatorWWPNsArray().length; ++i) {
                if (pWWPNsWithPC.contains(pParams.getInitiatorWWPNsArray()[i])) continue;
                mWWPNsWithoutPC.add(pParams.getInitiatorWWPNsArray()[i]);
            }
            if (mWWPNsWithoutPC.size() != 0) {
                for (int j = 0; j < mWWPNsWithoutPC.size(); ++j) {
                    String[] mOneWWPN = new String[]{(String)mWWPNsWithoutPC.get(j)};
                    ArrayList mOneWWPNList = new ArrayList();
                    mOneWWPNList.add(mWWPNsWithoutPC.get(j));
                    CIMObjectPath[] mCreatedPCs = this.exposePaths(pParams.getCapability(), null, pParams.getVolumeNames(), mOneWWPN, pParams.getTargetPortWWPNs(), pParams.getDeviceNumbers());
                    for (int i = 0; i < mCreatedPCs.length; ++i) {
                        String[] mDeviceNumbers = this.getDeviceNumbers(mCreatedPCs[i], pParams.getVolumeCOPs());
                        String[] mFCPortWWPNs = this.getFCPortWWPNs(mCreatedPCs[i]);
                        ArrayList bStorageHardwareIds = this.cPlugin.getHardwareIDManagement().retrieveStorageHardwareIDs(mOneWWPNList, true);
                        pNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResultsForStorageHardwareIDs(mFCPortWWPNs, bStorageHardwareIds, pParams.getVolumeIDs(), mDeviceNumbers, pParams, this.cPlugin.getHardwareIDManagement(), mCreatedPCs[i], this.cToken));
                        pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), (ArrayList)pNewVolumeAssignments, (String)pParams.getAPIMethodName()));
                    }
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }
}

