/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelperCreateAndUpdate;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.VolumeAssignmentModifyParams;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.sblim.wbem.cim.CIMObjectPath;

public class MappingManagementSMIS11
extends MappingManagement {
    public MappingManagementSMIS11(StorageConfigurationPlugin pPlugin, CIMClientWrapper pCIMClient, CIMObjectPath pStorageSystem, CapabilityData pCapablities, String pStorageSystemID, Token pToken) {
        super(pPlugin, pCIMClient, pStorageSystem, pCapablities, pStorageSystemID, pToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList deleteMappings(ArrayList pProtocolControllers, AssignmentParameter pParams, ArrayList pStorageHardwareIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"deleteMappings", (Object[])new Object[]{pProtocolControllers, pParams, pStorageHardwareIDs});
        ArrayList mNewVolumeAssignments = new ArrayList();
        try {
            CIMObjectPath[] bProtocolControllerCOPs = new CIMObjectPath[pProtocolControllers.size()];
            for (int i = 0; i < pProtocolControllers.size(); ++i) {
                bProtocolControllerCOPs[i] = ((ProtocolControllerToPrivileges)pProtocolControllers.get(i)).getProtocolController();
            }
            CIMObjectPath[] mNewPCs = this.hidePaths(bProtocolControllerCOPs, pParams.getCapability(), pParams.getVolumeNames(), pParams.getInitiatorWWPNsArray(), pParams.getTargetPortWWPNs());
            for (int i = 0; i < pProtocolControllers.size(); ++i) {
                ProtocolControllerToPrivileges bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllers.get(i);
                mNewVolumeAssignments.addAll(ConfigurationResultHelper.createUnMappingResults(bProtocolController.getPrivilegeToWWPNs(), pParams.getVolumeIDs(), this.cToken));
                pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), mNewVolumeAssignments, (String)pParams.getAPIMethodName()));
            }
        }
        finally {
            mLTH.exit(mNewVolumeAssignments);
        }
        return mNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList createMapping(ArrayList pProtocolControllerToPrivileges, AssignStorageVolumesParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"createMapping", (Object[])new Object[]{pProtocolControllerToPrivileges, pParams});
        ArrayList bNewVolumeAssignments = new ArrayList();
        try {
            ArrayList mWWPNsWithPC = new ArrayList();
            for (int i = 0; i < pProtocolControllerToPrivileges.size(); ++i) {
                ProtocolControllerToPrivileges bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllerToPrivileges.get(i);
                mWWPNsWithPC.addAll(bProtocolController.getWWPNs());
                CIMObjectPath[] mModifiedPCs = this.exposePaths(pParams.getCapability(), bProtocolController.getProtocolController(), pParams.getVolumeNames(), null, pParams.getTargetPortWWPNs(), pParams.getDeviceNumbers());
                this.checkModifiedProtocolControllers(bProtocolController, mModifiedPCs);
                String[] mDeviceNumbers = this.getDeviceNumbers(bProtocolController.getProtocolController(), pParams.getVolumeCOPs());
                String[] mFCPortWWPNs = this.getFCPortWWPNs(bProtocolController.getProtocolController());
                bNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResults(bProtocolController.getPrivilegeToWWPNs(), pParams.getVolumeIDs(), mDeviceNumbers, mFCPortWWPNs, bProtocolController.getProtocolController(), this.cToken));
                pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), bNewVolumeAssignments, (String)pParams.getAPIMethodName()));
            }
            this.createMappingExposePathsWithoutProtocolController(pParams, bNewVolumeAssignments, mWWPNsWithPC);
        }
        finally {
            mLTH.exit(bNewVolumeAssignments);
        }
        return bNewVolumeAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapVolumesToPorts(ArrayList pProtocolControllers, AssignStorageVolumesParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"mapVolumesToPorts", (Object[])new Object[]{pProtocolControllers, pParams});
        try {
            ArrayList mNewVolumeAssignments = pParams.getMappingsToModify().isEmpty() ? this.createMapping(pProtocolControllers, pParams) : this.modifyMapping(pProtocolControllers, pParams);
        }
        finally {
            DBHelperCreateAndUpdate mDBHelper = new DBHelperCreateAndUpdate(this.cToken);
            mDBHelper.createMappings(pParams.getAsyncResult(), pParams);
            mDBHelper.close();
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList modifyMapping(ArrayList pProtocolControllerToPrivileges, AssignStorageVolumesParameter pParams) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Token)this.cToken, (Object)this, (String)"modifyMapping", (Object[])new Object[]{pProtocolControllerToPrivileges, pParams});
        ArrayList bNewVolumeAssignments = new ArrayList();
        try {
            ProtocolControllerToPrivileges bProtocolController = null;
            for (int i = 0; i < pProtocolControllerToPrivileges.size(); ++i) {
                bProtocolController = (ProtocolControllerToPrivileges)pProtocolControllerToPrivileges.get(i);
                VolumeAssignmentModifyParams mMapping = null;
                for (int j = 0; j < pParams.getMappingsToModify().size(); ++j) {
                    mMapping = (VolumeAssignmentModifyParams)pParams.getMappingsToModify().get(j);
                    if (bProtocolController.getWWPNs().contains(mMapping.getInitiatorPortWWPN())) break;
                }
                CIMObjectPath[] mModifiedPCs = null;
                if (mMapping.getTargetPortsToAddWWPNs() != null && mMapping.getTargetPortsToAddWWPNs().length > 0) {
                    mModifiedPCs = this.exposePaths(pParams.getCapability(), bProtocolController.getProtocolController(), null, null, mMapping.getTargetPortsToAddWWPNs(), null);
                    this.checkModifiedProtocolControllers(bProtocolController, mModifiedPCs);
                }
                if (mMapping.getTargetPortsToRemoveWWPNs() != null && mMapping.getTargetPortsToRemoveWWPNs().length > 0) {
                    mModifiedPCs = this.hidePaths(new CIMObjectPath[]{bProtocolController.getProtocolController()}, pParams.getCapability(), null, null, mMapping.getTargetPortsToRemoveWWPNs());
                    this.checkModifiedProtocolControllers(bProtocolController, mModifiedPCs);
                }
                String[] mDeviceNumbers = this.getDeviceNumbers(bProtocolController.getProtocolController(), pParams.getVolumeCOPs());
                String[] mFCPortWWPNs = this.getFCPortWWPNs(bProtocolController.getProtocolController());
                bNewVolumeAssignments.addAll(ConfigurationResultHelper.createMappingResults(bProtocolController.getPrivilegeToWWPNs(), pParams.getVolumeIDs(), mDeviceNumbers, mFCPortWWPNs, bProtocolController.getProtocolController(), this.cToken));
                pParams.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)pParams.getAsyncResult(), bNewVolumeAssignments, (String)pParams.getAPIMethodName()));
            }
            this.createMappingExposePathsWithoutProtocolController(pParams, bNewVolumeAssignments, bProtocolController.getWWPNs());
        }
        finally {
            mLTH.exit(bNewVolumeAssignments);
        }
        return bNewVolumeAssignments;
    }
}

