/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.util.Vector;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.VolumeManagement;
import org.eclipse.aperi.disk.common.CIM.VolumeManagementDS;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.control.StorageConfigurationPluginESS;
import org.eclipse.aperi.disk.control.util.CreateStorageVolumesParameter;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.sblim.wbem.cim.CIMObjectPath;

public class StorageConfigurationPluginDS
extends StorageConfigurationPluginESS {
    public VolumeManagement getVolumeManagement() {
        if (this.cVolumeManagement == null) {
            this.cVolumeManagement = new VolumeManagementDS(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cVolumeManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult[] createStorageVolumes(CreateStorageVolumesParameter pParam) throws NotAvailableException, Exception {
        Vector<AsyncResult> mResult;
        LogTraceHelper mLTH;
        block23: {
            String methodName = "createStorageVolumes";
            mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)methodName, (Object[])new Object[]{pParam});
            mResult = new Vector<AsyncResult>();
            CIMObjectPath[] mStoragePoolCIMOPs = pParam.getStoragePoolCIMOPs();
            StoragePool[] mStoragePools = pParam.getStoragePools();
            String[] mVolumeNames = pParam.getVolumeNames();
            long[] mSizes = pParam.getSizes();
            CIMClientWrapper bCimClient = null;
            int idx = 0;
            try {
                bCimClient = CIMClientPool.getClient((String)pParam.getCimom().getUserId(), (String)pParam.getCimom().getPassword(), (String)pParam.getCimom().getServiceUrl(), (String)pParam.getCimom().getInteropSchemaNamespace());
                bCimClient.setTimeout(1200000L);
                pParam.setCIMClientWrapper(bCimClient);
                for (idx = 0; idx < mStoragePoolCIMOPs.length; ++idx) {
                    int nNumVolumes = 1;
                    long[] bSizesSupported = this.getVolumeManagement().getSupportedSizeRange(mStoragePoolCIMOPs[idx], null);
                    int bBatchIdx = 0;
                    for (int idx1 = 0; idx1 < mStoragePoolCIMOPs.length - 1; ++idx1) {
                        if (!mStoragePoolCIMOPs[idx1].equals((Object)mStoragePoolCIMOPs[idx1 + 1]) || mSizes[idx1] != mSizes[idx1 + 1]) continue;
                        bBatchIdx = idx1 + 1;
                    }
                    long mRequestedSize = mSizes[idx];
                    if (bBatchIdx != 0) {
                        mRequestedSize = 0L;
                        for (int idx1 = idx; idx1 <= bBatchIdx; ++idx1) {
                            mRequestedSize += mSizes[idx1];
                        }
                        nNumVolumes = bBatchIdx - idx + 1;
                    }
                    String storagePoolID = (String)ExternalKeyConverter.getStoragePoolKey((StoragePool)mStoragePools[idx], (StorageSubsystem)pParam.getStorageSubsystem());
                    if (bSizesSupported[0] != -1L && bSizesSupported[1] != -1L && bSizesSupported[2] != -1L) {
                        long bMinSize = bSizesSupported[0];
                        long bMaxSize = bSizesSupported[1];
                        long bDivisor = bSizesSupported[2];
                        if (mRequestedSize >= bMinSize && mRequestedSize <= bMaxSize) {
                            long bFinalSize = (mSizes[idx] + (bDivisor - 1L)) / bDivisor * bDivisor;
                            if (bBatchIdx != 0) {
                                String[] bTmpVolNames = new String[nNumVolumes];
                                System.arraycopy(mVolumeNames, idx, bTmpVolNames, 0, nNumVolumes);
                                AsyncResult[] bRes = ((VolumeManagementDS)this.getVolumeManagement()).createStorageVolumesInBunches(mStoragePools[idx], pParam.getCapability(), pParam.getStorageSubsystem(), pParam.getCimom(), mStoragePoolCIMOPs[idx], bTmpVolNames, bFinalSize, nNumVolumes);
                                for (int bResIdx = 0; bResIdx < bRes.length; ++bResIdx) {
                                    mResult.add(bRes[bResIdx]);
                                    if (bRes[bResIdx].getRc() == 0) {
                                        DiskMessageHelper.getSRMMessage((String)"HWN021676I", (Object)pParam.getVolumeNames()[idx + bResIdx], (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                                        continue;
                                    }
                                    DiskMessageHelper.getSRMMessage((String)"HWN021677E", (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                                }
                                idx = bBatchIdx;
                                continue;
                            }
                            AsyncResult bRes = this.getVolumeManagement().createStorageVolume(storagePoolID, pParam.getCapability(), pParam.getStorageSubsystem(), pParam.getCimom(), mStoragePoolCIMOPs[idx], mVolumeNames[idx], bFinalSize);
                            mResult.add(bRes);
                            if (bRes.getRc() == 0) {
                                DiskMessageHelper.getSRMMessage((String)"HWN021676I", (Object)pParam.getVolumeElementName(), (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                                continue;
                            }
                            DiskMessageHelper.getSRMMessage((String)"HWN021677E", (Object)new Long(pParam.getSizes()[idx]), (Object)pParam.getStoragePools()[idx].getDisplayName(), (Object)pParam.getStorageSubsystem().getDisplayName(), (LogTraceHelper)mLTH);
                            continue;
                        }
                        AsyncResult[] bSubJobRes = null;
                        bSubJobRes = bBatchIdx != 0 ? new AsyncResult[bBatchIdx - idx] : new AsyncResult[1];
                        VolumeID bResult = new VolumeID();
                        bResult.setStoragePoolID(storagePoolID);
                        Object[] bResults = new VolumeID[]{bResult};
                        SRMMessage message = new SRMMessage("HWN021610E", new String[]{new Long(mRequestedSize).toString(), storagePoolID, new Long(bDivisor).toString(), new Long(bMinSize).toString(), new Long(bMaxSize).toString()});
                        for (int sjIdx = 0; sjIdx < bSubJobRes.length; ++sjIdx) {
                            AsyncResult bAsyncRes = new AsyncResult(-1, 0);
                            bAsyncRes.setSRMMessage(message);
                            bAsyncRes.setRc(10005);
                            bSubJobRes[sjIdx] = bAsyncRes;
                            bSubJobRes[sjIdx].setResults(bResults);
                        }
                        for (int bSubJobResIdx = 0; bSubJobResIdx < bSubJobRes.length; ++bSubJobResIdx) {
                            mResult.add(bSubJobRes[bSubJobResIdx]);
                        }
                        throw new ServerException(message);
                    }
                    AsyncResult[] bSubJobRes = null;
                    bSubJobRes = bBatchIdx != 0 ? new AsyncResult[bBatchIdx - idx] : new AsyncResult[1];
                    VolumeID bResult = new VolumeID();
                    bResult.setStoragePoolID(storagePoolID);
                    Object[] bResults = new VolumeID[]{bResult};
                    ServerException bException = DiskMessageHelper.getServerException((String)"HWN021503E", null, (LogTraceHelper)mLTH);
                    mLTH.traceError("GetDefaultSupportedSizeRange returned invalid values", (Throwable)bException);
                    for (int sjIdx = 0; sjIdx < bSubJobRes.length; ++sjIdx) {
                        AsyncResult bAsyncRes = new AsyncResult(-1, 0);
                        bAsyncRes.setSRMMessage(bException.getSRMMessage());
                        bAsyncRes.setRc(10001);
                        bSubJobRes[sjIdx] = bAsyncRes;
                        bSubJobRes[sjIdx].setResults(bResults);
                    }
                    for (int bSubJobResIdx = 0; bSubJobResIdx < bSubJobRes.length; ++bSubJobResIdx) {
                        mResult.add(bSubJobRes[bSubJobResIdx]);
                    }
                    throw bException;
                }
                if (bCimClient == null) break block23;
            }
            catch (Exception e) {
                block24: {
                    try {
                        int i;
                        AsyncResult bResult = new AsyncResult();
                        ServerException bException = null;
                        int bRC = 10001;
                        for (i = 0; i < mResult.size(); ++i) {
                            AsyncResult bFailureResult = (AsyncResult)mResult.elementAt(i);
                            if (bFailureResult.getReturnException() == null || !(bFailureResult.getReturnException() instanceof ServerException)) continue;
                            bException = (ServerException)((Object)bFailureResult.getReturnException());
                            bRC = bFailureResult.getRc();
                            break;
                        }
                        for (i = mResult.size(); i < mStoragePools.length; ++i) {
                            String storagePoolID = (String)ExternalKeyConverter.getStoragePoolKey((StoragePool)mStoragePools[i], (StorageSubsystem)pParam.getStorageSubsystem());
                            if (bException != null) {
                                this.setVolumeCreationSubjobFailed(bResult, storagePoolID, bException, bRC, mLTH);
                            } else {
                                this.setVolumeCreationSubjobFailed(bResult, storagePoolID, mLTH);
                            }
                            mResult.add(bResult);
                        }
                        if (bCimClient == null) break block24;
                    }
                    catch (Throwable throwable) {
                        if (bCimClient != null) {
                            CIMClientPool.returnClient(bCimClient);
                            bCimClient = null;
                        }
                        mLTH.exit(mResult);
                        throw throwable;
                    }
                    CIMClientPool.returnClient((CIMClientWrapper)bCimClient);
                    bCimClient = null;
                }
                mLTH.exit(mResult);
            }
            CIMClientPool.returnClient((CIMClientWrapper)bCimClient);
            bCimClient = null;
        }
        mLTH.exit(mResult);
        return mResult.toArray(new AsyncResult[mResult.size()]);
    }
}

