/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.HardwareIDMangement;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.CIM.MappingManagementMultiplePort;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagement;
import org.eclipse.aperi.disk.common.CIM.VolumeManagement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class StorageConfigurationPluginMultiplePort
extends StorageConfigurationPlugin {
    public MappingManagement getMappingManagement() {
        if (this.cMappingManagement == null) {
            this.cMappingManagement = new MappingManagementMultiplePort(this, this.cParams.getCIMClientWrapper(), this.cParams.getStorageSubsystemCIMOP(), this.cParams.getCapability(), this.cParams.getStorageSubsystemID(), this.cParams.getToken());
        }
        return this.cMappingManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAssignAccess(AssignStorageVolumesParameter pParam) throws ServerException {
        block11: {
            LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"validateAssignAccess", (Object[])new Object[]{pParam});
            try {
                super.validateAssignAccess(pParam);
                try {
                    DBConnection mConnection = ServiceUtils.getConnection();
                    try {
                        List mProtocolControllerCops = this.retrieveInvolvedProtocolControllers(pParam, false);
                        List mAffectedVolumeCops = this.retrieveAffectedVolumes(pParam, mProtocolControllerCops);
                        List mCollateralVolumeCops = this.extractUnique(Arrays.asList(pParam.getVolumeCOPs()), mAffectedVolumeCops, new Comparator(){

                            public int compare(Object pO1, Object pO2) {
                                return ((CIMObjectPath)pO1).equals(pO2) ? 0 : 1;
                            }
                        });
                        List mAffectedInitiatorPortWWPNs = this.retrieveAffectedInitiatorPortWWPNs(pParam, mProtocolControllerCops);
                        List mCollateralPortWWPNs = this.extractUnique(pParam.getInitiatorWWPNs(), mAffectedInitiatorPortWWPNs, new Comparator(){

                            public int compare(Object pO1, Object pO2) {
                                return ((String)pO1).compareTo((String)pO2);
                            }
                        });
                        List mCollateralPorts = this.getPortsFromWWPNs(mConnection, pParam, mCollateralPortWWPNs);
                        if (mCollateralVolumeCops.size() <= 0 && mCollateralPorts.size() <= 0) break block11;
                        ArrayList mAllPorts = new ArrayList(pParam.getInitiatorPortList());
                        mAllPorts.addAll(mCollateralPorts);
                        pParam.setInitiatorPorts(mAllPorts);
                        ArrayList mAllWWPNs = new ArrayList(pParam.getInitiatorWWPNs());
                        mAllWWPNs.addAll(mCollateralPortWWPNs);
                        pParam.setInitiatorWWPNs(mAllWWPNs);
                        ArrayList<CIMObjectPath> mAllVolumeCops = new ArrayList<CIMObjectPath>(Arrays.asList(pParam.getVolumeCOPs()));
                        mAllVolumeCops.addAll(mCollateralVolumeCops);
                        pParam.setVolumeCOPs(mAllVolumeCops.toArray(new CIMObjectPath[mAllVolumeCops.size()]));
                        List mCollateralVolumes = this.getVolumes(mConnection, pParam, mCollateralVolumeCops);
                        ArrayList<StorageVolume> mAllVolumes = new ArrayList<StorageVolume>(Arrays.asList(pParam.getVolumes()));
                        mAllVolumes.addAll(mCollateralVolumes);
                        pParam.setVolumes(mAllVolumes.toArray(new StorageVolume[mAllVolumes.size()]));
                        List mCollateralVolumeIds = this.getVolumeIds(mCollateralVolumes);
                        ArrayList<String> mAllVolumeIds = new ArrayList<String>(Arrays.asList(pParam.getVolumeIDs()));
                        mAllVolumeIds.addAll(mCollateralVolumeIds);
                        pParam.setVolumeIDs(mAllVolumeIds.toArray(new String[mAllVolumeIds.size()]));
                        List mCollateralVolumeNames = this.getVolumeNames(mCollateralVolumes);
                        ArrayList<String> mAllVolumeNames = new ArrayList<String>(Arrays.asList(pParam.getVolumeNames()));
                        mAllVolumeNames.addAll(mCollateralVolumeNames);
                        pParam.setVolumeNames(mAllVolumeNames.toArray(new String[mAllVolumeNames.size()]));
                        if (pParam.isForce()) {
                            SRMMessage tpcMsg = DiskMessageHelper.getSRMMessage((String)"HWN021605I", null, null, (LogTraceHelper)mLTH);
                            AsyncResult mResult = pParam.getAsyncResult();
                            mResult.setSRMMessage(tpcMsg);
                            pParam.setAsyncResult(mResult);
                            break block11;
                        }
                        throw DiskMessageHelper.getServerException((String)"HWN021606E", (Object)mCollateralPortWWPNs, (Object)mCollateralVolumeNames, (LogTraceHelper)mLTH);
                    }
                    finally {
                        if (mConnection != null) {
                            mConnection.close();
                        }
                    }
                }
                catch (SQLException sqlEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
                }
                catch (DiskManagerTimeoutException dmEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)dmEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            finally {
                mLTH.exit(null);
            }
        }
    }

    private List getVolumeNames(List pVolumes) {
        ArrayList<String> mResult = new ArrayList<String>(pVolumes.size());
        for (StorageVolume mVolume : pVolumes) {
            mResult.add(mVolume.getName());
        }
        return mResult;
    }

    private List getVolumeIds(List pVolumes) {
        ArrayList<String> mResult = new ArrayList<String>(pVolumes.size());
        for (StorageVolume mVolume : pVolumes) {
            mResult.add(mVolume.getName() + "+" + mVolume.getNameFormat() + "+" + this.getParams().getStorageSubsystemID());
        }
        return mResult;
    }

    private List getVolumes(DBConnection pConnection, AssignmentParameter pParam, List pVolumeCops) throws SQLException, CIMException, DiskManagerTimeoutException {
        ArrayList<StorageVolume> mResult = new ArrayList<StorageVolume>(pVolumeCops.size());
        for (CIMObjectPath mVolumeCop : pVolumeCops) {
            CIMInstance mVolumeInstance = pParam.getCIMClientWrapper().getInstance(mVolumeCop, false);
            StorageVolume mVolume = new StorageVolume();
            mVolume.setName((String)mVolumeCop.getKey("DeviceID").getValue().getValue());
            mVolume.setNameFormat(((Number)mVolumeInstance.getProperty("NameFormat").getValue().getValue()).shortValue());
            mVolume.setSubsystemId(pParam.getStorageSubsystem().getSubsystemId());
            if (!mVolume.retrieve(pConnection)) continue;
            mResult.add(mVolume);
        }
        return mResult;
    }

    private List getPortsFromWWPNs(DBConnection pConnection, AssignmentParameter pParam, List pPortWWPNs) {
        LinkedList<Port> mResult = new LinkedList<Port>();
        Iterator i = pPortWWPNs.iterator();
        while (i.hasNext()) {
            try {
                Port mPort = ExternalKeyManager.getPort((String)((String)i.next()), (int)pParam.getStorageSubsystem().getSubsystemId(), (DBConnection)pConnection);
                mResult.add(mPort);
            }
            catch (EntityNotFoundException e) {
                mResult.add(null);
            }
        }
        return mResult;
    }

    private List retrieveAffectedVolumes(AssignmentParameter pParam, List pProtocolControllerCops) {
        VolumeManagement mVM = this.getVolumeManagement();
        LinkedList mResult = new LinkedList();
        Iterator i = pProtocolControllerCops.iterator();
        while (i.hasNext()) {
            ArrayList mVolumes = mVM.retrieveVolumesOfProtocolController((CIMObjectPath)i.next());
            mResult.addAll(mVolumes);
        }
        return mResult;
    }

    private List retrieveAffectedInitiatorPortWWPNs(AssignmentParameter pParam, List pProtocolControllerCops) {
        PrivilegeManagement mPrivMgt = this.getPrivilegeManagement();
        LinkedList mPrivileges = new LinkedList();
        for (CIMObjectPath mProtocolControllerCop : pProtocolControllerCops) {
            mPrivileges.addAll(mPrivMgt.retrievePrivilegesForProtocolController(mProtocolControllerCop, new ArrayList()));
        }
        LinkedList mWWPNs = new LinkedList();
        for (PrivilegeToWWPNs mPriv2Wwpn : mPrivileges) {
            mWWPNs.addAll(mPriv2Wwpn.getWWPNs());
        }
        return mWWPNs;
    }

    private List retrieveInvolvedProtocolControllers(AssignmentParameter pParam, boolean pIsUnassign) {
        ArrayList mUnMappedVolumes = new ArrayList();
        MappingManagement mMMgr = this.getMappingManagement();
        AbstractList mProtocolControllerToPrivileges = new LinkedList();
        mProtocolControllerToPrivileges.addAll(mMMgr.retrieveProtocolControllersForVolumes(pParam.getVolumeCOPs(), mUnMappedVolumes));
        if (!pIsUnassign) {
            ArrayList mOriginalInitiatorWWPNs = pParam.getInitiatorWWPNs();
            HardwareIDMangement mHwIdMgmt = this.getHardwareIDManagement();
            ArrayList mHwIds = mHwIdMgmt.retrieveStorageHardwareIDs(mOriginalInitiatorWWPNs, false);
            ArrayList mUnMappedHwIds = new ArrayList();
            mProtocolControllerToPrivileges.addAll(mMMgr.retrieveProtocolControllersForStorageHardwareIDs(mHwIds, mUnMappedHwIds));
            ArrayList mProtocolControllerToPrivilegesChecked = new ArrayList();
            for (int i = 0; i < mProtocolControllerToPrivileges.size(); ++i) {
                CIMObjectPath mPC = this.getMappingManagement().validateProtocolController(((ProtocolControllerToPrivileges)mProtocolControllerToPrivileges.get(i)).getProtocolController());
                if (mPC == null) continue;
                mProtocolControllerToPrivilegesChecked.add(mProtocolControllerToPrivileges.get(i));
            }
            mProtocolControllerToPrivileges = mProtocolControllerToPrivilegesChecked;
        }
        ArrayList<CIMObjectPath> mResult = new ArrayList<CIMObjectPath>(mProtocolControllerToPrivileges.size());
        Iterator i = mProtocolControllerToPrivileges.iterator();
        while (i.hasNext()) {
            mResult.add(((ProtocolControllerToPrivileges)i.next()).getProtocolController());
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateUnAssignAccess(AssignmentParameter pParam) throws ServerException {
        block13: {
            LogTraceHelper mLTH = LogTraceHelper.entry((Token)pParam.getToken(), (Object)this, (String)"validateUnAssignAccess", (Object[])new Object[]{pParam});
            try {
                super.validateUnAssignAccess(pParam);
                try {
                    DBConnection mConnection = ServiceUtils.getConnection();
                    try {
                        List mProtocolControllerCops = this.retrieveInvolvedProtocolControllers(pParam, true);
                        List mAffectedVolumeCops = new LinkedList();
                        List mCollateralVolumeCops = new LinkedList();
                        if (pParam.getMappingMode() != AssignmentParameter.MAP) {
                            mAffectedVolumeCops = this.retrieveAffectedVolumes(pParam, mProtocolControllerCops);
                            mCollateralVolumeCops = this.extractUnique(Arrays.asList(pParam.getVolumeCOPs()), mAffectedVolumeCops, new Comparator(){

                                public int compare(Object pO1, Object pO2) {
                                    return ((CIMObjectPath)pO1).equals(pO2) ? 0 : 1;
                                }
                            });
                        }
                        List mAffectedInitiatorPortWWPNs = new LinkedList();
                        List mCollateralPortWWPNs = new LinkedList();
                        List mCollateralPorts = new LinkedList();
                        if (pParam.getMappingMode() != AssignmentParameter.MASK) {
                            mAffectedInitiatorPortWWPNs = this.retrieveAffectedInitiatorPortWWPNs(pParam, mProtocolControllerCops);
                            mCollateralPortWWPNs = this.extractUnique(pParam.getInitiatorWWPNs(), mAffectedInitiatorPortWWPNs, new Comparator(){

                                public int compare(Object pO1, Object pO2) {
                                    return ((String)pO1).compareTo((String)pO2);
                                }
                            });
                            mCollateralPorts = this.getPortsFromWWPNs(mConnection, pParam, mCollateralPortWWPNs);
                        }
                        if (mCollateralVolumeCops.size() <= 0 && mCollateralPorts.size() <= 0) break block13;
                        ArrayList mAllPorts = new ArrayList(pParam.getInitiatorPortList());
                        mAllPorts.addAll(mCollateralPorts);
                        pParam.setInitiatorPorts(mAllPorts);
                        ArrayList mAllWWPNs = new ArrayList(pParam.getInitiatorWWPNs());
                        mAllWWPNs.addAll(mCollateralPortWWPNs);
                        pParam.setInitiatorWWPNs(mAllWWPNs);
                        ArrayList<CIMObjectPath> mAllVolumeCops = new ArrayList<CIMObjectPath>(Arrays.asList(pParam.getVolumeCOPs()));
                        mAllVolumeCops.addAll(mCollateralVolumeCops);
                        pParam.setVolumeCOPs(mAllVolumeCops.toArray(new CIMObjectPath[mAllVolumeCops.size()]));
                        List mCollateralVolumes = this.getVolumes(mConnection, pParam, mCollateralVolumeCops);
                        ArrayList<StorageVolume> mAllVolumes = new ArrayList<StorageVolume>(Arrays.asList(pParam.getVolumes()));
                        mAllVolumes.addAll(mCollateralVolumes);
                        pParam.setVolumes(mAllVolumes.toArray(new StorageVolume[mAllVolumes.size()]));
                        List mCollateralVolumeIds = this.getVolumeIds(mCollateralVolumes);
                        ArrayList<String> mAllVolumeIds = new ArrayList<String>(Arrays.asList(pParam.getVolumeIDs()));
                        mAllVolumeIds.addAll(mCollateralVolumeIds);
                        pParam.setVolumeIDs(mAllVolumeIds.toArray(new String[mAllVolumeIds.size()]));
                        List mCollateralVolumeNames = this.getVolumeNames(mCollateralVolumes);
                        ArrayList<String> mAllVolumeNames = new ArrayList<String>(Arrays.asList(pParam.getVolumeNames()));
                        mAllVolumeNames.addAll(mCollateralVolumeNames);
                        pParam.setVolumeNames(mAllVolumeNames.toArray(new String[mAllVolumeNames.size()]));
                        if (pParam.isForce()) {
                            SRMMessage tpcMsg = DiskMessageHelper.getSRMMessage((String)"HWN021603W", null, null, (LogTraceHelper)mLTH);
                            AsyncResult mResult = pParam.getAsyncResult();
                            mResult.setSRMMessage(tpcMsg);
                            pParam.setAsyncResult(mResult);
                            break block13;
                        }
                        throw DiskMessageHelper.getServerException((String)"HWN021604E", mAffectedInitiatorPortWWPNs, mCollateralPortWWPNs, (Object)pParam.getVolumeIDsForCOPs(mAllVolumeCops.toArray(new CIMObjectPath[mAffectedVolumeCops.size()])), (Object)mCollateralVolumeNames, (LogTraceHelper)mLTH);
                    }
                    finally {
                        if (mConnection != null) {
                            mConnection.close();
                        }
                    }
                }
                catch (SQLException sqlEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sqlEx.getMessage(), (LogTraceHelper)mLTH);
                }
                catch (DiskManagerTimeoutException dmEx) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)dmEx.getMessage(), (LogTraceHelper)mLTH);
                }
            }
            finally {
                mLTH.exit(null);
            }
        }
    }
}

