/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.Capabilities;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.GenericDiscoveryProcessPlugin;
import org.eclipse.aperi.disk.discovery.StorageDeviceData;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt64;

public class LSIDiscoveryProcessPlugin
extends GenericDiscoveryProcessPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LSIDiscoveryProcessPlugin() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"LSIDiscoveryProcessPlugin", null);
        try {
            this.cCIMOMExclusions = this.readCimomExclusion(mLTH);
            mLTH.objectCreation(LSIDiscoveryProcessPlugin.class.getName());
        }
        finally {
            mLTH.exit(null);
        }
    }

    protected void getSpecificDataForDevice(CIMInstance pInstance, StorageDeviceData pData) throws DiscoveryException {
        CIMInstance[] mNodes = pData.getNodes();
        long cacheSize = 0L;
        for (int i = 0; i < mNodes.length; ++i) {
            CIMProperty bInstance = mNodes[i].getProperty("CacheMemorySize");
            if (bInstance == null) continue;
            cacheSize += ((UnsignedInt64)bInstance.getValue().getValue()).longValue();
        }
        cacheSize = cacheSize * 1024L * 1024L;
        pInstance.addProperty(new CIMProperty("CACHE".toLowerCase(), new CIMValue((Object)new Long(cacheSize), new CIMDataType(7))));
        this.getProviderVersion(pInstance, pData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getProviderVersion(CIMInstance pCluster, StorageDeviceData pDeviceData) throws DiscoveryException {
        String mMethodName = "getProviderVersion";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[]{pCluster, pDeviceData});
        try {
            CIMInstance mInstance = null;
            this.cParameters.put("IN_SYSTEM_CIMOMVersion", pCluster);
            this.cParameters.put("NAMESPACE", pDeviceData.getNameSpace());
            String[] mRegCluster = Router.getRouter().perform("CIMOMVersion", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mRegCluster);
            JobInfo mJob = (JobInfo)JobEngine.getInstance().getJobs(mRegCluster[1]).get(0);
            if (!mJob.isSuccessful()) {
                this.cParameters.remove("NAMESPACE");
                this.checkJobSuccessful(mMethodName, mLTH, mJob, "CONFIGURATIONCAPABILITIES");
            }
            this.cParameters.remove("NAMESPACE");
            Response mResponse = mJob.getResponse();
            if (mResponse instanceof Response) {
                Enumeration mEnumRemote = (Enumeration)mResponse.getData();
                while (mEnumRemote.hasMoreElements()) {
                    mInstance = (CIMInstance)mEnumRemote.nextElement();
                    String mValue = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"BuildInfo");
                    mLTH.traceInfo("Used CIMOM Version:" + mValue);
                    pDeviceData.setCIMOMVersion(mValue);
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    protected void saveSpecificData(StorageDeviceData pData, LogTraceHelper pLTH, MapperRouter pMapperRouter, String pSMISVersion, String pScannID, Hashtable pReturnValue) throws SQLException {
        CIMInstance mInstance = pData.getInstance("");
        int mMaxVol = (Integer)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"MaxStorageVolumes");
        Capabilities mCapabilities = pData.getCapabilities();
        pLTH.traceInfo("saveSpecificData for FAStT MAX VOLUMES: " + mMaxVol);
        mCapabilities.setNumberOfVolumesSuporrted(mMaxVol);
        pData.setCapabilities(mCapabilities);
    }

    protected String readCimomExclusion(LogTraceHelper pLTH) {
        return this.readRegExForCIMOMExclusion("LSI", pLTH);
    }

    protected boolean isUsedProfile(CIMInstance mProfileInstance) {
        boolean mReturn = super.isUsedProfile(mProfileInstance);
        String mVersion = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mProfileInstance, (String)"RegisteredVersion");
        if (mVersion == null) {
            return mReturn;
        }
        return mReturn && !mVersion.startsWith("1.0.2") && !mVersion.startsWith("1.0.3");
    }
}

