/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.discovery.DiscoveryException;
import org.eclipse.aperi.disk.discovery.ProcessPlugin;
import org.eclipse.aperi.disk.discovery.StorageDeviceData;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.UnsignedInt16;

public class SwitchDiscoveryProcessPlugin
extends ProcessPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchDiscoveryProcessPlugin() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"SwitchDiscoveryProcessPlugin", null);
        try {
            mLTH.objectCreation(SwitchDiscoveryProcessPlugin.class.getName());
        }
        finally {
            mLTH.exit(null);
        }
    }

    public List collectDeviceData(String pObjectManagerID, String pCIMOMVersion) throws DiscoveryException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"collectDeviceData", (Object[])new Object[]{pObjectManagerID});
        LinkedList mDeviceList = new LinkedList();
        LinkedList mReturn = new LinkedList();
        boolean mSupportsServerProfile = pObjectManagerID != null;
        String mScannID = null;
        Response mResponse = null;
        try {
            List mSystemList = this.getEnumeratedSystems();
            mScannID = this.cObjectJob.getResourceId();
            mResponse = this.cObjectJob.getResponse();
            this.handleComputerSystem(mDeviceList, null, null, mSystemList);
            Iterator mDeviceIt = mDeviceList.iterator();
            int mCurrentDevice = 0;
            while (mDeviceIt.hasNext()) {
                Object[] mArray = (Object[])mDeviceIt.next();
                ++mCurrentDevice;
                this.getProductOfSystem((CIMInstance)mArray[1], (StorageDeviceData)mArray[0], false);
                this.getSAPForSystem((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                this.getSoftwareOfDevice((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                this.getSpecificDataForDevice((CIMInstance)mArray[1], (StorageDeviceData)mArray[0]);
                mLTH.traceInfo("NameSpace :" + ((StorageDeviceData)mArray[0]).getNameSpace());
                mLTH.traceInfo(((StorageDeviceData)mArray[0]).getDebugString());
                this.saveAllInformation(mReturn, mScannID, mArray);
            }
        }
        catch (SQLException pEx) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)pEx.getMessage(), (Throwable)pEx, (LogTraceHelper)mLTH);
        }
        finally {
            mLTH.traceInfo("Ready");
            mLTH.exit(mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllInformation(List mReturn, String mScannID, Object[] mArray) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)"saveAllInformation", (Object[])new Object[]{mReturn, mScannID, mArray});
        try {
            Hashtable mSlpKeyReferences = this.saveNameSpace(mLTH, this.getMapperRouter(), mScannID, ((StorageDeviceData)mArray[0]).getNameSpace(), ((StorageDeviceData)mArray[0]).getCIMOMVersion());
            Hashtable mReturnValues = this.saveSubSystem(mArray, mLTH, this.getMapperRouter(), mScannID, mSlpKeyReferences);
            if (mReturnValues.size() > 0) {
                mReturnValues.putAll(mSlpKeyReferences);
                this.saveProduct(mArray, mLTH, this.getMapperRouter(), mScannID, mReturnValues);
                this.saveNodes(mArray, mLTH, this.getMapperRouter(), mScannID, mReturnValues);
                this.saveSoftware(mArray, mLTH, this.getMapperRouter(), mScannID, mReturnValues);
                this.saveSpecificData((StorageDeviceData)mArray[0], mLTH, this.getMapperRouter(), ((StorageDeviceData)mArray[0]).getSMISVersion(), mScannID, mReturnValues);
                this.cDiskCimProcessor.doCommit(mLTH);
                Vector mDedicated = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)((CIMInstance)mArray[1]), (String)"Dedicated");
                if (((StorageDeviceData)mArray[0]).getProfile() != null && ((StorageDeviceData)mArray[0]).getProfile().indexOf("Switch") >= 0 || mDedicated != null && (mDedicated.contains(DiscoveryConstants.DEDICATED_SWITCH) || mDedicated.contains(DiscoveryConstants.DEDICATED_L3SWITCH) || mDedicated.contains(DiscoveryConstants.DEDICATED_OFFICESWITCH))) {
                    CIMOMSelector.getSelector().activateCimomForSwitch(Integer.parseInt((String)mReturnValues.get("ref_toplevelsystem_cimom2namespaceid")), (String)mReturnValues.get("ref_switch_wwn"));
                    mReturn.add((StorageDeviceData)mArray[0]);
                } else {
                    mLTH.traceWarning("Not a switch profile or a computer system dedicated as switch");
                }
            } else {
                mLTH.traceInfo("No additional info returned for SaveSubsystem");
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getEnumeratedSystems() throws DiscoveryException {
        String mMethodName = "getEnumeratedSystems";
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cRequest, (Object)this, (String)mMethodName, (Object[])new Object[0]);
        Vector<CIMInstance> mList = new Vector<CIMInstance>();
        CIMInstance mInstance = null;
        try {
            String[] mObjectManager = Router.getRouter().perform("ENUM_COMPUTERSYSTEM", this.cParameters, new Integer(this.cRequest.getId()).toString());
            Router.getRouter().waitTilComplete(mObjectManager);
            JobInfo mObjectJob = (JobInfo)JobEngine.getInstance().getJobs(mObjectManager[1]).get(0);
            if (!mObjectJob.isSuccessful()) {
                this.checkJobSuccessful(mMethodName, mLTH, mObjectJob, "ENUM_COMPUTERSYSTEM");
            }
            this.cObjectJob = mObjectJob;
            Response mResponse = mObjectJob.getResponse();
            Enumeration mObjMgrEnum = (Enumeration)mResponse.getData();
            while (mObjMgrEnum.hasMoreElements()) {
                mInstance = (CIMInstance)mObjMgrEnum.nextElement();
                Vector mDedicated = (Vector)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mInstance, (String)"Dedicated");
                UnsignedInt16 mUI16 = (UnsignedInt16)mDedicated.get(0);
                if (mUI16.intValue() == 5) {
                    mList.add(mInstance);
                    continue;
                }
                mLTH.traceInfo("Not used dedicated field");
            }
        }
        finally {
            mLTH.exit(mList);
        }
        return mList;
    }
}

