/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.FCPortIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class FCPortCreationHandler
extends FCPortIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData mR1 = new CIMIndicationHandler.RegistrationData("CIM_FCPort", "CIM_InstCreation");
        return new CIMIndicationHandler.RegistrationData[]{mR1};
    }

    public FCPortCreationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        CIMInstance mTopLevelCS;
        CIMInstance mFcPort;
        CIMObjectPath mFcPortCop = this.getEvent().getSourceCop();
        try {
            mFcPort = this.getEvent().getSourceInstance();
            mTopLevelCS = this.getAttachedTopLevelSystem(mFcPortCop);
        }
        catch (CIMException e) {
            throw new RuntimeException(e);
        }
        catch (DiskManagerTimeoutException e) {
            throw new RuntimeException(e);
        }
        try {
            DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                MapperRouter mMapperRouter = MapperRouter.getMapperRouter();
                IDBAttributeMapper mAttributeMapperSystem = mMapperRouter.findMapper(mTopLevelCS.getClassName(), "1.0.2", null, null, "15", "CIM_ComputerSystem");
                IDBAttributeMapper mAttributeMapperPort = mMapperRouter.findMapper(this.getCIMClassname(), "1.0.2", null, null, null, "CIM_FCPort");
                try {
                    Hashtable mParamsSubsystem = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mTopLevelCS);
                    String mServiceUrl = this.getEvent().getCIMOM().getServiceUrl();
                    mParamsSubsystem.put("ref_serviceurl", mServiceUrl);
                    mParamsSubsystem.put("ref_namespace", mTopLevelCS.getObjectPath().getNameSpace());
                    MapperResult mMapperResult = mAttributeMapperSystem.persist(mConnection, mParamsSubsystem, pProcessID);
                    Hashtable mParamsPort = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)mFcPort);
                    mParamsPort.put("ref_serviceurl", mServiceUrl);
                    mParamsPort.put("ref_namespace", mFcPortCop.getNameSpace());
                    mParamsPort.putAll(mMapperResult.getKeyReferences());
                    mMapperResult = mAttributeMapperPort.persist(mConnection, mParamsPort, pProcessID);
                    mConnection.commit();
                    AlertProcessor.processAlerts((String)pProcessID, (MapperResult)mMapperResult, new Hashtable(), new Hashtable());
                    Processor.getEventMonitorProxy().handleModelUpdate(pProcessID);
                }
                catch (Exception e) {
                    mConnection.rollback();
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return HandlingResult.SUCCESS;
    }
}

