/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;

public class PoolIndicationHandler
extends CIMIndicationHandler {
    public static final String GENERIC_CLASS = "CIM_StoragePool";

    public PoolIndicationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        super(pIndicationClassname, pCIMClassname, pEvent);
    }

    public HandlingResult handle(LogTraceHelper pLTH, String pProcessID) {
        return null;
    }

    protected CIMInstance getTopLevelSystemInstance(CIMInstance pPool) throws CIMException, DiskManagerTimeoutException {
        block4: {
            Enumeration mProfile;
            Enumeration mComputerSystem;
            CIMInstance mTLSInstance;
            LogTraceHelper mLTH;
            block5: {
                CIMInstance cIMInstance;
                mLTH = LogTraceHelper.entry((Object)((Object)this), (String)"getTopLevelSystemInstance", (Object[])new Object[]{pPool});
                mTLSInstance = null;
                try {
                    mComputerSystem = this.getEvent().getCIMClient().associators(pPool.getObjectPath(), "CIM_HostedStoragePool", "CIM_System", "PartComponent", "GroupComponent", false, false, null, mLTH);
                    if (!mComputerSystem.hasMoreElements()) break block4;
                    mTLSInstance = (CIMInstance)mComputerSystem.nextElement();
                    mProfile = this.getEvent().getCIMClient().associatorNames(mTLSInstance.getObjectPath(), "CIM_ElementConformsToProfile", "CIM_RegisteredProfile", "ManagedElement", "ConformantStandard", mLTH);
                    if (!mProfile.hasMoreElements()) break block5;
                    cIMInstance = mTLSInstance;
                }
                catch (Throwable throwable) {
                    mLTH.exit(mTLSInstance);
                    throw throwable;
                }
                mLTH.exit((Object)mTLSInstance);
                return cIMInstance;
            }
            mComputerSystem = this.getEvent().getCIMClient().associators(mTLSInstance.getObjectPath(), "CIM_ComponentCS", "CIM_ComputerSystem", "PartComponent", "GroupComponent", false, false, null, mLTH);
            if (!mComputerSystem.hasMoreElements()) break block4;
            mTLSInstance = (CIMInstance)mComputerSystem.nextElement();
            mProfile = this.getEvent().getCIMClient().associatorNames(mTLSInstance.getObjectPath(), "CIM_ElementConformsToProfile", "CIM_RegisteredProfile", "ManagedElement", "ConformantStandard", mLTH);
            if (!mProfile.hasMoreElements()) break block4;
            CIMInstance cIMInstance = mTLSInstance;
            mLTH.exit((Object)mTLSInstance);
            return cIMInstance;
        }
        throw new RuntimeException("Cannot detect TopLevelComputerSystem");
    }

    protected static StoragePool getPool(DBConnection pConnection, String pInstanceId, int[] pSubsystemIds) throws SQLException {
        for (int i = 0; i < pSubsystemIds.length; ++i) {
            StoragePool mResult = new StoragePool();
            mResult.setInstanceId(pInstanceId);
            mResult.setSubsystemId(pSubsystemIds[i]);
            if (!mResult.retrieve(pConnection)) continue;
            return mResult;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] getAffectedVolumes(DBConnection pConnection, StoragePool pPool) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResStorageVolumeTable.getColumnInfo((String)"POOL_ID"), new Integer(pPool.getPoolId()).toString());
        String mQueryString = "SELECT SVID FROM " + TResStorageVolumeTable.getTablename() + " WHERE " + "POOL_ID" + " = (?)";
        DBResultSet mDbResult = ComplexQuery.sqlQuery((DBConnection)pConnection, (String)mQueryString, mParameters);
        try {
            ArrayList<Integer> mResult = new ArrayList<Integer>();
            while (mDbResult.next()) {
                mResult.add(new Integer(mDbResult.getInt(1)));
            }
            int[] mReturn = new int[mResult.size()];
            for (int i = 0; i < mReturn.length; ++i) {
                mReturn[i] = (Integer)mResult.get(i);
            }
            int[] nArray = mReturn;
            return nArray;
        }
        finally {
            if (mDbResult != null) {
                mDbResult.closeAll();
            }
        }
    }

    protected static void detachExtents(DBConnection pConnection, StoragePool pPool) throws SQLException {
        Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
        mParameters.put(TResStorageExtentTable.getColumnInfo((String)"POOL_ID"), new Integer(pPool.getPoolId()).toString());
        String mQueryString = "UPDATE " + TResStorageExtentTable.getTablename() + " SET " + "POOL_ID" + " = CAST(NULL AS INTEGER) WHERE " + "POOL_ID" + " = (?)";
        int mRc = ComplexQuery.sqlUpdate((DBConnection)pConnection, (String)mQueryString, mParameters);
    }

    public static int changeDetectableAttributeForStoragePool(DBConnection pConn, String pValue, Integer pIDvalue) throws SQLException {
        if (!pValue.equals("0") && !pValue.equals("1")) {
            return 0;
        }
        Hashtable<ColumnInfo, String> mParams = new Hashtable<ColumnInfo, String>();
        mParams.put(TResStoragePoolTable.getColumnInfo((String)"DETECTABLE"), pIDvalue.toString());
        String mSQL = "UPDATE " + TResStoragePoolTable.getTablename() + " SET " + "DETECTABLE" + " = " + pValue + " WHERE " + "POOL_ID" + " = (?)";
        return ComplexQuery.sqlUpdate((DBConnection)pConn, (String)mSQL, mParams);
    }
}

