/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas.netapp;

import java.io.Serializable;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler;
import org.eclipse.aperi.agent.nas.netapp.TableHandler;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.data.LongInput;
import org.eclipse.aperi.snmp.data.OID;

class SpareDiskTableHandler
extends TableHandler {
    public SpareDiskTableHandler(OID pOID, NasFiler pFiler, SnmpSession pListener) {
        super(pOID, pFiler, pListener);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SpareDiskTableHandler.class.getName(), (String)"SpareDiskTableHandler", (String)"pOID, pFiler, pListener");
        }
        this.badTypeMsgID = "NAA0084E";
        this.tableOIDLength = ProbeNetAppFiler.SPARE_PREFIX_LENGTH + 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SpareDiskTableHandler.class.getName(), (String)"SpareDiskTableHandler");
        }
    }

    protected String checkNameLength() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SpareDiskTableHandler.class.getName(), (String)"checkNameLength", (String)"");
        }
        String result = this.array.length == ProbeNetAppFiler.SPARE_PREFIX_LENGTH + 2 ? null : "NAA0091W";
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SpareDiskTableHandler.class.getName(), (String)"checkNameLength", (Object)traceResult);
        }
        return traceResult;
    }

    protected boolean typeOK(Serializable content) {
        return content instanceof LongInput || content instanceof Number;
    }

    protected void process(Serializable content) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SpareDiskTableHandler.class.getName(), (String)"process", (String)"content");
        }
        Number number = ProbeNetAppFiler.checkNumber(content, this.filer);
        Device dev = ProbeNetAppFiler.newDisk();
        dev.devSerialNumber = this.filer.nfName + "/S" + number.intValue();
        dev.devDiscoveredTime = this.array[this.array.length - 1];
        dev.devNext = this.comp.cmpDevice;
        this.comp.cmpDevice = dev;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SpareDiskTableHandler.class.getName(), (String)"process");
        }
    }
}

